#ifndef _PATCHMII_PATCHES_H_
#define _PATCHMII_PATCHES_H_

/* IOS36 ES patches - Credits go to bushing, Waninkoko, et. al. 
	patches include */
	
// IOS36 title info replacement
extern const sha1 ios36_info_content_hash;
		
int patch_ios36_info_content(u8* buf, u32 size);

// IOS36 ES module patches
// - Signature hash check patch
// - ES_Addticket version check patch
// - ES_SetUID permission check patch
// - System Title delete check patch
// - Three patches for ES_OpenTitleContent
// -- ES_OpenTitleContent permission check patch
// -- ES_ReadContent permission check patch
// -- ES_CloseContent permission check patch
extern const sha1 ios36_ES_module_hash;
int patch_ios36_ES_module(u8* buf, u32 size);
		
// IOS36 DI module patches
// - DVD_LowUnencryptedRead limit patch
extern const sha1 ios36_DI_module_hash;
int patch_ios36_DI_module(u8* buf, u32 size);

#endif
