/*  patches.c -- "cIOS" IOS patches

    Copyright (C) 2008 tona

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 2.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include <gccore.h>

#include "patchmii_core.h"
#include "patches.h"
#include "info_content_app.h"


// "cIOS" IOS36 patches.
// most patches from Waninkoko, some are from patchmii/bushing/others

const sha1 ios36_info_content_hash =
	{0x4B, 0x7A, 0x24, 0x6E, 0x14, 0x7D, 0x40, 0x29, 0x5F, 0x6C, 
		0x51, 0x71, 0x83, 0xA0, 0x5C, 0x75, 0x29, 0xCE, 0x57, 0xF8};
		
const sha1 ios36_ES_module_hash = 
	{0xE6, 0x26, 0xD8, 0xA0, 0x92, 0x78, 0x3F, 0xB7, 0x9D, 0x8E, 
		0x2F, 0x19, 0x6F, 0x3D, 0xD5, 0xFF, 0x6D, 0xB6, 0x26, 0xEE};
		
const sha1 ios36_DI_module_hash = 
	{0x26, 0x0B, 0xE9, 0x47, 0xA0, 0x8F, 0x57, 0xF6, 0xEF, 0x51, 
		0x08, 0x64, 0x27, 0xFE, 0x22, 0x2F, 0xD4, 0x04, 0x03, 0x99};

int patch_ios36_info_content(u8* buf, u32 size){
	printf("Replacing info content...");
	if (size != info_content_app_size){
		printf("Info content size is wrong! %u %u\n", size, info_content_app_size);
		return -1;
	}
	memcpy(buf, info_content_app, size);
	printf("Done\n");
	return 0;
}

int patch_ios36_DI_module(u8* buf, u32 size){
	const u8 readlimit_old_table[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
									0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x0A, 0x00, 0x00, 
									0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
									0x7E, 0xD4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08};

	const u8 dvdread_newlimit[] = {0x7E, 0xD4, 0x00, 0x00};
	
	u32 i = 0;
	bool found_enabledvd = false, found_readlimit = false;
	
	printf("Patching DI module....");
	
	while (i < size - sizeof readlimit_old_table && !(found_enabledvd && found_readlimit)){
		spinner();
	
		if (!found_readlimit && !memcmp(buf+i, readlimit_old_table, sizeof readlimit_old_table)){
			memcpy(buf+i+12, dvdread_newlimit, sizeof dvdread_newlimit);
			printf("\bPotch  ");
			found_enabledvd = true;
		}
		i++;
	}
	
	printf("\b\b! \n");
	
	if (!(found_enabledvd || found_readlimit)){
		printf("Couldn't find patch locations!\n");
		return -1;
	}
	
	return 0;
}

int patch_ios36_ES_module(u8* buf, u32 size){
	const u8 old_hash_check[] = {0x20,0x07,0x23,0xA2};
	const u8 addticket_vers_check[] = {0xD2,0x01,0x4E,0x56};
	const u8 setuid_check[] = {0xD1,0x2A,0x1C,0x39};
	const u8 delete_check[] = {0xD8,0x00,0x4A,0x04};
	const u8 opentitlecontent_check[] = { 0x9D, 0x05, 0x42, 0x9D, 0xD0, 0x03 };
	const u8 readcontent_check[] = { 0xFC, 0x0F, 0xB5, 0x30, 0x1C, 0x14, 0x1C, 0x1D, 0x4B, 0x0E, 0x68, 0x9B,
									0x2B, 0x00, 0xD0, 0x03, 0x29, 0x00, 0xDB, 0x01, 0x29, 0x0F, 0xDD, 0x01 };
	const u8 closecontent_check[] = { 0xB5, 0x10, 0x4B, 0x10, 0x68, 0x9B, 0x2B, 0x00, 0xD0,
									0x03, 0x29, 0x00, 0xDB, 0x01, 0x29, 0x0F, 0xDD, 0x01 };

	u32 i= 0;
	bool found_hash = false, found_addticket = false, found_setuid = false, found_delete = false, 
		found_opentitlecontent = false, found_readcontent = false, found_closecontent = false;
	
	printf("Patching ES Module....");

	while (i < size - sizeof readcontent_check
			&& !(found_hash && found_addticket && found_setuid && found_delete 
			&& found_opentitlecontent && found_readcontent )){
		spinner();
		
		if (!found_hash && !memcmp(buf+i, old_hash_check, sizeof old_hash_check)){
			buf[i+1] = 0x00;
			printf("\bpatch  ");
			found_hash = true;
		}
	
		if (!found_addticket && !memcmp(buf+i, addticket_vers_check, sizeof addticket_vers_check)){
			printf("\bpatch  ");
			buf[i] = 0xE0;
			found_addticket = true;
		}
	
		if (!found_setuid && !memcmp(buf+i, setuid_check, sizeof setuid_check)){
			printf("\bpatchity  ");
			*(u16*)(&buf[i]) = 0x46C0;
			found_setuid = true;
		}
	
		if (!found_delete && !memcmp(buf+i, delete_check, sizeof delete_check)){
			printf("\bpatchy  ");
			buf[i] = 0xE0;
			found_delete = true;
		}
		
		if (!found_opentitlecontent && !memcmp(buf+i, opentitlecontent_check, sizeof opentitlecontent_check)){
			printf("\bpatch  ");
			buf[i+4] = 0xE0;
			found_opentitlecontent = true;
		}
		
		if (!found_readcontent && !memcmp(buf+i, readcontent_check, sizeof readcontent_check)){
			printf("\bpatch  ");
			*(u16*)(&buf[i+14]) = 0x46C0;
			*(u16*)(&buf[i+18]) = 0x46C0;
			buf[i+22] = 0xE0;
			found_readcontent = true;
		}
		
        if (!found_closecontent && !memcmp(buf+i, closecontent_check, sizeof closecontent_check)){
			printf("\bpitch  ");
            *(u16*)(&buf[i+8]) = 0x46C0;
            *(u16*)(&buf[i+12]) = 0x46C0;
            found_closecontent = true;
        }
		i++;
	}
	
	printf ("\b\b! \n");
	
	if (!(found_hash || found_addticket || found_setuid || found_delete 
			|| found_opentitlecontent || found_readcontent )){
		printf("Couldn't find patch locations!\n");
		return -1;
	}
	
	return 0;
}



