/*-------------------------------------------------------------
 
cios_clone.c -- cIOS clone installation
 
Copyright (C) 2008 tona
 
This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any
damages arising from the use of this software.
 
Permission is granted to anyone to use this software for any
purpose, including commercial applications, and to alter it and
redistribute it freely, subject to the following restrictions:
 
1.The origin of this software must not be misrepresented; you
must not claim that you wrote the original software. If you use
this software in a product, an acknowledgment in the product
documentation would be appreciated but is not required.
 
2.Altered source versions must be plainly marked as such, and
must not be misrepresented as being the original software.
 
3.This notice may not be removed or altered from any source
distribution.
 
-------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <gccore.h>
#include <wiiuse/wpad.h>

#include "patchmii_core.h"
#include "uninstall.h"
#include "wiibasics.h"

#define CIOS_REVISION 5
#define INSTALLER_VERSION 1

int install_cIOS_clone(void){
	int ret;
	printf("\nInitializing patchmii....\n");
	patchmii_network_init();
	ret = patchmii_install(1, 36, 1042, 1, 249, CIOS_REVISION, true);
	if (ret) return ret;
	return 0;
}

int test_cios(void){
	int ret, cfd;
	static u8 fbuffer[0x40] ATTRIBUTE_ALIGN(32);
	static tikview viewdata[0x10] ATTRIBUTE_ALIGN(32);
	u32 views;
	static u64 tid ATTRIBUTE_ALIGN(32) = TITLE_ID(1,2);
	
	ret = ES_SetUID(TITLE_ID(1,2));
	printf("SetUID: %d\n", ret);
	
	tid = TITLE_ID(0x10001,0x48415858);
	//tid = TITLE_ID(1, 2);
	
	ret = ES_GetNumTicketViews(tid, &views);
	if (ret < 0) {
		printf(" Error! ES_GetNumTickets (ret = %d)\n", ret);
		wait_anyKey();
		return ret;
	}

	if (!views) {
		printf(" No tickets found!\n");
		wait_anyKey();
		return 0;
	} else if (views > 16) {
		printf(" Too many ticket views! (views = %d)\n", views);
		wait_anyKey();
		return 0;
	}
	
	ret = ES_GetTicketViews(tid, viewdata, 1);
	if (ret < 0)
	{
		printf("Error! ES_OpenTitleContent (ret = %d)\n", ret);
		wait_anyKey();
		return 0;
	}
	
	ret = ES_OpenTitleContent(tid, viewdata, 0);
	printf("ES_OpenTitleContent: %d\n", ret);
	if (ret < 0)
	{
		printf("Error! ES_OpenTitleContent (ret = %d)\n", ret);
		wait_anyKey();
		return 0;
	}
	
	cfd = ret;
	
	ret = ES_ReadContent(cfd,fbuffer,0x40);
	printf("ES_ReadContent: %d\n", ret);
	
	hex_print_array16(fbuffer, 0x40);
	printf("\n");
	
	ret = ES_CloseContent(cfd);
	if (ret < 0)
	{
		printf("Error! ES_CloseContent (ret = %d)\n", ret);
		wait_anyKey();
		return 0;
	}
	return 0;
}

//---------------------------------------------------------------------------------
int main(int argc, char **argv) {
//---------------------------------------------------------------------------------
	int ret = 0;
	int current_ios;
	IOS_ReloadIOS(249);
	
	basicInit();
	
	current_ios = IOS_GetVersion();
	
	printf("cIOS rev%02d Clone Installer - patchmii port v%d\n", CIOS_REVISION, INSTALLER_VERSION);
	printf("------------------------------------------\n");
	printf("This software comes with NO WARRANTY!\n\n\n");

	if (current_ios == 249){
		//test_cios();
		printf("cIOS seems to be installed. Do you want to uninstall it?\n");
		if (yes_or_no())
			Uninstall_FromTitle(TITLE_ID(1,249));
	} else {
		printf("Are you sure you want to install the cIOS clone?\n");
		
		
		if (yes_or_no())
			ret = install_cIOS_clone();
		
		if (ret)
			printf("ERROR Installing cIOS: %d\n", ret);
	}
	printf("\nThank you come again! (Press any key to exit)\n");
	wait_anyKey();
	
	return 0;
}
