#ifndef _WADMANAGER_H_
#define _WADMANAGER_H_

#ifdef __cplusplus
extern "C" {
#endif

// Constants
#define ENTRIES_PER_PAGE    17
#define MAX_FILENAME_LEN    59
#define MAX_DIR_LEVELS      10
#define WAD_DIRECTORY       "/"

#define KB_SIZE     1024.0
#define MB_SIZE     1048576.0
#define GB_SIZE     1073741824.0

#define MAXPATHLEN 1024
#define MAXJOLIET 255
#define MAXDISPLAY 45

typedef struct {
    char dir[MAXPATHLEN]; // directory path of browserList
    int numEntries; // # of entries in browserList
    int selIndex; // currently selected index of browserList
    int pageIndex; // starting index of browserList page display
} BROWSERINFO;

typedef struct {
    u64 offset; // DVD offset
    unsigned int length; // file length
    char isdir; // 0 - file, 1 - directory
    char filename[MAXJOLIET + 1]; // full filename
    char displayname[MAXDISPLAY + 1]; // name for browser display
    /* 1 = Batch Install, 2 = Batch Uninstall - Leathl */
    int install;
} BROWSERENTRY;

/* 'FAT File' structure */
typedef struct {
    /* Filename */
    char filename[128];
    /* 1 = Batch Install, 2 = Batch Uninstall - Leathl */
    int install;

    /* Filestat */
    struct stat filestat;
} fatFile;

extern BROWSERINFO browser;
extern BROWSERENTRY * browserList;
extern char rootdir[1024];
extern u8 gDirLevel;
extern const int ENTRIES_PER_PAGE_HALF_MIN_ONE;

int ParseDirectory2(int filterElfDol);
char *PopCurrentDir(s32 *Selected, s32 *Start);
bool IsListFull(void);
void WaitPrompt(char *);
char *PeekCurrentDir(void);
int PushCurrentDir(char *dirStr, s32 Selected, s32 Start);
int Menu_FatDevice(void);
void SetDefaultConfig(void);
int ReadConfigFile(char *);
int wadmanager();

#ifdef __cplusplus
}
#endif

#endif
