#ifndef _WAD_H_
#define _WAD_H_

#ifdef __cplusplus
extern "C" {
#endif

/* 'WAD Header' structure */
typedef struct {
    /* Header length */
    u32 header_len;

    /* WAD type */
    u16 type;

    u16 padding;

    /* Data length */
    u32 certs_len;
    u32 crl_len;
    u32 tik_len;
    u32 tmd_len;
    u32 data_len;
    u32 footer_len;
}ATTRIBUTE_PACKED wadHeader;

int installedIOS;

s32 Wad_GetTMD_and_Certs(char *filename, void **ptmd, u32 *tmdlen,
    void **certs, u32 *certslen);
bool check_WAD(char *filename, u32 version, u16 revision);
s32 Wad_Install(FILE *);
s32 Wad_Uninstall(FILE *);
s32 Wad_Dump(u64 id, char *path);

#ifdef __cplusplus
}
#endif

#endif
