#include <ogcsys.h>
#include <stdio.h>
#include <stdlib.h>
#include <wiiuse/wpad.h>
#include <wiilight.h>

#include "dopios.h"
#include "fat.h"
#include "gecko.h"
#include "network.h"
#include "sys.h"
#include "tools.h"
#include "video.h"

/* Constants */
#define CERTS_LEN 0x280

/* Variables */
static const char certs_fs[] ATTRIBUTE_ALIGN(32) = "/sys/cert.sys";
bool Shutdown = false;
extern void udelay(int us);

void __Sys_ResetCallback() {
    ExitMainThread = true;
}

void __Sys_PowerCallback() {
    /* Poweroff console */
    Shutdown = true;
    ExitMainThread = true;
}

void System_Init() {
    /* Initialize video subsytem */
#ifndef NO_DEBUG
    InitGecko();
#endif
    /*System_Deinit();
    __IOS_ShutdownSubsystems();

    __IOS_InitializeSubsystems();*/
    gprintf("\n\Wii Mod\n");gprintf("Initializing Wii\n");gprintf("VideoInit\n");
    Video_Init();
    

    gprintf("WPAD_Init\n");
    WPAD_Init();
    gprintf("PAD_Init\n");
    PAD_Init();
    WIILIGHT_Init();
    
    /* Set RESET/POWER button callback */
    WPAD_SetPowerButtonCallback(__Sys_PowerCallback);
    SYS_SetResetCallback(__Sys_ResetCallback);
    SYS_SetPowerCallback(__Sys_PowerCallback);
}

void System_Deinit() {
    SDCard_deInit();
    WPAD_Shutdown();
    NetworkShutdown();
}

void Sys_Reboot(void) {
    gprintf("Restart console\n");
    System_Deinit();
    STM_RebootSystem();
}

void System_Shutdown() {
    int ret;
    gprintf("\n");gprintf("Powering Off Console\n");
    System_Deinit();
    
    if (CONF_GetShutdownMode() == CONF_SHUTDOWN_IDLE) {
        ret = CONF_GetIdleLedMode();
        if (ret >= CONF_LED_OFF && ret <= CONF_LED_BRIGHT) ret
                = STM_SetLedMode(ret);
        
        ret = STM_ShutdownToIdle();
    } else
        ret = STM_ShutdownToStandby();
}

s32 Sys_GetCerts(signed_blob **certs, u32 *len) {
    static signed_blob certificates[CERTS_LEN] ATTRIBUTE_ALIGN(32);
    s32 fd, ret;
    
    /* Open certificates file */
    fd = IOS_Open(certs_fs, 1);
    if (fd < 0) return fd;

    /* Read certificates */
    ret = IOS_Read(fd, certificates, sizeof(certificates));
    /* Close file */
    IOS_Close(fd);
    
    /* Set values */
    if (ret > 0) {
        *certs = certificates;
        *len = sizeof(certificates);
    }

    return ret;
}
