#ifndef _FAT_H_
#define _FAT_H_

#include <sys/dir.h>

#ifdef __cplusplus
extern "C" {
#endif

/* 'FAT Device' structure */
typedef struct {
    /* Device mount point */
    char *mount;

    /* Device name */
    char *name;

    /* Device interface */
    const DISC_INTERFACE *interface;
} fatDevice;

extern fatDevice fdevList[];
extern fatDevice *fdev;
extern const int NB_FAT_DEVICES;

int USBDevice_Init();
void USBDevice_deInit();
int SDCard_Init();
void SDCard_deInit();
s32 Fat_Mount(fatDevice *);
void Fat_Unmount(fatDevice *);

#ifdef __cplusplus
}
#endif

#endif
