#ifndef IOSMENU_H
#define IOSMENU_H

#ifdef __cplusplus
extern "C" {
#endif

bool CheckForIOS(int ver, u64 rev);
int IOSMenu();

typedef enum {
    IOS_NotonNus, IOS_NoNusstub, IOS_Stub, IOS_OK
} Iosmode;

typedef struct IOSrev {
    u32 num;
    Iosmode mode;
    u32 hash[5];
} IOSrev;

typedef struct IOSlisting {
    u32 ver;
    int onnus;
    const char Description[512];
    u32 cnt;
    IOSrev revs[30];
} IOSlisting;

extern const int GrandIOSLEN;
extern int LesserIOSLEN;
extern const IOSlisting GrandIOSList[];
extern s32 GrandIOSListLookup[256];
extern s32 GrandIOSListLookup2[256];

#ifdef __cplusplus
}
#endif

#endif
