///////////////////////////////////////////////////////
// Tools
///////////////////////////////////////////////////////

// Includes
#include <string.h>
#include <malloc.h>

#include "sysCheckGX/Tools.h"

void *AllocateMemory(u32 size)
{
	return memalign(32, (size + 31)&(~31));
}

char *ReplaceString(const char *expression, const char *oldValue, const char *newValue)
{
	const char	*pos;
	char		*returnValue;
	size_t 	 	posReturnValue;
	size_t		size;
	size_t		allocatedSize;

	// Find the first occurrence
	pos = strstr(expression, oldValue);

	if (pos == NULL)
		return NULL;
	else
	{
		size = (size_t)pos - (size_t)expression;
		allocatedSize = size + strlen(newValue) + 1;
		returnValue = (char *)malloc(allocatedSize);
		posReturnValue = 0;

		strncpy(returnValue + posReturnValue, expression, size);
		posReturnValue += size;
		expression = pos + strlen(oldValue);

		size = strlen(newValue);
		strncpy(returnValue + posReturnValue, newValue, size);
		posReturnValue += size;

		// Find the first occurrence
		pos = strstr(expression, oldValue);

		while (pos != NULL)
		{
			size = (size_t)pos - (size_t)expression;
			allocatedSize += size + strlen(newValue);
			returnValue = (char *)realloc(returnValue, allocatedSize);

			strncpy(returnValue + posReturnValue, expression, size);
			posReturnValue += size;

			expression = pos + strlen (oldValue);

			size = strlen(newValue);
			strncpy(returnValue + posReturnValue, newValue, size);
			posReturnValue += size;

			// Find the next occurrence
			pos = strstr(expression, oldValue);
		}

		size = strlen(expression) + 1;
		allocatedSize += size;
		returnValue = (char *)realloc(returnValue, allocatedSize);
		strncpy(returnValue + posReturnValue, expression, size);
	}

	return returnValue;
}
