#ifndef _SYSTITLE_H_
	#define _SYSTITLE_H_

	// Includes
	#include <string>

	// Namespaces
	using namespace std;

	// Structures
	struct TmdViewContent
	{
		u32 Id;
		u32 Index;
		u16 Type;
		u64 Size;
	} ATTRIBUTE_PACKED;
	 
	struct TmdView
	{
		u8  Version; 				// 0x0000
		u8  Filler[3];
		u64 IosTitleId; 			// 0x0004
		u64 TitleId; 				// 0x00c
		u32 TitleType;				// 0x0014
		u16 GroupId; 				// 0x0018
		u8  Reserved[0x3e]; 		// 0x001a (This is the same reserved 0x3e bytes from the tmd)
		u16 TitleVersion; 			// 0x0058
		u16 NumberContents; 		// 0x005a
		TmdViewContent Contents[];	// 0x005c
	} ATTRIBUTE_PACKED;

	// Classes
	class SysTitle
	{
		// Private methods
		private:
			static int GetTMD(u64, tmd **);
			static int GetTMD(u64, signed_blob **);
			static int GetTMDView(u64, TmdView **);
			static int GetVersion(u64, u16 *);
			
		// Public methods
		public:
			static string GetBootFilename(u64);	
			static u16    GetVersion32(u32);
	};
#endif
