#ifndef _SHA1_H_
	#define _SHA1_H_

	// Structures
	typedef struct 
	{
		unsigned long state[5];
		unsigned long count[2];
		unsigned char buffer[64];
	} SHA1_CTX;

	#ifdef __cplusplus
		extern "C"
		{
	#endif

	// Prototypes
	void SHA1Transform(unsigned long state[5], unsigned char buffer[64]);
	void SHA1Init(SHA1_CTX*);
	void SHA1Update(SHA1_CTX*, unsigned char*, unsigned int);
	void SHA1Final(unsigned char digest[20], SHA1_CTX* context);
	void SHA1(unsigned char *, unsigned int, unsigned char *);

	#ifdef __cplusplus
		}
	#endif
#endif
