// Includes
#include <string.h>
#include <gccore.h>

#include "sysCheckGX/Patcher.h"
#include "sysCheckGX/SHA1.h"

int Patcher::BruteTMD(tmd *ptmd)
{
	u16 fill;

	for (fill = 0; fill < 65535; fill++) 
	{
		ptmd->fill3 = fill;
		sha1 hash;
		SHA1((u8 *)ptmd, TMD_SIZE(ptmd), hash);

		if (hash[0] == 0)
			return 0;
	}

	return -1;
}

void Patcher::ForgeTMD(signed_blob *signedTmd)
{
	ZeroSignature(signedTmd);
	BruteTMD((tmd*)SIGNATURE_PAYLOAD(signedTmd));
}

int Patcher::BruteTicket(tik *ticket) 
{
	u16 fill;

	for (fill = 0; fill < 65535; fill++) 
	{
		ticket->padding = fill;
		sha1 hash;
		SHA1((u8*)ticket, sizeof(ticket), hash);

		if (hash[0] == 0)
			return 0;
	}

	return -1;
}

void Patcher::ForgeTicket(signed_blob *signedTicket)
{
	ZeroSignature(signedTicket);
	BruteTicket((tik*)SIGNATURE_PAYLOAD(signedTicket));
}

void Patcher::ZeroSignature(signed_blob *sig)
{
	u8 *psig = (u8*)sig;

	memset(psig + 4, 0, SIGNATURE_SIZE(sig) - 4);
}
