// Includes
#include "sysCheckGX/NAND.h"
#include "sysCheckGX/Tools.h"

// Constants
#define BASE_PATH "/tmp"

// Variables
bool Nand::Initialized = false;

int Nand::Startup() 
{
	if (Initialized)
		return 0;

    int ret = ISFS_Initialize();

	Initialized = (ret == ISFS_OK);

	return ret;
}

void Nand::Shutdown()
{
	if (!Initialized)
		return;

	ISFS_Deinitialize();

	Initialized = false;
}

int Nand::OpenRead(const char *filePath)
{
	Startup();

	return ISFS_Open(filePath, ISFS_OPEN_READ);	
}

int Nand::Close(int fp) 
{
	if (fp < 1)
		return 0;

	return ISFS_Close(fp);
}

int Nand::Read(int fp, u8 *buffer, u32 length) 
{
	Startup();

    // Read file
    return ISFS_Read(fp, buffer, length);
}

int Nand::Read(const char *filePath, u8 **buffer)
{
	int ret = 0;
	int file = 0;
	u32 size = 0;

	file = Nand::OpenRead(filePath);

	if (file < 1)
		return file;

	size = Nand::GetFileSize(file);

	if (size == 0)
	{
		ret = -1;
		
		goto end;
	}

	*buffer = (u8*)AllocateMemory(size);

	if (!buffer)
		return -1;

	ret = Nand::Read(file, *buffer, size);

	if (!buffer)
		ret = -1;

end:
	Nand::Close(file);

	return ret;
}

u32 Nand::GetFileSize(int fp)
{
	if (fp < 1)
		return 0;

	Startup();
	fstats *status = (fstats*)AllocateMemory(sizeof(fstats));

	int ret = ISFS_GetFileStats(fp, status);

	if (ret < 0)
	{
		ret = 0;

		goto end;
	}

	ret = status->file_length;

end:
	delete status;
	
	status = NULL;
	
	return ret;
}
