// Includes
#include <string.h>

#include "sysCheckGX/Identify.h"
#include "sysCheckGX/Tools.h"
#include "sysCheckGX/Patcher.h"
#include "sysCheckGX/Tools.h"
#include "sysCheckGX/NAND.h"

#include "Ticket_dat.h"
#include "Tmd_dat.h"

int Identify::AsSuperUser()
{
	int 	ret = -1;
	u32 	keyId = 0;
	static	signed_blob *cert;
	static	u32 size;

	int file = Nand::OpenRead("/sys/cert.sys");

	if (file > 0)
	{	
		size = Nand::GetFileSize(file);
		cert = (signed_blob*)AllocateMemory(size);
		
		int ret = Nand::Read(file, (u8*)cert, size);
		
		Nand::Close(file);
		
		if (ret != (int)size)
			cert = (signed_blob*)NULL;
	}

	ret = ES_Identify(cert, size, (signed_blob*)Tmd_dat, Tmd_dat_size, (signed_blob*)Ticket_dat, Ticket_dat_size, &keyId);

	if (ret > -1)
		return ret;

	keyId = 0;

	signed_blob *stmd = NULL;
	signed_blob *sticket = NULL;
	tmd 		*ptmd = NULL;
	tik 		*pticket = NULL;
	u64 		titleId = 0x100000002ULL;	

	stmd = (signed_blob*)AllocateMemory(520);
	sticket = (signed_blob*)AllocateMemory(STD_SIGNED_TIK_SIZE);

	memset(stmd, 0, 520);
	memset(sticket, 0, STD_SIGNED_TIK_SIZE);

	stmd = &stmd[0];
	sticket = &sticket[0];
	*stmd = *sticket = 0x10001;
	ptmd = (tmd*)SIGNATURE_PAYLOAD(stmd);
	pticket = (tik*)SIGNATURE_PAYLOAD(sticket);

	// First, try prebuilt tmd/ticket (some IOSes unpatched will work with the prebuilt tmd/ticket, others don't)
	strcpy(ptmd->issuer, "Root-CA00000001-CP00000004");
	ptmd->title_id = titleId;
	ptmd->num_contents = 1;
	Patcher::ForgeTMD(stmd);

	// Try building a forged tmd/ticket
	strcpy(pticket->issuer, "Root-CA00000001-XS00000003");
	pticket->ticketid =  0x000038A45236EE5FULL;
	pticket->titleid = titleId;

	memset(pticket->cidx_mask, 0xFF, 0x20);
	Patcher::ForgeTicket(sticket);

	ret = ES_Identify(cert, size, stmd, 520, sticket, STD_SIGNED_TIK_SIZE, &keyId);

	// Free resources
	delete stmd;
	
	stmd = NULL;
	
	delete sticket;

	sticket = NULL;

	return ret;
}
