// Includes
#include <cstdio>

#include "sysCheckGX/Tools.h"
#include "sysCheckGX/FileSystem.h"

FILE *File::OpenBinary(const char *path)
{
	return fopen(path, "rb");
}

bool File::Exists(const char *path)
{
	FILE *fp = NULL;

	fp = fopen(path, "r");
	
	if (fp)
	{
		fclose(fp);
		fp = NULL;
		
		return true;
	}
	else
		return false;
}

int File::ReadBinary(const char *path, u8 **outbuf, u32 *outlen)
{
	return Read(path, "rb", outbuf, outlen);
}

int File::Read(const char *path, u8 **outbuf, u32 *outlen)
{
	return Read(path, "r", outbuf, outlen);
}

int File::Read(const char *path, const char *mode, u8 **outbuf, u32 *outlen)
{
	int ret;

	FILE *fp = NULL;
	
	fp = fopen(path, mode);
	
	if (fp)
	{
		fseek(fp, 0, SEEK_END);
		
		*outlen = ftell(fp);
		
		fseek(fp, 0, SEEK_SET);

		*outbuf = (u8*)AllocateMemory(*outlen);

		if (*outbuf == NULL) 
			ret = -1;

		if (fread(*outbuf, *outlen, 1, fp) != 1)
			ret = -2; // Failed to read the file so return an error
		else
			ret = 1; // File successfully loaded so return

		fclose(fp);
		fp = NULL;

		return ret;
	}
	else
		return -1;
}

int File::ReadOffset(FILE *fp, u32 offset, u32 length, u8 **outbuf)
{
	fseek(fp, offset, SEEK_SET);

	return fread(*outbuf, length, 1, fp);
}

int File::ReadOffsetAlloc(FILE *file, u32 offset, u32 length, u8 **outbuf)
{
	u8  *buffer = NULL;
	int ret;

	// Allocate memory
	buffer = (u8*)AllocateMemory(length);
	
	if (!buffer)
		return -1;

	// Read file
	ret = ReadOffset(file, offset, length, &buffer);

	if (ret < 0) 
	{
		delete buffer; buffer = NULL;

		return ret;
	}

	DCFlushRange(buffer, length);

	// Set pointer
	*outbuf = buffer;

	return 0;
}
