// Includes
#include <stdio.h>
#include <string.h>
#include <gccore.h>

#include "sysCheckGX/Extra.h"
#include "Language/GetText.h"

// Private Fields
char SystemMenuVersion::Message[6] = {};
char History::Message[256] = {};

char *SystemMenuVersion::ToString(u32 sysVersion)
{	
	memset(Message, 0, sizeof(Message));
	sprintf(Message, "?");

	switch (sysVersion)
	{
		case 97:
			sprintf(Message, "2.0U");
			
			break;

		case 128:
			sprintf(Message, "2.0J");
			
			break;

		case 130:
			sprintf(Message, "2.0E");
			
			break;

		case 162:
			sprintf(Message, "2.1E");
			
			break;

		case 192:
			sprintf(Message, "2.2J");
			
			break;

		case 193:
			sprintf(Message, "2.2U");
			
			break;

		case 194:
			sprintf(Message, "2.2E");
			
			break;

		case 224:
			sprintf(Message, "3.0J");
			
			break;

		case 225:
			sprintf(Message, "3.0U");
			
			break;

		case 226:
			sprintf(Message, "3.0E");
			
			break;

		case 256:
			sprintf(Message, "3.1J");
			
			break;

		case 257:
			sprintf(Message, "3.1U");
			
			break;

		case 258:
			sprintf(Message, "3.1E");
			
			break;

		case 288:
			sprintf(Message, "3.2J");
			
			break;

		case 289:
			sprintf(Message, "3.2U");
			
			break;

		case 290:
			sprintf(Message, "3.2E");
			
			break;

		case 352:
			sprintf(Message, "3.3J");
			
			break;

		case 353:
			sprintf(Message, "3.3U");
			
			break;

		case 354:
			sprintf(Message, "3.3E");
			
			break;

		case 384:
			sprintf(Message, "3.4J");
			
			break;

		case 385:
			sprintf(Message, "3.4U");
			
			break;

		case 386:
			sprintf(Message, "3.4E");
			
			break;

		case 390:
			sprintf(Message, "3.5K");
			
			break;

		case 416:
			sprintf(Message, "4.0J");
			
			break;

		case 417:
			sprintf(Message, "4.0U");
			
			break;

		case 418:
			sprintf(Message, "4.0E");
			
			break;

		case 448:
			sprintf(Message, "4.1J");
			
			break;

		case 449:
			sprintf(Message, "4.1U");
			
			break;

		case 450:
			sprintf(Message, "4.1E");
			
			break;

		case 454:
			sprintf(Message, "4.1K");
			
			break;

		case 480:
			sprintf(Message, "4.2J");
			
			break;

		case 481:
			sprintf(Message, "4.2U");
			
			break;

		case 482:
			sprintf(Message, "4.2E");
			
			break;

		case 486:
			sprintf(Message, "4.2K");
			
			break;

		case 512:
			sprintf(Message, "4.3J");
			
			break;

		case 513:
			sprintf(Message, "4.3U");
			
			break;

		case 514:
			sprintf(Message, "4.3E");
			
			break;

		case 518:
			sprintf(Message, "4.3K");
			
			break;
	}
	
	return Message;	
}

char *History::ToString(u32 titleID, bool infoStub, s32 infoRevision)
{
	memset(Message, 0, sizeof(Message));

	if ((titleID == 3) && (infoRevision == 65280))
		sprintf(Message, GetReportText("This is a stub IOS present in some Wiis. No known functional version has ever been found.", true));
	else if ((titleID == 4) && (!infoStub))
	{
		if (infoRevision == 3)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Very primitive IOS that was probably used during the manufacturing process.", true));
	}
	else if ((titleID == 9) && (!infoStub))
	{
		if (infoRevision == 516)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, "%s %s", GetReportText("Used by System Menu", true), "1.0.");
	}
	else if ((titleID == 10) && (infoRevision == 516))
		sprintf(Message, GetReportText("First Stub IOS.", true));
	else if ((titleID == 11) && (!infoStub))
	{
		if (infoRevision == 10)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Exclusively used by System Menu 2.0 and System Menu 2.1.", true));
	}
	else if ((titleID == 12) && (!infoStub))
	{
		if (infoRevision == 6)
			sprintf(Message, "%s ", GetReportText("First Release (June 4, 2006).", true));

		sprintf(Message, GetReportText("This is the oldest known version of IOS. It was probably developed to be used in Wii Demos and product showcases.", true));
	}
	else if ((titleID == 13) && (!infoStub))
	{
		if (infoRevision == 10)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Used by News, Weather and Photo 1.0 Channels.", true));
	}
	else if ((titleID == 15) && (!infoStub))
	{
		if (infoRevision == 257)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Contains NAND BOOT PROGRAM (this was probably accidental).", true));
	}
	else if ((titleID == 16) && (infoRevision == 257))
		sprintf(Message, GetReportText("This IOS was originally a leaked IOS from Nintendo's Wii Backup Disc.", true));
	else if ((titleID == 20) && (!infoStub))
	{
		if (infoRevision == 12)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Exclusively used by System Menu%s", true), " 2.2.");
	}
	else if ((titleID == 21) && (!infoStub))
	{
		if (infoRevision == 514)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Contains NAND boot program. Most debugging messages are removed. Most common for third-party titles.", true));
	}
	else if ((titleID == 30) && (!infoStub))
	{
		if (infoRevision == 1037)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Added USB Keyboard support.", true));

		if (infoRevision == 1037)
			sprintf(Message, " %s %s", GetReportText("Used by System Menu", true), "3.0.");

		if (infoRevision == 1039)
			sprintf(Message, " %s %s", GetReportText("Used by System Menu", true), "3.1.");

		if (infoRevision == 1040)
			sprintf(Message, " %s %s", GetReportText("Used by System Menu", true), "3.2.");

		if (infoRevision == 2576)
			sprintf(Message, " %s %s", GetReportText("Used by System Menu", true), "3.3.");
	}
	else if ((titleID == 31) && (!infoStub))
	{
		if (infoRevision == 1037)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Used by the Regional Titles for News & Weather.", true));
	}
	else if ((titleID == 34) && (!infoStub))
	{
		if (infoRevision == 1039)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Mostly used by the HackMii Installer as long as it's not fakesigned.", true));
	}
	else if (titleID == 36)
	{
		if (infoRevision == 1042)
			sprintf(Message, "%s %s", GetReportText("Initial Release.", true), GetReportText("Used by HackMii Installer v0.4 & v0.6.", true));
		else
			sprintf(Message, GetReportText("If the IOS revision is <> 1042 HackMii Installer v0.4 & v0.6 will not run properly (no usable or vulnerable IOS installed on this Wii).", true));
	}
	else if ((titleID == 37) && (!infoStub))
	{
		if (infoRevision == 2070)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Fixed the signing bug. Used by several WiiWare games.", true));
	}
	else if ((titleID == 38) && (!infoStub))
	{
		if (infoRevision == 3609)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Required and installed by the official Nintendo Wii Speak Channel.", true));
	}
	else if ((titleID == 40) && (!infoStub))
	{
		if (infoRevision == 3072)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, "%s %s %s.", GetReportText("Used by System Menu", true), "3.3", GetReportText("in Korea", true));
	}
	else if ((titleID == 53) && (!infoStub))
	{
		if (infoRevision == 4113)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Used by several WiiWare games.", true));
	}
	else if ((titleID == 55) && (!infoStub))
	{
		if (infoRevision == 4633)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, "%s %s", GetReportText("Required and installed by the official Nintendo Wii Speak Channel.", true), GetReportText("Used by several WiiWare games.", true));
	}
	else if ((titleID == 56) && (!infoStub))
	{
		if (infoRevision == 4890)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Used by the Wii Speak Channel 2.0. %s", true), GetReportText("Used by several WiiWare games.", true));

		if (infoRevision == 5146)
			sprintf(Message, " %s", GetReportText("Not available on NUS, only available via disc update.", true));
	}
	else if ((titleID == 58) && (!infoStub))
	{
		if (infoRevision == 5918)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("This is the first IOS with an official USB 2.0 module.", true));

		if (infoRevision == 5918)
			sprintf(Message, " %s", GetReportText("Not available on NUS, only available via disc update.", true));

		if (infoRevision == 6175)
			sprintf(Message, " %s", GetReportText("First release available on NUS. Used by the HackMii Installer as long as it's not fakesigned.", true));
	}
	else if ((titleID == 60) && (!infoStub))
	{
		if (infoRevision == 6943)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("It is known to have SDHC support.", true));
	}
	else if ((titleID == 61) && (!infoStub))
	{
		if (infoRevision == 4890)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, GetReportText("Used by the Wii Shop Channel from the System Menu 4.0, 4.1 and 4.2. Also used by Photo Channel 1.1 v3+. It is known to have SDHC support.", true));
	}
	else if ((titleID == 70) && (!infoStub))
	{
		if (infoRevision == 6687)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, "%s %s %s", GetReportText("Used by System Menu", true), "4.2.", GetReportText("It is known to have SDHC support.", true));
	}
	else if ((titleID == 80) && (!infoStub))
	{
		if (infoRevision == 6943)
			sprintf(Message, "%s ", GetReportText("Initial Release.", true));

		sprintf(Message, "%s %s %s", GetReportText("Used by System Menu", true), "4.3.", GetReportText("It is known to have SDHC support.", true));
	}
	else if ((titleID == 202) && (!infoStub))
		sprintf(Message, "%s %s", GetReportText("Used by Hermes as a custom IOS.", true), GetReportText("It is known to have DVD and USB 2.0 support.", true));
	else if ((titleID == 222) && (!infoStub))
		sprintf(Message, GetReportText("Used by Hermes as a custom IOS.", true));
	else if ((titleID == 223) && (!infoStub))
		sprintf(Message, GetReportText("Used by Hermes as a custom IOS.", true));
	else if ((titleID == 224) && (!infoStub))
		sprintf(Message, GetReportText("Used by Hermes as a custom IOS.", true));
	else if ((titleID == 249) && (!infoStub))
		sprintf(Message, GetReportText("Used by Waninkoko as a custom IOS. It is also used by the cIOS Patchmii Installer.", true));
	else if ((titleID == 250) && (!infoStub))
		sprintf(Message, GetReportText("Used by Waninkoko as a backup of his custom IOS.", true));
	else if (titleID == 254)
	{
		switch (infoRevision)
		{
			case 31338: // BootMii As IOS is installed on IOS254 rev 31338 (HackMiiInstaller v0.6)
				sprintf(Message, GetReportText("Used by BootMii %s.", true), GetReportText("(HackMiiInstaller v0.6)", true));
				
				break;

			case 65280:
				sprintf(Message, GetReportText("Used by BootMii.", true));
				
				break;

			case 65281: // BootMii As IOS is installed on IOS254 rev 65281 (HackMiiInstaller v0.7x)
				sprintf(Message, GetReportText("Used by BootMii %s.", true), GetReportText("(HackMiiInstaller v0.7x)", true));
				
				break;

			default:
				sprintf(Message, GetReportText("Used by PatchMii as a temporary IOS.", true));
				
				break;
		}
	}
	
	return Message;	
}
