///////////////////////////////////////////////////////
// Copyright (C) 2009
// by Dimok
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications and to alter it and
// redistribute it freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you
//    must not claim that you wrote the original software. If you use
//    this software in a product, an acknowledgment in the product
//    documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such and
//    must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
///////////////////////////////////////////////////////

// Includes
#include "Libs/LibWiiGUI/GUI.h"
#include "Prompts/PromptWindows.h"
#include "Menu/Menu.h"
#include "System/FileOps.h"
#include "Language/GetText.h"
#include "Text/TextEditor.h"

// Constants
#define EFFECT_SLEEP 50

// Extern variables
extern GuiWindow *mainWindow;

// Extern methods
extern void ResumeGui();
extern void HaltGui();

// Text viewer
void TextViewer(const char *filePath)
{
    bool exitWindow = false;
    u8	 *file = NULL;
    u64	 fileSize = 0;

    int ret = LoadFileToMem(filePath, &file, &fileSize);

    if ((ret == -1) || (ret == -3))
	{
        MessageBox(ERROR, true, GetText("Error"), GetText("Can not open the file!"), GetText("OK"));

        return;
	}
    else if (ret == -2)
	{
        MessageBox(ERROR, true, GetText("Error"), GetText("Not enough memory!"), GetText("OK"));

        return;
	}
    else if (ret == -10)
	{
        MessageBox(EXCLAMATION, true, "", GetText("Action cancelled!"), GetText("OK"));
    
		return;
	}
	
	// Check if enough memory available
    char *fileText = new char[fileSize];

    if (!fileText)
	{
        MessageBox(ERROR, true, GetText("Error!"), GetText("Not enough memory!"), GetText("OK"));

        return;
	}

    snprintf(fileText, fileSize, "%s", (char *)file);

    free(file);
	
    file = NULL;

    char *fileName = strrchr(filePath, '/') + 1;

    TextEditor Editor(fileText, 9, fileName);
    Editor.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    Editor.SetPosition(0, 0);
	Editor.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);
	
    delete [] fileText;

    fileText = NULL;

    HaltGui();
	mainWindow->SetState(STATE_DISABLED);
    mainWindow->Append(&Editor);
    mainWindow->ChangeFocus(&Editor);
    ResumeGui();
	
	while (Editor.GetEffect() > 0)
		usleep(EFFECT_SLEEP);
    
    while (!exitWindow)
    {
        if (Editor.GetState() == STATE_CLICKED)
            exitWindow = true;
	}

    Editor.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);
	
	HaltGui();
    mainWindow->Append(&Editor);
    ResumeGui();
	
	while (Editor.GetEffect() > 0)
		usleep(EFFECT_SLEEP);
    
	HaltGui();
    mainWindow->Remove(&Editor);
	mainWindow->SetState(STATE_DEFAULT);
    ResumeGui();
}
