#ifndef TEXTEDITOR_H
	#define TEXTEDITOR_H

	// Includes
	#include "Libs/LibWiiGUI/GUI.h"

	// Classes
	class TextEditor : public GuiElement
	{
		// Public methods
		public:
			TextEditor(char *, int, char *);
			~TextEditor(void);

			void DisableTriggerUpdate(bool);
			void SetText(char *);
			void SetFocus(bool);
			void SetAlignment(int, int);
			void ResetState(void);
			void Draw(void);
			void Update(GuiTrigger *);

		// Protected fields
		protected:
			int 		 currentLine;
			int 		 linesToDraw;
			int 		 totalLines;
			bool 		 focus;
			bool 		 triggerDisabled;

			GuiWindow    *Window;

			GuiButton    *arrowUpBtn;
			GuiButton    *arrowDownBtn;
			GuiButton    *scrollbarBoxBtn;
			GuiButton    *closeBtn;

			GuiImage     *bgTexteditorImg;
			GuiImage     *arrowDownImg;
			GuiImage     *arrowDownOverImg;
			GuiImage     *arrowUpImg;
			GuiImage     *arrowUpOverImg;
			GuiImage     *scrollbarBoxImg;
			GuiImage     *scrollbarBoxOverImg;
			GuiImage     *closeImg;
			GuiImage     *closeImgOver;

			GuiImageData *bgTexteditorData;
			GuiImageData *arrowDown;
			GuiImageData *arrowDownOver;
			GuiImageData *arrowUp;
			GuiImageData *arrowUpOver;
			GuiImageData *scrollbarBox;
			GuiImageData *scrollbarBoxOver;
			GuiImageData *closeImgData;
			GuiImageData *closeImgOverData;

			GuiSound     *btnSoundOver;
			GuiSound     *btnSoundClick;

			GuiTrigger   *triggerA;
			GuiTrigger   *triggerHeldA;
			GuiTrigger   *triggerB;
			GuiTrigger   *triggerHome;

			GuiText      *titleTxt;
			GuiText      *fileContentTxt;
	};
#endif
