// Includes
#include "Menu/Menu.h"
#include "Main.h"
#include "System/Storage/Mounter.h"

// Constants
#define ShutdownToDefault	0
#define ShutdownToIdle		1
#define ShutdownToStandby	2

// Variables
u8 shutdown = 0;
u8 reset = 0;

void AppExit()
{
	ExitGUIThreads();
	StopGX();
	ShutdownAudio();
}

void __Sys_ResetCallback(void)
{
	reset = 1;
}

void __Sys_PowerCallback(void)
{
	shutdown = 1;
}

void Sys_Init(void)
{
	SYS_SetResetCallback(__Sys_ResetCallback);
	SYS_SetPowerCallback(__Sys_PowerCallback);
}

void Sys_Reboot(void)
{
	AppExit();
	STM_RebootSystem();
}

static void _Sys_Shutdown(int SHUTDOWN_MODE)
{
	AppExit();
	WPAD_Flush(0);
	WPAD_Disconnect(0);
	WPAD_Shutdown();

	if ((CONF_GetShutdownMode() == CONF_SHUTDOWN_IDLE &&  SHUTDOWN_MODE != ShutdownToStandby) || SHUTDOWN_MODE == ShutdownToIdle)
	{
		s32 ret;

		ret = CONF_GetIdleLedMode();

		if (ret >= 0 && ret <= 2)
			STM_SetLedMode(ret);

		STM_ShutdownToIdle();
	}
	else
		STM_ShutdownToStandby();
}

void Sys_Shutdown(void)
{
	_Sys_Shutdown(ShutdownToDefault);
}

void Sys_ShutdownToIdle(void)
{
	_Sys_Shutdown(ShutdownToIdle);
}

void Sys_ShutdownToStandby(void)
{
	_Sys_Shutdown(ShutdownToStandby);
}

void Sys_LoadMenu(void)
{
	AppExit();
	
	// Return to the Wii system menu
	SYS_ResetSystem(SYS_RETURNTOMENU, 0, 0);
}

void Sys_BackToLoader(void)
{
	AppExit();

	if (*((u32*) 0x80001800))
		exit(0);

	// Channel Version
	Sys_LoadMenu();
}

void Sys_ExitToPriiloader(void)
{
	AppExit();
	SDMount();
//	Nand::Shutdown();
//  ISFS_Unmount();

	// Set the magic word
	*(vu32*)0x8132FFFB = 0x4461636f; // Causes PriiLoader to skip autoboot and load the PriiLoader menu
//	*(vu32*)0x8132FFFB = 0x50756e65; // Causes PriiLoader to skip autoboot and load System Menu

	sleep(2);

	// Reset system
	SYS_ResetSystem(SYS_RESTART, 0, 0);

	// Wait for next frame
	VIDEO_WaitVSync();
}
