/////////////////////////////////////////////////////////
// Metaphrasis is a static conversion class for transforming RGBA image
// buffers into verious GX texture formats for Wii homebrew development.
// Copyright (C) 2008 Armin Tamzarian
// 
// This file is part of Metaphrasis.
// 
// Metaphrasis is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Metaphrasis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with Metaphrasis.  If not, see <http://www.gnu.org/licenses/>.
/////////////////////////////////////////////////////////

#ifndef METAPHRASIS_H_
	#define METAPHRASIS_H_

	// Includes
	#include <gccore.h>
	#include <stdint.h>
	#include <malloc.h>
	#include <string.h>

	// Classes
	class Metaphrasis
	{
		// Public methods
		public:
			Metaphrasis(void);
			virtual ~Metaphrasis(void);

			static uint32_t *convertBufferToI4(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToI8(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToIA4(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToIA8(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToRGBA8(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToRGB565(uint32_t *, uint16_t, uint16_t);
			static uint32_t *convertBufferToRGB5A3(uint32_t *, uint16_t, uint16_t);

			static uint8_t  convertRGBAToIA4(uint32_t);
			static uint16_t convertRGBAToIA8(uint32_t);
			static uint16_t convertRGBAToRGB565(uint32_t);
			static uint16_t convertRGBAToRGB5A3(uint32_t);
	};
#endif
