// Includes
#include "Libs/LibWiiGUI/GUI.h"
#include "Prompts/PromptWindows.h"
#include "Menu/HomeMenu.h"
#include "Settings/SettingsPrompts.h"
#include "Menu/Menu.h"
#include "Main.h"

// Constants
#define EFFECT_SLEEP 50

// Extern variables
extern GuiWindow *mainWindow;
extern GuiSound  *backgroundMusic;

// Extern methods
extern void ResumeGui();
extern void HaltGui();

int ShowMenuSettings()
{
	Settings Settings;
	
	int menu = MENU_NONE;
	int ret;
	int quit = 0;
	
	// Enumerations
	enum
	{
		FADE,
		LEFT,
		RIGHT
	};
	
	int slideDirection = FADE;

	// Sounds
	GuiSound btnSoundOver(ButtonOver_pcm, ButtonOver_pcm_size, SOUND_PCM, cfg.SFXVolume);
	GuiSound btnClick(ButtonClick_pcm, ButtonClick_pcm_size, SOUND_PCM, cfg.SFXVolume);
	
	// Triggers
	GuiTrigger triggerA;
	triggerA.SetSimpleTrigger(-1, WPAD_BUTTON_A | WPAD_CLASSIC_BUTTON_A, PAD_BUTTON_A);

	GuiTrigger triggerB;
	triggerB.SetButtonOnlyTrigger(-1, WPAD_BUTTON_B | WPAD_CLASSIC_BUTTON_B, PAD_BUTTON_B);

	GuiTrigger triggerHome;
	triggerHome.SetButtonOnlyTrigger(-1, WPAD_BUTTON_HOME | WPAD_CLASSIC_BUTTON_HOME, 0);

	// Objects
	GuiImageData btnOutline(SettingsMenuButton_png);
	GuiImageData settingsbg(BackgroundSettings_png);
	
	GuiImageData MainButtonImgData(SettingsTitle_png);
	GuiImageData MainButtonImgOverData(SettingsTitleOver_png);

	GuiText titleTxt(GetText("Settings"), 28, (GXColor){0, 0, 0, 255});
	titleTxt.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	titleTxt.SetPosition(0, 38);

	GuiImage settingsbackground(&settingsbg);
	
	GuiText btnBackTxt(GetText("Go Back"), 22, (GXColor){0, 0, 0, 255});
	btnBackTxt.SetMaxWidth(btnOutline.GetWidth() - 30, GuiText::WRAP);
	GuiImage btnBackImg(&btnOutline);
	GuiButton btnBack(btnBackImg.GetWidth(), btnBackImg.GetHeight());
	btnBack.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	btnBack.SetPosition(-180, 400);
	btnBack.SetImage(&btnBackImg);
	btnBack.SetImageOver(&btnBackImg);
	btnBack.SetLabel(&btnBackTxt);
	btnBack.SetSoundOver(&btnSoundOver);
	btnBack.SetSoundClick(&btnClick);
	btnBack.SetTrigger(&triggerA);
	btnBack.SetTrigger(&triggerB);
	btnBack.SetEffectGrow();

	GuiButton home(1, 1);
	home.SetTrigger(&triggerHome);
	
	GuiImage btnHomebrewImg(&MainButtonImgData);
	GuiImage btnHomebrewImgOver(&MainButtonImgOverData);
	GuiText btnHomebrewTxt(GetText("Homebrew"), 32, (GXColor){0, 0, 0, 255});
	btnHomebrewTxt.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
	btnHomebrewTxt.SetPosition(0, -15);
	btnHomebrewTxt.SetMaxWidth(btnHomebrewImg.GetWidth(), GuiText::WRAP);
	GuiButton btnHomebrew(btnHomebrewImg.GetWidth(), btnHomebrewImg.GetHeight());
	btnHomebrew.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	btnHomebrew.SetPosition(0, 90);
	btnHomebrew.SetImage(&btnHomebrewImg);
	btnHomebrew.SetImageOver(&btnHomebrewImgOver);
	btnHomebrew.SetLabel(&btnHomebrewTxt);
	btnHomebrew.SetSoundOver(&btnSoundOver);
	btnHomebrew.SetSoundClick(&btnClick);
	btnHomebrew.SetEffectGrow();
	btnHomebrew.SetTrigger(&triggerA);

	GuiImage btnSoundImg(&MainButtonImgData);
	GuiImage btnSoundImgOver(&MainButtonImgOverData);
	GuiText btnSoundTxt(GetText("Sound"), 32, (GXColor){0, 0, 0, 255});
	btnSoundTxt.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
	btnSoundTxt.SetPosition(0, -15);
	btnSoundTxt.SetMaxWidth(btnSoundImg.GetWidth(), GuiText::WRAP);
	GuiButton btnSound(btnSoundImg.GetWidth(), btnSoundImg.GetHeight());
	btnSound.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	btnSound.SetPosition(0, 160);
	btnSound.SetImage(&btnSoundImg);
	btnSound.SetImageOver(&btnSoundImgOver);
	btnSound.SetLabel(&btnSoundTxt);
	btnSound.SetSoundOver(&btnSoundOver);
	btnSound.SetSoundClick(&btnClick);
	btnSound.SetEffectGrow();
	btnSound.SetTrigger(&triggerA);

	GuiImage btnFoldersImg(&MainButtonImgData);
	GuiImage btnFoldersImgOver(&MainButtonImgOverData);
	GuiText btnFoldersTxt(GetText("Folders"), 32, (GXColor){0, 0, 0, 255});
	btnFoldersTxt.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
	btnFoldersTxt.SetPosition(0, -15);
	btnFoldersTxt.SetMaxWidth(btnFoldersImg.GetWidth(), GuiText::WRAP);
	GuiButton btnFolders(btnFoldersImg.GetWidth(), btnFoldersImg.GetHeight());
	btnFolders.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	btnFolders.SetPosition(0, 230);
	btnFolders.SetImage(&btnFoldersImg);
	btnFolders.SetImageOver(&btnFoldersImgOver);
	btnFolders.SetLabel(&btnFoldersTxt);
	btnFolders.SetSoundOver(&btnSoundOver);
	btnFolders.SetSoundClick(&btnClick);
	btnFolders.SetEffectGrow();
	btnFolders.SetTrigger(&triggerA);

	GuiImage btnCreditsImg(&MainButtonImgData);
	GuiImage btnCreditsImgOver(&MainButtonImgOverData);
	GuiText btnCreditsTxt(GetText("Credits"), 32, (GXColor){0, 0, 0, 255});
	btnCreditsTxt.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
	btnCreditsTxt.SetPosition(0, -15);
	btnCreditsTxt.SetMaxWidth(btnCreditsImg.GetWidth(), GuiText::WRAP);
	GuiButton btnCredits(btnCreditsImg.GetWidth(), btnCreditsImg.GetHeight());
	btnCredits.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	btnCredits.SetPosition(0, 300);
	btnCredits.SetImage(&btnCreditsImg);
	btnCredits.SetImageOver(&btnCreditsImgOver);
	btnCredits.SetLabel(&btnCreditsTxt);
	btnCredits.SetSoundOver(&btnSoundOver);
	btnCredits.SetSoundClick(&btnClick);
	btnCredits.SetEffectGrow();
	btnCredits.SetTrigger(&triggerA);

	int i = 0;

	OptionList optionsHomebrew;

	sprintf(optionsHomebrew.name[i++], GetText("Auto Shutdown Homebrew"));
	sprintf(optionsHomebrew.name[i++], GetText("Shutdown Mode"));
	sprintf(optionsHomebrew.name[i++], GetText("Display Report"));
	sprintf(optionsHomebrew.name[i++], GetText("Detailed Report"));
	sprintf(optionsHomebrew.name[i++], GetText("Use Language File"));
	sprintf(optionsHomebrew.name[i++], GetText("Rumble"));
	sprintf(optionsHomebrew.name[i++], GetText("Screen Size"));
	sprintf(optionsHomebrew.name[i++], GetText("Field Separator"));
	
	optionsHomebrew.length = i;

	GuiOptionBrowser optionBrowserHomebrew(396, 280, &optionsHomebrew);
	optionBrowserHomebrew.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	optionBrowserHomebrew.SetPosition(0, 90);

	i = 0;

	OptionList optionsSound;

	sprintf(optionsSound.name[i++], GetText("SFX Volume"));
	sprintf(optionsSound.name[i++], GetText("Music Volume"));

	optionsSound.length = i;

	GuiOptionBrowser optionBrowserSound(396, 280, &optionsSound);
	optionBrowserSound.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	optionBrowserSound.SetPosition(0, 90);

	i = 0;

	OptionList optionsFolders;

	sprintf(optionsFolders.name[i++], GetText("Language File Folder"));
	sprintf(optionsFolders.name[i++], GetText("Report Folder"));

	optionsFolders.length = i;
	
	GuiOptionBrowser optionBrowserFolders(396, 280, &optionsFolders);
	optionBrowserFolders.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	optionBrowserFolders.SetPosition(0, 90);
	
	GuiWindow w(ScreenWidth, ScreenHeight);
	
	int pageToDisplay = 1;
	
	while (pageToDisplay > 0) // Set to 0 to quit
	{
		usleep(THREAD_SLEEP);

		menu = MENU_NONE;

		if (pageToDisplay == 1)
		{
			// Standard procedure made in all pages
			btnHomebrew.StopEffect();
			btnSound.StopEffect();
			btnFolders.StopEffect();
			btnCredits.StopEffect();

			if (slideDirection == RIGHT)
			{
				btnHomebrew.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_OUT, 35);
				btnSound.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_OUT, 35);
				btnFolders.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_OUT, 35);
				btnCredits.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_OUT, 35);

				while (btnHomebrew.GetEffect() > 0)
					usleep(EFFECT_SLEEP);
			}
			else if (slideDirection == LEFT)
			{
				btnHomebrew.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_OUT, 35);
				btnSound.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_OUT, 35);
				btnFolders.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_OUT, 35);
				btnCredits.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_OUT, 35);

				while (btnHomebrew.GetEffect() > 0)
					usleep(EFFECT_SLEEP);
			}

			// Set Widescreen
			if (cfg.Widescreen == Widescreen_On)
			{
				titleTxt.SetWidescreen(true);
				settingsbackground.SetWidescreen(true);
				btnBackTxt.SetWidescreen(true);
				btnBackImg.SetWidescreen(true);
				btnHomebrewImg.SetWidescreen(true);
				btnHomebrewImgOver.SetWidescreen(true);
				btnHomebrewTxt.SetWidescreen(true);
				btnSoundImg.SetWidescreen(true);
				btnSoundImgOver.SetWidescreen(true);
				btnSoundTxt.SetWidescreen(true);
				btnFoldersImg.SetWidescreen(true);
				btnFoldersImgOver.SetWidescreen(true);
				btnFoldersTxt.SetWidescreen(true);
				btnCreditsImg.SetWidescreen(true);
				btnCreditsImgOver.SetWidescreen(true);
				btnCreditsTxt.SetWidescreen(true);
			}

			HaltGui();

			mainWindow->RemoveAll();
			mainWindow->Append(&w);

			w.RemoveAll();

			// Append objects
			w.Append(&settingsbackground);
			w.Append(&titleTxt);
			w.Append(&btnBack);
			w.Append(&home);
			w.Append(&btnHomebrew);
			w.Append(&btnSound);
			w.Append(&btnFolders);
			w.Append(&btnCredits);
			
			btnFolders.SetImage(&btnFoldersImg);
			btnFolders.SetImageOver(&btnFoldersImgOver);
			
			// Disable ability to click through Main buttons
			optionBrowserHomebrew.SetClickable(false);
			optionBrowserSound.SetClickable(false);
			optionBrowserFolders.SetClickable(false);
			
			btnHomebrew.StopEffect();
			btnSound.StopEffect();
			btnFolders.StopEffect();
			btnCredits.StopEffect();

			btnHomebrew.SetEffectGrow();
			btnSound.SetEffectGrow();
			btnFolders.SetEffectGrow();
			btnCredits.SetEffectGrow();

			if (slideDirection == FADE)
			{
				btnHomebrew.SetEffect(EFFECT_FADE, 20);
				btnSound.SetEffect(EFFECT_FADE, 20);
				btnFolders.SetEffect(EFFECT_FADE, 20);
				btnCredits.SetEffect(EFFECT_FADE, 20);
			}
			else if (slideDirection == LEFT)
			{
				btnHomebrew.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_IN, 35);
				btnSound.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_IN, 35);
				btnFolders.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_IN, 35);
				btnCredits.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_IN, 35);
			}
			else if (slideDirection == RIGHT)
			{
				btnHomebrew.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_IN, 35);
				btnSound.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_IN, 35);
				btnFolders.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_IN, 35);
				btnCredits.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_IN, 35);
			}

			mainWindow->Append(&w);

			ResumeGui();

			while (btnHomebrew.GetEffect() > 0)
				usleep(EFFECT_SLEEP);
		}

		while (menu == MENU_NONE)
		{
			usleep(THREAD_SLEEP);

			if (pageToDisplay == 1)
			{
				bool firstRun = true;
				
				if (home.GetState() == STATE_CLICKED)
				{
					backgroundMusic->Pause();

					int choice = WindowExitPrompt();
					
					switch (choice)
					{
//						case CHOICE_PRIILOADER:
//							Settings.Save();
//							Sys_ExitToPriiloader();
//
//							break;

						case CHOICE_IDLE_SHUTDOWN:
							Settings.Save();
							Sys_ShutdownToIdle();

							break;

						case CHOICE_FULL_SHUTDOWN:
							Settings.Save();
							Sys_ShutdownToStandby();

							break;

						case CHOICE_SYSTEM_MENU:
							Settings.Save();
							Sys_LoadMenu();

							break;

						case CHOICE_HBC:
							Settings.Save();
							Sys_BackToLoader();

							break;

						default:
							mainWindow->SetState(STATE_DEFAULT);
							backgroundMusic->Resume();
							backgroundMusic->Play();
							home.ResetState();
							
							menu = MENU_NONE;

							break;
					}
				}
				
				if (btnHomebrew.GetState() == STATE_CLICKED)
				{
					btnHomebrew.SetEffect(EFFECT_FADE, -20);
					btnSound.SetEffect(EFFECT_FADE, -20);
					btnFolders.SetEffect(EFFECT_FADE, -20);
					btnCredits.SetEffect(EFFECT_FADE, -20);
					
					while (btnHomebrew.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					HaltGui();

					w.Remove(&btnHomebrew);
					w.Remove(&btnSound);
					w.Remove(&btnFolders);
					w.Remove(&btnCredits);

					titleTxt.SetText(GetText("Homebrew"));
					quit = 0;
					w.Append(&optionBrowserHomebrew);
					optionBrowserHomebrew.SetClickable(true);
					ResumeGui();

					usleep(THREAD_SLEEP);
					optionBrowserHomebrew.SetEffect(EFFECT_FADE, 20);

					while (optionBrowserHomebrew.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					while (quit == 0)
					{
						usleep(THREAD_SLEEP);

						if (btnBack.GetState() == STATE_CLICKED)
						{
							btnBack.ResetState();
							quit = 1;
							
							break;
						}
						else if (home.GetState() == STATE_CLICKED)
						{
			
            				backgroundMusic->Pause();

							int choice = WindowExitPrompt();

							switch (choice)
							{
//								case CHOICE_PRIILOADER:
//									Settings.Save();
//									Sys_ExitToPriiloader();
//
//									break;

								case CHOICE_IDLE_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToIdle();

									break;

								case CHOICE_FULL_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToStandby();

									break;

								case CHOICE_SYSTEM_MENU:
									Settings.Save();
									Sys_LoadMenu();

									break;

								case CHOICE_HBC:
									Settings.Save();
									Sys_BackToLoader();

									break;

								default:
									mainWindow->SetState(STATE_DEFAULT);
									backgroundMusic->Resume();
									backgroundMusic->Play();
									home.ResetState();
									
									menu = MENU_NONE;

									break;
							}
						}

						ret = optionBrowserHomebrew.GetClickedOption();

						switch (ret)
						{
							case 0:
								cfg.AutoShutdownHomebrew++;
								
								if (cfg.AutoShutdownHomebrew > 1)
								{
									cfg.AutoShutdownHomebrew = AutoShutdownHomebrew_Off;
									cfg.ShutdownMode = ShutdownMode_Off;
								}

								if (cfg.AutoShutdownHomebrew == AutoShutdownHomebrew_On)
									cfg.ShutdownMode = ShutdownMode_SystemMenu;
								
								break;

							case 1:
								cfg.ShutdownMode++;
								
								if (cfg.ShutdownMode > 3)
									cfg.ShutdownMode = ShutdownMode_Off;

								if (cfg.ShutdownMode == ShutdownMode_Off)
									cfg.AutoShutdownHomebrew = AutoShutdownHomebrew_Off;
								else
									cfg.AutoShutdownHomebrew = AutoShutdownHomebrew_On;

								break;

							case 2:
								cfg.DisplayReport++;
								
								if (cfg.DisplayReport > 1)
									cfg.DisplayReport = DisplayReport_Off;
									
								break;

							case 3:
								cfg.DetailedReport++;
								
								if (cfg.DetailedReport > 1)
									cfg.DetailedReport = DetailedReport_Off;
									
								break;

							case 4:
								cfg.UseLanguageFile++;
								
								if (cfg.UseLanguageFile > 1)
									cfg.UseLanguageFile = UseLanguageFile_Off;
									
								break;

							case 5:
								cfg.Rumble++;
								
								if (cfg.Rumble > 1)
									cfg.Rumble = Rumble_Off;
									
								break;

							case 6:
								cfg.Widescreen++;
								
								if (cfg.Widescreen > 1)
									cfg.Widescreen = Widescreen_Off;
									
								break;

							case 7:
								cfg.FieldSeparator++;
								
								if (cfg.FieldSeparator > 1)
									cfg.FieldSeparator = 0;
									
								break;
						}

						if (ret >= 0 || firstRun)
						{
							firstRun = false;

							if (cfg.AutoShutdownHomebrew == AutoShutdownHomebrew_Off)
								snprintf(optionsHomebrew.value[0], 256, "%s", GetText("Off"));
							else 
								snprintf(optionsHomebrew.value[0], 256, "%s", GetText("On"));

							switch (cfg.ShutdownMode)
							{
								case ShutdownMode_Off:
									snprintf(optionsHomebrew.value[1], 256, "%s", GetText("Off"));

									break;
								
								case ShutdownMode_HBC:
									snprintf(optionsHomebrew.value[1], 256, "%s", GetText("HBC"));

									break;
								
								case ShutdownMode_SystemMenu:
									snprintf(optionsHomebrew.value[1], 256, "%s", GetText("System Menu"));

									break;
								
								default:
									snprintf(optionsHomebrew.value[1], 256, "%s", GetText("Shutdown"));

									break;
							}

							if (cfg.DisplayReport == DisplayReport_Off)
								snprintf(optionsHomebrew.value[2], 256, "%s", GetText("No"));
							else
								snprintf(optionsHomebrew.value[2], 256, "%s", GetText("Yes"));

							if (cfg.DetailedReport == DetailedReport_Off)
								snprintf(optionsHomebrew.value[3], 256, "%s", GetText("No"));
							else
								snprintf(optionsHomebrew.value[3], 256, "%s", GetText("Yes"));

							if (cfg.UseLanguageFile == UseLanguageFile_Off)
								snprintf(optionsHomebrew.value[4], 256, "%s", GetText("Off"));
							else
								snprintf(optionsHomebrew.value[4], 256, "%s", GetText("On"));

							if (cfg.Rumble == Rumble_Off)
								snprintf(optionsHomebrew.value[5], 256, "%s", GetText("Off"));
							else
								snprintf(optionsHomebrew.value[5], 256, "%s", GetText("On"));

							if (cfg.Widescreen == Widescreen_Off)
								snprintf(optionsHomebrew.value[6], 256, "%s", "4/3");
							else
								snprintf(optionsHomebrew.value[6], 256, "%s", "16/9");
							
							if (cfg.FieldSeparator == FieldSeparator_Comma)
								snprintf(optionsHomebrew.value[7], 256, "%s", ",");
							else
								snprintf(optionsHomebrew.value[7], 256, "%s", ";");

							optionBrowserHomebrew.TriggerUpdate();
						}
					}

					// Load language file
					if (cfg.UseLanguageFile == UseLanguageFile_On)
						Settings.LoadLanguage();
					else
						GetTextCleanUp();

					optionBrowserHomebrew.SetEffect(EFFECT_FADE, -20);
					
					while (optionBrowserHomebrew.GetEffect() > 0)
						usleep(EFFECT_SLEEP);
					
					titleTxt.SetText(GetText("Settings"));
					slideDirection = FADE;
					pageToDisplay = 1;
					btnHomebrew.ResetState();

					break;
				}
				else if (btnSound.GetState() == STATE_CLICKED)
				{
					btnHomebrew.SetEffect(EFFECT_FADE, -20);
					btnSound.SetEffect(EFFECT_FADE, -20);
					btnFolders.SetEffect(EFFECT_FADE, -20);
					btnCredits.SetEffect(EFFECT_FADE, -20);
					
					while (btnSound.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					HaltGui();
					
					w.Remove(&btnHomebrew);
					w.Remove(&btnSound);
					w.Remove(&btnFolders);
					w.Remove(&btnCredits);

					titleTxt.SetText(GetText("Sound"));
					quit = 0;
					w.Append(&optionBrowserSound);
					optionBrowserSound.SetClickable(true);
					ResumeGui();

					usleep(THREAD_SLEEP);
					optionBrowserSound.SetEffect(EFFECT_FADE, 20);

					while (optionBrowserSound.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					while (quit == 0)
					{
						usleep(THREAD_SLEEP);

						if (btnBack.GetState() == STATE_CLICKED)
						{
							btnBack.ResetState();
							quit = 1;
							
							break;
						}
						else if (home.GetState() == STATE_CLICKED)
						{
			
            				backgroundMusic->Pause();
							
							int choice = WindowExitPrompt();
							
							switch (choice)
							{
//								case CHOICE_PRIILOADER:
//									Settings.Save();
//									Sys_ExitToPriiloader();
//
//									break;

								case CHOICE_IDLE_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToIdle();

									break;

								case CHOICE_FULL_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToStandby();

									break;

								case CHOICE_SYSTEM_MENU:
									Settings.Save();
									Sys_LoadMenu();

									break;

								case CHOICE_HBC:
									Settings.Save();
									Sys_BackToLoader();

									break;

								default:
									mainWindow->SetState(STATE_DEFAULT);
									backgroundMusic->Resume();
									backgroundMusic->Play();
									home.ResetState();
									
									menu = MENU_NONE;

									break;
							}
						}
						
						ret = optionBrowserSound.GetClickedOption();

						switch (ret)
						{
							case 0:
								cfg.SFXVolume += 5;

								if (cfg.SFXVolume > 100)
									cfg.SFXVolume = 0;

								break;

							case 1:
								cfg.MusicVolume += 5;

								if (cfg.MusicVolume > 100)
									cfg.MusicVolume = 0;

								break;
						}

						if (ret >= 0 || firstRun)
						{
							firstRun = false;

							if (cfg.SFXVolume == SFXVolume_Off)
								snprintf (optionsSound.value[0], 256, "%s", GetText("Off"));
							else
								snprintf (optionsSound.value[0], 256, "%i", cfg.SFXVolume);

							if (cfg.MusicVolume == MusicVolume_Off)
								snprintf (optionsSound.value[1], 256, "%s", GetText("Off"));
							else
								snprintf (optionsSound.value[1], 256, "%i", cfg.MusicVolume);
							
							optionBrowserSound.TriggerUpdate();
						}
					}

					optionBrowserSound.SetEffect(EFFECT_FADE, -20);
					
					while (optionBrowserSound.GetEffect() > 0)
						usleep(EFFECT_SLEEP);
					
					titleTxt.SetText(GetText("Settings"));
					slideDirection = FADE;
					pageToDisplay = 1;
					btnSound.ResetState();

					break;
				}	
				else if (btnFolders.GetState() == STATE_CLICKED)
				{
					btnHomebrew.SetEffect(EFFECT_FADE, -20);
					btnSound.SetEffect(EFFECT_FADE, -20);
					btnFolders.SetEffect(EFFECT_FADE, -20);
					btnCredits.SetEffect(EFFECT_FADE, -20);

					while (btnFolders.GetEffect() > 0)
						usleep(EFFECT_SLEEP);
						
					HaltGui();

					w.Remove(&btnHomebrew);
					w.Remove(&btnSound);
					w.Remove(&btnFolders);
					w.Remove(&btnCredits);

					titleTxt.SetText(GetText("Folders"));
					quit = 0;
					w.Append(&optionBrowserFolders);
					optionBrowserFolders.SetClickable(true);
					ResumeGui();

					usleep(THREAD_SLEEP);
					optionBrowserFolders.SetEffect(EFFECT_FADE, 20);
					
					while (optionBrowserFolders.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					bool firstRun = true;

					while (quit == 0)
					{
						usleep(THREAD_SLEEP);

						if (btnBack.GetState() == STATE_CLICKED)
						{
							btnBack.ResetState();
							quit = 1;

							break;
						}
						else if (home.GetState() == STATE_CLICKED)
						{							
							backgroundMusic->Pause();

            				int choice = WindowExitPrompt();

							switch (choice)
							{
//								case CHOICE_PRIILOADER:
//									Settings.Save();
//									Sys_ExitToPriiloader();
//
//									break;

								case CHOICE_IDLE_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToIdle();

									break;

								case CHOICE_FULL_SHUTDOWN:
									Settings.Save();
									Sys_ShutdownToStandby();

									break;

								case CHOICE_SYSTEM_MENU:
									Settings.Save();
									Sys_LoadMenu();

									break;

								case CHOICE_HBC:
									Settings.Save();
									Sys_BackToLoader();

									break;

								default:
									mainWindow->SetState(STATE_DEFAULT);
									backgroundMusic->Resume();
									backgroundMusic->Play();
									home.ResetState();
									
									menu = MENU_NONE;

									break;
							}
						}
						
						ret = optionBrowserFolders.GetClickedOption();

						switch (ret)
						{
							case 0:
							{
								w.Remove(&optionBrowserFolders);
								w.Remove(&btnBack);

								char entered[100] = "";

								snprintf(entered, sizeof(entered), "%s", cfg.LanguageFolder);
								titleTxt.SetText(GetText("Language File Folder"));

								int result = OnScreenKeyboard(entered, sizeof(entered));

								if (result == INPUT_SAVED)
								{
									if (entered[strlen(entered) - 1] != '/')
										strcat(entered, "/");

									snprintf(cfg.LanguageFolder, sizeof(cfg.LanguageFolder), "%s", entered);

									Settings.Save();
								}

								titleTxt.SetText(GetText("Folders"));

								// Append objects
								w.Append(&optionBrowserFolders);
								w.Append(&btnBack);
								
								break;
							}
							case 1:
							{
								w.Remove(&optionBrowserFolders);
								w.Remove(&btnBack);

								char entered[100] = "";

								snprintf(entered, sizeof(entered), "%s", cfg.ReportFolder);
								titleTxt.SetText(GetText("Report Folder"));

								int result = OnScreenKeyboard(entered, sizeof(entered));

								if (result == INPUT_SAVED)
								{
									if (entered[strlen(entered) - 1] != '/')
										strcat(entered, "/");

									snprintf(cfg.ReportFolder, sizeof(cfg.ReportFolder), "%s", entered);

									Settings.Save();
								}

								titleTxt.SetText(GetText("Folders"));

								// Append objects
								w.Append(&optionBrowserFolders);
								w.Append(&btnBack);
								
								break;
							}
						}
						
						if (ret >= 0 || firstRun)
						{
							firstRun = false;
							
							snprintf(optionsFolders.value[0], 256, "%s", cfg.LanguageFolder);
							snprintf(optionsFolders.value[1], 256, "%s", cfg.ReportFolder);
							
							optionBrowserFolders.TriggerUpdate();
						}
					}

					optionBrowserFolders.SetEffect(EFFECT_FADE, -20);

					while (optionBrowserFolders.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					titleTxt.SetText(GetText("Settings"));
					slideDirection = FADE;
					pageToDisplay = 1;
					btnFolders.ResetState();

					break;
				}
				else if (btnCredits.GetState() == STATE_CLICKED)
				{
					btnHomebrew.SetEffect(EFFECT_FADE, -20);
					btnSound.SetEffect(EFFECT_FADE, -20);
					btnFolders.SetEffect(EFFECT_FADE, -20);
					btnCredits.SetEffect(EFFECT_FADE, -20);

					while (btnCredits.GetEffect() > 0)
						usleep(EFFECT_SLEEP);

					HaltGui();

					// Show credits window
					ShowCreditsWindow();
					
					titleTxt.SetText(GetText("Settings"));
					slideDirection = FADE;
					pageToDisplay = 1;
					btnCredits.ResetState();

					break;
				}	
			}
			
			if (btnBack.GetState() == STATE_CLICKED)
			{
				btnBack.ResetState();
				Settings.Save();
				menu = MENU_MAIN;
				pageToDisplay = 0; // Quit

				break;
			}
		}
	}
	
	w.SetEffect(EFFECT_FADE, -20);

	while (w.GetEffect() > 0)
		usleep(EFFECT_SLEEP);
	
	Settings.Save();

	HaltGui();
	mainWindow->RemoveAll();
	ResumeGui();
	
	return menu;
}
