#ifndef _SETTINGS_H_
	#define _SETTINGS_H_

	// Includes
	#include <unistd.h>

	// Constants
	#define LOG_FILE_NAME			"sysCheckGX.log"
	#define CONFIG_FOLDER          	"Config/sysCheckGX/"
	#define CONFIG_FILE_NAME		"sysCheckGX.ini"
	#define SIMPLE_REPORT_FILE_NAME	"sysCheckGX.txt"
	#define FULL_REPORT_FILE_NAME	"sysCheckGX.csv"
	#define LANGUAGE_FILE_NAME		"sysCheckGX.lang"

	// Enumerations
	enum
	{
		SystemCheck_Off = 0,
		SystemCheck_On
	};

	enum
	{
		AutoShutdownHomebrew_Off = 0,
		AutoShutdownHomebrew_On
	};

	enum
	{
		ShutdownMode_Off = 0,
		ShutdownMode_HBC,
		ShutdownMode_SystemMenu,
		ShutdownMode_Shutdown
	};

	enum
	{
		DisplayReport_Off = 0,
		DisplayReport_On
	};

	enum
	{
		DetailedReport_Off = 0,
		DetailedReport_On
	};

	enum
	{
		UseLanguageFile_Off = 0,
		UseLanguageFile_On,
	};

	enum
	{
		Rumble_Off = 0,
		Rumble_On
	};

	enum
	{
		Widescreen_Off = 0,
		Widescreen_On
	};

	enum
	{
		FieldSeparator_Comma = 0,
		FieldSeparator_DotComma
	};

	enum
	{
		SFXVolume_Off = 0,
		MusicVolume_Off = 0
	};

	// Structures
	typedef struct
	{
		short SystemCheck;						// System Check
		short AutoShutdownHomebrew;				// Shutdown homebrew automatically after system check
		short ShutdownMode;						// Shutdown mode
		short DisplayReport;					// Display report after system check
		short DetailedReport;					// Detailed / simplified report
		short UseLanguageFile;					// Use Language File
		short Rumble;							// Rumble
		short Widescreen;						// Widescreen
		short FieldSeparator;					// Field separator

		short SFXVolume;						// Sound effects volume
		short MusicVolume;						// Music volume

		char  ReportFolder[MAXPATHLEN];			// Report folder
		char  LanguageFolder[MAXPATHLEN];		// Languagefile folder
	} CFG;

	// Extern variables
	extern CFG cfg;

	// Classes
	class Settings
	{
		// Public members
		public:
			Settings(void);
			~Settings(void);

			void SetDefault(void);
			bool Load(void);
			bool Save(void);
			bool Reset(void);
			bool Init(void);
			bool SetSetting(char *, char *);
			bool LoadLanguage(void);

		// Protected members
		protected:
			void ParseLine(char *);
			void TrimLine(char *, char *, int);

			FILE *file;
	};
#endif
