// Includes
#include "Prompts/PromptWindows.h"
#include "System/FileOps.h"
#include "Main.h"

// variables
CFG	cfg;

Settings::Settings()
{
}

// Class destructor
Settings::~Settings()
{
}

// Set default settings
void Settings::SetDefault()
{	
	cfg.SystemCheck = SystemCheck_On;
	cfg.AutoShutdownHomebrew = AutoShutdownHomebrew_Off;
	cfg.ShutdownMode = ShutdownMode_Off;
	cfg.DisplayReport = DisplayReport_On;
	cfg.DetailedReport = DetailedReport_Off;
	cfg.UseLanguageFile = UseLanguageFile_Off;
	cfg.Rumble = Rumble_On;
	cfg.Widescreen = Widescreen_Off;
	cfg.FieldSeparator = FieldSeparator_Comma;

	cfg.SFXVolume = 100;
	cfg.MusicVolume = 80;

    sprintf(cfg.ReportFolder, "sd:/");
    sprintf(cfg.LanguageFolder, "sd:/%s", CONFIG_FOLDER);
}

// Save settings
bool Settings::Save()
{
	char filePath[300];

    snprintf(filePath, sizeof(filePath), "sd:/%s%s", CONFIG_FOLDER, CONFIG_FILE_NAME);
	
    char folder[300];

	snprintf(folder, sizeof(folder), "sd:/%s", CONFIG_FOLDER);

	CreateSubfolder(folder);
	
    file = fopen(filePath, "w");

    if (!file)
	{
        fclose(file);
		
        return false;
	}
	
    fprintf(file, "# %s Configuration File.\n", APP_TITLE);
	fprintf(file, "# This file was automatically generated.\n\n");

	fprintf(file, "[Homebrew]\n");
	fprintf(file, "# SystemCheck: 0 = Disabled, 1 = Enabled\n");
	fprintf(file, "SystemCheck = %d\n\n", cfg.SystemCheck);

	fprintf(file, "# AutoShutdown Homebrew: 0 = Disabled, 1 = Enabled\n");
	fprintf(file, "AutoShutdownHomebrew = %d\n\n", cfg.AutoShutdownHomebrew);

	fprintf(file, "# Shutdown Mode: 0 = Disabled, 1 = HBC, 2 = System Menu, 3 = Shutdown\n");
	fprintf(file, "ShutdownMode = %d\n\n", cfg.ShutdownMode);

	fprintf(file, "# Display Report: 0 = Disabled, 1 = Enabled\n");
	fprintf(file, "DisplayReport = %d\n\n", cfg.DisplayReport);

	fprintf(file, "# 0 = Generate Simplified Report, 1 = Detailed Report\n");
	fprintf(file, "DetailedReport = %d\n\n", cfg.DetailedReport);

	fprintf(file, "# Use the language file: 0 = Off, 1 = On\n");
	fprintf(file, "UseLanguageFile = %d\n\n", cfg.UseLanguageFile);

	fprintf(file, "# Rumble: 0 = Off, 1 = On\n");
	fprintf(file, "Rumble = %d\n\n", cfg.Rumble);

	fprintf(file, "# Screen Size: 0 = 4/3, 1 = 16/9\n");
	fprintf(file, "Widescreen = %d\n\n", cfg.Widescreen);

	fprintf(file, "# Field Separator: 0 = ',', 1 = ';'\n");
	fprintf(file, "FieldSeparator = %d\n\n\n", cfg.FieldSeparator);

	fprintf(file, "[Sound]\n");
	fprintf(file, "# Sound Effects Volume: 0 = Off, 100 = Maximum volume\n");
	fprintf(file, "SFXVolume = %d\n\n", cfg.SFXVolume);

	fprintf(file, "# Music Volume: 0 = Off, 100 = Maximum volume\n");
	fprintf(file, "MusicVolume = %d\n\n\n", cfg.MusicVolume);
	
	fprintf(file, "[Folders]\n");
	fprintf(file, "# Language File Folder\n");
	fprintf(file, "LanguageFolder = %s\n\n", cfg.LanguageFolder);

	fprintf(file, "# Report Folder\n");
	fprintf(file, "ReportFolder = %s\n", cfg.ReportFolder);

	fclose(file);

	return true;
}

// Load settings
bool Settings::Load()
{
    char filePath[300];
    
	snprintf(filePath, sizeof(filePath), "sd:/%s%s", CONFIG_FOLDER, CONFIG_FILE_NAME);

	file = fopen(filePath, "r");
	
	if (!file)
		return false;
	
	char line[300];

	while (fgets(line, sizeof(line), file))
	{
		if (line[0] == '#' || line[0] == '[')
			continue;

        this->ParseLine(line);
	}

	fclose(file);

	return true;
}

// Initialize settings
bool Settings::Init()
{
	SetDefault();
	Load();
	Save();	
	
	return true;
}

// Reset settings
bool Settings::Reset()
{
    this->SetDefault();

    if (this->Save())
        return true;

	return false;
}

bool Settings::SetSetting(char *name, char *value)
{
    int i = 0;

	if (strcmp(name, "SystemCheck") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.SystemCheck = i;
		
		return true;
	}
	if (strcmp(name, "AutoShutdownHomebrew") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.AutoShutdownHomebrew = i;
		
		return true;
	}
	else if (strcmp(name, "ShutdownMode") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.ShutdownMode = i;
		
		return true;
	}
	else if (strcmp(name, "DisplayReport") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.DisplayReport = i;
		
		return true;
	}
	else if (strcmp(name, "DetailedReport") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.DetailedReport = i;
		
		return true;
	}
	else if (strcmp(name, "UseLanguageFile") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.UseLanguageFile = i;
		
		return true;
	}
	else if (strcmp(name, "Rumble") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.Rumble = i;
		
		return true;
	}
	else if (strcmp(name, "SFXVolume") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.SFXVolume = i;
		
		return true;
	}
	else if (strcmp(name, "MusicVolume") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.MusicVolume = i;
		
		return true;
	}
	else if (strcmp(name, "Widescreen") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.Widescreen = i;
		
		return true;
	}
	else if (strcmp(name, "FieldSeparator") == 0)
	{
		if (sscanf(value, "%d", &i) == 1)
			cfg.FieldSeparator = i;
		
		return true;
	}
	else if (strcmp(name, "LanguageFolder") == 0)
	{
        strncpy(cfg.LanguageFolder, value, sizeof(cfg.LanguageFolder));
		
		return true;
	}
	else if (strcmp(name, "ReportFolder") == 0)
	{
        strncpy(cfg.ReportFolder, value, sizeof(cfg.ReportFolder));
		
		return true;
	}

    return false;
}

bool Settings::LoadLanguage()
{
	bool ret;
	char path[MAXPATHLEN];

	snprintf(path, sizeof(path), "%s%s", cfg.LanguageFolder, LANGUAGE_FILE_NAME);
	
	ret = GetTextLoadLanguage(path);
	
	Save();

    return ret;
}

void Settings::ParseLine(char *line)
{
    char temp[200], name[200], value[200];

    memcpy(temp, line, strlen(line) + 1);

    char *eq = strchr(temp, '=');

    if (!eq)
		return;

    *eq = 0;

    this->TrimLine(name, temp, sizeof(name));
    this->TrimLine(value, eq + 1, sizeof(value));
	this->SetSetting(name, value);
}

void Settings::TrimLine(char *dest, char *src, int size)
{
	int len;

	while (*src == ' ')
		src++;

	len = strlen(src);

	while (len > 0 && strchr(" \r\n", src[len - 1]))
		len--;

	if (len >= size)
		len = size - 1;

	strncpy(dest, src, len);
	dest[len] = 0;
}
