///////////////////////////////////////////////////////
// Copyright (C) 2010
// by Dimok
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications and to alter it and
// redistribute it freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you
//    must not claim that you wrote the original software. If you use
//    this software in a product, an acknowledgment in the product
//    documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such and
//    must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
///////////////////////////////////////////////////////

// Includes
#include "Report/Report.h"
#include "Main.h"
#include "Prompts/PromptWindows.h"
#include "System/FileOps.h"
#include "Text/TextViewer.h"

Report::Report()
{
}

// Class destructor
Report::~Report()
{
}

bool Report::Show(bool detailedReport)
{
    char reportPath[MAXPATHLEN];
	
	if (detailedReport)
		snprintf(reportPath, sizeof(reportPath), "%s%s", cfg.ReportFolder, FULL_REPORT_FILE_NAME);
	else
		snprintf(reportPath, sizeof(reportPath), "%s%s", cfg.ReportFolder, SIMPLE_REPORT_FILE_NAME);

	if (CheckFile(reportPath))
	{
		// View the report
		TextViewer(reportPath);

		return true;
	}
	else
	{
		char message[MAXPATHLEN];

		snprintf(message, sizeof(message), "%s %s.", GetText("Fail to open"), reportPath);

		MessageBox(ERROR, false, GetText("Error!"), message, GetText("OK"));

		return false;
	}
}
