#ifndef _PROMPTWINDOWS_H_
	#define _PROMPTWINDOWS_H_

	// Includes
	#include <gctypes.h>

	// Enumerations
	enum
	{
		NONE = 0,					// No icon
		ERROR = 1,					// Error icon
		INFORMATION = 2,			// Information icon
		EXCLAMATION = 3,			// Exclamation icon
		QUESTION = 4				// Interrogation icon
	};

	enum
	{
		MESSAGEBOX_TIMEOUT = -2,	// Used for TimedMessageBox only
		MESSAGEBOX_NONE = -1,
		MESSAGEBOX_CLOSE = 0,
		MESSAGEBOX_BUTTON1 = 1,
		MESSAGEBOX_BUTTON2 = 2,
		MESSAGEBOX_BUTTON3 = 3,
		MESSAGEBOX_BUTTON4 = 4
	};

	enum
	{
		INPUT_CANCELLED = 0,		// On-screen keyboard input cancelled
		INPUT_SAVED = 1				// On-screen keyboard input saved
	};

	// Prototypes
	int  MessageBox(int icon = NONE, bool stealth = false, const char *caption = NULL, const char *message = NULL, const char *btn1Label = NULL, const char *btn2Label = NULL, const char *btn3Label = NULL, const char *btn4Label = NULL);
	int  TimedMessageBox(int seconds = 5, const char *caption = NULL, const char *message = NULL, const char *btn1Label = NULL, const char *btn2Label = NULL, const char *btn3Label = NULL, const char *btn4Label = NULL);
	int  OnScreenKeyboard(char *, u16, int stealth = 0);
	void ShowCreditsWindow(void);
#endif
