///////////////////////////////////////////////////////
// Copyright (C) 2010
// created by Dimok
// modified by Dj_Skual
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you
//    must not claim that you wrote the original software. If you use
//    this software in a product, an acknowledgment in the product
//    documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such and
//    must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// All prompt windows
///////////////////////////////////////////////////////

// Includes
#include "Libs/LibWiiGUI/GUI.h"
#include "Prompts/PromptWindows.h"
#include "Prompts/ProgressWindow.h"
#include "Menu/HomeMenu.h"
#include "FileList.h"
#include "Menu/Menu.h"
#include "Main.h"

// Constants
#define EFFECT_SLEEP 50

// Extern variables
extern GuiWindow *mainWindow;
extern GuiSound  *backgroundMusic;
extern bool      actioncanceled;

// Extern methods
extern void ResumeGui();
extern void HaltGui();

// Displays a prompt window to user, with information, an error message or presenting a user with a choice of up to 4 buttons.
int MessageBox(int icon, bool stealth, const char *caption, const char *message, const char *btn1Label, const char *btn2Label, const char *btn3Label, const char *btn4Label)
{
	// Sounds
	GuiSound btnSoundOver(ButtonOver_pcm, ButtonOver_pcm_size, SOUND_PCM, cfg.SFXVolume);
    GuiSound btnClick(ButtonClick_pcm, ButtonClick_pcm_size, SOUND_PCM, cfg.SFXVolume);
    
	// Triggers
    GuiTrigger triggerA;
    triggerA.SetSimpleTrigger(-1, WPAD_BUTTON_A | WPAD_CLASSIC_BUTTON_A, PAD_BUTTON_A);
	
    GuiTrigger triggerB;
    triggerB.SetButtonOnlyTrigger(-1, WPAD_BUTTON_B | WPAD_CLASSIC_BUTTON_B, PAD_BUTTON_B);

	// Objects
    GuiWindow promptWindow(472, 320);
    promptWindow.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    promptWindow.SetPosition(0, -10);

    GuiImageData dialogBox(DialogueBox_png);
    GuiImage dialogBoxImg(&dialogBox);

	// Icons
	GuiImageData iconError(IconError_png);
	GuiImage iconErrorImg(&iconError);
	iconErrorImg.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	iconErrorImg.SetPosition(20, 80);

	GuiImageData iconInformation(IconInformation_png);
	GuiImage iconInformationImg(&iconInformation);
	iconInformationImg.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	iconInformationImg.SetPosition(20, 80);

	GuiImageData iconExclamation(IconExclamation_png);
	GuiImage iconExclamationImg(&iconExclamation);
	iconExclamationImg.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	iconExclamationImg.SetPosition(20, 80);

	GuiImageData iconQuestion(IconQuestion_png);
	GuiImage iconQuestionImg(&iconQuestion);
	iconQuestionImg.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	iconQuestionImg.SetPosition(20, 80);

    GuiText titleTxt(caption, 24, (GXColor){0, 0, 0, 255});
    titleTxt.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
    titleTxt.SetPosition(0, 25);
    titleTxt.SetMaxWidth(380, GuiText::WRAP);

    GuiText msgTxt(message, 22, (GXColor){0, 0, 0, 255});
    msgTxt.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    msgTxt.SetPosition(0, -50);
    msgTxt.SetMaxWidth(350, GuiText::WRAP);

	GuiImageData btnClose(Close_png);
	GuiImage closeImg(&btnClose);
	GuiImageData btnCloseOver(CloseOver_png);
	GuiImage closeImgOver(&btnCloseOver);
	GuiButton closeBtn(closeImg.GetWidth(), closeImg.GetHeight());

	closeBtn.SetAlignment(ALIGN_RIGHT, ALIGN_TOP);
	closeBtn.SetPosition(-22, 26);
	closeBtn.SetImage(&closeImg);
	closeBtn.SetImageOver(&closeImgOver);
	closeBtn.SetSoundOver(&btnSoundOver);
	closeBtn.SetSoundClick(&btnClick);
	closeBtn.SetTrigger(&triggerA);
	closeBtn.SetEffectGrow();

    GuiText btn1Txt(btn1Label, 22, (GXColor){0, 0, 0, 255});

	GuiImageData btnOutline(Button_png);
    GuiImage btn1Img(&btnOutline);
    GuiButton btn1(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn1.SetLabel(&btn1Txt);
    btn1.SetImage(&btn1Img);
    btn1.SetSoundOver(&btnSoundOver);
    btn1.SetSoundClick(&btnClick);
    btn1.SetTrigger(&triggerA);
    btn1.SetState(STATE_SELECTED);
    btn1.SetEffectGrow();

    GuiText btn2Txt(btn2Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn2Img(&btnOutline);
    GuiButton btn2(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn2.SetLabel(&btn2Txt);
    btn2.SetImage(&btn2Img);
    btn2.SetSoundOver(&btnSoundOver);
    btn2.SetSoundClick(&btnClick);
	btn2.SetTrigger(&triggerA);
    btn2.SetEffectGrow();

    GuiText btn3Txt(btn3Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn3Img(&btnOutline);
    GuiButton btn3(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn3.SetLabel(&btn3Txt);
    btn3.SetImage(&btn3Img);
    btn3.SetSoundOver(&btnSoundOver);
    btn3.SetSoundClick(&btnClick);
	btn3.SetTrigger(&triggerA);
    btn3.SetEffectGrow();

    GuiText btn4Txt(btn4Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn4Img(&btnOutline);
    GuiButton btn4(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn4.SetLabel(&btn4Txt);
    btn4.SetImage(&btn4Img);
    btn4.SetSoundOver(&btnSoundOver);
    btn4.SetSoundClick(&btnClick);
	btn4.SetTrigger(&triggerA);
    btn4.SetEffectGrow();

    if (btn2Label && !btn3Label && !btn4Label)
	{
        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(40, -50);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-40, -50);
	}
	else if (btn2Label && btn3Label && !btn4Label)
	{
        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(50, -100);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-50, -100);
        btn3.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn3.SetPosition(0, -50);
	}
	else if (btn2Label && btn3Label && btn4Label)
	{
        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(50, -100);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-50, -100);
        btn3.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn3.SetPosition(50, -50);
        btn4.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn4.SetPosition(-50, -50);
	}
	else if (!btn2Label && btn3Label && btn4Label)
	{
        btn1.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn1.SetPosition(0, -100);
        btn3.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn3.SetPosition(50, -50);
        btn4.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn4.SetPosition(-50, -50);
	}
	else
	{
        btn1.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn1.SetPosition(0, -50);
	}
	
	GuiButton B(1, 1);
	B.SetTrigger(&triggerB);
	
	// Set Widescreen
	if (cfg.Widescreen == Widescreen_On)
	{
		dialogBoxImg.SetWidescreen(true);
		iconErrorImg.SetWidescreen(true);
		iconInformationImg.SetWidescreen(true);
		iconExclamationImg.SetWidescreen(true);
		iconQuestionImg.SetWidescreen(true);
		titleTxt.SetWidescreen(true);
		msgTxt.SetWidescreen(true);
		closeImg.SetWidescreen(true);
		closeImgOver.SetWidescreen(true);
		btn1Txt.SetWidescreen(true);
		btn1Img.SetWidescreen(true);
		btn2Txt.SetWidescreen(true);
		btn2Img.SetWidescreen(true);
		btn3Txt.SetWidescreen(true);
		btn3Img.SetWidescreen(true);
		btn4Txt.SetWidescreen(true);
		btn4Img.SetWidescreen(true);
	}

	// Append objects
    promptWindow.Append(&dialogBoxImg);

	switch (icon)
	{
		case ERROR:
			promptWindow.Append(&iconErrorImg);

			break;

		case INFORMATION:
			promptWindow.Append(&iconInformationImg);

			break;

		case EXCLAMATION:
			promptWindow.Append(&iconExclamationImg);

			break;

		case QUESTION:
			promptWindow.Append(&iconQuestionImg);

			break;
	}

    promptWindow.Append(&titleTxt);
    promptWindow.Append(&msgTxt);
    promptWindow.Append(&closeBtn);
	promptWindow.Append(&B);
    
    if (btn1Label)
        promptWindow.Append(&btn1);
    
	if (btn2Label)
        promptWindow.Append(&btn2);
    
	if (btn3Label)
        promptWindow.Append(&btn3);
    
	if (btn4Label)
        promptWindow.Append(&btn4);

    promptWindow.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);

    HaltGui();

	if (!stealth)
		mainWindow->SetState(STATE_DISABLED);
		
    mainWindow->Append(&promptWindow);
    mainWindow->ChangeFocus(&promptWindow);
    ResumeGui();

    int choice = MESSAGEBOX_NONE;

    while (choice == MESSAGEBOX_NONE)
    {
        usleep(THREAD_SLEEP);
		
		if (btn1.GetState() == STATE_CLICKED)
            choice = MESSAGEBOX_BUTTON1;
        else if (btn2.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON2;
        else if (btn3.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON3;
        else if (btn4.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON4;
        else if (closeBtn.GetState() == STATE_CLICKED || B.GetState() == STATE_CLICKED)
		{
            B.ResetState();
			choice = MESSAGEBOX_CLOSE;
		}
	}

    promptWindow.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);

    while (promptWindow.GetEffect() > 0)
		usleep(EFFECT_SLEEP);

    HaltGui();
    mainWindow->Remove(&promptWindow);

	if (!stealth)
		mainWindow->SetState(STATE_DEFAULT);
		
    ResumeGui();

    return choice;
}

// Displays a timed prompt window to user, with information, an error message or presenting a user with a choice of up to 4 buttons
int TimedMessageBox(int seconds, const char *caption, const char *message, const char *btn1Label, const char *btn2Label, const char *btn3Label, const char *btn4Label)
{
	// Sounds
	GuiSound btnSoundOver(ButtonOver_pcm, ButtonOver_pcm_size, SOUND_PCM, cfg.SFXVolume);
    GuiSound btnClick(ButtonClick_pcm, ButtonClick_pcm_size, SOUND_PCM, cfg.SFXVolume);
    
	// Triggers
    GuiTrigger triggerA;
    triggerA.SetSimpleTrigger(-1, WPAD_BUTTON_A | WPAD_CLASSIC_BUTTON_A, PAD_BUTTON_A);
	
    GuiTrigger triggerB;
    triggerB.SetButtonOnlyTrigger(-1, WPAD_BUTTON_B | WPAD_CLASSIC_BUTTON_B, PAD_BUTTON_B);

	// Objects
    GuiWindow promptWindow(472, 320);
    promptWindow.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    promptWindow.SetPosition(0, -10);

	// Dialogue box
    GuiImageData dialogBox(DialogueBox_png);
    GuiImage dialogBoxImg(&dialogBox);

	// Throbber
	GuiImageData throbber(Throbber_png);
	GuiImage throbberImg(&throbber);
    throbberImg.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
	throbberImg.SetPosition(0, 60);

    GuiText titleTxt(caption, 24, (GXColor){0, 0, 0, 255});
    titleTxt.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
    titleTxt.SetPosition(0, 25);
    titleTxt.SetMaxWidth(380, GuiText::WRAP);

    GuiText msgTxt(message, 22, (GXColor){0, 0, 0, 255});
    msgTxt.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    msgTxt.SetMaxWidth(350, GuiText::WRAP);

	GuiImageData btnClose(Close_png);
	GuiImage closeImg(&btnClose);

	GuiImageData btnCloseOver(CloseOver_png);
	GuiImage closeImgOver(&btnCloseOver);

	GuiButton closeBtn(closeImg.GetWidth(), closeImg.GetHeight());
	closeBtn.SetAlignment(ALIGN_RIGHT, ALIGN_TOP);
	closeBtn.SetPosition(-22, 26);
	closeBtn.SetImage(&closeImg);
	closeBtn.SetImageOver(&closeImgOver);
	closeBtn.SetSoundOver(&btnSoundOver);
	closeBtn.SetSoundClick(&btnClick);
	closeBtn.SetTrigger(&triggerA);
	closeBtn.SetEffectGrow();

    GuiText btn1Txt(btn1Label, 22, (GXColor){0, 0, 0, 255});

	GuiImageData btnOutline(Button_png);
    GuiImage btn1Img(&btnOutline);

    GuiButton btn1(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn1.SetLabel(&btn1Txt);
    btn1.SetImage(&btn1Img);
    btn1.SetSoundOver(&btnSoundOver);
    btn1.SetSoundClick(&btnClick);
    btn1.SetTrigger(&triggerA);
    btn1.SetState(STATE_SELECTED);
    btn1.SetEffectGrow();

    GuiText btn2Txt(btn2Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn2Img(&btnOutline);
    GuiButton btn2(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn2.SetLabel(&btn2Txt);
    btn2.SetImage(&btn2Img);
    btn2.SetSoundOver(&btnSoundOver);
    btn2.SetSoundClick(&btnClick);
	btn2.SetTrigger(&triggerA);
    btn2.SetEffectGrow();

    GuiText btn3Txt(btn3Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn3Img(&btnOutline);
    GuiButton btn3(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn3.SetLabel(&btn3Txt);
    btn3.SetImage(&btn3Img);
    btn3.SetSoundOver(&btnSoundOver);
    btn3.SetSoundClick(&btnClick);
	btn3.SetTrigger(&triggerA);
    btn3.SetEffectGrow();

    GuiText btn4Txt(btn4Label, 22, (GXColor){0, 0, 0, 255});
    GuiImage btn4Img(&btnOutline);
    GuiButton btn4(btnOutline.GetWidth(), btnOutline.GetHeight());
    btn4.SetLabel(&btn4Txt);
    btn4.SetImage(&btn4Img);
    btn4.SetSoundOver(&btnSoundOver);
    btn4.SetSoundClick(&btnClick);
	btn4.SetTrigger(&triggerA);
    btn4.SetEffectGrow();

    if (btn2Label && !btn3Label && !btn4Label)
	{
		msgTxt.SetPosition(0, 0);

        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(40, -50);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-40, -50);
	}
	else if (btn2Label && btn3Label && !btn4Label)
	{
		msgTxt.SetPosition(0, -20);

        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(50, -100);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-50, -100);
        btn3.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn3.SetPosition(0, -50);
	}
	else if (btn2Label && btn3Label && btn4Label)
	{
		msgTxt.SetPosition(0, -20);

        btn1.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn1.SetPosition(50, -100);
        btn2.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn2.SetPosition(-50, -100);
        btn3.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn3.SetPosition(50, -50);
        btn4.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn4.SetPosition(-50, -50);
	}
	else if (!btn2Label && btn3Label && btn4Label)
	{
		msgTxt.SetPosition(0, -20);

        btn1.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn1.SetPosition(0, -100);
        btn3.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
        btn3.SetPosition(50, -50);
        btn4.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
        btn4.SetPosition(-50, -50);
	}
	else
	{
		msgTxt.SetPosition(0, 0);

        btn1.SetAlignment(ALIGN_CENTER, ALIGN_BOTTOM);
        btn1.SetPosition(0, -50);
	}
	
	GuiButton B(1, 1);
	B.SetTrigger(&triggerB);
	
	// Set Widescreen
	if (cfg.Widescreen == Widescreen_On)
	{
		dialogBoxImg.SetWidescreen(true);
		throbberImg.SetWidescreen(true);
		titleTxt.SetWidescreen(true);
		msgTxt.SetWidescreen(true);
		closeImg.SetWidescreen(true);
		closeImgOver.SetWidescreen(true);
		btn1Txt.SetWidescreen(true);
		btn1Img.SetWidescreen(true);
		btn2Txt.SetWidescreen(true);
		btn2Img.SetWidescreen(true);
		btn3Txt.SetWidescreen(true);
		btn3Img.SetWidescreen(true);
		btn4Txt.SetWidescreen(true);
		btn4Img.SetWidescreen(true);
	}

	// Append objects
    promptWindow.Append(&dialogBoxImg);
	promptWindow.Append(&throbberImg);
    promptWindow.Append(&titleTxt);
    promptWindow.Append(&msgTxt);
    promptWindow.Append(&closeBtn);
	promptWindow.Append(&B);
    
    if (btn1Label)
        promptWindow.Append(&btn1);
    
	if (btn2Label)
        promptWindow.Append(&btn2);
    
	if (btn3Label)
        promptWindow.Append(&btn3);
    
	if (btn4Label)
        promptWindow.Append(&btn4);

    promptWindow.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);
	
    HaltGui();
    mainWindow->SetState(STATE_DISABLED);
    mainWindow->Append(&promptWindow);
    mainWindow->ChangeFocus(&promptWindow);
    ResumeGui();

    int angle = 0;
    int timer = 0;
    int choice = MESSAGEBOX_NONE;

    while (choice == MESSAGEBOX_NONE)
    {
		timer++;

		usleep(10000);

		// Move the throbber image
		angle += 2;

		if(angle > 360)
			angle = 0 + (angle - 360);

		throbberImg.SetAngle(angle);
		
		if (btn1.GetState() == STATE_CLICKED)
            choice = MESSAGEBOX_BUTTON1;
        else if (btn2.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON2;
        else if (btn3.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON3;
        else if (btn4.GetState() == STATE_CLICKED)
			choice = MESSAGEBOX_BUTTON4;
        else if (closeBtn.GetState() == STATE_CLICKED || B.GetState() == STATE_CLICKED)
		{
            B.ResetState();
			choice = MESSAGEBOX_CLOSE;
		}
		else if (timer >= (seconds * 100))
			choice = MESSAGEBOX_TIMEOUT;
	}

    promptWindow.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);

    while (promptWindow.GetEffect() > 0)
		usleep(EFFECT_SLEEP);

    HaltGui();
    mainWindow->Remove(&promptWindow);
    mainWindow->SetState(STATE_DEFAULT);
    ResumeGui();

    return choice;
}

// Opens an on-screen keyboard window, with the data entered being stored into the specified variable
int OnScreenKeyboard(char *var, u16 maxLen, int stealth)
{
	int save = -1;

	GuiKeyboard keyboard(var, maxLen);

	// Sounds
	GuiSound btnSoundOver(ButtonOver_pcm, ButtonOver_pcm_size, SOUND_PCM, cfg.SFXVolume);
	GuiSound btnSoundClick(ButtonClick_pcm, ButtonClick_pcm_size, SOUND_PCM, cfg.SFXVolume);

	// Triggers	
	GuiTrigger triggerA;
	triggerA.SetSimpleTrigger(-1, WPAD_BUTTON_A | WPAD_CLASSIC_BUTTON_A, PAD_BUTTON_A);

	GuiTrigger triggerB;
	triggerB.SetSimpleTrigger(-1, WPAD_BUTTON_B | WPAD_CLASSIC_BUTTON_B, PAD_BUTTON_B);

	GuiText okBtnTxt(GetText("OK"), 22, (GXColor){0, 0, 0, 255});
	GuiText cancelBtnTxt(GetText("Cancel"), 22, (GXColor){0, 0, 0, 255});

	// Objects	
	GuiImageData btnOutline(Button_png);
	GuiImage okBtnImg(&btnOutline);
	
	GuiButton okBtn(btnOutline.GetWidth(), btnOutline.GetHeight());
	okBtn.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
	okBtn.SetPosition(20, 0);
	okBtn.SetLabel(&okBtnTxt);
	okBtn.SetImage(&okBtnImg);
	okBtn.SetImageOver(&okBtnImg);
	okBtn.SetSoundOver(&btnSoundOver);
	okBtn.SetSoundClick(&btnSoundClick);
	okBtn.SetTrigger(&triggerA);
	okBtn.SetEffectGrow();

	GuiImage cancelBtnImg(&btnOutline);
	GuiButton cancelBtn(btnOutline.GetWidth(), btnOutline.GetHeight());
	cancelBtn.SetAlignment(ALIGN_RIGHT, ALIGN_BOTTOM);
	cancelBtn.SetPosition(-20, 0);
	cancelBtn.SetLabel(&cancelBtnTxt);
	cancelBtn.SetImage(&cancelBtnImg);
	cancelBtn.SetImageOver(&cancelBtnImg);
	cancelBtn.SetSoundOver(&btnSoundOver);
	cancelBtn.SetSoundClick(&btnSoundClick);
	cancelBtn.SetTrigger(&triggerA);
	cancelBtn.SetTrigger(&triggerB);
	cancelBtn.SetEffectGrow();
	
	// Set Widescreen
	if (cfg.Widescreen == Widescreen_On)
	{
		okBtnTxt.SetWidescreen(true);
		cancelBtnTxt.SetWidescreen(true);
		okBtnImg.SetWidescreen(true);
		cancelBtnImg.SetWidescreen(true);
	}

	// Append objects
	keyboard.Append(&okBtn);
	keyboard.Append(&cancelBtn);
	
	HaltGui();

	if (!stealth)
		mainWindow->SetState(STATE_DISABLED);

	// Append objects
	mainWindow->Append(&keyboard);
	mainWindow->ChangeFocus(&keyboard);
	ResumeGui();

	while (save == -1)
	{
		usleep(THREAD_SLEEP);

		if (okBtn.GetState() == STATE_CLICKED)
			save = INPUT_SAVED;
		else if (cancelBtn.GetState() == STATE_CLICKED)
			save = INPUT_CANCELLED;
	}

	if (save)
		snprintf(var, maxLen, "%s", keyboard.kbTextStr);

	HaltGui();
	mainWindow->Remove(&keyboard);

	if (!stealth)
		mainWindow->SetState(STATE_DEFAULT);

	ResumeGui();

	return save;
}

// Show credit window
void ShowCreditsWindow()
{
	// Music
    GuiSound *creditsMusic = NULL;

    backgroundMusic->Pause();

    creditsMusic = new GuiSound(CreditsMusic_ogg, CreditsMusic_ogg_size, SOUND_OGG, 50);
    creditsMusic->SetLoop(false);
    creditsMusic->Play();

    GuiWindow creditsWindow(ScreenWidth, ScreenHeight);
    GuiWindow creditsWindowBox(580, 448);
    creditsWindowBox.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);

	// Background image
    GuiImageData creditsBox(BackgroundCredits_png);
    GuiImage creditsBoxImg(&creditsBox);
    creditsBoxImg.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);

    creditsWindowBox.Append(&creditsBoxImg);

    int i = 0;
    int numEntries = 26;
    int y = 20;

    GuiText *txt[numEntries];
	
    txt[i] = new GuiText(GetText("Credits"), 28, (GXColor){255, 255, 255, 255});
    txt[i]->SetAlignment(ALIGN_CENTER, ALIGN_TOP);
    txt[i]->SetPosition(0, 12);
	
    i++;
    y+=38;

    GuiText::SetPresets(16, (GXColor){255, 255, 255, 255}, 0, GuiText::WRAP, FTGX_JUSTIFY_LEFT | FTGX_ALIGN_TOP, ALIGN_LEFT, ALIGN_TOP);

	txt[i] = new GuiText(GetText("Homebrew application which does several checks on installed IOS:"));
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(5, y);

	i++;
	y+=22;

	char message[100];
	
	snprintf(message, sizeof(message), "-%s", GetText("IOS Stub"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;

	snprintf(message, sizeof(message), "-%s", GetText("Trucha Bug"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(350, y);

	i++;
	y+=22;

	snprintf(message, sizeof(message), "-%s", GetText("Flash Access"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;

	snprintf(message, sizeof(message), "-%s", GetText("ES_Identify"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(350, y);

	i++;
	y+=22;

	snprintf(message, sizeof(message), "-%s", GetText("NAND Access"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;

	snprintf(message, sizeof(message), "-%s", GetText("Boot2 Access"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(350, y);

	i++;
	y+=22;

	snprintf(message, sizeof(message), "-%s", GetText("USB 2.0"));

	txt[i] = new GuiText(message);
	txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;
	y+=38;

    txt[i] = new GuiText(GetText("Development:"));
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(5, y);
	
    i++;

    txt[i] = new GuiText("Erik Spyder");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
	
    i++;
    y+=38;

    txt[i] = new GuiText(GetText("Based on on the work of others (credit goes to those guys):"));
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(5, y);
	
    i++;
    y+=22;

    txt[i] = new GuiText("AnyTitle Deleter");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
	
    i++;

    txt[i] = new GuiText("DOP-Mii");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(350, y);
	
    i++;
    y+=22;
	
	txt[i] = new GuiText("IOS Check");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
    i++;
	
	txt[i] = new GuiText("LibWiiLight");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(350, y);
	
    i++;
    y+=22;

    txt[i] = new GuiText("Preloader");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
	
    i++;

    txt[i] = new GuiText("Priiloader");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(350, y);
    i++;
    y+=22;

	txt[i] = new GuiText("Savegame Manager GX");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
	
    i++;

	txt[i] = new GuiText("Title Lister");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(350, y);
	
    i++;
    y+=22;

	txt[i] = new GuiText("USB Loader GX");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(140, y);
	
    i++;

	txt[i] = new GuiText("WiiXplorer");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    txt[i]->SetPosition(350, y);
	
	i++;
	y+=25;

	txt[i] = new GuiText(GetText("Special thanks:"));
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(5, y);

	i++;

	txt[i] = new GuiText("DevKitPro development team.");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;
	y+=22;

	txt[i] = new GuiText("Tantric for LibWiiGUI.");
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(140, y);

	i++;
	y+=30;

    txt[i] = new GuiText(GetText("The author can not be held responsible for any damage sysCheck GX might cause."), 17, (GXColor){255, 255, 255, 255});
    txt[i]->SetAlignment(ALIGN_LEFT, ALIGN_TOP);
	txt[i]->SetPosition(5, y);

	numEntries = i + 1;

	// Append objects
    for (i = 0; i < numEntries; i++)
        creditsWindowBox.Append(txt[i]);

    creditsWindow.Append(&creditsWindowBox);
    creditsWindow.SetEffect(EFFECT_FADE, 30);

    HaltGui();
	
    mainWindow->SetState(STATE_DISABLED);
    mainWindow->Append(&creditsWindow);
	
    ResumeGui();

	bool exit = false;

    while (!exit)
	{
		if (ButtonsPressed() != 0)
            exit = true;
	}

    creditsMusic->Stop();

    delete creditsMusic;

    creditsWindow.SetEffect(EFFECT_FADE, -30);

    while (creditsWindow.GetEffect() > 0)
		usleep(50);
    
	HaltGui();
    
	mainWindow->Remove(&creditsWindow);    
	mainWindow->SetState(STATE_DEFAULT);
    
	for (i = 0; i < numEntries; i++)
	{
        delete txt[i];
		
        txt[i] = NULL;
	}
    
	ResumeGui();

    backgroundMusic->Resume();
    backgroundMusic->Play();
}
