///////////////////////////////////////////////////////
// Home Menu
//
// Displays a prompt window to user, with information, an error message, or
// presenting a user with a choice of up to 4 buttons
///////////////////////////////////////////////////////

// Includes
#include "Libs/LibWiiGUI/GUI.h"
#include "Prompts/PromptWindows.h"
#include "Menu/HomeMenu.h"
#include "FileList.h"
#include "Menu/Menu.h"
#include "Main.h"
#include "sysCheckGX/Check.h"

// Constants
#define EFFECT_SLEEP 50

// Extern variables
extern GuiWindow *mainWindow;
extern GuiSound  *backgroundMusic;

// Extern methods
extern void ResumeGui();
extern void HaltGui();

int WindowExitPrompt()
{
	Settings Settings;
	
	// Sounds
	GuiSound *homeIn = NULL;
    homeIn = new GuiSound(MenuIn_ogg, MenuIn_ogg_size, SOUND_OGG, cfg.SFXVolume);
    homeIn->SetLoop(false);
    homeIn->Play();

    GuiSound *homeOut = NULL;
    homeOut = new GuiSound(MenuOut_ogg, MenuOut_ogg_size, SOUND_OGG, cfg.SFXVolume);
    homeOut->SetLoop(false);

    GuiSound *wiimoteIn = NULL;
    wiimoteIn = new GuiSound(WiimoteIn_ogg, WiimoteIn_ogg_size, SOUND_OGG, cfg.SFXVolume);
    wiimoteIn->SetLoop(false);
	
	GuiSound *wiimoteOut = NULL;
    wiimoteOut = new GuiSound(WiimoteOut_ogg, WiimoteOut_ogg_size, SOUND_OGG, cfg.SFXVolume);
    wiimoteOut->SetLoop(false);
	
	GuiSound btnSoundOver(ButtonOver_pcm, ButtonOver_pcm_size, SOUND_PCM, cfg.SFXVolume);
    GuiSound btnSoundClick(ButtonClick_pcm, ButtonClick_pcm_size, SOUND_PCM, cfg.SFXVolume);
	
	// Triggers
    GuiTrigger triggerA;
    triggerA.SetSimpleTrigger(-1, WPAD_BUTTON_A | WPAD_CLASSIC_BUTTON_A, PAD_BUTTON_A);

    GuiTrigger triggerB;
    triggerB.SetButtonOnlyTrigger(-1, WPAD_BUTTON_B | WPAD_CLASSIC_BUTTON_B, PAD_BUTTON_B);

    GuiTrigger triggerHome;
    triggerHome.SetButtonOnlyTrigger(-1, WPAD_BUTTON_HOME | WPAD_CLASSIC_BUTTON_HOME, 0);

    GuiButton home(1, 1);
	home.SetTrigger(&triggerHome);
	
	GuiButton B(1, 1);
	B.SetTrigger(&triggerB);
	
	// Objects
	GuiWindow promptWindow(640, 480);
    promptWindow.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    promptWindow.SetPosition(0, 0);

	GuiImageData top(ExitTop_png);
	GuiImage btnTopImg(&top);

	GuiImageData topOver(ExitTopOver_png);
    GuiImage btnTopOverImg(&topOver);

    GuiImageData bottom(ExitBottom_png);
	GuiImage btnBottomImg(&bottom);

	GuiImageData bottomOver(ExitBottomOver_png);
	GuiImage btnBottomOverImg(&bottomOver);

	GuiImageData button(ExitButton_png);
	GuiImage btnBackToLoaderImg(&button);

	GuiImageData close(CloseHomeButton_png);
    GuiImage closeImg(&close);

	GuiText titleTxt(GetText("HOME Menu"), 36, (GXColor){255, 255, 255, 255});
    titleTxt.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    titleTxt.SetPosition(40, 40);
    titleTxt.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);

	GuiText btnCloseTxt(GetText("Close"), 28, (GXColor){0, 0, 0, 255});
    btnCloseTxt.SetAlignment(ALIGN_LEFT, ALIGN_MIDDLE);
    btnCloseTxt.SetPosition(60, 0);
    btnCloseTxt.SetMaxWidth(close.GetWidth() - 75, GuiText::SCROLL);

    GuiButton btnClose(close.GetWidth(), close.GetHeight());
    btnClose.SetImage(&closeImg);
    btnClose.SetAlignment(ALIGN_CENTER, ALIGN_TOP);
    btnClose.SetPosition(190, 30);
    btnClose.SetLabel(&btnCloseTxt);
	btnClose.SetRumble(false);

    btnClose.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);
	
    GuiButton btnTop(top.GetWidth(), top.GetHeight());
	btnTop.SetAlignment(ALIGN_LEFT, ALIGN_TOP);
    btnTop.SetPosition(0, 0);
    btnTop.SetImage(&btnTopImg);
    btnTop.SetImageOver(&btnTopOverImg);
    btnTop.SetSoundOver(&btnSoundOver);
	btnTop.SetSoundClick(&btnSoundClick);

	if (cfg.Rumble == Rumble_On)
		btnTop.SetRumble(true);
		
    btnTop.SetTrigger(&triggerA);
    btnTop.SetTrigger(&triggerB);
    btnTop.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_IN, 50);

    GuiText btnBackToLoaderTxt(GetText("Quit"), 28, (GXColor){0, 0, 0, 255});
    btnBackToLoaderTxt.SetMaxWidth(button.GetWidth() - 20, GuiText::WRAP);
    GuiButton btnBackToLoader(button.GetWidth(), button.GetHeight());
    btnBackToLoader.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    btnBackToLoader.SetPosition(-150, 0);
    btnBackToLoader.SetImage(&btnBackToLoaderImg);
    btnBackToLoader.SetImageOver(&btnBackToLoaderImg);
    btnBackToLoader.SetLabel(&btnBackToLoaderTxt);
    btnBackToLoader.SetSoundOver(&btnSoundOver);
	btnBackToLoader.SetSoundClick(&btnSoundClick);

	if (cfg.Rumble == Rumble_On)
		btnBackToLoader.SetRumble(true);
		
    btnBackToLoader.SetTrigger(&triggerA);
	btnBackToLoader.SetEffectGrow();
	btnBackToLoader.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_IN, 50);
    
    GuiText btnShutdownTxt(GetText("Shutdown Wii"), 28, (GXColor){0, 0, 0, 255});
    btnShutdownTxt.SetMaxWidth(button.GetWidth() - 20, GuiText::WRAP);
	GuiImage btnShutdownImg(&button);
    GuiButton btnShutdown(button.GetWidth(), button.GetHeight());
    btnShutdown.SetAlignment(ALIGN_CENTER, ALIGN_MIDDLE);
    btnShutdown.SetPosition(150, 0);
    btnShutdown.SetImage(&btnShutdownImg);
    btnShutdown.SetImageOver(&btnShutdownImg);
    btnShutdown.SetLabel(&btnShutdownTxt);
    btnShutdown.SetSoundOver(&btnSoundOver);
	btnShutdown.SetSoundClick(&btnSoundClick);

	if (cfg.Rumble == Rumble_On)
		btnShutdown.SetRumble(true);
		
    btnShutdown.SetTrigger(&triggerA);
	btnShutdown.SetEffectGrow();
	btnShutdown.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_IN, 50);

	GuiButton btnBottom(bottom.GetWidth(), bottom.GetHeight());
	btnBottom.SetAlignment(ALIGN_LEFT, ALIGN_BOTTOM);
	btnBottom.SetPosition(0, 0);
	btnBottom.SetImage(&btnBottomImg);
	btnBottom.SetImageOver(&btnBottomOverImg);
    btnBottom.SetSoundOver(&btnSoundOver);
	btnBottom.SetSoundClick(&btnSoundClick);

	if (cfg.Rumble == Rumble_On)
		btnBottom.SetRumble(true);
		
    btnBottom.SetTrigger(&triggerA);
    btnBottom.SetTrigger(&triggerB);
	btnBottom.SetEffect(EFFECT_SLIDE_BOTTOM | EFFECT_SLIDE_IN, 50);

	// Set Widescreen
	if (cfg.Widescreen == Widescreen_On)
	{
		titleTxt.SetWidescreen(true);
		btnCloseTxt.SetWidescreen(true);
		closeImg.SetWidescreen(true);
		btnTopImg.SetWidescreen(true);
		btnTopOverImg.SetWidescreen(true);
		btnBackToLoaderTxt.SetWidescreen(true);
		btnBackToLoaderImg.SetWidescreen(true);
		btnShutdownTxt.SetWidescreen(true);
		btnShutdownImg.SetWidescreen(true);
		btnBottomImg.SetWidescreen(true);
		btnBottomOverImg.SetWidescreen(true);
	}

	// Append objects
	promptWindow.Append(&btnTop);
    promptWindow.Append(&btnBackToLoader);
    promptWindow.Append(&btnShutdown);
    promptWindow.Append(&btnBottom);
    promptWindow.Append(&btnClose);
    promptWindow.Append(&titleTxt);
	promptWindow.Append(&home);
	
	HaltGui();
    mainWindow->SetState(STATE_DISABLED);
    mainWindow->Append(&promptWindow);
    mainWindow->ChangeFocus(&promptWindow);
    ResumeGui();

	int choice = 0;

    while (choice == 0)
	{
        usleep(THREAD_SLEEP);

		if (btnTop.GetState() == STATE_CLICKED || btnBottom.GetState() == STATE_CLICKED || home.GetState() == STATE_CLICKED)
		{
			choice = 1;
			btnTop.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);
            btnClose.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);
            btnBottom.SetEffect(EFFECT_SLIDE_BOTTOM | EFFECT_SLIDE_OUT, 50);
            btnBackToLoader.SetEffect(EFFECT_SLIDE_LEFT | EFFECT_SLIDE_OUT, 50);
            btnShutdown.SetEffect(EFFECT_SLIDE_RIGHT | EFFECT_SLIDE_OUT, 50);
            titleTxt.SetEffect(EFFECT_SLIDE_TOP | EFFECT_SLIDE_OUT, 50);
		}
		else if (btnBackToLoader.GetState() == STATE_CLICKED)
		{
            int ret;

//			if (IsPriiloaderInstalled())
//				ret = MessageBox(QUESTION, false, GetText("Quit"), GetText("Are you sure you want to quit ?"), GetText("HBC"), GetText("System Menu"), GetText("Priiloader"), GetText("Cancel"));
//			else
				ret = MessageBox(QUESTION, false, GetText("Quit"), GetText("Are you sure you want to quit ?"), GetText("HBC"), GetText("System Menu"), GetText("Cancel"));
			
            if (ret == MESSAGEBOX_BUTTON1)
				choice = CHOICE_HBC; // Homebrew Channel
			else if (ret == MESSAGEBOX_BUTTON2)
				choice = CHOICE_SYSTEM_MENU; // System Menu
//			else if (ret == MESSAGEBOX_BUTTON3)
//				choice = CHOICE_PRIILOADER; // Priiloader
			
            HaltGui();
            mainWindow->SetState(STATE_DISABLED);
            promptWindow.SetState(STATE_DEFAULT);
            mainWindow->ChangeFocus(&promptWindow);
            ResumeGui();
            btnBackToLoader.ResetState();
		}
		else if (btnShutdown.GetState() == STATE_CLICKED)
		{
			int ret = MessageBox(QUESTION, false, GetText("Shutdown Wii"), GetText("Are you sure you want to Shutdown ?"), GetText("Full Shutdown"), GetText("Idle Shutdown"), GetText("Cancel"));
  
			if (ret == MESSAGEBOX_BUTTON1)
                choice = CHOICE_FULL_SHUTDOWN; // Full Shutdown
			else if (ret == MESSAGEBOX_BUTTON2)
				choice = CHOICE_IDLE_SHUTDOWN; // Idle Shutdown
			
            HaltGui();
			
            mainWindow->SetState(STATE_DISABLED);
            promptWindow.SetState(STATE_DEFAULT);
            mainWindow->ChangeFocus(&promptWindow);
            
			ResumeGui();
			
            btnShutdown.ResetState();
		}
	}
	
    homeIn->Stop();
    homeOut->Play();
	
    while (btnTop.GetEffect() > 0)
		usleep(EFFECT_SLEEP);
    
	while (promptWindow.GetEffect() > 0)
		usleep(EFFECT_SLEEP);
    
	HaltGui();
    
	wiimoteOut->Stop();
	
	delete homeIn;
	delete wiimoteIn;
    delete wiimoteOut;
	
	mainWindow->Remove(&promptWindow);
    
	while (homeOut->IsPlaying() > 0)
		usleep(EFFECT_SLEEP);
    
	homeOut->Stop();
    
	delete homeOut;
    
	ResumeGui();
    
	return choice;
}
