#ifndef __PNGU__
	#define __PNGU__

	// Constants (Return codes)
	#define PNGU_OK							0
	#define PNGU_ODD_WIDTH					1
	#define PNGU_ODD_STRIDE					2
	#define PNGU_INVALID_WIDTH_OR_HEIGHT	3
	#define PNGU_FILE_IS_NOT_PNG			4
	#define PNGU_UNSUPPORTED_COLOR_TYPE		5
	#define PNGU_NO_FILE_SELECTED			6
	#define PNGU_CANT_OPEN_FILE				7
	#define PNGU_CANT_READ_FILE				8
	#define PNGU_LIB_ERROR					9

	// Color types
	#define PNGU_COLOR_TYPE_GRAY			1
	#define PNGU_COLOR_TYPE_GRAY_ALPHA		2
	#define PNGU_COLOR_TYPE_PALETTE			3
	#define PNGU_COLOR_TYPE_RGB				4
	#define PNGU_COLOR_TYPE_RGB_ALPHA		5
	#define PNGU_COLOR_TYPE_UNKNOWN 		6

	#ifdef __cplusplus
		extern "C"
		{
	#endif

	// Types
	typedef unsigned char 		PNGU_u8;
	typedef unsigned short 		PNGU_u16;
	typedef unsigned int 		PNGU_u32;
	typedef unsigned long long 	PNGU_u64;

	// Structures
	typedef struct
	{
		PNGU_u8 r;
		PNGU_u8 g;
		PNGU_u8 b;
	} PNGUCOLOR;

	typedef struct
	{
		PNGU_u32  imgWidth; 	// In pixels
		PNGU_u32  imgHeight; 	// In pixels
		PNGU_u32  imgBitDepth; 	// In bitx
		PNGU_u32  imgColorType;	// PNGU_COLOR_TYPE_*
		PNGU_u32  validBckgrnd; // Non zero if there is a background color
		PNGUCOLOR bckgrnd; 		// Backgroun color
		PNGU_u32  numTrans; 	// Number of transparent colors
		PNGUCOLOR *trans; 		// Transparent colors
	} PNGUPROP;

	// Image context, always initialize with SelectImageFrom* and free with ReleaseImageContext
	struct 		   _IMGCTX;
	typedef struct _IMGCTX *IMGCTX; 

	// Prototypes
	PNGU_u32	PNGU_RGB8_TO_YCbYCr(PNGU_u8, PNGU_u8, PNGU_u8, PNGU_u8, PNGU_u8, PNGU_u8);
	void 		PNGU_YCbYCr_TO_RGB8(PNGU_u32, PNGU_u8 *, PNGU_u8 *, PNGU_u8 *, PNGU_u8 *, PNGU_u8 *, PNGU_u8 *);
	IMGCTX		PNGU_SelectImageFromBuffer(const void *);
	IMGCTX		PNGU_SelectImageFromDevice(const char *);
	void 		PNGU_ReleaseImageContext(IMGCTX);
	int 		PNGU_GetImageProperties(IMGCTX, PNGUPROP *);
	int 		PNGU_DecodeToYCbYCr(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32);
	int 		PNGU_DecodeToRGB565(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32);
	int 		PNGU_DecodeToRGBA8(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32, PNGU_u8);
	int 		PNGU_DecodeTo4x4RGB565(IMGCTX, PNGU_u32, PNGU_u32, void *);
	int 		PNGU_DecodeTo4x4RGB5A3(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u8);
	int 		PNGU_DecodeTo4x4RGBA8(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u8);
	int 		PNGU_EncodeFromYCbYCr(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32);
	int 		PNGU_EncodeFromRGB(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32);
	int 		PNGU_EncodeFromGXTexture(IMGCTX, PNGU_u32, PNGU_u32, void *, PNGU_u32);
	int 		PNGU_EncodeFromEFB(IMGCTX, PNGU_u32, PNGU_u32, PNGU_u32);

	// Macros

	// Convert RGB8 values to RGB565
	#define PNGU_RGB8_TO_RGB565(r,g,b) (((((PNGU_u16) r) & 0xF8U) << 8) | ((((PNGU_u16) g) & 0xFCU) << 3) | (((PNGU_u16) b) >> 3))

	// Convert RGBA8 values to RGB5A3
	#define PNGU_RGB8_TO_RGB5A3(r,g,b,a)	(PNGU_u16) (((a & 0xE0U) == 0xE0U) ? \
											(0x8000U | ((((PNGU_u16) r) & 0xF8U) << 7) | ((((PNGU_u16) g) & 0xF8U) << 2) | (((PNGU_u16) b) >> 3)) : \
											(((((PNGU_u16) a) & 0xE0U) << 7) | ((((PNGU_u16) r) & 0xF0U) << 4) | (((PNGU_u16) g) & 0xF0U) | ((((PNGU_u16) b) & 0xF0U) >> 4)))

	// Decode an image inside a buffer at given coordinates
	#define PNGU_DECODE_TO_COORDS_YCbYCr(ctx,coordX,coordY,imgWidth,imgHeight,bufferWidth,bufferHeight,buffer)	\
			PNGU_DecodeToYCbYCr (ctx, imgWidth, imgHeight, ((void *) buffer) + (coordY) * (bufferWidth) * 2 +	\
			(coordX) * 2, (bufferWidth) - (imgWidth))

	// Decode an image inside a buffer at given coordinates
	#define PNGU_DECODE_TO_COORDS_RGB565(ctx,coordX,coordY,imgWidth,imgHeight,bufferWidth,bufferHeight,buffer)	\
			PNGU_DecodeToRGB565 (ctx, imgWidth, imgHeight, ((void *) buffer) + (coordY) * (bufferWidth) * 2 +	\
			(coordX) * 2, (bufferWidth) - (imgWidth))

	// Decode an image inside a buffer at given coordinates
	#define PNGU_DECODE_TO_COORDS_RGBA8(ctx,coordX,coordY,imgWidth,imgHeight,default_alpha,bufferWidth,bufferHeight,buffer)	\
			PNGU_DecodeToRGBA8 (ctx, imgWidth, imgHeight, ((void *) buffer) + (coordY) * (bufferWidth) * 2 +	            \
			(coordX) * 2, (bufferWidth) - (imgWidth), default_alpha)

	// Encode an image stored into an YCbYCr buffer at given coordinates
	#define PNGU_ENCODE_TO_COORDS_YCbYCr(ctx,coordX,coordY,imgWidth,imgHeight,bufferWidth,bufferHeight,buffer)	\
			PNGU_EncodeFromYCbYCr (ctx, imgWidth, imgHeight, ((void *) buffer) + (coordY) * (bufferWidth) * 2 +	\
			(coordX) * 2, (bufferWidth) - (imgWidth))

	#ifdef __cplusplus
		}
	#endif
#endif
