///////////////////////////////////////////////////////
// LibWiiGUI Copyright 2009
// by Tantric
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// Menu input trigger management
// Determine if action is neccessary based on input data by comparing controller input data to a specific trigger element
///////////////////////////////////////////////////////

// Includes
#include "GUI.h"

// Variables
static int scrollDelay = 0;

// Class constructor
GuiTrigger::GuiTrigger()
{
	chan = -1;
	
	memset(&wPadData, 0, sizeof(WPADData));
	memset(&pad, 0, sizeof(PADData));
	
	wPad = &wPadData;
}

// Class destructor
GuiTrigger::~GuiTrigger()
{
}

// Sets a simple trigger
//
// Requires:
// 		- Element is selected
// 		- Trigger button is pressed
void GuiTrigger::SetSimpleTrigger(s32 ch, u32 wiibtns, u16 gcbtns)
{
	type = TRIGGER_SIMPLE;
	chan = ch;
	wPadData.btns_d = wiibtns;
	pad.btns_d = gcbtns;
}

// Sets a held trigger
//
// Requires:
// 		- Element is selected
// 		- Trigger button is pressed and held
void GuiTrigger::SetHeldTrigger(s32 ch, u32 wiibtns, u16 gcbtns)
{
	type = TRIGGER_HELD;
	chan = ch;
	wPadData.btns_h = wiibtns;
	pad.btns_h = gcbtns;
}

// Sets a button trigger
//
// Requires:
//		- Trigger button is pressed
void GuiTrigger::SetButtonOnlyTrigger(s32 ch, u32 wiibtns, u16 gcbtns)
{
	type = TRIGGER_BUTTON_ONLY;
	chan = ch;
	wPadData.btns_d = wiibtns;
	pad.btns_d = gcbtns;
}

// Sets a button trigger
//
// Requires:
// 		- Trigger button is pressed
// 		- Parent window is in focus
void GuiTrigger::SetButtonOnlyInFocusTrigger(s32 ch, u32 wiibtns, u16 gcbtns)
{
	type = TRIGGER_BUTTON_ONLY_IN_FOCUS;
	chan = ch;
	wPadData.btns_d = wiibtns;
	pad.btns_d = gcbtns;
}

// Get X/Y value from Wii Joystick (Classic, Nunchuk) input
s8 GuiTrigger::WPAD_Stick(u8 right, int axis)
{
	float mag = 0.0;
	float ang = 0.0;

	switch (wPad->exp.type)
	{
		case WPAD_EXP_NUNCHUK:

		case WPAD_EXP_GUITARHERO3:
			if (right == 0)
			{
				mag = wPad->exp.nunchuk.js.mag;
				ang = wPad->exp.nunchuk.js.ang;
			}

			break;

		case WPAD_EXP_CLASSIC:
			if (right == 0)
			{
				mag = wPad->exp.classic.ljs.mag;
				ang = wPad->exp.classic.ljs.ang;
			}
			else
			{
				mag = wPad->exp.classic.rjs.mag;
				ang = wPad->exp.classic.rjs.ang;
			}

			break;

		default:
			break;
	}

	// Calculate x/y value (angle need to be converted into radian)
	if (mag > 1.0)
		mag = 1.0;
	else if (mag < -1.0)
		mag = -1.0;

	double val;

	if (axis == 0) // X axis
		val = mag * sin((PI * ang) / 180.0f);
	else // Y axis
		val = mag * cos((PI * ang) / 180.0f);

	return (s8)(val * 128.0f);
}

// Move menu selection left (via PAD/Joystick)
// Allows scroll delay and button overriding
bool GuiTrigger::Left()
{
	u32 wiibtn = WPAD_BUTTON_LEFT;

	if ((wPad->btns_d | wPad->btns_h) & (wiibtn | WPAD_CLASSIC_BUTTON_LEFT) || (pad.btns_d | pad.btns_h) & PAD_BUTTON_LEFT || pad.stickX < -PADCAL || WPAD_Stick(0,0) < -PADCAL)
	{
		if (wPad->btns_d & (wiibtn | WPAD_CLASSIC_BUTTON_LEFT) || pad.btns_d & PAD_BUTTON_LEFT)
		{
			scrollDelay = SCROLL_INITIAL_DELAY; // Reset scroll delay

			return true;
		}
		else if (scrollDelay == 0)
		{
			scrollDelay = SCROLL_LOOP_DELAY;

			return true;
		}
		else if (scrollDelay > 0)
			scrollDelay--;
	}

	return false;
}

// Move menu selection right (via PAD/Joystick)
// Allows scroll delay and button overriding
bool GuiTrigger::Right()
{
	u32 wiibtn = WPAD_BUTTON_RIGHT;

	if ((wPad->btns_d | wPad->btns_h) & (wiibtn | WPAD_CLASSIC_BUTTON_RIGHT) || (pad.btns_d | pad.btns_h) & PAD_BUTTON_RIGHT || pad.stickX > PADCAL || WPAD_Stick(0,0) > PADCAL)
	{
		if (wPad->btns_d & (wiibtn | WPAD_CLASSIC_BUTTON_RIGHT) || pad.btns_d & PAD_BUTTON_RIGHT)
		{
			scrollDelay = SCROLL_INITIAL_DELAY; // Reset scroll delay

			return true;
		}
		else if (scrollDelay == 0)
		{
			scrollDelay = SCROLL_LOOP_DELAY;
			
			return true;
		}
		else if (scrollDelay > 0)
			scrollDelay--;
	}
	
	return false;
}

// Move menu selection up (via PAD/Joystick)
// Allows scroll delay and button overriding
bool GuiTrigger::Up()
{
	u32 wiibtn = WPAD_BUTTON_UP;

	if ((wPad->btns_d | wPad->btns_h) & (wiibtn | WPAD_CLASSIC_BUTTON_UP) || (pad.btns_d | pad.btns_h) & PAD_BUTTON_UP || pad.stickY > PADCAL || WPAD_Stick(0,1) > PADCAL)
	{
		if (wPad->btns_d & (wiibtn | WPAD_CLASSIC_BUTTON_UP) || pad.btns_d & PAD_BUTTON_UP)
		{
			scrollDelay = SCROLL_INITIAL_DELAY; // Reset scroll delay
			
			return true;
		}
		else if (scrollDelay == 0)
		{
			scrollDelay = SCROLL_LOOP_DELAY;
			
			return true;
		}
		else if (scrollDelay > 0)
			scrollDelay--;
	}

	return false;
}

// Move menu selection down (via PAD/Joystick)
// Allows scroll delay and button overriding
bool GuiTrigger::Down()
{
	u32 wiibtn = WPAD_BUTTON_DOWN;

	if ((wPad->btns_d | wPad->btns_h) & (wiibtn | WPAD_CLASSIC_BUTTON_DOWN) || (pad.btns_d | pad.btns_h) & PAD_BUTTON_DOWN || pad.stickY < -PADCAL || WPAD_Stick(0,1) < -PADCAL)
	{
		if (wPad->btns_d & (wiibtn | WPAD_CLASSIC_BUTTON_DOWN) || pad.btns_d & PAD_BUTTON_DOWN)
		{
			scrollDelay = SCROLL_INITIAL_DELAY; // Reset scroll delay
			
			return true;
		}
		else if (scrollDelay == 0)
		{
			scrollDelay = SCROLL_LOOP_DELAY;
			
			return true;
		}
		else if (scrollDelay > 0)
			scrollDelay--;
	}

	return false;
}
