///////////////////////////////////////////////////////
// LibWiiGUI Copyright 2009
// by Tantric
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// GUI tooltip class definitions
// Display, manage and manipulate tooltips in the GUI
///////////////////////////////////////////////////////

// Includes
#include "GUI.h"

static GuiImageData tooltipLeft(TooltipLeft_png);
static GuiImageData tooltipTile(TooltipTile_png);
static GuiImageData tooltipRight(TooltipRight_png);

// Class constructor
GuiTooltip::GuiTooltip(const char *t, int Alpha):leftImage(&tooltipLeft), tileImage(&tooltipTile), rightImage(&tooltipRight)
{
	text = NULL;
	height = leftImage.GetHeight();
	leftImage.SetParent(this);
	tileImage.SetParent(this);
	rightImage.SetParent(this);
	leftImage.SetParentAngle(false);
	tileImage.SetParentAngle(false);
	rightImage.SetParentAngle(false);
	SetText(t);
	SetAlpha(Alpha);
}

// Class destructor
GuiTooltip::~GuiTooltip()
{
	if (text)
		delete text;
}

// Gets the element's current scale
float GuiTooltip::GetScale()
{
	float s = scale * scaleDyn;

	return s;
}

// Sets the text of the GuiTooltip element
void GuiTooltip::SetText(const char *t)
{
	if (text)
	{
		delete text;
		
		text = NULL;
	}

	int tile_cnt = 0;

	if (t && (text = new GuiText(t, 22, (GXColor){0, 0, 0, 255})))
	{
		text->SetParent(this);
		tile_cnt = (text->GetTextWidth() - 12) / tileImage.GetWidth();

		if (tile_cnt < 0)
			tile_cnt = 0;
	}

	tileImage.SetPosition(leftImage.GetWidth(), 0);
	tileImage.SetTile(tile_cnt);
	rightImage.SetPosition(leftImage.GetWidth() + tile_cnt * tileImage.GetWidth(), 0);
	width = leftImage.GetWidth() + tile_cnt * tileImage.GetWidth() + rightImage.GetWidth();
}

void GuiTooltip::SetWidescreen(bool)
{
}

// Draw the Tooltip on screen
void GuiTooltip::Draw()
{
	if (!this->IsVisible())
		return;

	leftImage.Draw();
	tileImage.Draw();
	rightImage.Draw();

	if (text)
		text->Draw();

	this->UpdateEffects();
}
