///////////////////////////////////////////////////////
// LibWiiGUI Copyright 2009
// by Tantric
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// GUI sound class definitions
///////////////////////////////////////////////////////

// Includes
#include "GUI.h"

// Class constructor
GuiSound::GuiSound(const u8 *snd, s32 len, int t, int v = 100)
{
    sound = snd;
	length = len;
	type = t;
	voice = -1;
	volume = v;
	loop = false;
}

// Class destructor
GuiSound::~GuiSound()
{
#ifndef NO_SOUND
	if (type == SOUND_OGG)
		StopOgg();
#endif
}

// Start sound playback
void GuiSound::Play()
{
#ifndef NO_SOUND
	int vol;

	switch (type)
	{
		case SOUND_PCM:
			vol = 255 * (volume / 100.0);
			voice = ASND_GetFirstUnusedVoice();

			if (voice >= 0)
				ASND_SetVoice(voice, VOICE_STEREO_16BIT, 48000, 0, (u8 *)sound, length, vol, vol, NULL);

			break;

		case SOUND_OGG:
			voice = 0;

			if (loop)
				PlayOgg((char *)sound, length, 0, OGG_INFINITE_TIME);
			else
				PlayOgg((char *)sound, length, 0, OGG_ONE_TIME);

			SetVolumeOgg(255 * (volume / 100.0));

			break;
	}
#endif
}

// Stop sound playback
void GuiSound::Stop()
{
#ifndef NO_SOUND
	if (voice < 0)
		return;

	switch (type)
	{
		case SOUND_PCM:
			ASND_StopVoice(voice);

			break;

		case SOUND_OGG:
			StopOgg();

			break;
	}
#endif
}

// Pause sound playback
void GuiSound::Pause()
{
#ifndef NO_SOUND
	if (voice < 0)
		return;

	switch (type)
	{
		case SOUND_PCM:
			ASND_PauseVoice(voice, 1);

			break;

		case SOUND_OGG:
			PauseOgg(1);

			break;
	}
#endif
}

// Resume sound playback
void GuiSound::Resume()
{
#ifndef NO_SOUND
	if (voice < 0)
		return;

	switch (type)
	{
		case SOUND_PCM:
			ASND_PauseVoice(voice, 0);

			break;

		case SOUND_OGG:
			PauseOgg(0);

			break;
	}

#endif
}

// Checks if the sound is currently playing
bool GuiSound::IsPlaying()
{
	return (ASND_StatusVoice(voice) == SND_WORKING || ASND_StatusVoice(voice) == SND_WAITING);
}

// Set sound volume
// Sound volume (0-100)
void GuiSound::SetVolume(int vol)
{
#ifndef NO_SOUND
	volume = vol;

	if (voice < 0)
		return;

	int newvol = 255 * (volume / 100.0);

	switch (type)
	{
		case SOUND_PCM:
			ASND_ChangeVolumeVoice(voice, newvol, newvol);

			break;

		case SOUND_OGG:
			SetVolumeOgg(255 * (volume / 100.0));

			break;
	}
#endif
}

// Set the sound to loop playback (only applies to OGG)
void GuiSound::SetLoop(bool l)
{
	loop = l;
}
