///////////////////////////////////////////////////////
// LibWiiGUI Copyright 2009
// by Tantric
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// GUI image data class definitions
// Converts image data to RGBA8
// (Currently designed for use only with PNG files)
///////////////////////////////////////////////////////

// Includes
#include "GUI.h"

// Class constructor
GuiImageData::GuiImageData(const u8 *i)
{
	data = NULL;
	width = 0;
	height = 0;

	if (i)
	{
		PNGUPROP imgProp;
		IMGCTX ctx = PNGU_SelectImageFromBuffer(i);

		if (!ctx)
			return;

		int res = PNGU_GetImageProperties(ctx, &imgProp);

		if (res == PNGU_OK)
		{
			int len = imgProp.imgWidth * imgProp.imgHeight * 4;
			
			if (len%32)
				len += (32-len%32);
			
			data = (u8 *)memalign(32, len);

			if (data)
			{
				res = PNGU_DecodeTo4x4RGBA8 (ctx, imgProp.imgWidth, imgProp.imgHeight, data, 255);

				if (res == PNGU_OK)
				{
					width = imgProp.imgWidth;
					height = imgProp.imgHeight;
					DCFlushRange(data, len);
				}
				else
				{
					free(data);
					data = NULL;
				}
			}
		}
		
		PNGU_ReleaseImageContext (ctx);
	}
}

// Class destructor
GuiImageData::~GuiImageData()
{
	if (data)
	{
		free(data);
		data = NULL;
	}
}

// Gets a pointer to the image data
u8 *GuiImageData::GetImage()
{
	return data;
}

// Gets the image width
int GuiImageData::GetWidth()
{
	return width;
}

// Gets the image height
int GuiImageData::GetHeight()
{
	return height;
}
