///////////////////////////////////////////////////////
// LibWiiGUI Copyright 2009
// by Tantric
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// GUI button class definitions
// Display, manage and manipulate buttons in the GUI
// Buttons can have images, icons, text and sound set (all of which are optional)
///////////////////////////////////////////////////////

// Includes
#include "GUI.h"

// Class constructor
GuiButton::GuiButton(int w, int h)
{
	width = w;
	height = h;
	image = NULL;
	imageOver = NULL;
	imageHold = NULL;
	imageClick = NULL;
	icon = NULL;
	icon2 = NULL;
	iconOver = NULL;
	iconHold = NULL;
	iconClick = NULL;
	toolTip = NULL;

	for (int i = 0; i < 3; i++)
	{
		label[i] = NULL;
		labelOver[i] = NULL;
		labelHold[i] = NULL;
		labelClick[i] = NULL;
	}

	soundOver = NULL;
	soundHold = NULL;
	soundClick = NULL;
	selectable = true;
	holdable = false;
	clickable = true;
	
	time1 = time2 = 0;
}

// Class destructor
GuiButton::~GuiButton()
{
}

// Sets the button's image
void GuiButton::SetImage(GuiImage *img)
{
	image = img;
	
	if (img)
		img->SetParent(this);
}

// Sets the button's image on over
void GuiButton::SetImageOver(GuiImage *img)
{
	imageOver = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's image on hold
void GuiButton::SetImageHold(GuiImage *img)
{
	imageHold = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's image on click
void GuiButton::SetImageClick(GuiImage *img)
{
	imageClick = img;
	
	if (img)
		img->SetParent(this);
}

// Sets the button's icon
void GuiButton::SetIcon(GuiImage *img)
{
	icon = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's icon 2
void GuiButton::SetIcon2(GuiImage *img)
{
	icon2 = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's icon on over
void GuiButton::SetIconOver(GuiImage *img)
{
	iconOver = img;
	
	if (img)
		img->SetParent(this);
}

// Sets the button's icon on hold
void GuiButton::SetIconHold(GuiImage *img)
{
	iconHold = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's icon on click
void GuiButton::SetIconClick(GuiImage *img)
{
	iconClick = img;

	if (img)
		img->SetParent(this);
}

// Sets the button's label
void GuiButton::SetLabel(GuiText *txt, int n)
{
	label[n] = txt;

	if (txt)
		txt->SetParent(this);
}

// Sets the button's label on over
void GuiButton::SetLabelOver(GuiText *txt, int n)
{
	labelOver[n] = txt;
	
	if (txt)
		txt->SetParent(this);
}

// Sets the button's label on hold
void GuiButton::SetLabelHold(GuiText *txt, int n)
{
	labelHold[n] = txt;

	if (txt)
		txt->SetParent(this);
}

// Sets the button's label on click
void GuiButton::SetLabelClick(GuiText *txt, int n)
{
	labelClick[n] = txt;

	if (txt)
		txt->SetParent(this);
}

// Sets the sound to play on over
void GuiButton::SetSoundOver(GuiSound *snd)
{
	soundOver = snd;
}

// Sets the sound to play on hold
void GuiButton::SetSoundHold(GuiSound *snd)
{
	soundHold = snd;
}

// Sets the sound to play on click
void GuiButton::SetSoundClick(GuiSound *snd)
{
	soundClick = snd;
}

// Sets the button's Tooltip on over
void GuiButton::SetToolTip(GuiTooltip *tt, int x, int y, int h_align, int v_align)
{
	if (tt)
	{
		toolTip = tt;
		toolTip->SetParent(this);
		toolTip->SetAlignment(h_align, v_align);
		toolTip->SetPosition(x, y);
	}
}

// Remove the button's Tooltip
void GuiButton::RemoveToolTip()
{
	toolTip = NULL;
}

// Draw the button on screen
void GuiButton::Draw()
{
	if (!this->IsVisible())
		return;

	// Draw image
	if ((state == STATE_SELECTED || state == STATE_HELD) && imageOver)
		imageOver->Draw();
	else if (image)
		image->Draw();

	// Draw icon
	if ((state == STATE_SELECTED || state == STATE_HELD) && iconOver)
		iconOver->Draw();
	else if (icon || icon2)
	{
		if (icon)
			icon->Draw();

		if (icon2)
			icon2->Draw();
	}

	// Draw text
	for (int i = 0; i < 3; i++)
	{
		if ((state == STATE_SELECTED || state == STATE_HELD) && labelOver[i])
			labelOver[i]->Draw();
		else if (label[i])
			label[i]->Draw();
	}

	this->UpdateEffects();
}

// Draw Tooltip
void GuiButton::DrawTooltip()
{
	if (this->IsVisible() && state == STATE_SELECTED && toolTip)
	{
	    if (time2 == 0)
		{
			time(&time1);
		    time2 = time1;
		}

		if (time1 != 0)	 // Timer is running
			time(&time1);

		if (time1 == 0 || difftime(time1, time2) >= 2)
		{
			if (time1 != 0)	 // Timer just expired
				toolTip->SetEffect(EFFECT_FADE, 20);

			time1 = 0;
			toolTip->Draw();

			return;
        }
	}
	else
	{
		if (time2 != 0 && time1 == 0) // Timer expires
		{
			if (toolTip)
				toolTip->SetEffect(EFFECT_FADE, -20);
		}

		time2 = 0;
	}

	if (toolTip && toolTip->GetEffect())
		toolTip->Draw();
}

// Constantly called to allow the GuiButton to respond to updated input data
void GuiButton::Update(GuiTrigger *t)
{
	if (state == STATE_CLICKED || state == STATE_DISABLED || !t)
		return;
	else if (parentElement && parentElement->GetState() == STATE_DISABLED)
		return;

#ifdef HW_RVL
	// Cursor
	if (t->wPad->ir.valid && t->chan >= 0)
	{
		if (this->IsInside(t->wPad->ir.x, t->wPad->ir.y))
		{
			if (state == STATE_DEFAULT)
			{
				this->SetState(STATE_SELECTED, t->chan);

				if (this->Rumble())
					rumbleRequest[t->chan] = 1;

				if (soundOver)
					soundOver->Play();

				if (effectsOver && !effects)
				{
					// initiate effects
					effects = effectsOver;
					effectAmount = effectAmountOver;
					effectTarget = effectTargetOver;
				}
			}
		}
		else
		{
			if (state == STATE_SELECTED && (stateChan == t->chan || stateChan == -1))
				this->ResetState();

			if (effectTarget == effectTargetOver && effectAmount == effectAmountOver)
			{
				// Initiate effects (in reverse)
				effects = effectsOver;
				effectAmount = -effectAmountOver;
				effectTarget = 100;
			}
		}
	}
#endif

	// Button triggers
	if (this->IsClickable())
	{
		s32 wm_btns, wm_btns_trig, cc_btns, cc_btns_trig;
		
		for (int i = 0; i < 6; i++)
		{
			if (trigger[i] && (trigger[i]->chan == -1 || trigger[i]->chan == t->chan))
			{
				// Higher 16 bits only (Wiimote)
				wm_btns = t->wPad->btns_d << 16;
				wm_btns_trig = trigger[i]->wPad->btns_d << 16;

				// Lower 16 bits only (Classic Controller)
				cc_btns = t->wPad->btns_d >> 16;
				cc_btns_trig = trigger[i]->wPad->btns_d >> 16;

				if ((t->wPad->btns_d > 0 && (wm_btns == wm_btns_trig || (cc_btns == cc_btns_trig && t->wPad->exp.type == EXP_CLASSIC))) || (t->pad.btns_d == trigger[i]->pad.btns_d && t->pad.btns_d > 0))
				{
					if (t->chan == stateChan || stateChan == -1)
					{
						if (state == STATE_SELECTED)
						{
							if (!t->wPad->ir.valid ||	this->IsInside(t->wPad->ir.x, t->wPad->ir.y))
							{
								this->SetState(STATE_CLICKED, t->chan);

								if (soundClick)
									soundClick->Play();
							}
						}
						else if (trigger[i]->type == TRIGGER_BUTTON_ONLY)
							this->SetState(STATE_CLICKED, t->chan);
						else if (trigger[i]->type == TRIGGER_BUTTON_ONLY_IN_FOCUS && parentElement->IsFocused())
							this->SetState(STATE_CLICKED, t->chan);
					}
				}
			}
		}
	}

	if (this->IsHoldable())
	{
		bool held = false;

		s32 wm_btns, wm_btns_h, wm_btns_trig, cc_btns, cc_btns_h, cc_btns_trig;

		for (int i = 0; i < 6; i++)
		{
			if (trigger[i] && (trigger[i]->chan == -1 || trigger[i]->chan == t->chan))
			{
				// Higher 16 bits only (Wiimote)
				wm_btns = t->wPad->btns_d << 16;
				wm_btns_h = t->wPad->btns_h << 16;
				wm_btns_trig = trigger[i]->wPad->btns_h << 16;

				// Lower 16 bits only (Classic Controller)
				cc_btns = t->wPad->btns_d >> 16;
				cc_btns_h = t->wPad->btns_h >> 16;
				cc_btns_trig = trigger[i]->wPad->btns_h >> 16;

				if ((t->wPad->btns_d > 0 && (wm_btns == wm_btns_trig || (cc_btns == cc_btns_trig && t->wPad->exp.type == EXP_CLASSIC))) || (t->pad.btns_d == trigger[i]->pad.btns_h && t->pad.btns_d > 0))
				{
					if (trigger[i]->type == TRIGGER_HELD && state == STATE_SELECTED && (t->chan == stateChan || stateChan == -1))
						this->SetState(STATE_CLICKED, t->chan);
				}

				if ((t->wPad->btns_h > 0 && (wm_btns_h == wm_btns_trig || (cc_btns_h == cc_btns_trig && t->wPad->exp.type == EXP_CLASSIC))) || (t->pad.btns_h == trigger[i]->pad.btns_h && t->pad.btns_h > 0))
				{
					if (trigger[i]->type == TRIGGER_HELD)
						held = true;
				}

				if (!held && state == STATE_HELD && stateChan == t->chan)
					this->ResetState();
				else if (held && state == STATE_CLICKED && stateChan == t->chan)
					this->SetState(STATE_HELD, t->chan);
			}
		}
	}

	if (updateCB)
		updateCB(this);
}
