log_to_console () {
    if [ "$bootsplashoff" ]; then
	    [ "${loop:-n}" != y ] || return 0
	    [ "${QUIET:-no}" != yes ] || return 0

	    # Only output to the console when we're given /dev/null
	    stdin=`readlink /proc/self/fd/0`
	    [ "${stdin#/dev/null}" != "$stdin" ] || return 0

	    func=$1
	    shift

	    loop=y $func "$@" </dev/console >/dev/console 2>&1 || true
    fi
}

log_success_msg () {
    if [ "$bootsplashoff" ]; then
	    log_to_console log_success_msg "$@"
	    print " * $@"
    fi
}

log_failure_msg () {
    if [ "$bootsplashoff" ]; then
	    log_to_console log_failure_msg "$@"

	    if log_use_fancy_output; then
		RED=`$TPUT setaf 1`
		NORMAL=`$TPUT op`
		print " $RED*$NORMAL $@"
	    else
		print " * $@"
	    fi
    fi
}

log_warning_msg () {
    if [ "$bootsplashoff" ]; then
	    log_to_console log_warning_msg "$@"

	    if log_use_fancy_output; then
		YELLOW=`$TPUT setaf 3`
		NORMAL=`$TPUT op`
		print " $YELLOW*$NORMAL $@"
	    else
		print " * $@"
	    fi
    fi
}

log_begin_msg () {
    if [ "$bootsplashoff" ]; then
    	log_daemon_msg "$1"
    fi
}

# We have to stop _before_ ?dm starts
log_daemon_msg () {
    if [ -z "$1" ]; then
        return 1
    fi
    if [ "$bootsplashoff" ]; then
	    log_to_console log_daemon_msg "$@"

	    if log_use_fancy_output && $TPUT xenl >/dev/null 2>&1; then
		COLS=`$TPUT cols`
		if [ "$COLS" ] && [ "$COLS" -gt 6 ]; then
		    COL=`$EXPR $COLS - 7`
		else
		    COLS=80
		    COL=73
		fi

		print -n " * $*       "

		$TPUT hpa `$EXPR $COLS - 1`
		print -n ' '
	    else
		print -n " * $@"
		COL=
	    fi

	    [ -x $SPL_UPD ] || return $1;

	    if [ -z "${RUNLEVEL:-}" ]; then
		# we need only the current level
		RUNLEVEL=`runlevel | sed 's/^. //'`
		# Bug # 470816
		if [ -z "$RUNLEVEL" ]; then
		    # if we can't figure out the runlevel (such as when run
		    # from a cron job) then don't do anything with Splashy
		    exit $1
		fi
	    fi
	    if [ "x$RUNLEVEL" = "x6" ] || [ "x$RUNLEVEL" = "x0" ]; then
		return 0
	    fi
    fi
}

log_progress_msg () {
    :
}

log_end_msg () {
    if [ -z "$1" ]; then
        return 1
    fi
    if [ "$bootsplashoff" ]; then
	    log_to_console log_end_msg "$@"

	    if [ "$COL" ] && [ -x "$TPUT" ]; then
		$TPUT hpa $COL
		if [ "$1" -eq 0 ]; then
		    print -n "["
		    $TPUT setaf 2 # green
		    print -n " OK "
		    $TPUT op # normal
		    print "]"
		else
		    print -n '['
		    $TPUT setaf 1 # red
		    print -n fail
		    $TPUT op # normal
		    print ']'
		fi
	    else
		if [ "$1" -eq 0 ]; then
		    print "   ...done."
		else
		    print "   ...fail!"
		fi
	    fi
    fi

    basename $0 | sed "s/`head -c 1 -`//" | cut -c1-2 > /tmp/fbsplash.fifo

    return $1
    log_status=$1
}

log_action_msg () {
    if [ "$bootsplashoff" ]; then
	    log_to_console log_action_msg "$@"

	    print " * $@"
    fi
}

log_action_begin_msg () {
    if [ "$bootsplashoff" ]; then
    	log_daemon_msg "$@..."
    fi
}

log_action_cont_msg () {
    if [ "$bootsplashoff" ]; then
    	log_daemon_msg "$@..."
    fi
}

log_action_end_msg () {
    if [ "$bootsplashoff" ]; then
    	# In the future this may do something with $2 as well.
    	log_end_msg "$1"
    fi
}
