# Copyright 2008-2009  Segher Boessenkool  <segher@kernel.crashing.org>
# Copyright      2011  Bernhard Urban <lewurm@gmail.com>
# This code is licensed to you under the terms of the GNU GPL, version 2;
# see file COPYING or http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

	.section .start,"ax"
	retadr = 0x90394140

	# The return addr for the nintendo loader is a bit different as for 3rd
	# party loaders. In fact, it depends which value is set by the apploader at
	# 0x8000002c:
	#  -  0x0: return address is 0x90394140 (some 3rd party loader, e.g. gecko os)
	#  - 0x23: return address is 0x90394000 (set by the sysmenu loader by nintendo)
	#  0B ver:                   0x90394100
	# to make both work, we insert some no op's here
	.fill (0x140/0x4), 4, 0x60000000

start:
	# Set up a stack frame.
	lis 1,0x8080 ; li 0,0 ; stwu 0,-64(1)

	# Stop audio and video.
	lis 0,audio_stop@h ; ori 0,0,audio_stop@l ; mtctr 0 ; bctrl
	lis 0,video_stop@h ; ori 0,0,video_stop@l ; mtctr 0 ; bctrl

	# Move code into place; a generous 32kB, starting at 64kB in
	# the save file.

	lis 3,main@h ; ori 3,3,main@l ; addi 5,3,-4
	lis 4,(retadr-4)@h ; ori 4,4,(retadr-4)@l
	# Calculate proper offset for the loader in memory
0:	lbzu 0,4(4); cmpwi 0,0x60 ; beq 0b
	addi 4,4,-4; addi 4,4,end-start

	li 0,0x2000 ; mtctr 0
0:	lwzu 0,4(4) ; stwu 0,4(5) ; bdnz 0b

	# Sync caches on it.
	li 0,0x0400 ; mtctr 0 ; mr 5,3
0:	dcbst 0,5 ; sync ; icbi 0,5 ; addi 5,5,0x20 ; bdnz 0b
	sync ; isync

	# Go for it!
	mtctr 3 ; bctr
end:
