#include <stdio.h>
#include <stdlib.h>
#include <gccore.h>
#include <wiiuse/wpad.h>

static void *xfb = NULL;
static GXRModeObj *rmode = NULL;

//---------------------------------------------------------------------------------
int main(int argc, char **argv) {
//---------------------------------------------------------------------------------
	VIDEO_Init();
	WPAD_Init();
	rmode = VIDEO_GetPreferredMode(NULL);
	xfb = MEM_K0_TO_K1(SYS_AllocateFramebuffer(rmode));
	console_init(xfb,20,20,rmode->fbWidth,rmode->xfbHeight,rmode->fbWidth*VI_DISPLAY_PIX_SZ);
	VIDEO_Configure(rmode);
	VIDEO_SetNextFramebuffer(xfb);
	VIDEO_SetBlack(FALSE);
	VIDEO_Flush();
	VIDEO_WaitVSync();
	if(rmode->viTVMode&VI_NON_INTERLACE) VIDEO_WaitVSync();
	

	int frcount = 0;
	int thiscycle = 0;
	int phase = 0;

	printf("\x1b[2;0H");
	printf("Searching for 3DS Private Key");
	printf("\x1b[3;0H");
	printf("[..........]");
	printf("\x1b[3;1H");

	while(1) {
		WPAD_ScanPads();
		u32 pressed = WPAD_ButtonsDown(0);
		if ( pressed & WPAD_BUTTON_HOME ) exit(0);
		VIDEO_WaitVSync();
		
		if (phase == 0) {
			frcount = frcount+1;
			
			if (frcount == 60) {
				frcount = 0;
				thiscycle = thiscycle+1;
				printf("+");
				if (thiscycle == 7) {
					thiscycle = 0;
					frcount = 0;
					phase = 1;
				}
			}
		}
		
		if (phase == 1){
			printf("\x1b[4;0H");
			printf("Wait, this isn't a 3DS!");
			frcount = frcount+1;
			if (frcount == 180) {
				frcount = 0;
				phase = 2;
			}
		
		}
		
		if (phase == 2){
			printf("\x1b[6;0H");
			printf("Finding Wii U Common Key");
			printf("\x1b[7;0H");
			printf("[..........]");
			printf("\x1b[7;1H");
			phase = 3;
		}
		
		if (phase == 3){
			frcount = frcount+1;
			if (frcount == 60) {
				frcount = 0;
				thiscycle = thiscycle+1;
				printf("+");
				if (thiscycle == 3) {
					thiscycle = 0;
					frcount = 0;
					phase = 4;
				}
			}
		}
		
		if (phase == 4){
			printf("\x1b[8;0H");
			printf("Not enough Wii internal space!");
			frcount = frcount+1;
			if (frcount == 120) {
				frcount = 0;
				phase = 5;
			}
		}
		
		if (phase == 5){
		printf("\x1b[9;0H");
			printf("You must run this program on the 1024MB Wii Elite model.");
			printf("\r\n");
			frcount = frcount+1;
			if (frcount == 240) {
				frcount = 0;
				phase = 6;
			}

		}
		
		if (phase == 6){
			printf("\x1b[11;0H");
			printf("Searching for any possible keys!");
			frcount = frcount+1;
			if (frcount == 180) {
				frcount = 0;
				phase = 7;
			}	
		}
		
		if (phase == 7){
			printf("\x1b[12;0H");
			printf("Found key for: front door. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: PS4 private. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: 360 Live spoof. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: my heart. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: tinymonkeyt's bedroom. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: Hitler's locked diary. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: world peace. \r\n");
			frcount = 0; while(frcount<30) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("Found key for: keeping cereal crunchy in milk. \r\n");
			frcount = 0; while(frcount<120) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("\r\n");
			phase = 8;
		}
		
		if (phase == 8){
			printf("This program has determined itself as a failure in doing anything useful\r\nand will now self-destruct, along with your inferior 512MB Wii Standard model.\r\n\r\n");
			frcount = 0; while(frcount<600) { frcount = frcount+1; VIDEO_WaitVSync(); }
			printf("#pcmasterrace");
			frcount = 0; while(frcount<120) { frcount = frcount+1; VIDEO_WaitVSync(); }
			SYS_ResetSystem(SYS_POWEROFF,0,0);
		}
	}

	return 0;
}
