#include <QtCore/QCoreApplication>
#include <QFile>
#include <QtDebug>
#include <QBuffer>
#include <QStringList>
#include <qendian.h>


QByteArray ReadFile( const QString &path )
{
	QFile file( path );
	if( !file.exists() || !file.open( QIODevice::ReadOnly ) )
	{
		qWarning() << "ReadFile -> can't open" << path;
		return QByteArray();
	}
	QByteArray ret = file.readAll();
	file.close();
	return ret;
}

bool WriteFile( const QString &path, const QByteArray &ba )
{
	QFile file( path );
	if( !file.open( QIODevice::WriteOnly | QIODevice::Truncate ) )
	{
		qWarning() << "WriteFile -> can't open" << path;
		return false;
	}
	if( file.write( ba ) != ba.size() )
	{
		file.close();
		qWarning() << "WriteFile -> can't write all the data to" << path;
		return false;
	}
	file.close();
	return true;
}

QByteArray ChecksumJap( QByteArray ba )
{
	quint32 tmp;
	quint32 sum1 = 0;
	quint32 sum2 = 0;

	QBuffer buf( &ba );
	buf.open( QIODevice::ReadWrite );

	buf.seek( 8 );
	for( int i = 2; i < 0x12 * 9; i++ )
	{
		buf.read( (char*)&tmp, 4 );
		sum1 += qFromBigEndian( tmp );
	}

	buf.seek( 8 );
	for( int i = 2; i < 0x31c8 * 4; i++ )//0x31c8 is for JAP version
	{
		buf.read( (char*)&tmp, 4 );
		sum2 += qFromBigEndian( tmp );
	}

	qDebug() << "checkSums:" << hex << sum1 << sum2;

	buf.seek( 0 );
	tmp = qFromBigEndian( sum1 );
	buf.write( (const char*)&tmp, 4 );
	tmp = qFromBigEndian( sum2 );
	buf.write( (const char*)&tmp, 4 );

	buf.close();

	return ba;

}

#define NOP 0x60000000

//how many extra instruction do i have before the loader ( for killing audio and shit )
#define NUM_INSTRUCTIONS_BEFORE_LOADER 6

//where doesnt the name in the save start that is being exploited?
#define NAME_OFFSET  0xf3a

//how long must the name be?
#define NAME_LEN 0x144

//where am i putting the loader inside the save file?
#define SAVE_LOADER_START 0x2aa0

//where am i putting the instructions before the loader inside the save file?
#define SAVE_INSTRUCTIONS_START ( SAVE_LOADER_START - ( 4 * NUM_INSTRUCTIONS_BEFORE_LOADER ) )

//where in the save file does our return address need to be?
#define RETURN_ADDR_OFFSET ( NAME_OFFSET + NAME_LEN )

QByteArray MakeHaxx1( QByteArray ba, const QByteArray &loader )
{
//where is the elf loader going to be in memory?
#define ENTRYPOINT 0x80446c20

//where do the instructions start?
#define INSTRUCTION_START ( ENTRYPOINT - ( 4 * NUM_INSTRUCTIONS_BEFORE_LOADER ) )

	qDebug() << "making haxx for v1";
	quint32 tmp;
	QBuffer buf( &ba );
	buf.open( QIODevice::ReadWrite );

	//write the address of our code to execute
	buf.seek( RETURN_ADDR_OFFSET );
	tmp = qFromBigEndian( (quint32)INSTRUCTION_START );
	buf.write( (char*)&tmp, 4 );
	qDebug() << "ENTRYPOINT        :" << hex << ENTRYPOINT;
	qDebug() << "RETURN_ADDR_OFFSET:" << hex << INSTRUCTION_START << "@" << hex << RETURN_ADDR_OFFSET;

	//write some code to execute before the elf loader
	buf.seek( SAVE_INSTRUCTIONS_START );
	tmp = qFromBigEndian( (quint32)0x4bc6605d );//bl audiostop
	buf.write( (char*)&tmp, 4 );
	tmp = qFromBigEndian( (quint32)0x4bc89c91 );//bl videostop
	buf.write( (char*)&tmp, 4 );
	while( buf.pos() < SAVE_LOADER_START )
	{
		tmp = qFromBigEndian( (quint32)NOP );	//throw in some NOP in case i need to insert more instructions later
		buf.write( (char*)&tmp, 4 );
	}

	buf.seek( SAVE_LOADER_START );				//write the loader
	buf.write( loader );
	buf.close();

	//fix checksums
	QByteArray fixed = ChecksumJap( ba );
	return fixed;
}

QByteArray MakeHaxx2( QByteArray ba, const QByteArray &loader )
{
//where is the elf loader going to be in memory?
#define ENTRYPOINT2 0x80446ca0

//where do the instructions start?
#define INSTRUCTION_START2 ( ENTRYPOINT2 - ( 4 * NUM_INSTRUCTIONS_BEFORE_LOADER ) )

	qDebug() << "making haxx for v2";
	quint32 tmp;
	QBuffer buf( &ba );
	buf.open( QIODevice::ReadWrite );

	//write the address of our code to execute
	buf.seek( RETURN_ADDR_OFFSET );
	tmp = qFromBigEndian( (quint32)INSTRUCTION_START2 );
	buf.write( (char*)&tmp, 4 );
	qDebug() << "ENTRYPOINT        :" << hex << ENTRYPOINT2;
	qDebug() << "RETURN_ADDR_OFFSET:" << hex << INSTRUCTION_START2 << "@" << hex << RETURN_ADDR_OFFSET;

	//write some code to execute before the elf loader
	buf.seek( SAVE_INSTRUCTIONS_START );
	tmp = qFromBigEndian( (quint32)0x4bc66095 );//bl audiostop
	buf.write( (char*)&tmp, 4 );
	tmp = qFromBigEndian( (quint32)0x4bc89cc9 );//bl videostop
	buf.write( (char*)&tmp, 4 );
	while( buf.pos() < SAVE_LOADER_START )
	{
		tmp = qFromBigEndian( (quint32)NOP );	//throw in some NOP in case i need to insert more instructions later
		buf.write( (char*)&tmp, 4 );
	}

	buf.seek( SAVE_LOADER_START );				//write the loader
	buf.write( loader );
	buf.close();

	//fix checksums
	QByteArray fixed = ChecksumJap( ba );
	return fixed;
}

int main(int argc, char *argv[])
{
	QCoreApplication a(argc, argv);
	QStringList args = QCoreApplication::arguments();
	if( args.size() < 2 )
	{
		qDebug() << "args" << args;
		return 4;
	}
	QByteArray loader = ReadFile( "./loader/loader.bin" );
	QByteArray loader2 = ReadFile( "./loader/loader2.bin" );
	if( loader.isEmpty() || loader2.isEmpty() )
		return 1;

	QByteArray origSave = ReadFile( "./baseSave/000100005254344a/01.dat" );
	if( origSave.isEmpty() )
		return 2;

	if( origSave.size() < 0x31c80 )
	{
		qDebug() << "size" << hex << origSave.size();
		return 3;
	}


	//output path
	QString outPath = args.at( 1 );
	if( !outPath.endsWith( '/' ) )
		outPath += '/';

	//overflow the buffer
	for( int i = NAME_OFFSET; i < NAME_OFFSET + NAME_LEN; i++ )
	{
		if( origSave[ i ] == '\0' )
			origSave[ i ] = 1;
	}

	QBuffer buf( &origSave );
	buf.open( QIODevice::ReadWrite );
	buf.seek( NAME_OFFSET );//write my name in there :)
	buf.write( "Giantpune" );
	buf.close();

	//make the save for v1 of the game
	QByteArray out = MakeHaxx1( origSave, loader );

	//write the saves in reverse order since the game creates its list with lower numbers at the bottom
	WriteFile( outPath + "02.dat", out );

	//make the save for v2 of the game
	out = MakeHaxx2( origSave, loader2 );
	WriteFile( outPath + "01.dat", out );

	qDebug() << "done";

	return 0;
}

