// Copyright 2011 Pierre "delroth" Bourdon <delroth@gmail.com>
// This code is licensed to you under the terms of the GNU GPL, version 2;
// see file COPYING or http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

#include <byteswap.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    FILE* fp;
    int i;
    int read_val;
    int sum1 = 0;
    int sum2 = 0;

    fp = fopen(argv[1], "rb");

    fseek(fp, 8, SEEK_SET);
    for (i = 2; i < 0x12 * 9; ++i)
    {
        fread(&read_val, 1, sizeof (int), fp);
        sum1 += bswap_32(read_val);
    }

    fseek(fp, 8, SEEK_SET);
    for (i = 2; i < 0x32B1 * 4; ++i)
    {
        fread(&read_val, 1, sizeof (int), fp);
        sum2 += bswap_32(read_val);
    }

    printf("cksum = %08x %08x\n", sum1, sum2);
    fclose(fp);

    fp = fopen(argv[1], "r+b");
    sum1 = bswap_32(sum1);
    sum2 = bswap_32(sum2);
    fwrite(&sum1, 1, sizeof (int), fp);
    fwrite(&sum2, 1, sizeof (int), fp);
    fclose(fp);

    return 0;
}
