#! /bin/sh

cd "$(dirname "$0")"
set -e

TITLE_ID=RT4P
TITLE_NUM_ID=0001000052543450
OFFSET=5768

echo >&2 "Eri HaKawai for PAL 4.3 Wii, by delroth"

[ -d "$TOOLS" ] || {
    cat >&2 <<EOF
$0: error: you must set the TOOLS environment variable to point to the
directory where segher's Wii tools are installed.

They can be downloaded from http://git.infradead.org/?p=users/segher/wii.git
EOF
    exit 1
}

echo >&2 "Compiling the savezelda loader..."
make -C payload

echo >&2 "Compiling the checksum tool..."
gcc -o tos-cksum/tos-cksum tos-cksum/tos-cksum.c

echo >&2 "Injecting the loader into the save..."
rm -rf "$TITLE_NUM_ID"
cp -R orig-save "$TITLE_NUM_ID"
dd if=payload/loader.bin of="$TITLE_NUM_ID/01.dat" conv=notrunc bs=1 \
   seek="$OFFSET"
tos-cksum/tos-cksum "$TITLE_NUM_ID"/01.dat

echo >&2 "Creating the data.bin file..."
rm -rf private
mkdir -p private/wii/title/"$TITLE_ID"
"$TOOLS/twintig" "$TITLE_NUM_ID" private/wii/title/"$TITLE_ID"/data.bin

cat << EOF
$0: done!

Now, copy the generated "private" directory on your SD card, place a "boot.elf"
binary at the root of your SD card, and have fun!
EOF
