﻿--[[ Copyright (c) 2011 Sergei Larionov, Alexey Pinyagin

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Font("unicode")
Language("Русский", "Russian", "ru", "rus")
Inherit("English")
Encoding(utf8)

--[[  Оглавление
  1.  Главное меню
  2.  Игровое меню и панель инструментов
  3.  Отчеты
  4.  Окна интерфейса
  5.  Болезни
  6.  Факсы
  7.  Советчик
  8.  Письма из министерства (WIP)
--]]

-- 1.  Главное меню
main_menu = {
  new_game = "Новая игра",
  custom_level = "Дополнительные уровни",
  load_game = "Загрузить игру",
  options = "Настройки",
  exit = "Выход",
}
new_game_window = {
  tutorial = "Обучение",
  easy = "Студент (Легкий)",
  medium = "Доктор (Средний)",
  hard = "Консультант (Трудный)",
  cancel = "Отмена",
}
custom_game_window = {
  caption = "Дополнительные уровни",
}
load_game_window = {
  caption = "Загрузить игру",
}
save_game_window = {
  caption = "Сохранить игру",
  new_save_game = "Новое сохранение",
}
options_window = {
  fullscreen = "Во весь экран",
  height = "Высота",
  width = "Ширина",
  change_resolution = "Сменить разрешение",
  back = "Назад",
  original_path = "Папка с установленной оригинальной игрой Theme Hospital",
  browse = "Выбрать папку",
}
menu_list_window = {
  back = "Назад",
}
tooltip = {
  main_menu = {
    exit = "Стой! Пожалуйста, не уходи!",
    custom_level = "Играть отдельный уровень",
    options = "Изменить всякие параметры",
    new_game = "Начать совершенно новую игру с самого начала",
    load_game = "Загрузить сохраненную ранее игру",
  },
  new_game_window = {
    tutorial = "Поставьте галочку здесь, чтобы пройти режим обучения",
    easy = "Нажимайте сюда, если вы новичок в подобных играх",
    medium = "Самый обычный средний уровень сложности",
    hard = "Выберите этот вариант, если хотите усложнить себе игру",
    cancel = "Отмена",
  },
  totd_window = {
    previous = "Показать предыдущий совет",
    next = "Показать следующий совет",
  },
  options_window = {
    fullscreen_button = "Включить/отключить полноэкранный режим",
    change_resolution = "Сменить разрешение экрана на указанное слева",
    height = "Введите разрешение экрана по вертикали",
    width = "Введите разрешение экрана по горизонтали",
    language = "Select %s as language",
    back = "Закрыть окно настроек",
  },
  save_game_window = {
    new_save_game = "Введите имя для сохраненной игры",
    save_game = "Перезаписать игру «%s»",
  },
  load_game_window = {
    load_game = "Загрузить игру «%s»",
    load_autosave = "Загрузить автосохранение",
  },
}

-- 2.  Игровое меню и панель инструментов
menu = {
  file =    "  Файл",
  options = "  Опции",
  charts =  "  Отчеты",
}
menu_file = {
  save =    "  Сохранить",
  load =    "  Загрузить",
  restart = "  Начать заново",
  quit =    "  Выйти в главное меню",
}
menu_options = {
  game_speed =        "    Скорость игры",
  sound_vol =         "    Громкость звука",
  music_vol =         "    Громкость музыки",
  edge_scrolling =    "    Прокрутка мышью",
  announcements =     "    Сообщения",
  lock_windows =      "    Не двигать окна",
  settings =          "    Настройки",
  sound =             "    Звуки",
  announcements_vol = "    Громкость сообщений",
  music =             "    Музыка",
  autosave =          "    Автосохранение",
  jukebox =           "    Музыкальный автомат",
}
menu_options_game_speed = {
  pause =              "    (P) Пауза",
  slowest =            "    (1) Черепашья",
  slower =             "    (2) Медленная",
  normal =             "    (3) Обычная",
  max_speed =          "    (4) Быстрая",
  and_then_some_more = "    (5) Еще быстрее",
}
menu_charts = {
  statement =     "  Баланс банка",
  casebook =      "  Лабораторный журнал",
  policy =        "  Политика",
  research =      "  Исследования",
  graphs =        "  Графики",
  staff_listing = "  Список сотрудников",
  bank_manager =  "  Управляющий банка",
  status =        "  Состояние",
  briefing =      "  Инструктаж",
}
menu_file_load = {
  [1] = "  ИГРА 1  ",
  [2] = "  ИГРА 2  ",
  [3] = "  ИГРА 3  ",
  [4] = "  ИГРА 4  ",
  [5] = "  ИГРА 5  ",
  [6] = "  ИГРА 6  ",
  [7] = "  ИГРА 7  ",
  [8] = "  ИГРА 8  ",
}
menu_debug_overlay = {
  heat = "  TEMPERATURE  ",
  byte_0_1 = "  BYTE 0 & 1  ",
  byte_6 = "  BYTE 6  ",
  flags = "  FLAGS  ",
  byte_7 = "  BYTE 7  ",
  byte_5 = "  BYTE 5  ",
  byte_floor = "  BYTE FLOOR  ",
  positions = "  POSITIONS  ",
  byte_w_wall = "  BYTE W WALL  ",
  parcel = "  PARCEL  ",
  byte_n_wall = "  BYTE N WALL  ",
  none = "  NONE  ",
}
menu_file_save = {
  [1] = "  ИГРА 1  ",
  [2] = "  ИГРА 2  ",
  [3] = "  ИГРА 3  ",
  [4] = "  ИГРА 4  ",
  [5] = "  ИГРА 5  ",
  [6] = "  ИГРА 6  ",
  [7] = "  ИГРА 7  ",
  [8] = "  ИГРА 8  ",
}
install = {
  title = "--------------------------------- CorsixTH Setup ---------------------------------",
  th_directory = "CorsixTH для нормальной работы требуется оригинальная установленная игра Theme Hospital. Нажмите кнопку и выберите папку, в которую установлена оригинальная игра.",
  exit = "Выход",
}
dynamic_info = {
  patient = {
    emergency = "Чрезвычайная ситуация: %s",
    guessed_diagnosis = "Диагноз навскидку: %s ",
    diagnosis_progress = "Процесс диагностики",
    actions = {
      sent_to_other_hospital = "Отправлен в другую больницу",
      prices_too_high = "У вас слишком дорого, - я иду домой",
      no_gp_available = "Ждет постройки кабинета терапевта",
      waiting_for_treatment_rooms = "Ждет постройки кабинета для лечения",
      dying = "Умирает!",
      no_diagnoses_available = "Раз не знаете что со мной, - я иду домой",
      epidemic_sent_home = "Отправлен домой инспектором",
      cured = "Здоров!",
      waiting_for_diagnosis_rooms = "Ждет постройки диагностического кабинета",
      epidemic_contagious = "Заразный",
      awaiting_decision = "Ждет вашего решения",
      sent_home = "Отправлен домой",
      fed_up = "Сыт по горло и уходит",
      no_treatment_available = "Раз не можете вылечить, - я иду домой",
      on_my_way_to = "Идет в %s",
      queueing_for = "Стоит в очереди в %s",
    },
    diagnosed = "Поставлен диагноз: %s ",
  },
  health_inspector = "Инспектор",
  vip = "Шишка",
  object = {
    times_used = "Использовано раз: %d",
    queue_size = "Длина очереди: %d",
    strength = "Прочность: %d",
    queue_expected = "Ожидается очередь: %d",
  },
  staff = {
    actions = {
      going_to_repair = "Идет чинить %s",
      fired = "Уволен",
      waiting_for_patient = "Ждет пациента",
      wandering = "Слоняется без дела",
      heading_for = "Идет в %s",
    },
    tiredness = "Усталость",
  },
}
staff_title = {
  junior = "Студент",
  psychiatrist = "Психиатр",
  consultant = "Консультант",
  surgeon = "Хирург",
  doctor = "Доктор",
  researcher = "Исследователь",
  nurse = "Медсестра",
  receptionist = "Регистратор",
  general = "Общий",
}
tooltip = {
  toolbar = {
    bank_button = "Левая кнопка - управляющий банка, правая - баланс банка",
    balance = "Ваш баланс",
    reputation = "Ваша репутация",
    date = "Дата",
    rooms = "Строить кабинеты",
    objects = "Обставлять коридор",
    edit = "Редактировать кабинеты/мебель",
    hire = "Нанять персонал",
    staff_list = "Управление персоналом",
    town_map = "Карта",
    casebook = "Лабораторный журнал",
    research = "Исследования",
    status = "Состояние",
    charts = "Графики",
    policy = "Политика",
  },
}
misc = {
  hospital_open = "Открыть больницу",
  save_success = "Игра успешно сохранена",
  save_failed = "Ошибка: не удалось сохранить игру",
  low_res = "Низкое разрешение",
  no_heliport = "Либо заболевания не обнаружены, либо на этой карте нет вертолетной площадки.",
  grade_adverb = {
    extremely = "экстремально",
    mildly = "средне",
    moderately = "умеренно",
  },
  not_yet_implemented = "(еще не реализовано)",
  send_message = "Отправить сообщение игроку %d",
  out_of_sync = "Рассинхронизация игры",
  balance = "Файл баланса:",
  load_failed = "Сохранение не загружено",
  mouse = "Мышь",
  done = "Готово",
  force = "Ускорение",
  pause = "Пауза",
  send_message_all = "Отправить сообщение всем игрокам",
}
errors = {
  unavailable_screen_size = "Установленный размер экрана не поддерживается в полноэкранном режиме.",
  dialog_missing_graphics = "Sorry, the demo data files don't contain this dialog.",
  maximum_screen_size = "Максимальный размер экрана не должен превышать 3000x2000.",
  load_prefix = "Ошибка загрузки игры: ",
  save_prefix = "Ошибка сохранения игры: ",
  map_file_missing = "Не найден файл карты %s для этого уровня!",
  minimum_screen_size = "Размер экрана не должен быть менее, чем 640x480.",
}

-- 3.  Отчеты
staff_list = {
  morale = "Мораль",
  tiredness = "Бодрость",
  skill = "Компетентность",
}
bank_manager = {
  current_loan = "Текущий заем",
  balance = "Баланс",
  interest_payment = "Выплачиваемый процент",
  hospital_value = "Стоимость госпиталя",
  interest_rate = "Процентная ставка",
  inflation_rate = "Уровень инфляции",
  insurance_owed = "Выплаты страховщиков",
  statistics_page = {
    balance = "Баланс",
    details = "Причина",
    date = "Дата",
    current_balance = "Текущий баланс",
    money_in = "Приход",
    money_out = "Расход",
  },
}
transactions = {
  severance = "Выходное пособие",
  research = "Финансирование исследований",
  eoy_trophy_bonus = "Приз по итогам года",
  buy_object = "Покупка",
  cure_colon = "Лечение:",
  wages = "Выплата зарплат",
  personal_bonus = "Выплата премии",
  drug_cost = "Покупка лекарств",
  heating = "Счет за отопление",
  treat_colon = "Обследование:",
  hire_staff = "Прием на работу",
  bank_loan = "Заем у банка",
  insurance_colon = "Страховка:",
  sell_object = "Продажа",
  loan_interest = "Выплата процента по займу",
  loan_repayment = "Возврат по займу",
  buy_land = "Покупка участка",
  machine_replacement = "Замена машины",
  build_room = "Постройка",
  drinks = "Продажа напитков",
}
town_map = {
  number = "Номер участка",
  not_for_sale = "Не продается",
  price = "Цена участка",
  for_sale = "Продается",
  owner = "Владелец уч-ка",
  area = "Площадь уч-ка",
}
high_score = {
  categories = {
    deaths = "Пациентов угроблено",
    total_value = "Общая стоимость",
    money = "Самый богатый",
    cures = "Пациентов вылечено",
    visitors = "Количество посетителей",
    salary = "Размер зарплаты",
  },
}
research = {
  allocated_amount = "Распределенное количество",
  funds_allocation = "Распределение финасирования",
  categories = {
    improvements = "Улучшения",
    drugs = "Исследование лекарств",
    diagnosis = "Диагностическое оборудование",
    cure = "Оборудование для лечения",
    specialisation = "Специализация",
  },
}
policy = {
  header = "Политика больницы",
  diag_termination = "Длительность обследования",
  sliders = {
    guess = "Диагноз наугад",
    send_home = "Отправить домой",
    stop = "Прекратить",
    staff_room = "Идти отдыхать",
  },
  diag_procedure = "Процедура обследования",
  staff_rest = "Отправлять персонал отдыхать",
  staff_leave_rooms = "Покидать кабинеты",
}
casebook = {
  sent_home = "Отправлено домой",
  deaths = "Жертвы",
  treatment_charge = "Взимаемая плата",
  reputation = "Репутация",
  research = "Сосредоточить исследования",
  cure = "Лекарство",
  cured = "Вылечено",
  earned_money = "Денег получено",
}
progress_report = {
  quite_unhappy = "Люди вами недовольны",
  header = "Отчет об успехах",
  very_unhappy = "Люди вас не любят. Уделяйте им больше внимания",
  more_drinks_machines = "Пациенты умирают от жажды. Поставьте автоматы с напитками",
  too_cold = "У вас слишком холодно, поставьте еще батарей",
  too_hot = "Настройте систему отопления, у вас слишком жарко",
  percentage_pop = "Доля клиентов",
  win_criteria = "Условия для победы",
}
tooltip = {
  staff_list = {
    prev_person = "Предыдущая страница",
    next_person = "Следующая страница",
    detail = "Внимание к деталям",
    happiness = "Насколько ваши сотрудники довольны своей работой в целом",
    tiredness = "Показывает сколько ваши сотрудники еще смогут поработать без отдыха",
    ability = "Квалификация ваших сотрудников в среднем по больнице",
    happiness_2 = "Моральное состояние",
    ability_2 = "Профессиональные навыки",
    tiredness_2 = "Запас сил",
    researcher_train = "На %d%% готов к получению диплома исследователя",
    surgeon_train = "На %d%% готов к получению диплома хирурга",
    psychiatrist_train = "На %d%% готов к получению диплома психиатра",
    researcher = "Дипломированый исследователь",
    psychiatrist = "Дипломированый психиатр",
    surgeon = "Дипломированый хирург",
    handymen = "Показать список всех рабочих вашей больницы",
    nurses = "Показать список всех медсестер вашей больницы",
    doctors = "Показать список всех докторов вашей больницы",
    receptionists = "Показать список всех регистраторов вашей больницы",
    pay_rise = "Поднять оклад на 10%",
    bonus = "Выплатить премию в размере 10% от оклада",
    salary = "Текущая зарплата",
    close = "Назад к игре",
    sack = "Вышвырнуть на улицу",
    doctor_seniority = "Авторитет доктора",
    view_staff = "Наблюдать за работой",
    skills = "Дополнительные умения",
    total_wages = "Общая зарплата",
  },
  town_map = {
    close = "Закрыть",
    plants = "Показывать растения",
    fire_extinguishers = "Показывать огнетушители",
    people = "Показывать людей",
    balance = "Баланс",
    heat_dec = "Уменьшить температуру",
    heating_bill = "Счет за отопление",
    radiators = "Показывать батареи",
    objects = "Показывать мебель",
    heat_level = "Температура",
    heat_inc = "Увеличить температуру",
  },
  policy = {
    diag_termination = "Обследование пациента будет продолжаться, пока доктора не будут на столько процентов уверены в диагнозе или пока у них не закончатся средства диагностики",
    close = "Закрыть окно политики",
    staff_leave = "Нажмите здесь чтобы разрешить сотрудникам покидать кабинеты и идти туда где нужна их помощь",
    diag_procedure = "Если доктор уверен в своем диагнозе менее, чем значение «Отправить домой», пациент будет отправлен домой. Если же шансы выше чем «Диагноз наугад», он будет отправлен на лечение. В остальных случаях потребуется ваше решение",
    staff_rest = "Насколько усталым должен быть сотрудник, чтобы получить право на отдых",
    staff_stay = "Нажмите здесь чтобы сотрудники оставались в тех кабинетах, где вы их поставили",
  },
  bank_manager = {
    graph = "График ожидаемых выплат от %s",
    close = "Закрыть окно",
    hospital_value = "Текущая стоимость госпиталя вместе со всем оборудованием",
    graph_return = "Вернуться назад",
    current_loan = "Размер текущего займа",
    borrow_5000 = "Занять у банка 5000$",
    balance = "Ваш баланс",
    interest_payment = "Ежемесячные выплаты по займу",
    inflation_rate = "Размер инфляции за год",
    interest_rate = "Годовой процент по займу",
    repay_5000 = "Отдать банку 5000$",
    show_graph = "Показать график ожидаемых выплат от %s",
    insurance_owed = "Сколько денег вам должны %s",
  },
  casebook = {
    sent_home = "Количество пациентов, которым было отказано в лечении",
    increase = "Поднять стоимость",
    decrease = "Снизить стоимость",
    up = "Вверх",
    down = "Вниз",
    reputation = "Общая репутация этой практики",
    research = "Нажмите чтобы сосредоточить бюджет специальных исследований на этой проблеме",
    close = "Закрыть",
    earned_money = "Всего заработано на этом",
    deaths = "Количество летальных исходов",
    cured = "Количество вылеченных",
    treatment_charge = " Стоимость для пациентов",
    cure_type = {
      psychiatrist = "Это лечит психиатр",
      drug_percentage = "От этого есть лекарство. Ваше эффективно на %d%",
      machine = "Для лечения нужно специальное оборудование",
      surgery = "Лечение требует операции",
    },
    cure_requirement = {
      possible = "Вы можете это вылечить",
      build_room = "Вам нужно построить специальный кабинет для лечения",
      research_machine = "Для лечения нужно изобрести машину",
      hire_staff = "Вам нужно нанять специалиста для лечения",
    },
  },
  status = {
    population_chart = "Показывает соотношение числа посетителей в разных больницах",
    percentage_cured = "Вам нужно вылечить %d% всех посетителей. На данный момент вам удалось вылечить %d%",
    num_cured = "Вам нужно вылечить %d людей. Пока вам удалось исцелить %d",
    thirst = "Средний уровень жажды людей в больнице",
    close = "Закрыть окно",
    win_progress_own = "Показать успехи вашей больницы",
    reputation = "Ваша репутация должна достигать %d. Сейчас она составляет %d",
    population = "Добейтесь чтобы к вам приходили лечиться %d%% всех пациентов",
    warmth = "Средняя температура по больнице",
    percentage_killed = "Постарайтесь не убивать более чем %d%% посетителей. На данный момент вы угробили %d%%",
    balance = "На вашем счету должно быть не менее %d$. Сейчас у вас %d$",
    value = "Ваша больница должна стоить %d$. Сейчас она стоит %d$",
    win_progress_other = "Показать как идут дела у %s",
    happiness = "Общее состояние пациентов в вашей больнице",
  },
}

-- 4.  Другие окна
-- 4.1  Строительство и обстановка
build_room_window = {
  pick_room_type = "Выберите тип кабинета",
  pick_department = "Выберите кабинет",
  cost = "Стоимость: ",
}
room_classes = {
  diagnosis =  "Диагностика",
  treatment =  "Процедуры",
  clinics =    "Лечение",
  facilities = "Служебные комнаты",
}
rooms_short = {
  gps_office =        "Кабинет терапевта",
  general_diag =      "Общая диагностика",
  ultrascan =         "Ультрасканер",
  research_room =     "Исследовательский отдел",
  fracture_clinic =   "Лечение переломов",
  destroyed =         "Разрушено",
  staffroom =         "Комната отдыха",
  jelly_vat =         "Лечение ожеления",
  scanner =           "Сканер",
  decontamination =   "Обеззараживание",
  pharmacy =          "Аптека",
  cardiogram =        "Кардиография",
  reception =         "Регистратура",
  training_room =     "Лекционная",
  corridor_objects =  "Обстановка коридоров",
  operating_theatre = "Операционная",
  dna_fixer =         "Исправление ДНК",
  ward =              "Палата",
  psychiatric =       "Психиатрия",
  hair_restoration =  "Восстановление волос",
  inflation =         "Надувание",
  tongue_clinic =     "Языкорезка",
  toilets =           "Туалет",
  electrolysis =      "Электротерапия",
  x_ray =             "Рентген",
  blood_machine =     "Анализатор крови",
}
rooms_long = {
  ultrascan = "Кабинет ультрасканирования",
  research_room = "Исследовательский отдел",
  general = "Общий",
  gps_office = "Кабинет терапевта",
  inflation = "Кабинет надувания",
  staffroom = "Комната отдыха",
  jelly_vat = "Кабинет лечения ожеления",
  scanner = "Кабинет сканирования",
  emergency = "Реанимация",
  decontamination = "Кабинет обеззараживания",
  corridors = "Коридоры",
  cardiogram = "Кабинет кардиографии",
  ward = "Палата",
  training_room = "Лекционная комната",
  psychiatric = "Кабинет психиатра",
  operating_theatre = "Операционная",
  dna_fixer = "Кабинет исправления ДНК",
  tongue_clinic = "Кабинет обрезания языка",
  hair_restoration = "Кабинет восстановления волос",
  general_diag = "Общая диагностика",
  pharmacy = "Аптека",
  fracture_clinic = "Кабинет лечения переломов",
  toilets = "Туалет",
  electrolysis = "Кабинет электротерапии",
  x_ray = "Рентген-кабинет",
  blood_machine = "Кабинет анализа крови",
}
buy_objects_window = {
  price = "Стоимость: ",
  choose_items = "Выберите предметы",
  total = "Итого: ",
}
object = {
  chair = "Стул",
  litter = "Мусор",
  sofa = "Диван",
  operating_table = "Операционный стол",
  bench = "Скамья",
  scanner = "Сканер",
  couch = "Кушетка",
  blood_machine = "Анализатор крови",
  video_game = "Видеоигра",
  op_sink2 = "Раковина",
  door = "Дверь",
  auto_autopsy = "Автовскрывалка",
  reception_desk = "Регистратура",
  hair_restorer = "Оволоситель",
  projector = "Проектор",
  crash_trolley = "Скорая тележка",
  tv = "Ящик",
  ultrascanner = "Ультрасканер",
  surgeon_screen = "Хирургическая ширма",
  litter_bomb = "Мусорная бомба",
  inflator = "Надуватель",
  desk = "Письменный стол",
  pool_table = "Бильярд",
  x_ray_viewer = "Неготоскоп",
  radiation_shield = "Защита от излучения",
  bed = "Койка",
  swing_door2 = "Двустворчатая дверь",
  console = "Консоль",
  op_sink1 = "Раковина",
  bookcase = "Книжный шкаф",
  drinks_machine = "Автомат с газировкой",
  comfortable_chair = "Удобное кресло",
  skeleton = "Скелет",
  computer = "Компьютер",
  bin = "Козина для мусора",
  pharmacy_cabinet = "Аптечный шкаф",
  radiator = "Батарея",
  cast_remover = "Разгипсователь",
  atom_analyser = "Атомный анализатор",
  plant = "Растение",
  jelly_moulder = "Форма для желе",
  cardio = "Беговая дорожка",
  toilet = "Туалет",
  electrolyser = "Электролизатор",
  fire_extinguisher = "Огнетушитель",
  swing_door1 = "Двустворчатая дверь",
  lecture_chair = "Лекционный стул",
  screen = "Ширма",
  toilet_sink = "Раковина",
  shower = "Душ",
  gates_of_hell = "Врата в ад",
  slicer = "Языкорезка",
  dna_fixer = "Исправитель ДНК",
  x_ray = "Рентген",
  cabinet = "Картотека",
}
room_descriptions = {
  gp = {
    [1] = "Кабинет терапевта//",
    [2] = "Это основной диагностический кабинет в вашей больнице. Все новые пациенты приходят сюда чтобы узнать, что с ними не так. Отсюда они отправляются на дальнейшую диагностику или сразу на лечение. Вам может понадобиться несколько таких кабинетов, если пациентов будет слишком много. Чем просторнее помещение, и чем больше в нем предметов, тем выше престиж работающего здесь доктора. Впрочем, это относится ко всем кабинетам.//",
    [3] = "В кабинете терапевта может работать любой доктор.",
  },
  general_diag = {
    [1] = "Общая диагностика//",
    [2] = "Сюда направляются пациенты, которым требуется дополнительная диагностика. Здесь у врача значительно больше инструментов для обследования, чем у терапевта. Пациент вернется к терапевту с результатами обследования для постановки диагноза.//",
    [3] = "В кабинете общей диагностики может работать любой доктор.",
  },
  ultrascan = {
    [1] = "Ультрасканер//",
    [2] = "Ультрасканер - это практически вершина прогресса диагностического оборудования. Он очень дорогой, но он того стоит.//",
    [3] = "Ультрасканеру для полноценной работы требуется доктор. Также, ему требуется обслуживание.",
  },
  fracture_clinic = {
    [1] = "Лечение переломов.//",
    [2] = "Сюда приходят пациенты с поломанными костями. Используя мощный промышленный лазер, разгипсовочная машина срезает застывший гипс, что может вызывать незначительную агонию у пациента.//",
    [3] = "В этом кабинете работает медсестра. Машине также требуется частый ремонт.",
  },
  inflation = {
    [1] = "Кабинет надувания//",
    [2] = "В кабинет надувания направляют пациентов с выводящим из строя и очень болезненным недугом раздутой головы. Здесь их безразмерные черепа хлопнут и немедленно снова надуют до точно рассчитанного нормального давления.//",
    [3] = "В кабинете надувания может работать любой доктор. Аппарату требуется регулярный ремонт.",
  },
  jelly_vat = {
    [1] = "Лечение ожеления//",
    [2] = "Пациенты, страдающие забавной болезнью ожеления, должны дотрястись до этого кабинета, где их поместят в специальный бак. Медицинская наука не знает, что там происходит, но после процедуры им становится лучше.//",
    [3] = "В этом кабинете может работать любой доктор. Вам также понадобится рабочий для обслуживания машины.",
  },
  scanner = {
    [1] = "Сканер//",
    [2] = "При помощи этого сложного оборудования можно поставить очень точный диагноз.//",
    [3] = "Со сканером может работать любой доктор. Это устройство требует регулярного обслуживания.",
  },
  blood_machine = {
    [1] = "Анализатор крови//",
    [2] = "Эта машина разделяет кровь пациента на клетки и выясняет что с ними не в порядке.//",
    [3] = "С анализатором крови может работать любой доктор. Это устройство требует регулярного обслуживания.",
  },
  pharmacy = {
    [1] = "Аптека//",
    [2] = "Пациенты, которым поставлен диагноз и прописано лекарство, получают его в аптеке. Поскольку многие болезни излечиваются медикаментами, со временем тут может стать тесновато, и вам понадобится еще одна аптека.//",
    [3] = "В аптеке работает медсестра.",
  },
  cardiogram = {
    [1] = "Кардиография//",
    [2] = "Здесь пациентов проверяют на наличие болезней сердца и проводят стресс-тест на беговой дорожке. Затем с полученными результатами возвращают к терапевту.//",
    [3] = "В кардиографии может работать любой доктор. Беговой дорожке требуется регулярное обслуживание.",
  },
  ward = {
    [1] = "Палата//",
    [2] = "Во время обследования пациенты содержатся здесь под наблюдением медсестры. Также, тут они готовятся к операции.//",
    [3] = "В палате работает медсестра.",
  },
  psych = {
    [1] = "Психиатрия//",
    [2] = "Пациенты, страдающие от душевных недугов, должны посетить кабинет психиатра. Доктор обследует пациентов, и, если у них не все в порядке с головой, предложит прилечь на кушетку и побеседовать.//",
    [3] = "В этом кабинете может работать только специально обученный психиатр.",
  },
  staff_room = {
    [1] = "Комната персонала//",
    [2] = "После тяжелого рабочего дня, ваши сотрудники могут посетить эту комнату, чтобы отдохнуть и расслабиться. Усталые медики тормозят, хотят повышения зарплаты и могут даже уволиться. Также, они начинают чаще ошибаться. Убедитесь, что в вашей комнате достаточно места и развлечений для нескольких человек сразу.",
  },
  operating_theatre = {
    [1] = "Операционная//",
    [2] = "В этом важном помещении излечивают целый ряд заболеваний. Операционная должна быть просторной и хорошо оснащенной. Это очень важная часть любой больницы.//",
    [3] = "В операционной должны работать два квалифицированных хирурга.",
  },
  training = {
    [1] = "Лекционная//",
    [2] = "Ваши доктора могут повышать свою квалификацию в этой комнате. Лектор с дипломом хирурга, психиатра или исследователя может научить своих коллег всему, что знает. Те же, кто уже имеет диплом, здесь могут научиться лучше применять знания на практике.//",
    [3] = "Читать лекции здесь может только консультант.",
  },
  dna_fixer = {
    [1] = "Восстановление ДНК//",
    [2] = "Пациенты, имевшие несчастье войти в контакт с пришельцами из других миров, должны пройти процедуру починки ДНК. Поскольку восстановитель ДНК – машина сложная и высокотехнологичная, настоятельно рекомендуем разместить в кабинете огнетушитель, на всякий пожарный.//",
    [3] = "Восстановитель требует регулярного обслуживания. И работать с ним могут только доктора с дипломом исследователя.",
  },
  research = {
    [1] = "Исследовательский отдел//",
    [2] = "Здесь совершаются открытия и улучшаются существующие лекарства и методы лечения. Это очень полезный отдел, его работа творит чудеса в деле улучшения вашей статистики.//",
    [3] = "В исследовательском отделе могут работать только доктора с дипломом исследователя.",
  },
  hair_restoration = {
    [1] = "Восстановление волос//",
    [2] = "Машина восстановителя волос – последняя надежда для пациентов, страдающих плешивостью в терминальной стадии. При помощи этой машины доктор может быстро насадить совершенно новый волосяной покров.//",
    [3] = "В кабинете оволосителя может работать любой доктор. Время от времени машине требуется ремонт.",
  },
  electrolysis = {
    [1] = "Комната электролиза//",
    [2] = "Больные оволосением направляются в эту комнату, где специальная машина, называемая электролизатором, уничтожает излишние волосы и электрически запаивает поры при помощи состава, сильно напоминающего цемент.//",
    [3] = "В кабинете электролиза может работать любой доктор. Машина также требует обслуживания.",
  },
  slack_tongue = {
    [1] = "Лечение длинного языка//",
    [2] = "Пациенты с этим неутешительным диагнозом направляются в эту комнату для лечения. При помощи высокоточного оборудования, квалифицированный специалист возвращает языку нормальные размер и форму, а пациенту – хорошее самочувствие.//",
    [3] = "Здесь может работать любой доктор. Машину также надо иногда чинить.",
  },
  toilets = {
    [1] = "Туалет//",
    [2] = "Следуя зову природы, пациентам надо иногда облегчиться в комфортной обстановке ваших санитарных помещений. Вы можете установить дополнительные раковины и кабинки, если ожидаете наплыва посетителей. Иногда бывает полезно разместить дополнительные помещения в разных частях больницы.",
  },
  no_room = {
    [1] = "",
  },
  x_ray = {
    [1] = "Рентген//",
    [2] = "Сделанные при помощи специального излучения снимки внутренностей пациентов помогают врачам установить, что там не в порядке.//",
    [3] = "В кабинете рентгена может работать любой доктор. Также, машине требуется обслуживание.",
  },
  decontamination = {
    [1] = "Комната обеззараживания//",
    [2] = "Пациенты, подвергшиеся воздействию радиации, незамедлительно направляются в комнату обеззараживания. Приятный душ смоет с них всю ужасную радиацию и опасные отходы.//",
    [3] = "Оперировать душем может любой доктор. Также, машине требуется обслуживание.",
  },
}
place_objects_window = {
  place_objects_in_corridor = "Разместите эти предметы в коридорах.",
  place_windows = "Добавьте окон, если хотите, и нажмите «Подтвердить».",
  confirm_or_buy_objects = "Вы можете добавить, убрать или передвинуть объекты.",
  drag_blueprint = "Растяните комнату до желаемого размера.",
  place_door = "Разместите дверь",
}
staff_class = {
  doctor = "Доктор",
  handyman = "Рабочий",
  receptionist = "Регистратор",
  nurse = "Медсестра",
}
staff_descriptions = {
  good = {
    [1] = "Работает быстро и усердно. ",
    [2] = "Работает на совесть. ",
    [3] = "Мастер на все руки. ",
    [4] = "Легко заводит друзей и любит посмеяться. ",
    [5] = "Никогда не устает. Работает без остановки. ",
    [6] = "Имеет хорошее воспитание и утонченные манеры. ",
    [7] = "Проявляет талант и способности. ",
    [8] = "Очень основательно подходит к делу. ",
    [9] = "Никогда не сдается и всегда стремится к совершенству. ",
    [10] = "Помогает людям с улыбкой. ",
    [11] = "Всегда подбодрит и поможет. ",
    [12] = "Работает, как правило, хорошо и усердно. ",
    [13] = "Прилежно работает и ведет себя. ",
    [14] = "Никогда не подведет и не обидит. ",
    [15] = "Не оставит в беде. ",
  },
  misc = {
    [1] = "Играет в гольф. ",
    [2] = "Ныряет с аквалангом. ",
    [3] = "Делает скульптуры из льда. ",
    [4] = "Любит выпить. ",
    [5] = "Участвует в ралли. ",
    [6] = "Прыгает с тарзанкой. ",
    [7] = "Собирает подставки под пиво. ",
    [8] = "Любит прыгать в толпу со сцены. ",
    [9] = "Оглушительно пердит. ",
    [10] = "Любит расширять реки. ",
    [11] = "Варит самогон. ",
    [12] = "Собирает мебель своими руками. ",
    [13] = "Смотрит французское экспериментальное кино. ",
    [14] = "Играет на компьютере. ",
    [15] = "Водит грузовик. ",
    [16] = "Участвует в мотогонках. ",
    [17] = "Играет на скрипке и виолончели. ",
    [18] = "Обожает железнодорожные аварии. ",
    [19] = "Любит собак. ",
    [20] = "Слушает радио. ",
    [21] = "Часто принимает ванны. ",
    [22] = "Обучает резьбе по пальмам. ",
    [23] = "Делает мыльницы из овощей. ",
    [24] = "Особый констебль на полставки. ",
    [25] = "Бывший ведущий телевикторины. ",
    [26] = "Коллекционирует осколки времен ВМВ. ",
    [27] = "Переставляет мебель. ",
    [28] = "Слушает рейв и трип-хоп. ",
    [29] = "Любит злить насекомых при помощи дезодоранта. ",
    [30] = "Перебивает плохих комедиантов. ",
    [31] = "Шпионит на правительство. ",
    [32] = "Втайне садовник. ",
    [33] = "Провозит поддельные часы. ",
    [34] = "Поет рок'н'ролл. ",
    [35] = "Обожает дневные передачи. ",
    [36] = "Щекочет форель. ",
    [37] = "Завлекает туристов в музеи. ",
  },
  bad = {
    [1] = "Часто тормозит и дергается. ",
    [2] = "Невозможно заставить работать. ",
    [3] = "Ничего не умеет и не приносит пользы. ",
    [4] = "Хамит и ерничает. Не прощает и не забывает. ",
    [5] = "Быстро устает и на все жалуется. ",
    [6] = "Ничего не слышит. Пахнет капустой. ",
    [7] = "Плюет на работу. Предаст при первой возможности. ",
    [8] = "Ни о чем не думает и легко отвлекается. ",
    [9] = "Нервничает и часто ошибается. ",
    [10] = "Обижается и мстит за все. Ненавидит всех и вся. ",
    [11] = "Не соблюдает технику безопасности. ",
    [12] = "Видит работу в гробу. Настоящий лентяй. ",
    [13] = "Рискует зря и плюет на последствия. ",
    [14] = "Нагло врет и строит козни. ",
    [15] = "Дерзит и смотрит на всех свысока. ",
  },
}
tooltip = {
  build_room_window = {
    cost = "Цена выбранного кабинета",
    room_classes = {
      treatment = "Проказать процедурные кабинеты",
      diagnosis = "Показать комнаты для диагностики",
      facilities = "Показать служебные помещения",
      clinic = "Показать специализированные кабинеты для лечения",
    },
    close = "Ничего не строить и вернуться к игре",
  },
  hire_staff_window = {
    prev_person = "Предыдущий кандидат",
    cancel = "Отмена",
    psychiatrist = "Психиатр",
    surgeon = "Хирург",
    researcher = "Исследователь",
    salary = "Зарплата",
    next_person = "Следующий кандидат",
    nurses = "Посмотреть медсестер",
    handymen = "Посмотреть рабочих",
    doctors = "Посмотреть докторов",
    receptionists = "Посмотреть регистраторов",
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    hire = "Нанять",
    qualifications = "Дополнительные дипломы доктора",
    staff_ability = "Компетентность",
  },
  place_objects_window = {
    confirm = "Подтвердить",
    cancel = "Отмена",
    pick_up = "Поднять объект",
    buy_sell = "Купить/продать",
  },
  rooms = {
    ultrascan = "Доктор обследует пациентов при помощи ультрасканера",
    research_room = "Исследователи придумывают новые лекарства и машины в исследовательском отделе",
    fracture_clinic = "Здесь медсестра снимает гипс с пациентов со сломанными костями",
    gps_office = "У терапевта пациенты начинают диагностику, и здесь же им сообщают неутешительные результаты",
    inflation = "При помощи надувателя доктор лечит пациентов с раздутой головой",
    staffroom = "В комнате персонала доктора и медсестры отдыхают и набираются сил",
    jelly_vat = "При помощи специальной машины доктор лечит ожеление",
    scanner = "Доктор использует сканер для диагностики пациентов",
    decontamination = "При помощи обеззараживающего душа доктор лечит облученных пациентов",
    pharmacy = "В аптеке медсестра раздает больным медикаменты",
    cardiogram = "Доктор снимает кардиограмму для диагностики пациентов",
    ward = "Палата используется как для диагностики, так и для лечения. Здесь пациенты готовятся к операции под наблюдением медсестры",
    training_room = "В лекционной консультант может обучать других докторов",
    operating_theatre = "В операционной работают сразу два хирурга",
    psychiatry = "Здесь квалифицированный психиатр обследует пациентов и вправляет мозги самым сумасшедшим",
    hair_restoration = "При помощи оволосителя доктор лечит плешивость",
    tongue_clinic = "При помощи языкорезки доктор подрезает длинные языки",
    dna_fixer = "Здесь доктор лечит пациентов с инопланетной ДНК",
    general_diag = "Здесь доктор проводит общий осмотр пациентов. Дешево и сердито",
    toilets = "Постройте туалеты, если не хотите чтобы пациенты загадили вам всю больницу",
    electrolysis = "При помощи электролизатора доктор лечит волосение",
    x_ray = "Доктор использует рентген для диагностики пациентов",
    blood_machine = "Доктор использует анализатор крови для диагностики пациентов",
  },
  objects = {
    litter = "Мусор: какому-то пациенту не удалось найти в вашей больнице мусорной корзины, и он бросил это прямо здесь",
    sofa = "Диван: если у вас в комнате отдыха нет ничего интереснее, то хотя бы можно посидеть на диване",
    bench = "Скамья: предоставляет одно сидячее место, скрашивая часы, проведенные в очередях",
    video_game = "Игральный автомат: предоставляет вашим сотрудникам возможность порубиться в Hi-Octane",
    auto_autopsy = "Автовскрывалка: очень помогает в исследовании заболеваний",
    reception_desk = "Регистратура: отсюда регистраторша направит пациента к врачу",
    tv = "Тель-а-визор: вы же не хотите, чтобы ваши сотрудники пропустили свои любимые передачи",
    inflator = "Надуватель: излечивает раздутие головы",
    desk = "Стол: надо ведь доктору куда-то поставить свой компьютер",
    pool_table = "Бильярдный стол: помогает вашим работникам расслабиться",
    bed = "Койка: на ней смогут прилечь те, кто уже не в силах стоять",
    bookcase = "Книжный шкаф: полон справочных материалов на медицинские темы",
    drinks_machine = "Торговый автомат: не дает пациентам умереть от жажды и приносит прибыль",
    skeleton = "Скелет: используется как учебное пособие и на Хэллоуин",
    computer = "Компьютер: незаменимый инструмент исследователя",
    bin = "Корзина: чтобы пациентам было куда деть свой мусор",
    pharmacy_cabinet = "Аптечный шкаф: тут хранятся все лекарства",
    radiator = "Батарея: поддерживает тепло в вашей больнице",
    atom_analyser = "Атомный анализатор: эта машина ускоряет все исследовательские процессы",
    plant = "Растение: нравится пациентам и очищает воздух",
    toilet = "Стульчак: пациенты... мм... пользуются им",
    fire_extinguisher = "Огнетушитель: несколько уменьшает опасность поломки машин",
    lecture_chair = "Лекционный стул: ваши доктора на нем сидят, записывают лекции, скучают и рисуют каракули. Чем больше стульев вы поставите, тем больше докторов сможет обучаться одновременно",
    toilet_sink = "Раковина: наиболее чистоплотные пациенты моют здесь свои грязные руки. Они будут очень недовольны, если не найдут свободной раковины",
    cabinet = "Картотека: содержит карточки пациентов, записи и научные документы",
  },
}
-- 4.2  Статус
queue_window = {
  num_in_queue = "Длина очереди",
  num_entered = "Всего посещений",
  max_queue_size = "Макс. длина",
  num_expected = "Ожидается",
}
tooltip = {
  handyman_window = {
    prio_machines = "Увеличить приоритет ремонта",
    prio_litter = "Увеличить приоритет уборки",
    prio_plants = "Увеличить приоритет поливки",
  },
  machine_window = {
    repair = "Вызвать рабочего для ремонта",
    name = "Название",
    close = "Закрыть",
    times_used = "Количество использований",
    status = "Состояние",
    replace = "Заменить машину",
  },
  patient_window = {
    graph = "Щелкните чтобы увидеть историю лечения или график график самочувствия",
    casebook = "Посмотреть статистику по болезни",
    close = "Закрыть",
    queue = "Посмотреть очередь",
    happiness = "Самочувствие пациента",
    warmth = "Согретость пациента",
    center_view = "Центрировать экран на пациенте",
    thirst = "Уровень жажды пациента",
    send_home = "Выставить из больницы",
    abort_diagnosis = "Отправить на лечение немедленно, не дожидаясь окончания диагностики",
  },
  staff_window = {
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    psychiatrist = "Психиатр",
    close = "Закрыть окно",
    ability = "Компетентность",
    pick_up = "Взять",
    sack = "Уволить",
    surgeon = "Хирург",
    happiness = "Настроение",
    salary = "Ежемесячная зарплата",
    name = "Имя",
    tiredness = "Запас сил",
    center_view = "Левая кнопка - центрировать экран, правая - выбрать следующего сотрудника",
    skills = "Особые умения",
    researcher = "Исследователь",
    face = "Портрет - нажмите, чтобы перейти к экрану управления персоналом",
  },
}
-- 4.3  Запросы
confirmation = {
  abort_edit_room = "Вы сейчас строите или редактируете кабинет. Если все необходимое уже на месте, он будет построен, иначе же он будет удален. Продолжить?",
  return_to_blueprint = "Точно вернуться к режиму разметки?",
  delete_room = "Вы точно хотите удалить эту комнату?",
  quit = "Вы выбрали выход. А вы в этом уверены?",
  needs_restart = "Изменение этого параметра ребует перезапуска CorsixTH. Все несохраненные данные при этом будут потеряны. Продолжить?",
  overwrite_save = "В этом файле уже есть сохраненная игра. Перезаписать ее?",
  sack_staff = "Вы правда хотите уволить этого сотрудника?",
  replace_machine = "Вы правда хотите заменить %s за %d$?",
  restart_level = "Вы серьёзно хотите начать уровень заново?",
}
pay_rise = {
  definite_quit = "Я увольняюсь, и точка. Я сыт по горло этим местом.",
  regular = {
    [1] = "Я крайне устаю. Мне нужен хороший отдых плюс повышение зарплаты на %d$, если хотите меня видеть на этой никчемной работе.",
    [2] = "Я очень устаю. Мне надо отдохнуть и не помешает получить надбавку в %d$ до %d$. Пошевеливайся, деспот.",
    [3] = "Ну все. Я тут тружусь как лошадь. Прибавьте мне %d$, а то уволюсь.",
    [4] = "Я в негодовании. Требую добавить к зарплате %d$, чтобы стало %d$, или я ухожу.",
    [5] = "Родители всегда говорили мне что в этом деле хорошо платят. Так что повысьте мне зарплату на %d$, или я пойду издавать компьютерные игры.",
    [6] = "С меня хватит. Платите мне как следует. Я хочу, чтобы мне повысили зарплату на %d$.",
  },
  poached = "Мне предлагают %d$ у %s. Платите мне не меньше, или я ухожу.",
}

-- 5.  Болезни
diseases = {
  general_practice = {
    name = "Обследование: терапевт",
  },
  diag_ward = {
    name = "Обследование: палата",
  },
  diag_ultrascan = {
    name = "Обследование: ультрасканер",
  },
  diag_blood_machine = {
    name = "Обследование: анализатор крови",
  },
  diag_x_ray = {
    name = "Обследование: рентген",
  },
  diag_psych = {
    name = "Обследование: психиатр",
  },
  diag_general_diag = {
    name = "Обследование: общая диагностика",
  },
  diag_cardiogram = {
    name = "Обследование: кардиограмма",
  },
  diag_scanner = {
    name = "Обследование: сканер",
  },
  autopsy = {
    name = "Вскрытие",
  },
  third_degree_sideburns = {
    cause = "Причина - непреодолимая тоска по семидесятым.",
    cure = "Лечение - психиатр должен, используя самые современные методы, убедить пациента, что чрезмерная волосатость уже не в моде.",
    name = "Бакенбарды третьей степени",
    symptoms = "Симптомы - длинные волосы, смешные штаны, обувь на платформе и сверкающий макияж.",
  },
  discrete_itching = {
    cause = "Причина - крошечные насекомые с очень острыми зубами.",
    cure = "Лечение - пациент выпивает липкий фармацевтический сироп, который защищает кожу.",
    name = "Спонтанное зудение",
    symptoms = "Симптомы - интенсивное чесание вплоть до воспламенения.",
  },
  the_squits = {
    cause = "Причина - поедание кусочков пиццы, упавших под плиту.",
    cure = "Лечение - клейкая смесь вязких фармацевтических реактивов сгущает все внутри у пациента.",
    name = "Метания",
    symptoms = "Симптомы - фу, какая гадость. Не будем об этом.",
  },
  spare_ribs = {
    cause = "Причина - сидение на холодном каменном полу.",
    cure = "Лечение - два хирурга должны удалить лишние ребра и завернуть их пациенту с собой.",
    name = "Лишние ребра",
    symptoms = "Симптомы - неприятные ощущения от массивной груди.",
  },
  king_complex = {
    cause = "Причина - дух Короля, который захватил контроль над разумом пациента.",
    cure = "Лечение - психиатр рассказывает пациенту как нелепо тот выглядит.",
    name = "Комплекс Короля",
    symptoms = "Симптомы - слабость к цветастой замшевой обуви и чизбургерам.",
  },
  fake_blood = {
    cause = "Причина - скорее всего, пациент стал жертвой розыгрыша.",
    cure = "Лечение - психиатр должен помочь пациенту успокоиться.",
    name = "Фальшивая кровь",
    symptoms = "Симптомы - красная жидкость в венах, которая испаряется при контакте с одеждой.",
  },
  invisibility = {
    cause = "Причина - укус радиоактивного (и, само собой, невидимого) муравья.",
    cure = "Лечение - напиток насыщенного цвета, приготовленный в аптеке, восстанавливает видимость пациента.",
    name = "Невидимость",
    symptoms = "Симптомы - пациент чувствует себя нормально и даже может использовать болезнь чтобы разыгрывать близких.",
  },
  golf_stones = {
    cause = "Причина - вдыхание ядовитого газа, содержащегося в мячиках для гольфа.",
    cure = "Лечение - образования удаляются хирургами в операционной.",
    name = "Мячики в почках",
    symptoms = "Симптомы - бред и чувство стыда.",
  },
  infectious_laughter = {
    cause = "Причина - просмотр классических комедий.",
    cure = "Лечение - квалифицированный психиатр должен напомнить пациенту, что не все в этой жизни смешно.",
    name = "Заразный смех",
    symptoms = "Симптомы - непроизвольное фырканье и повторение несмешных шуток.",
  },
  baldness = {
    cause = "Причина - вранье и придумавание небылиц с целью привлечения внимания.",
    cure = "Лечение - в ходе болезненной процедуры специальная машина плавно восстанавливает волосяной покров.",
    name = "Плешивость",
    symptoms = "Симптомы - блестящесть и смущение.",
  },
  heaped_piles = {
    cause = "Причина - привычка торчать возле питьевых фонтанчиков.",
    cure = "Лечение - приятная на вкус смесь сильных кислот растворяет кучи изнутри.",
    name = "Скученные кучи",
    symptoms = "Симптомы - у пациента такое чувство, будто он/она сидит на мешке с твердыми шариками.",
  },
  unexpected_swelling = {
    cause = "Причина - все внезапное.",
    cure = "Лечение - возбухание может быть уменьшено хирургами при помощи автогена.",
    name = "Внезапное возбухание",
    symptoms = "Симптом - возбухание.",
  },
  jellyitis = {
    cause = "Причина - пища, богатая желатином и избыток физической активности.",
    cure = "Лечение - пациента помещают в разжелетиватель в специальном кабинете.",
    name = "Ожеление",
    symptoms = "Симптомы - пациент чрезмерно трясется и часто падает.",
  },
  hairyitis = {
    cause = "Причина - длительные прогулки в свете луны.",
    cure = "Лечение - электролизатор удаляет волосы и запаивает поры.",
    name = "Оволосение",
    symptoms = "Симптомы - обостренное обоняние.",
  },
  alien_dna = {
    cause = "Причина - прыгающие личинки разумных видов пришельцев.",
    cure = "Лечение - в специальной машине ДНК извлекается, очищается от фрагментов пришельцев и быстро вставляется на место.",
    name = "ДНК пришельцев",
    symptoms = "Симптомы - постепенное превращение в пришельца и стремление уничтожить человечество.",
  },
  bloaty_head = {
    cause = "Причина - нюхание сыра и питье неочищенной дождевой воды.",
    cure = "Лечение - раздутая голова лопается и затем надувается до нормального давления при помощи хитроумной машины.",
    name = "Раздутие головы",
    symptoms = "Симптомы - очень неприятны для пациента.",
  },
  gastric_ejections = {
    cause = "Причина - острая мексиканская и индийская пища.",
    cure = "Лечение - выпивание специального связующего состава предотвращает какие бы то ни было извержения.",
    name = "Гастральные извержения",
    symptoms = "Симптомы - полупереваренная пища извергается из пациента в случайных местах.",
  },
  uncommon_cold = {
    cause = "Причина - крошечные капли соплей в воздухе.",
    cure = "Лечение - большой глоток необычной микстуры от кашля, сваренной из секретных ингредиентов в аптеке.",
    name = "Необычная простуда",
    symptoms = "Симптомы - сопли, чихание и обесцвечивание легких.",
  },
  corrugated_ankles = {
    cause = "Причина - езда через асфальтовые гребни на дорогах.",
    cure = "Лечение - слегка токсичная смесь трав и специй позволяет пациенту выпрямить лодыжки.",
    name = "Волнистые лодыжки",
    symptoms = "Симптомы - привычная обувь больше не подходит пациенту.",
  },
  sleeping_illness = {
    cause = "Причина - чрезмерная активность сонной железы в глотке пациента.",
    cure = "Лечение - медсестра должна дать пациенту большую дозу сильных стимуляторов.",
    name = "Сонная болезнь",
    symptoms = "Симптомы - непреодолимое желание поспать преследует пациента.",
  },
  sweaty_palms = {
    cause = "Причина - боязнь собеседований.",
    cure = "Лечение - психиатр должен уговорить пациента избавиться от этой выдуманной болезни.",
    name = "Потные ладони",
    symptoms = "Симптомы - рукопожатие пациента напоминает сжимание мокрой губки.",
  },
  serious_radiation = {
    cause = "Причина - жевание изотопов плутония.",
    cure = "Лечение - пациента нужно как следует промыть под обеззараживающим душем.",
    name = "Сильное облучение",
    symptoms = "Симптомы - пациент себя очень, очень плохо чувствует.",
  },
  gut_rot = {
    cause = "Причина - Старая добрая крепкая микстура от кашля тетушки О'Мэлли.",
    cure = "Лечение - медсестра приготовит специальную смесь химикатов для покрытия внутренностей пациента.",
    name = "Гнилые кишки",
    symptoms = "Симптомы - никакого кашля, но и никаких стенок желудка.",
  },
  iron_lungs = {
    cause = "Причина - городской смог и дым от шашлыков.",
    cure = "Лечение - два хирурга проводят операцию чтобы удалить затвердевшие легкие.",
    name = "Железные легкие",
    symptoms = "Симптомы - способность выдыхать огонь и громко кричать под водой.",
  },
  broken_wind = {
    cause = "Причина - упражнения на беговой дорожке после еды.",
    cure = "Лечение - насыщенная особыми водянистыми атомами микстура выпивается залпом.",
    name = "Бурные ветра",
    symptoms = "Симптомы - представляют опасность для находящих позади пациента.",
  },
  kidney_beans = {
    cause = "Причина - разгрызание ледяных кубиков в напитках.",
    cure = "Лечение - два хирурга должны удалить бобы, не прикасаясь к почкам.",
    name = "Бобы в почках",
    symptoms = "Симптомы - боль и частые визиты в туалет.",
  },
  transparency = {
    cause = "Причина - слизывание йогурта с крышечек упаковок.",
    cure = "Лечение - специально охлажденная и подкрашенная в аптеке вода вылечит эту болезнь.",
    name = "Прозрачность",
    symptoms = "Симптомы - плоть становится прозрачной и ужасно выглядит.",
  },
  broken_heart = {
    cause = "Причина - кто-нибудь более молодой, богатый и стройный чем пациент.",
    cure = "Лечение - два хирурга вскрывают грудную клетку и, затаив дыхание, аккуратно собирают сердце.",
    name = "Разбитое сердце",
    symptoms = "Симптомы - плач и боли в мышцах от разрывания праздничных фотографий.",
  },
  slack_tongue = {
    cause = "Причина - хроническое обсуждение мыльных опер.",
    cure = "Лечение - язык помещается в языкорезку и укорачивается быстро, точно, безжалостно.",
    name = "Длинный язык",
    symptoms = "Симптомы - язык примерно в пять раз увеличен в размерах.",
  },
  tv_personalities = {
    cause = "Причина - просмотр телепередач в дневное время.",
    cure = "Лечение - квалифицированный психиатр должен убедить пациента выкинуть телевизор и купить радио.",
    name = "Звезда экрана",
    symptoms = "Симптомы - пациент думает, что может вести собственное кулинарное шоу.",
  },
  ruptured_nodules = {
    cause = "Причина - прыжки с тарзанкой в холодную погоду.",
    cure = "Лечение - хирург удаляет грыжу твердой, уверенной рукой.",
    name = "Грыжа",
    symptoms = "Симптомы - невозможность сидеть с комфортом.",
  },
  fractured_bones = {
    cause = "Причина - падение с большой высоты на бетонные поверхности.",
    cure = "Лечение - сперва накладывается гипс, затем он удаляется при помощи устройства с лазером.",
    name = "Сломанные кости",
    symptoms = "Симптомы - громкий треск и неспособность использовать поврежденные конечности.",
  },
  chronic_nosehair = {
    cause = "Причина - высокомерное фыркание в присутствии менее успешных людей.",
    cure = "Лечение - отвратительное противоволосяное зелье приготавливается в аптеке.",
    name = "Хроническое носоволосение",
    symptoms = "Симптомы - нособорода, в которой можно свить гнездо.",
  },
}

-- 6.  Факсы
fax = {
  --  Эпидемия
  epidemic = {
    cover_up_explanation_1 = "Или вы можете попытаться вылечить всех зараженных, пока про это не узнали в министерстве здравоохранения.",
    cover_up_explanation_2 = "Если к приезду инспектора эпидемия все еще будет бушевать, приготовьтесь к неприятностям.",
    choices = {
      cover_up = "Попытаться вылечить всех зараженных пациентов пока есть время и пока он еще в больнице.",
      declare = "Объявить об эпидемии. Признать свою вину и заплатить штраф.",
    },
    disease_name = "Ваши доктора обнаружили особо заразный подвид %s.",
    declare_explanation_fine = "Вы можете объявить об эпидемии, заплатить штраф в %d$, тогда вам немедленно окажут помощь в вакцинации. Ваша репутация несколько пострадает.",
  },
  epidemic_result = {
    fine_amount = "Правительство объявило чрезвычайное положение, а вас оштрафовали на %d$.",
    close_text = "Ура!",
    hospital_evacuated = "У комиссии не осталось другого выбора, кроме как объявить эвакуацию.",
    succeeded = {
      part_1_name = "До департамента здоровья дошли слухи, что в вашей больнице бушует эпидемия %s.",
      part_2 = "Однако, инспектору не удалось найти им подтверждение.",
    },
    compensation_amount = "Правительство решило компенсировать ущерб, который эти враки нанесли репутации вашей больницы, в сумме %d$.",
    failed = {
      part_1_name = "В попытке скрыть наличие заразной инфекции %s,",
      part_2 = "ваши сотрудники вызвали распространение болезни по округе.",
    },
    rep_loss_fine_amount = "Журналисты уже заточили карандаши. Ваша репутация серьезно пострадает. К тому же, вас оштрафовали на %d$.",
  },
  --  Визит шишки
  vip_visit_query = {
    choices = {
      invite = "Отправить шишке официальное приглашение",
      refuse = "Наврать что-нибудь, чтобы не приходил",
    },
    vip_name = "%s выразил желание посетить вашу больницу",
  },
  vip_visit_result = {
    telegram = "Телеграмма!",
    remarks = {
      good = {
        [1] = "Какая хорошая больница! Спасибо за приглашение.",
        [2] = "Хмм... Определенно, неплохое медицинское учреждение.",
        [3] = "Мне очень понравилась ваша милая больничка. Ну, кто со мной в ресторан?",
      },
      super = {
        [1] = "Что за невероятная больница! Если я вдруг заболею, отвезите меня туда.",
        [2] = "Вот это я понимаю - больница!",
        [3] = "Это супербольница. Уж я-то в них разбираюсь.",
      },
      bad = {
        [1] = "Не надо было мне приходить. Лучше бы я просидел четырехчасовую оперу!",
        [2] = "Мне до сих пор не по себе. Они правда называют свое заведение больницей? Больше похоже на свинарник!",
        [3] = "Я сыт по горло визитами в подобные выгребные ямы и постоянным вниманием прессы! Я подаю в отставку.",
      },
      mediocre = {
        [1] = "Что ж, я видал и похуже. Им есть куда расти.",
        [2] = "Не знаю, стоит ли туда обращаться, если почувствуете себя неважно.",
        [3] = "Что я могу сказать, больница как больница. Я ожидал большего.",
      },
      very_bad = {
        [1] = "Ну и свалка! Я приложу все усилия чтобы ее закрыли.",
        [2] = "Никогда не видел больницы хуже. Какой позор!",
        [3] = "Я потрясен. Это нельзя назвать больницей! Мне надо выпить.",
      },
    },
    rep_boost = "Ваша репутация улучшилась.",
    vip_remarked_name = "После посещения вашей больницы, %s заметил:",
    cash_grant = "Вам выдали грант в размере %d$.",
    rep_loss = "Ваша репутация пострадала.",
    close_text = "Спасибо за приглашение.",
  },
  --  Болезни
  disease_discovered = {
    discovered_name = "Ваша команда обнаружила новое заболевание. Это %s",
  },
  disease_discovered_patient_choice = {
    need_to_build = "Для лечения нам потребуется %s.",
    need_to_employ = "Наймите %s чтобы вылечить это.",
    what_to_do_question = "Что нам делать с этим пациентом?",
    guessed_percentage_name = "Мы не совсем уверены, что с этим пациентом. Существует вероятность в %d% что это %s",
    choices = {
      send_home = "Отправить пациента домой.",
      research = "Отправить пациента в исследовательский отдел.",
      wait = "Задержать пациента в больнице на какое-то время.",
    },
    disease_name = "Ваша команда обнаружила новое заболевание. Это %s",
    need_to_build_and_employ = "Можно будет попробовать, если вы построите %s и наймете %s .",
    can_not_cure = "Мы не можем это вылечить.",
  },
  diagnosis_failed = {
    choices = {
      send_home = "Отправить пациента домой.",
      take_chance = "Рискнуть и попытаться вылечить.",
      wait = "Задержать пациента, пока вы не построите еще кабинетов диагностики.",
    },
    situation = "Мы проверили этого пациента на всех наших машинах, но так и не поняли, что с ним случилось.",
    what_to_do_question = "Что нам с ним делать?",
    partial_diagnosis_percentage_name = "Есть шанс в %d%, что мы правильно угадаем какой вид %s у этого пациента.",
  },
  --  Чрезвычайная ситуация
  emergency = {
  locations = {
    [1] = "Новоуренгойский химзавод",
    [2] = "Фальшивый Университет",
    [3] = "Центр Принудительного Озеленения",
    [4] = "Институт Разработки Опасных Штук",
    [5] = "Клуб Хороших Танцоров",
    [6] = "Издательство «МакулатураПресс»",
    [7] = "Похоронное бюро «Безенчук и нимфы»",
    [8] = "Китайский ресторанчик дяди Вонга",
    [9] = "ГлавХимСбытСтыдЗагранПоставка",
  },
    num_disease = "У нас тут %d человек с диагнозом %s и им требуется немедленное лечение.",
    cure_possible_drug_name_efficiency = "У вас есть все необходимое оборудование и специалисты. У вас есть нужное лекарство. Это %s и оно эффективно на %d%",
    cure_not_possible_employ = "Вам потребуется нанять %s",
    cure_not_possible = "Сейчас вы не можете это вылечить.",
    cure_possible = "У вас есть все необходимое оборудование и специалисты, так что вы, наверное, справитесь.",
    choices = {
      accept = "Да. Я разберусь с этой ситуацией.",
      refuse = "Нет. Я отказываюсь в этом участвовать.",
    },
    location = "На предприятии %s чрезвычайная ситуация.",
    cure_not_possible_build = "Вам надо будет построить %s",
    cure_not_possible_build_and_employ = "Вам надо будет построить %s и нанять %s",
    bonus = "Вознаграждение за помощь составит %d. Если вы не справитесь, ваша репутация серьезно пострадает.",
  },
  emergency_result = {
    earned_money = "Из всей суммы %d$ вы заработали %d$.",
    close_text = "Нажмите чтобы закрыть.",
    saved_people = "Вы спасли %d из %d человек.",
  },
}

-- 7.  Советчик
adviser = {
  tutorial = {
    build_reception = "Привет. Прежде всего, вашей новой больнице понадобится регистратура. Выберите ее в меню обстановки коридоров.",
    order_one_reception = "Щелкните один раз на мигающей строке, чтобы заказать стойку регистратуры.",
    accept_purchase = "Щелкните на мигающей кнопке, чтобы подтвердить заказ.",
    reception_invalid_position = "Стойка сейчас серого цвета, потому что ее нельзя разместить здесь. Попробуйте передвинуть или развернуть ее.",
    rotate_and_place_reception = "Пощелкайте правой кнопкой, чтобы развернуть стойку и установите ее левой кнопкой.",
    hire_receptionist = "А еще вам понадобится регистратор, чтобы принимать новых посетителей.",
    select_receptionists = "Нажмите мигающую кнопку, чтобы просмотреть регистраторов, которые ищут работу. Число на кнопке показывает, сколько кандидатур доступно.",
    next_receptionist = "Это резюме первой регистраторши в нашем списке. Нажмите мигающую кнопку, чтобы посмотреть следующее.",
  prev_receptionist = "Нажмите мигающую кнопку, чтобы вернуться к предыдущему резюме.",
    choose_receptionist = "Выберите регистратора, чьи профессиональные способности и зарплата вас устраивают и нажмите мигающую кнопку чтобы нанять ее.",
    receptionist_invalid_position = "Здесь ее поставить нельзя.",
    place_receptionist = "Поставьте вашу новую регистраторшу, где хотите. Она достаточно умна, чтобы добраться до своего стола.",
    build_gps_office = "Чтобы начать прием пациентов, первым делом постройте кабинет терапевта.",
    select_diagnosis_rooms = "Нажмите мигающую кнопку, чтобы увидеть список комнат диагностики.",
    click_gps_office = "Нажмите мигающую кнопку, чтобы выбрать кабинет терапевта.",
    click_and_drag_to_build = "Для начала решите, какого размера будет новый кабинет. Удерживайте левую кнопку мыши и растяните чертеж до нужного размера.",
    room_too_small = "Чертеж сейчас красного цвета потому, что он слишком мал. Растащите его побольше.",
    room_in_invalid_position = "Ой! Такой чертеж не пойдет, красная область перекрывает другие кабинеты или находится за стенами больницы.",
    room_big_enough = "Такого размера достаточно. Вы можете передвинуть кабинет или изменить размер еще раз, если хотите.",
    place_door = "Двигайте мышью вдоль стен кабинета, чтобы выбрать место для двери.",
    door_in_invalid_position = "Нет! Здесь нельзя сделать вход в кабинет. Щелкните где-нибудь на стене чертежа.",
    place_windows = "Проделайте несколько окон точно так же, как вы сделали дверь. Это совсем не обязательно, но так у ваших работников будет, куда глазеть в свободное время.",
    window_in_invalid_position = "Тут нельзя сделать окно. Будьте добры указать другое место на стене кабинета.",
    place_objects = "Правая кнопка вращает мебель, а левая устанавливает ее.",
    object_in_invalid_position = "Это предмет нельзя поставить здесь. Пожалуйста, переместите его или попробуйте повращать, возможно он станет сюда боком.",
    confirm_room = "Нажмите мигающую кнопку, чтобы завершить строительство, или нажмите на крестик, чтобы вернуться к предыдущему шагу.",
    information_window = "Справочное сообщение рассказывает вам о кабинете терапевта, который вы только что построили.",
    hire_doctor = "Чтобы обследовать и лечить пациентов, вам понадобится доктор.",
    select_doctors = "Нажмите мигающую кнопку, чтобы просмотреть докторов, которые ищут работу.",
    choose_doctor = "Как следует изучите резюме и рекомендации кандидатов прежде чем сделаете выбор.",
    place_doctor = "Поставьте доктора где-нибудь в пределах больницы. Он направится в кабинет терапевта, когда к вам придет первый пациент.",
    doctor_in_invalid_position = "Эй! Тут его поставить нельзя.",
  },
  epidemic = {
    hurry_up = "Если что-то не сделать с этой эпидемией, мы окажемся в беде по самые ноздри. Шевелитесь!",
    serious_warning = "Эта заразная болезнь распространяется с невиданной скоростью. Сделайте же что-нибудь!",
    multiple_epidemies = "Похоже, у нас тут несколько эпидемий сразу. Какой кошмар.",
  },
  staff_advice = {
    need_handyman_machines = "Вам понадобится рабочий, чтобы ремонтировать машины в больнице.",
    need_doctors = "У вас не хватает врачей. Можно попробовать отправить самых лучших докторов в кабинеты с наибольшими очередями, вдруг поможет.",
    need_handyman_plants = "Вам понадобится рабочий, чтобы поливать растения.",
    need_handyman_litter = "Посетители совсем загадили нашу больницу. Наймите рабочего, чтобы подметать за ними.",
    need_nurses = "Вам нужно нанять медсестру. Аптека и палата не могут работать сами по себе.",
    too_many_doctors = "У вас слишком много докторов. Некоторые из них болтаются без дела.",
    too_many_nurses = "Я думаю что у вас слишком много медсестер... Они вам так нравятся?",
  },
  earthquake = {
    damage = "От землетрясения пострадали %d машин и %d человек.",
    alert = "Приближается землетрясение. Ваши машины могут пострадать от него, а если они в плохом состоянии, то и вовсе развалиться.",
    ended = "Фух. Это было довольно сильным, примерно %d по шкале Рихтера.",
  },
  surgery_requirements = {
    need_surgeons_ward_op = "Чтобы выполнять операции, вам надо нанять двух хирургов, а также построить палату и операционную.",
    need_surgeon_ward = "Чтобы начать оперировать, вам нужен еще один хирург и палата.",
  },
  vomit_wave = {
    started = "Похоже, в нашей больнице завелся рвотный вирус. Если бы вы поддерживали чистоту, этого бы не случилось. Наймите больше рабочих.",
    ended = "Уф! Похоже, волна тошноты отступила. На будущее, постарайтесь содержать больницу в чистоте.",
  },
  level_progress = {
    halfway_lost = "Вы на полпути к поражению.",
    dont_kill_more_patients = "Вы больше не можете себе позволить убивать пациентов.",
    another_patient_killed = "Ну вот! Еще один склеил ласты. И таких уже %d по больнице.",
    halfway_won = "Вы на полпути к победе.",
    close_to_win_increase_value = "Вы почти выиграли. Увеличьте стоимость больницы на %d.",
    financial_criteria_met = "Вы уже заработали достаточно денег. Не давайте балансу опуститься ниже %d и продолжайте эффективно управлять больницей.",
    nearly_won = "Вы уже почти выграли этот уровень.",
    hospital_value_enough = "Не давайте стоимости больницы упасть ниже %d и разберитесь с остальными проблемами, чтобы победить.",
    another_patient_cured = "Отлично, еще один пациент покинул больницу живым и здоровым. Мы вылечили уже %d.",
    three_quarters_lost = "Вы на три четверти проиграли этот уровень.",
    reputation_good_enough = "Хорошо, ваша репутация достаточно высока. Не опускайте ее ниже %d и разберитесь с имеющимися проблемами, чтобы победить.",
    cured_enough_patients = "Вы вылечили достаточно пациентов, но ваша больница еще недостаточно хороша.",
    nearly_lost = "Еще чуть-чуть - и вы проиграете.",
    improve_reputation = "Вам надо поднять репутацию еще на %d, чтобы выиграть этот уровень.",
    three_quarters_won = "Вы прошли три четверти пути к победе.",
  },
  staff_place_advice = {
    receptionists_only_at_desk = "Регистраторы могут работать только в регистратуре.",
    only_psychiatrists = "В психиатрии могут работать только доктора с дипломом психиатра.",
    only_surgeons = "Только хирурги могут работать в операционной.",
  },
  room_forbidden_non_reachable_parts = "Так вы заблокируете доступ к другим частям больницы.",
  research = {
    machine_improved = "%s улучшен вашим исследовательским отделом.",
    drug_fully_researched = "Вы исследовали %s на 100%.",
    new_machine_researched = "Изобретена новая %s.",
    drug_improved = "Исследовательский отдел улучшил ваше лекарство от %s.",
  },
  boiler_issue = {
    minimum_heat = "Я вас везде ищу! Паровой котел в подвале развалился. Скоро у нас в больнице станет весьма прохладно.",
    maximum_heat = "Паровой котел в подвале заклинило! Регулятор температуры вышел из строя и мы тут все скоро помрем от жары! Можно попробовать поставить еще автоматов с газировкой.",
    resolved = "Ну слава Богу! Система отопления снова работает как надо. Теперь температура в больнице станет нормальной.",
  },
  room_requirements = {
    research_room_need_researcher = "В исследовательском отделе должен работать доктор-исследователь.",
    op_need_another_surgeon = "Вам нужен еще один хирург, чтобы операционная наконец заработала.",
    op_need_ward = "Вам нужна палата, чтобы готовить пациентов к операции.",
    reception_need_receptionist = "Прием пацентов ведет регистратор.",
    psychiatry_need_psychiatrist = "Раз уж у вас есть кабинет психиатра, наймите и самого психиатра.",
    pharmacy_need_nurse = "Наймите медсестру, чтобы работать в аптеке.",
    ward_need_nurse = "Вам нужно нанять медсестру на работу в этой палате.",
    op_need_two_surgeons = "Наймите двух хирургов, чтобы начать выполнять операции.",
    training_room_need_consultant = "Вам нужен консультант, чтобы читать лекции.",
    gps_office_need_doctor = "Вам нужно нанять доктора, который будет вести прием в этом кабинете.",
  },
  goals = {
    win = {
      money = "Заработайте еще %d$, чтобы соответствовать финансовым требованиям этого уровня.",
      cure = "Вылечите еще %d пациентов, чтобы выиграть этот уровень.",
      reputation = "Поднимите свою репутацию до %d, чтобы удолетворить требования уровня.",
      value = "Вам нужно поднять стоимость больницы до %d$",
    },
    lose = {
      kill = "Убейте еще %d пациентов и вы проиграете!",
    },
  },
  warnings = {
    charges_too_low = "Вы мало просите за свои услуги. Хоть это и привлекает новых клиентов, вы с них много не получите.",
    charges_too_high = "У вас очень высокие цены. Это может временно поднять доходы, но так вы отпугиваете потенциальных клиентов.",
    staff_overworked = "Ваши люди сильно устают. От этого они работают кое-как и могут соверщать катастрофические ошибки.",
    doctors_tired = "Ваши доктора сильно устали. Скорее разрешите им отдохнуть.",
    people_did_it_on_the_floor = "У одного из пациентов иссякло терпение. Теперь кому-то придется все это отмывать.",
    queues_too_long = "У вас в больнице длинные очереди.",
    money_very_low_take_loan = "Ваш банковский баланс ниже плинтуса. Я слышала, у них там займы выдают.",
    patients_very_thirsty = "Ваши пациенты страдают от жажды. Если вы не поставите торговые автоматы, они пойдут пить домой, а лечиться - в другую больницу!",
    machinery_very_damaged = "Срочно найдите ремонтника, чтобы чинить ваши машины, а то кто-нибудь серьезно пострадает!",
    handymen_tired2 = "Ваши рабочие спят на ходу. Немедленно отправьте их в комнату отдыха.",
    desperate_need_for_watering = "Ваши растения умирают от жажды. Наймите рабочего, чтобы поливать их.",
    nurses_tired = "Ваши медсестры валятся с ног от усталости. Им очень нужен отдых.",
    too_much_litter = "У вас проблема с мусором. Ее можно решить, наняв еще рабочих.",
    reception_bottleneck = "Регистратура не справляется с наплывом посетителей. Вам нужно расширить ее и нанять еще регистратора.",
    place_plants4 = "Поставьте еще горшков с растениями, чтобы облегчить страдания пациентов.",
    change_priorities_to_plants = "Прикажите вашим рабочим чаще поливать растения.",
    staff_too_hot = "Вашим сотрудникам жарко. Уберите лишние батареи из кабинетов или уменьшите нагрев.",
    finanical_trouble2 = "Начинайте зарабатывать деньги или окажетесь за воротами. Потеряйте еще %d$ и вы проиграете.",
    plants_thirsty = "Присматривайте за растениями, их не помешает поливать почаще.",
    litter_everywhere = "У вас свалка, а не больница. Направьте еще рабочих на уборку.",
    nurses_tired2 = "Ваши медсестры засыпают на работе. Отправьте их отдыхать.",
    plants_dying = "Ваши растения засыхают на глазах, они в жизни не видели лейки. Мертвые растения нагоняют тоску на пациентов.",
    reduce_staff_rest_threshold = "Я тут подумала, может стоит уменьшить порог усталости для персонала в настройках политики больницы? Я не то, что бы настаиваю.",
    more_toilets = "Больнице нужны туалеты. Ваши клиенты с трудом сдерживают себя.",
    hospital_is_rubbish = "Везде говорят, что ваша больница ни к черту. Это ничем не помогает нам привлекать новых клиентов.",
    pay_back_loan = "У вас полно денег. Как насчет возврата долгов?",
    financial_trouble3 = "Состояние вашего банковского счета внушает опасения. Вам очень нужны деньги. Вы всего в %d$ от банкротства.",
    bankruptcy_imminent = "Эй! Еще немного и вы обанкротитесь. Тратьте осторожнее!",
    build_toilet_now = "Терпение ваших клиентов подходит к концу. Немедленно постройте туалет, или последствия не заставят себя ждать. И перестаньте ухмыляться, это серьезно!",
    patient_stuck = "Кто-то заблудился в ваших коридорах. У вас тут больница или парк развлечений?",
    no_patients_last_month = "В этом месяце у нас не было ни одного клиента. Вот так сюрприз.",
    more_benches = "Не помешает поставить скамеек. Не заставляйте больных стоять.",
    many_epidemics = "Похоже, у нас тут несколько эпидемий сразу. Это может обернуться серьезными проблемами.",
    place_plants_to_keep_people = "Люди злятся и уходят. Может горшков с цветами поставить?",
    patients_thirsty2 = "Пациенты хотят пить. Купите еще торговых автоматов или переставьте те, что есть, поудобнее.",
    money_low = "У вас заканчиваются деньги!",
    staff_unhappy = "Ваши сотрудники недовольны работой. Попробуйте подбодрить их премиями, а лучше постройте комнату персонала. Еще можно изменить политику больницы.",
    people_freezing = "Невероятно, в наш век центрального отопления ваши пациенты дрожат от холода. Поставьте батареи отопления и увеличьте нагрев.",
    need_toilets = "Пациентам нужны туалеты. И, желательно, поскорее.",
    nobody_cured_last_month = "В прошедшем месяце вы никого не вылечили.",
    patients_very_cold = "Пациенты замерзают. Увеличьте нагрев и поставьте побольше батарей в больнице.",
    build_toilets = "Немедленно постройте туалет или столкнетесь с антисанитарными последствиями. А запах...",
    many_killed = "Вы уже убили %d человек. Вы же их вроде лечить должны.",
    place_plants2 = "Люди уходят. Может, им не хватает зеленых растений?",
    staff_tired = "Ваши сотрудники невероятно устали. Если вы не дадите им отдохнуть в комнате персонала, они могут слететь с катушек.",
    machines_falling_apart = "Ваши машины разваливаются. Наймите ремонтника немедленно!",
    patients_unhappy = "Людям не нравится ваша больница. Предпримите что-нибудь по этому поводу.",
    place_plants3 = "Пациенты пребывают в печали. Поставьте горшков с цветами, чтобы подбодрить их.",
    staff_unhappy2 = "Ваши сотрудники недовольно ворчат. Скоро они захотят повышения зарплаты.",
    cash_low_consider_loan = "У вас на счету негусто. Как насчет кредита?",
    queue_too_long_at_reception = "У вас в регистратуре огромная очередь. Поставьте еще одну стойку и наймите регистратора.",
    queue_too_long_send_doctor = "В больнице огромная очередь в %s. Убедитесь, что там ведется прием.",
    financial_trouble = "Ваше финансовое положение удручает. Сделайте же что-нибудь! Потратьте еще %d$ и вы проиграете!",
    doctors_tired2 = "Ваши доктора невероятно устали. Им нужен отдых.",
    handymen_tired = "Ваши рабочие невероятно устали. Им нужен отдых.",
    patient_leaving = "Вот уходит пациент. Причина? У вас никчемная и бесполезная больница.",
    machinery_damaged2 = "Вашим машинам требуется ремонт, наймите рабочего.",
    patients_leaving = "Клиенты уходят. Сделайте вашу больницу более терпимой, поставив скамейки, растения, автоматы с газировкой и прочее.",
    epidemic_getting_serious = "Эта заразная болезнь быстро распространяется. Сделайте же что-нибудь!",
    machinery_damaged = "Быстрее почините свои машины. Скоро они начнут ломаться.",
    people_have_to_stand = "Несчастные больные вынуждены стоять. Поставьте еще скамеек.",
    build_staffroom = "Немедленно постройте комнату персонала. Ваши люди скоро начнут падать в обморок от усталости. Неужели для вас нет ничего святого!",
    machinery_slightly_damaged = "Оборудование вашего госпиталя понемногу изнашивается. Не забывайте чинить его время от времени.",
    need_staffroom = "Вашим сотрудникам нужна комната для отдыха.",
    patients_getting_hot = "В вашей больнице слишком жарко. Пожалуйста, снизьте нагрев или уберите часть батарей.",
    machinery_deteriorating = "Ваши машины начали изнашиваться от частого использования. Присматривайте за ними.",
    patients_too_hot = "Пациенты жалуются на жару. Уберите лишние батареи, снизьте температуру или поставьте еще автоматов с газировкой.",
    patients_thirsty = "Пациенты хотят пить. Может быть, стоит поставить торговые автоматы?",
    machine_severely_damaged = "%s скоро совсем развалится.",
    litter_catastrophy = "Мусор в вашей больнице выходит из под контроля. Скорее направьте еще рабочих на уборку!",
    staff_very_cold = "Сотрудники жалуются на холод. Увеличьте температуру или поставьте еще батарей.",
    deal_with_epidemic_now = "Если что-то не сделать с этой эпидемией, мы окажемся в беде по самые ноздри. Шевелитесь!",
    too_many_plants = "Я вижу, вы любите цветы. У вас тут настоящие джунгли.",
    patients_really_thirsty = "Пациенты очень хотят пить. Поставьте ваши торговые автоматы туда, где самые длинные очереди.",
    some_litter = "Дайте рабочим указание прибраться в больнице, пока проблема с мусором не разрослась.",
    patients_annoyed = "Люди терпеть не могут вашу больницу, и я не могу их винить за это. Разберитесь с вашими проблемами, или будет хуже!",
  },
  placement_info = {
    door_cannot_place = "Извините, тут дверь проделать нельзя.",
    staff_cannot_place = "К сожалению, этого человека нельзя здесь поставить.",
    object_cannot_place = "Сюда не поместится.",
    room_cannot_place = "Здесь нельзя устроить кабинет.",
    room_cannot_place_2 = "Тут кабинет не поместится.",
    window_cannot_place = "Здесь нельзя сделать окно.",
    reception_cannot_place = "Регистратура сюда не встанет.",
  },
  information = {
    larger_rooms = "Большие кабинеты повышают самооценку и производительность людей, которые в них работают.",
    extra_items = "Дополнительные предметы в кабинетах нравятся вашим сотрудникам и повышают производительность.",
    epidemic = "У вас в больнице распространяется заразная болезнь. Это нужно немедленно пресечь!",
    promotion_to_doctor = "Один из ваших студентов стал доктором.",
    emergency = "Чрезвычайная ситуация! Караул! Спасайся кто может!",
    patient_abducted = "Вашего клиента похищают пришельцы!",
    first_cure = "Отличная работа! Вы только что вылечили своего первого пациента.",
    promotion_to_consultant = "Один из ваших докторов стал консультантом.",
    handyman_adjust = "Вы можете повысить эффективность рабочих, перераспределив их приоритеты.",
    promotion_to_specialist = "Один из ваших докторов стал %s.",
    initial_general_advice = {
      rats_have_arrived = "В вашей больнице завелись крысы. Попробуйте пострелять их своей мышью.",
      first_patients_thirsty = "Посетители в вашей больнице хотят пить. Поставьте для них автоматы с газировкой.",
      research_now_available = "Вы построили исследовательский отдел. Теперь вы можете открыть окно исследований.",
      decrease_heating = "Посетители жалуются на жару. Понизьте уровень нагрева. Это можно сделать в окне карты.",
      first_emergency = "Над головой чрезвычайных пациентов крутится мигалка. Вылечите их до того, как закончится время.",
      first_epidemic = "У вас в больнице эпидемия! Примите решение, объявите ли вы о ней или попытаетесь скрыть.",
      taking_your_staff = "У вас пытаются переманить сотрудника. Вам придется побороться, если хотите удержать его.",
      place_radiators = "Посетители жалуются на холод. Вы можете заказать дополнительные батареи из меню обстановки коридоров.",
      epidemic_spreading = "Заразная болезнь распространяется по больнице. Постарайтесь вылечить зараженных до того, как они уйдут домой.",
      machine_needs_repair = "Одна из ваших машин требует ремонта. Найдите дымящуюся машину и щелкните на ней. Затем нажмите кнопку вызова рабочего.",
      increase_heating = "Пациенты замерзают. Увеличьте нагрев в окне карты.",
      first_VIP = "Скоро вас посетит с экскурсией какая-то большая шишка. Постарайтесь, чтобы он не заметил антисанитарии и недовольных пациентов.",
    },
    patient_leaving_too_expensive = "Пациент ушел, не заплатив за %s. Для него это слишком дорого.",
    vip_arrived = "Внимание! %s прибыл в вашу больницу с официальным визитом! Проследите, чтобы все прошло как по маслу.",
    epidemic_health_inspector = "Слухи об эпидемии в вашей больнице достигли министерства здравоохранения. Приготовьтесь в приезду инспектора.",
    first_death = "Вы только что угробили своего первого пациента. Надеюсь, вы собой довольны?",
    pay_rise = "Кто-то из ваших сотрудников угрожает уволиться. Вы можете согласиться на повышение зарплаты или отказать. Нажмите на значок слева внизу чтобы увидеть заявление.",
    place_windows = "Дополнительные окна делают комнаты светлее, а персонал - счастливее.",
    fax_received = "Значок, который сейчас вылез слева внизу экрана сообщает вам что-то важное или требует ваше решение по какому-либо вопросу.",
  },
}

-- 8.  Письма из министерства
introduction_texts = {
  level1 = {
    [1] = "Добро пожаловать в вашу первую больницу!//",
    [2] = "Чтобы начать принимать пациентов, постройте регистратуру и кабинет терапевта, наймите регистраторшу и доктора. ",
    [3] = "Потом просто ждите когда придут первые пациенты.",
    [4] = "Также, вам не помешает построить кабинет психиатра и нанять доктора с соответствующим дипломом. ",
    [5] = "Чтобы лечить больных, вам потребуется аптека и медсестра. ",
    [6] = "Приготовьтесь принимать пациентов с раздутой головой. Для них надо будет построить кабинет со специальной машиной. ",
    [7] = "Попробуйте вылечить 10 человек и смотрите, чтобы ваша репутация не упала ниже 200.",
  },
  level2 = {
    [1] = "В этой местности встречается больше разных заболеваний. ",
    [2] = "Подготовьте больницу к наплыву пациентов и не забудьте построить исследовательский отдел. ",
    [3] = "Очень важно поддерживать ваше заведение в чистоте и стараться повысить свою репутацию. Ожидайте прибытия пациентов с длинными языками - постройте для них специальный кабинет. ",
    [4] = "Комната кардиографии поможет вам точнее ставить диагнозы. ",
    [5] = "Оба этих кабинета должны быть исследованы прежде, чем вы сможете их построить. В окне карты вы теперь можете приобретать дополнительные корпуса для вашей больницы. ",
    [6] = "Ваша цель - заработать 10 000$, вылечить 40 человек и не уронить репутацию ниже 300.",
  },
  level3 = {
    [1] = "На этот раз ваша больница будет расположена в богатом районе. ",
    [2] = "Министерство здравоохранения ожидает получить здесь нехилую прибыль. ",
    [3] = "Для начала, вам предстоит заработать хорошую репутацию, затем сосредоточтесь на превращении ее в деньги. ",
    [4] = "Знайте, что вы можете столкнуться с чрезвычайными ситуациями. ",
    [5] = "Это означает, что к вам в больницу прибудет группа людей с серьезным заболеванием. ",
    [6] = "Если вы успеете их вылечить за ограниченное время, то заработаете солидный бонус и хорошую репутацию. ",
    [7] = "Вам придется столкнуться с синдромом Короля, а также выделить деньги на постройку палаты и операционной. ",
    [8] = "Заработайте 20 000$ чтобы добиться успеха.",
  },
  level4 = {
    [1] = "Проследите, чтобы пациенты были довольны, хорошо обслужены и не умирали.",
    [2] = "Ваша репутация имеет большое значение, так что постарайтесь поднять ее как можно выше.",
    [3] = "Не беспокойтесь о деньгах - они придут вместе с высокой репутацией.",
    [4] = "Теперь вы также можете обучать ваших докторов, чтобы повысить их навыки.",
    [5] = "Так они смогут справляться даже с самыми необчными болезнями.",
    [6] = "Поднимите вашу репутацию до 500.",
  },
  level5 = {
    [1] = "С таким разнообразием заболеваний, как в этой больнице, вам не придется сидеть без дела.",
    [2] = "Ваши доктора - вчерашние студенты, так что им необходимо будет подучиться.",
    [3] = "У вас есть три консультанта, которые помогут обучить новичков, постарайтесь их не разозлить.",
    [4] = "А еще наша больница стоит прямо над разломом Сан Андроид.",
    [5] = "Ожидайте землетрясений.",
    [6] = "Они могут повредить ваши машины и нарушить работу больницы.",
    [7] = "Поддерживайте репутацию не ниже 400 и заработайте 50 000$. Также, вылечите 200 пациентов.",
  },
  level6 = {
    [1] = "Опираясь на весь свой опыт, постройте хорошо организованную больницу, приносящую стабильный доход и способную вылечить все, что угодно.",
    [2] = "Знайте, что в этой местности особенно быстро распространяются всякие инфекции.",
    [3] = "Если в вашей больнице не будет идеально чисто, ждите вспышек эпидемий среди пациентов.",
    [4] = "Заработайте 150 000$ и доведите стоимость больницы до 140 000$.",
  },
  level7 = {
    [1] = "Здесь вы будете под неусыпным наблюдением министерства здравоохранения, так что постарайтесь, чтобы деньги текли рекой, а репутация стремилась ввысь. ",
    [2] = "Мы не можем вам позволить убивать пациентов - это плохо для бизнеса. ",
    [3] = "Проследите, чтобы у вас было все необходимое оборудование и высококлассные специалисты. ",
    [4] = "Заработайте 600 репутации плюс 200 000$ на банковский счет.",
  },
  level8 = {
    [1] = "Ваша задача - построить как можно более эффективную и рентабельную больницу. ",
    [2] = "Народ здесь живет на широкую ногу, так что не стесняйтесь стричь капусту изо всех сил. ",
    [3] = "Нет, конечно, лечить людей - хорошо, и все такое, но вам ОЧЕНЬ нужны их деньги. ",
    [4] = "Проследите, чтобы ваши пациенты были в состоянии дойти до кассы. ",
    [5] = "Накопите на счету, ни много ни мало, 300 000$ чтобы завершить этот уровень.",
  },
  level9 = {
    [1] = "Теперь, когда на счету министерства полно денег, и сам министр разъезжает на новеньком лимузине, вы вновь можете заняться постройкой приличной, хорошо организованной больницы для самых нуждающихся. ",
    [2] = "Будьте готовы к любым неприятностям.",
    [3] = "Если вы озаботитесь приобретением всего необходимого оборудования и кадров, ничто не сможет причинить вам проблем. ",
    [4] = "Ваша больница должна стоить 200 000$, а на вашем счету должно быть 400 000$. ",
    [5] = "Мы не примем меньшего.",
  },
  level10 = {
    [1] = "Помимо излечения всех болезней, которые бывают в этом захолустье, министерство просит вас уделить внимание исследованию лекарств.",
    [2] = "К нам поступают жалобы от некоего Овсика, местного активиста, так что улучшайте свои лекарства, чттобы не ударить в грязь лицом.",
    [3] = "Также, не давайте поводов для упреков. Сведите число трупов к минимуму.",
    [4] = "Кстати, отведите место для кабинета лечения ожеления.",
    [5] = "Улучшите все лекарства до 80% эффективности, повысьте репутацию до 650 и соберите 500 000$.",
  },
  level11 = {
    [1] = "Вам предоставляется шанс построить идеальную больницу. ",
    [2] = "Это невероятно престижное место, и министерство хотело бы видеть здесь соответствующее лечебное учреждение. ",
    [3] = "Мы ожидаем от вас большой прибыли, высокой репутации и использования всех возможных средств для достижения цели. ",
    [4] = "Это очень важная работа. ",
    [5] = "Чтобы ее выполнить, вам придется лезть из кожи вон. ",
    [6] = "Кстати, в этой местности замечены НЛО. Интересно, ваш персонал готов к подобным сюрпризам? ",
    [7] = "Доведите стоимость больницы до $240,000, соберите $500,000 и поднимите репутацию до 700.",
  },
  level12 = {
    [1] = "Эта задача - вершина всех задач. ",
    [2] = "Восхищенное вашим успехом, министерство предлагает вам сложную работу: им нужен кто-то, кто построит еще одну идеальную больницу, принесет огромное количество денег и заработает невероятную репутацию. ",
    [3] = "От вас ожидается, что вы скупите всю землю в округе, вылечите всех (да-да, именно всех) и получите все награды. ",
    [4] = "Возьметесь за дело?",
    [5] = "Заработайте $650,000, вылечите 750 человек и ваша репутация не должна быть ниже 800, чтобы выиграть.",
  },
  level13 = {
    [1] = "Ваше невероятное мастерство владения больницей заинтересовало сверхсекретный отдел сверхсексретной службы. ",
    [2] = "У них есть для вас сюрприз: переполненная крысами больница требует эффективного вмешательства. ",
    [3] = "Уничтожьте как можно больше крыс, пока рабочие не убрали весь мусор. ",
    [4] = "Справитесь?",
  },
  level14 = {
    [1] = "Перед вами очередное задание: эта больница богата разного рода неожиданностями. ",
    [2] = "Приведите ее к успеху и станьте победителем из победителей. ",
    [3] = "Не думайте, что все будет очень легко. Перед вашим лицом предстанут весьма жесткие условия ",
    [4] = "Удачи!",
  },
  level15 = {
    [1] = "Итак, освоим важные моменты для создания хорошей больницы.//",
    [2] = "Иногда вашим врачам требуется помощь в постановке правильного диагноза. Для дополнительных обследований ",
    [3] = "необходимо построить специальные кабинеты, например, кабинет общей диагностики.",
  },
  level16 = {
    [1] = "Вы уже поставили диагнозы нескольким пациентам, и пора приниматься за их лечение. Для этого необходимо построить различные кабинеты. ",
    [2] = "Для начала постройте аптеку и наумите медсестру, которая будет выдавать пациентам спасительные лекарства.",
  },
  level17 = {
    [1] = "Последнее предупреждение: зорко следите за репутацией, ведь именно она привлекает к вам пациентов из самых дальних уголков страны, а соответственно и их деньги. ",
    [2] = "Если вы не будете убивать много людей и они будут довольны вашей больницей, особых проблем у вас не возникнет.//",
    [3] = "Теперь вы сами себе хозяин. Удачи! На этом все.",
  },
  level18 = {
  },
}
letter = {
  [1] = {
    [1] = "Уважаемый %s,//",
    [2] = "Великолепно! Вы превосходно справляетесь с управлением этой больницей. Мы, большие шишки из министерства здравоохранения, хотим предложить вам заняться более крупным проектом. Вы идеально подходите нам для этой работы. Мы готовы платить вам %d$. Подумайте над нашим предложением.//",
    [3] = "Вас интересует работа в больнице «%s»?",
  },
  [2] = {
    [1] = "Уважаемый %s,//",
    [2] = "Очень хорошо! Вы добились больших успехов в вашей больнице. Если вы не прочь сменить обстановку и не боитесь трудностей, мы можем предложить вам работу в другом месте. Соглашайтесь, и вы не пожалеете. Ваша зарплата составит %d$//",
    [3] = "Вы хотите работать в больнице «%s»?",
  },
  [3] = {
    [1] = "Уважаемый %s,//",
    [2] = "Вы добились огромных успехов, управляя этой больницей. Посему, мы предсказываем вам большое будущее и хотим предложить новый пост. Мы готовы платить вам %d$ и думаем, вы не прочь принять этот вызов.//",
    [3] = "Вы хотите управлять больницей «%s»?",
  },
  [4] = {
    [1] = "Уважаемый %s,//", 
    [2] = "Поздравляем! У нас тут в министерстве все под впечатлением от ваши управленческих способностей. Мы возлагаем на вас большие надежды! Поэтому, мы хотим предложить вам работу посложнее. Ваша зарплата составит %d$, решение за вами.//",
    [3] = "Вас интересует работа в больнице «%s»?",
  },
  [5] = {
    [1] = "Уважаемый %s,//",
    [2] = "Снова здравствуйте. Мы понимаем, как вам неохота покидать эту уютную больничку, но все же убедительно просим вас пересмотреть свое мнение. Мы будем платить вам %d$, если вы отправитесь в другую больницу и организуете ее работу так же хорошо.//",
    [3] = "Вы согласны отправиться работать в больницу «%s»?",
  },
  [6] = {
    [1] = "Уважаемый %s,//",
    [2] = "Поздравляем. Представляем, как вы счастливы владеть этой прекрасной больницей, но следующая ступенька карьерной лестницы уже ждет вас. Вы будете получать $%d, если согласитесь. Надеемся, вы сделаете правильный выбор.//",
    [3] = "Согласны ли вы занять свое место в больнице «%s»?",
  },
  [7] = {
    [1] = "Уважаемый %s,//",
    [2] = "Добрый день! В министерстве здравоохранения всем очень интересно, что держит вас в вашей больнице. Может быть, ваше заведение и превосходно, но, все же, хотим предложить вам перевод в новую больницу, где вас ожидают новые песпективы и зарплата в $%d.//",
    [3] = "Вы согласны перейти работать в больницу «%s»?",
  },
  [8] = {
    [1] = "Уважаемый %s//,",
    [2] = "И еще раз, здравствуйте. Вы отклонили наше предыдущее предложение новой работы с зарплатой в %d$. Однако, мы настаиваем на пересмотре вами своего решения. Вот увидите, новое место работы намного лучше!//",
    [3] = "Пожалуйста, согласитесь занять пост руководителя в больнице «%s».",
  },
  [9] = {
    [1] = "Уважаемый %s//,",
    [2] = "На протяжении длительного времени вы зарекомендовали себя как отличный руководитель. Такая заслуга не может остаться без награды, и мы рады предложить вам пост главного управляющего больницами. Это важная должность, и размер зарплаты составит $%d. Вы взойдете на пост по ковровой дорожке, и люди встретят вас с почетом.//",
    [3] = "Вами пройден большой путь. Спасибо за все, что вы делаете.//",
    [4] = "",
  },
  [10] = {
    [1] = "Уважаемый %s//,",
    [2] = "Примите наши поздравления: вы изумительно справляетесь со всеми поставленными задачами. Ваш профессионализм открывает для вас множество путей. Вы будете получать пенсию в размере $%d и иметь личный лимузин, если согласитесь на наше предложение разъезжать по городам, проводя организационную работу в больницах.//",
    [3] = "Мы гордимся вами. Еще никто не отдавал столько сил на спасение человеческих жизней.//",
    [4] = "",
  },
  [11] = {
    [1] = "Уважаемый %s//,",
    [2] = "Ваша карьера была образцовой, вы вдохновляли нас. Спасибо за посещение такого количества больниц и огромную проделанную работу. Предлагаем вам пожизненные выплаты в размере $%d, а вы будете разъезжать в роскошном кабриолете по больницам городов и проводить мастер-классы по достижению успеха в карьере.//",
    [3] = "Вы являетесь примером для каждого здравомыслящего человека, и все, без исключения, хотели бы стать такими же успешными, как вы.//",
    [4] = "",
  },
  [12] = {
    [1] = "Уважаемый %s//,",
    [2] = "Ваша успешная карьера лучшего со времен Моисея управляющего больницей близится к завершению. Однако, учитывая ваши заслуги в медицине, министерство здравоохранения готово предложить вам $%d просто за то, что вы будете появляться на презентациях, открытиях, запусках кораблей и иногда на ток-шоу. Весь мир жаждет видеть вас, и ваше имя будет отличной рекламой для нас!//",
    [3] = "Пожалуйста, примите наше предложение. Работа несложная, и вам будет предоставлена машина и полицейский эскорт, куда бы вы ни отправились.//",
    [4] = "",
  },
  custom_level_completed = "Отличная работа! Вы выполнили все задачи на этой карте!",
  dear_player = "Уважаемый %s",
  return_to_main_menu = "Вернетесь в главное меню или продолжите игру?",
}

-- 9.  Имена и названия
months = {
  [1] = "янв",
  [2] = "фев",
  [3] = "мар",
  [4] = "апр",
  [5] = "мая",
  [6] = "июн",
  [7] = "июл",
  [8] = "авг",
  [9] = "сен",
  [10] = "окт",
  [11] = "ноя",
  [12] = "дек",
}
humanoid_name_starts = {
  [1] = "Клизм",
  [2] = "Орех",
  [3] = "Стол",
  [4] = "Бочк",
  [5] = "Нос",
  [6] = "Ерш",
  [7] = "Штан",
  [8] = "Болт",
  [9] = "Дуб",
  [10] = "Брод",
  [11] = "Чурб",
  [12] = "Крив",
  [13] = "Торт",
  [14] = "Кос",
  [15] = "Гор",
  [16] = "Долг",
  [17] = "Шар",
  [18] = "Рыж",
  [19] = "Пост",
  [20] = "Разд",
  [21] = "Жир",
  [22] = "Фаф",
  [23] = "Темн",
  [24] = "Пуст",
  [25] = "Морд",
  [26] = "Кот",
  [27] = "Срам",
  [28] = "Винт",
  [29] = "Мал",
  [30] = "Треп",
  [31] = "Остр",
  [32] = "Плот",
  [33] = "Хрен",
}
humanoid_name_ends = {
  [1] = "енко",
  [2] = "ович",
  [3] = "ай-оглы",
  [4] = "ицки",
  [5] = "атюк",
  [6] = "ински",
  [7] = "ецман",
  [8] = "идзе",
  [9] = "инян",
  [10] = "амян",
  [11] = "овски",
  [12] = "евич",
  [13] = "сон",
  [14] = "ски",
  [15] = "берг",
  [16] = "енюк",
  [17] = "ишко",
  [18] = "атко",
  [19] = "ейко",
  [20] = "акец",
  [21] = "елло",
  [22] = "ецки",
  [23] = "орец",
  [24] = "ацки",
  [25] = "анян",
  [26] = "атич",
}
vip_names = {
  [1] = "Мэр Большого Трумптона",
  [2] = "Лоуренс Найтингейл",
  [3] = "Бернард, король Нидерландов",
  [4] = "Онг Сян Су Куй, предводитель бирманской демократической оппозиции",
  [5] = "Сэр Риджинальд Крамбли",
  [6] = "Сэр Вилли Сэвил",
  [7] = "Советник Кроуфорд Первс",
  [8] = "«Ракета» Ронни Джепсон",
  [9] = "Футболист премьер-лиги",
  [10] = "Л. Ф. Пробст III",
  health_minister = "Министр здравоохранения",
}

-- 10  WIP
-- 10.2  Не для перевода
menu_options_volume = {
  [50] = "  50%  ",
  [100] = "  100%  ",
  [30] = "  30%  ",
  [60] = "  60%  ",
  [90] = "  90%  ",
  [10] = "  10%  ",
  [20] = "  20%  ",
  [40] = "  40%  ",
  [80] = "  80%  ",
  [70] = "  70%  ",
}
cheats_window = {
  cheats = {
    end_month = "End of Month",
    emergency = "Create Emergency",
    win_level = "Win Level",
    create_patient = "Create Patient",
    money = "Money Cheat",
    lose_level = "Lose Level",
    all_research = "All Research Cheat",
    end_year = "End of Year",
  },
  close = "Close",
  caption = "Cheats",
  cheated = {
    no = "Cheats used: No",
    yes = "Cheats used: Yes",
  },
  warning = "Warning: You will not get any bonus points at the end of the level if you cheat!",
}
original_credits = {
  [1] = " ",
  [2] = " ",
  [3] = " ",
  [4] = " ",
  [5] = " ",
  [6] = " ",
  [7] = " ",
  [8] = " ",
  [9] = " ",
  [10] = " ",
  [11] = " ",
  [12] = ":Designed and Created by",
  [13] = ":Bullfrog Productions",
  [14] = " ",
  [15] = ":Pluto Development Team",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = " ",
  [29] = " ",
  [30] = " ",
  [31] = ":Programming",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = " ",
  [38] = " ",
  [39] = " ",
  [40] = ":Art",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = " ",
  [47] = " ",
  [48] = " ",
  [49] = ":Additional Programming",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = " ",
  [55] = " ",
  [56] = " ",
  [57] = ":Additional Art",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = " ",
  [66] = " ",
  [67] = " ",
  [68] = ":Intro Sequence",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = " ",
  [72] = " ",
  [73] = " ",
  [74] = ":Music and Sound Effects",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = " ",
  [79] = " ",
  [80] = " ",
  [81] = ":Additional Music",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = " ",
  [86] = " ",
  [87] = " ",
  [88] = ":Announcer Voiceover",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = " ",
  [92] = " ",
  [93] = " ",
  [94] = ":Level Design",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = " ",
  [101] = " ",
  [102] = " ",
  [103] = ":Scripting",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = " ",
  [109] = " ",
  [110] = " ",
  [111] = ":R&D",
  [112] = " ",
  [113] = ":Graphics Engine",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = " ",
  [118] = " ",
  [119] = " ",
  [120] = ":R&D Support",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = " ",
  [127] = " ",
  [128] = " ",
  [129] = ":Library and Tools",
  [130] = " ",
  [131] = "Dos and Win 95 Library",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = " ",
  [137] = " ",
  [138] = " ",
  [139] = ":Network Library",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = " ",
  [144] = " ",
  [145] = " ",
  [146] = ":Sound Library",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = " ",
  [151] = " ",
  [152] = " ",
  [153] = ":Installer Programming",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = " ",
  [159] = " ",
  [160] = " ",
  [161] = ":Moral Support",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = " ",
  [165] = " ",
  [166] = " ",
  [167] = ":Testing Manager",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = " ",
  [171] = " ",
  [172] = " ",
  [173] = ":Lead Testers",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = " ",
  [178] = " ",
  [179] = " ",
  [180] = ":Play Testers",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = " ",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = " ",
  [203] = "And all our other Work Experience Play Testers",
  [204] = " ",
  [205] = " ",
  [206] = " ",
  [207] = ":Technical Support",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = " ",
  [213] = " ",
  [214] = " ",
  [215] = ":Marketing",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = " ",
  [220] = " ",
  [221] = " ",
  [222] = ":With thanks to:",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = " ",
  [229] = " ",
  [230] = " ",
  [231] = ":PR",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = " ",
  [235] = " ",
  [236] = " ",
  [237] = ":Documentation",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = " ",
  [244] = " ",
  [245] = " ",
  [246] = ":Documentation & Packaging Design",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = " ",
  [251] = " ",
  [252] = " ",
  [253] = ":Localisation Project Manager",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = " ",
  [257] = " ",
  [258] = " ",
  [259] = ":Localisation",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = " ",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = " ",
  [268] = "C.T.O. S.p.A. Zola Predosa (BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = " ",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Mart®ez",
  [276] = " ",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = " ",
  [281] = " ",
  [282] = " ",
  [283] = ":Production",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = " ",
  [287] = " ",
  [288] = " ",
  [289] = ":Producer",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = " ",
  [293] = " ",
  [294] = " ",
  [295] = ":Associate Producer",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = " ",
  [299] = " ",
  [300] = " ",
  [301] = ":Operations",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = " ",
  [305] = " ",
  [306] = " ",
  [307] = ":Company Administration",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = ":Company Management",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":All at Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = ":Special Thanks to",
  [332] = ",",
  [333] = "Everyone at Frimley Park Hospital",
  [334] = " ",
  [335] = ":Especially",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = " ",
  [340] = " ",
  [341] = " ",
  [342] = ":Keep On Thinking",
  [343] = " ",
  [344] = " ",
  [345] = " ",
  [346] = " ",
  [347] = " ",
  [348] = " ",
  [349] = " ",
  [350] = " ",
  [351] = " ",
  [352] = " ",
  [353] = " ",
  [354] = " ",
  [355] = " ",
  [356] = " ",
  [357] = " ",
  [358] = " ",
  [359] = " ",
  [360] = " ",
  [361] = ".",
}
-- 10.3  Непереведенные
tooltip = {
  queue_window = {
    end_of_queue = "Перетащите пациента на этот значок, чтобы переместить его в конец очереди",
    num_entered = "Количество пациентов, посетивших кабинет",
    close = "Закрыть запрос",
    num_in_queue = "Количество пациентов в очереди",
    num_expected = "Количество пациентов, направленных сюда из регистратуры",
    front_of_queue = "Перетащите пациента на этот значок, чтобы переместить его в начало очереди",
    dec_queue_size = "Уменьшить максимальный размер очереди",
    max_queue_size = "Макимальный размер очереди в регистратуру",
    inc_queue_size = "Увеличить  максимальный размер очереди",
    patient = "Перетащите пациента в нужное место очереди. Щелкните на пациенте правой кнопкой, чтобы отправить его домой или в другую больницу",
    patient_dropdown = {
      send_home = "Выгнать пациента из больницы",
      hospital_2 = "Направить пациента в другую больницу",
      reception = "Отправить в регистратуру",
      hospital_1 = "Направить пациента в другую больницу",
      hospital_3 = "Направить пациента в другую больницу",
    },
  },
  jukebox = {
    rewind = "Предыдущая дорожка",
    loop = "Повторять текущую дорожку",
    stop = "Остановить",
    close = "Закрыть",
    current_title = "Текущая дорожка",
    play = "Воспроизвести",
    fast_forward = "Следующая дорожка",
  },
  graphs = {
    deaths = "Показать/скрыть умерших",
    close = "Закрыть окно",
    scale = "Масштаб графика",
    money_out = "Показать/скрыть расходы",
    visitors = "Показать/скрыть посетителей",
    wages = "Показать/скрыть зарплаты",
    balance = "Показать/скрыть баланс",
    money_in = "Показать/скрыть доход",
    cures = "Показать/скрыть вылеченных",
    reputation = "Показать/скрыть репутацию",
  },
  message = {
    button = "Щелкните, чтобы открыть сообщение",
    button_dismiss = "Щелкните левой кнопкой, чтобы просмотреть сообщение, правой - чтобы отклонить его",
  },
  pay_rise_window = {
    accept = "Повысить зарплату",
    decline = "Отказать в повышении зарплаты",
  },
  custom_game_window = {
    start_game_with_name = "Загрузить уровень %s",
  },
  cheats_window = {
    close = "Close the cheats dialog",
    cheats = {
      end_month = "Jumps to the end of the month.",
      emergency = "Creates an emergency.",
      win_level = "Win the current level.",
      create_patient = "Creates a Patient at the map border.",
      money = "Adds 10.000 to your bank balance.",
      lose_level = "Lose the current level.",
      all_research = "Completes all research.",
      end_year = "Jumps to the end of the year.",
    },
  },
  menu_list_window = {
    back = "Закрыть окно",
  },
  watch = {
    emergency = "Чрезвычайное происшествие: время, оставшееся на лечение срочных пациентов.",
    hospital_opening = "Время на постройку: по истечении этого времени больница будет открыта. Если вы хотите открыть больницу уже сейчас, нажмите зеленую кнопку.",
    epidemic = "Эпидемия: время на остановку эпидемии. Когда время закончится или зараженный пациент покинет больницу, приедет инспектор. Кнопка включает/отключает режим вакцинации. Щелкните на пациенте, и медсестра введет ему вакцину.",
  },
  calls_dispatcher = {
    assigned = "This box is marked if someone is assigned to the corresponding task.",
    task = "List of tasks - click task to open assigned staff's window and scroll to location of task",
    close = "Close the calls dispatcher dialog",
  },
  information = {
    close = "Закрыть окно информации",
  },
  lua_console = {
    textbox = "Enter Lua code to run here",
    execute_code = "Run the code you have entered",
    close = "Close the console",
  },
  staff_window = {
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    psychiatrist = "Психиатр",
    close = "Закрыть окно",
    ability = "Компетентность",
    pick_up = "Взять",
    sack = "Уволить",
    surgeon = "Хирург",
    happiness = "Настроение",
    salary = "Ежемесячная зарплата",
    name = "Имя",
    tiredness = "Запас сил",
    center_view = "Левая кнопка - центрировать экран, правая - выбрать следующего сотрудника",
    skills = "Особые умения",
    researcher = "Исследователь",
    face = "Портрет - нажмите, чтобы перейти к экрану управления персоналом",
  },
  research = {
    cure_inc = "Повысить приоритет исследований",
    close = "Закрыть экран исследований",
    specialisation_dec = "Понизить приоритет исследований",
    diagnosis_dec = "Понизить приоритет исследований",
    allocated_amount = "Выделенные ресурсы",
    improvements_inc = "Повысить приоритет исследований",
    drugs_dec = "Понизить приоритет исследований",
    drugs_inc = "Повысить приоритет исследований",
    cure_dec = "Понизить приоритет исследований",
    specialisation_inc = "Повысить приоритет исследований",
    improvements_dec = "Понизить приоритет исследований",
    diagnosis_inc = "Повысить приоритет исследований",
  },
  statement = {
    close = "Закрыть экран баланса",
  },
  buy_objects_window = {
    confirm = "Купить предмет(ы)",
    cancel = "Отмена",
    increase = "Купить на один предмет больше",
    total_value = "Общая сумма покупки",
    price = "Стоимость предмета",
    decrease = "Купить на один предмет меньше",
  },
  fax = {
    close = "Закрыть окно, не удаляя сообщение",
  },
  window_general = {
    confirm = "Подтвердить",
    cancel = "Отмена",
  },
}
totd_window = {
  previous = "Предыдущая подсказка",
  tips = {
    [1] = "Любая больница нуждается в регистратуре и кабинете терапевта. Именно в них решается дальнейшая судьба пациента и он направляется на дальнейшее лечение. Кстати, аптека тоже не помешает.",
    [2] = "Машины, например, аппарат надувания, требуют регулярного ухода. Для этого нужно нанять одного-двух работников. Испорченные машины могут доставить много неприятностей как персоналу, так и пациентам.",
    [3] = "Персоналу свойственно уставать. Не забывайте строить комнаты отдыха для них.",
    [4] = "Устанавливайте достаточно батарей отопления для поддержания тепла в больнице, иначе персонал и пациенты будут недовольны. Распределение тепла по помещению можно посмотреть на карте города.",
    [5] = "Профессионализм доктора сильно влияет на скорость постановки диагноза и качество лечения. Один профессиональный терапевт способен заменить двух неопытных.",
    [6] = "Студенты и доктора могут повышать свой профессиональный уровень на лекциях консультанта. Если консультант обладает специальными навыками (психиатра, хирурга или исследователя), он сможет передать их ученикам.",
    [7] = "А вы пробовали набирать европейский номер службы спасения (112) на факсе? Перед тем, как пробовать, включите звук!",
    [8] = "Вы можете изменить некоторые настройки, например разрешение экрана или язык игры, перейдя в меню настроек из главного меню или непосредственно из игры.",
    [9] = "Везде английские слова, хотя вы выбрали в настройках совсем не английский язык? Помогите закончить перевод игры!",
    [10] = "Команда CorsixTH нуждается в вашей помощи! Если вы хотите помочь в написании кода, создании графики или перевода игры, свяжитесь с нами на форуме, по электронной почте или на IRC-канале (corsix-th at freenode).",
    [11] = "Если вы нашли ошибки, пишите на наш багтрекер: th-issues.corsix.org",
    [12] = "Каждый уровень игры требует выполнения определенных условий для его завершения. Периодически заглядывайте в окно статуса, чтобы знать, какие условия выполнены, а какие - еще нет.",
    [13] = "Для редактирования или удаления кабинета есть специальная кнопка на панели внизу экрана.",
    [14] = "Чтобы разобраться в толпе пациентов, наведите курсор на кабинет, и ожидающие своей очереди посетители будут выделены.",
    [15] = "Щелкните на двери кабинета для просмотра очереди. Пациентов, стоящих в очереди можно перемещать, направлять в другие кабинеты и даже выгонять.",
    [16] = "Недовольный персонал требует повышения зарплат. Убедитесь в том, что ваши работники пребывают в кофортабельных условиях труда.",
    [17] = "Если в помещении больницы становится слишком жарко, пациентов начинает мучать жажда! Во избежание этого установите достаточное количество автоматов с водой в коридорах.",
    [18] = "Вы можете прервать диагностику пациента, будучи уверенным в постановке диагноза. Но будьте осторожны: ваша ошибка может повлечь за собой смерть пациента.",
    [19] = "Чрезвычайные ситуации могут принести вам неплохой доход, конечно, при условии, что у вас есть возможность и время для лечения таких пациентов.",
  },
  next = "Следующая подсказка",
}
trophy_room = {
  reputation = "РЕПУТАЦИЯ",
  happy_vips = {
    awards = {
      [1] = "Вы получили Нобелевскую премию за впечатления, произведенное на высокопоставленных особ. Все большие шишки, посещавшие вашу больницу за прошедший год, оценили ее выше всяких похвал.",
      [2] = "Поздравляем! Вы награждены орденом Подлизы за потакание всем большим шишкам, посещавшим вашу больницу в прошедшем году. Шикарно.",
    },
    trophies = {
      [1] = "Клуб Важных Персон вручает вам кубок Популярности за оказанное внимание всем VIP-персонам, посетившим ваше заведение в прошедшем году. Теперь вы можете считать себя немного известнее.",
    },
  },
  rats_killed = {
    awards = {
    },
    trophies = {
      [1] = "Вы награждены кубком Истребителя за уничтожение %d крыс в вашей больнице за прошедший год.",
      [2] = "Вы номинированы на награду от Аниткрысной Коалиции за выдающиеся успехи в истреблении %d этих мерзких тварей за прошедший год.",
      [3] = "Вы награждены орденом Крысобоя за отвагу и доблесть в уничтожении этих гадких созданий. Было убито %d крыс за прошедший год.",
    },
  },
  happy_staff = {
    awards = {
    },
    trophies = {
      [1] = "Вы награждены кубком Улыбки за поддержание хорошего настроения ваших тружеников в течении прошедшего года.",
      [2] = "Институт Вселенского Счастья вручает вам приз за отсутвие в вашем прекрасном заведении несчастных работников в прошедшем году.",
      [3] = "Эта награда, Сияющий Позолоченный кубок, вручается вам за поддержание в прошедшем году хорошего настроения работников в любой ситуации!",
    },
  },
  rats_accuracy = {
    awards = {
    },
    trophies = {
      [1] = "Вы несомненно заслужили уважение Общества снайперов за %d%% точность при отстреле крыс.",
      [2] = "Эта награда торжестенно вручается вам за %d%% попадания по крысам вашей больницы в прошедшем году.",
      [3] = "Чтобы отметить истребление %d%% крыс в вашей больнице, вам вручается премия Почётного крысолова!",
    },
  },
  all_cured = {
    awards = {
      [1] = "Поздравляем с получением ордена Марии Кюри за успешное излечение всех пациентов, посетивших вашу больницу в прошедшем году!",
    },
    trophies = {
      [1] = "Международная Ассоциация Излечения с гордостью вручает вам кубок Всездравия за стопроцентное излечение пациентов в прошедшем году.",
      [2] = "Вы получаете Здоровенную премию за заботу о выздоровлении каждого пациента больницы!",
    },
  },
  no_deaths = {
    awards = {
      [1] = "Поздравляем! Вы получаете орден имени В. Безтрупова за стопроцентное выживание ваших пациентов.",
    },
    trophies = {
      [1] = "Общество Продолжения Жизни вручает вам награду за отсутствие смертей среди пациентов в прошедшем году.",
      [2] = "Вы награждены кубком Выживания за то, что в прошедшем году сохранили жизни всех своих пациентов. Поразительно!",
    },
  },
  many_cured = {
    awards = {
      [1] = "Примите наши поздравления с получением ордена Матери Терезы за большинство вылеченных пациентов в прошедшем году.",
    },
    trophies = {
      [1] = "Международная Ассоциация Излечения торжественно вручает вам награду за излечение почти всех пациентов, обратившимся в больницу в прошедшем году.",
      [2] = "Вы получаете такую ценную награду, как кубок Выживания за невероятно высокий процент вылеченных пациентов вашего заведения за прошедший год.",
    },
  },
  high_rep = {
    awards = {
      [1] = "Вам торжественно вручается награда Кабинета Министров за поддержание стабильно высокой репутации больницы в прошедшем году. Отлично!",
      [2] = "Пожалуйста, примите награду команды CorsixTH за высочайшую репутацию вашего заведения. Вы это заслужили.",
    },
    trophies = {
      [1] = "Поздравляем с получением кубка Мегапафоса за достижение такой репутации в прошедшем году. Так держать!",
    },
  },
  sold_drinks = {
    awards = {
    },
    trophies = {
      [1] = "Международная Ассоциация Стоматологов вручает вам награду и медальку за огромное количество проданных газированных напитков за прошедший год.",
      [2] = "Ваша больница награждается кубком Пыщь-пыщь в честь продажи невероятного количества прохладительных напитков в прошедшем году.",
      [3] = "Позвольте нам, при поддержке кондитерской фабрики «Синий Пролетарий», вручить вам покрытый шоколадом кубок за высокий уровень продаж газированных напитков в прошедшем году.",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "Поздравляем! Вы награждены орденом Лопаты и Тяпки за поддержание растений в добром здравии круглый год.",
    },
    trophies = {
      [1] = "В честь того, что вы поддерживали растения в отличном состоянии весь прошедший год, Национальный Ботанический Сад вручает вам премию Листоворотки Дикопроизрастающей.",
      [2] = "Компания «СемеНа, получи» награждает вас премией имени Мичурина в честь своевременного ухода за растениями в прошедшем году.",
    },
  },
  cash = "ДЕНЬГИ",
}
drug_companies = {
  [1] = "ГосФармХимПром",
  [2] = "ИП Лечилкин",
  [3] = "ОАО Шприцеватор",
  [4] = "КолесоПлюс",
  [5] = "ИП Бергман и Ко",
}
insurance_companies = {
  [1] = "ООО Вектор",
  [2] = "ЧП Луковые Кольца",
  [3] = "ООО Братство Стали",
  [4] = "ЧП Дедушка Вареник",
  [5] = "ОДО Лебединая Песня",
  [6] = "ГосБытСнабСтрах",
  [7] = "ООО Недострах",
  [8] = "ЧП Залкинд и сыновья",
  [9] = "Бивис и Батт-хед Ко",
  [10] = "ООО Застрахуй-ка",
  [11] = "ООО Страховой Синдикат",
  out_of_business = "OUT OF BUSINESS",
}
competitor_names = {
  [1] = "ПРОФИТ",
  [2] = "МАРВИН",
  [3] = "МЕДИВАН",
  [4] = "ГИППОМЕД",
  [5] = "ТОНУС",
  [6] = "ЛОЩИНА",
  [7] = "ДЗЕН",
  [8] = "САЛВИН",
  [9] = "АКИРА",
  [10] = "ПУЛЬМАН",
  [11] = "ЧАРЛИ",
  [12] = "КРИОНИКА",
  [13] = "ГОРГОНА",
  [14] = "ОЛИФАНТ",
  [15] = "КАЛИНА",
  [16] = "НОРМАЛ",
  [17] = "ВИНСЕНТ",
  [18] = "МОЗЕС",
  [19] = "АМБУЛАНТА",
  [20] = "АХМЕД",
  [21] = "МАКСВЕЛ",
}
level_names = {
[1] = "Отравинск",
[2] = "Сонная лощина",
[3] = "Полянск",
[4] = "Правобережино",
[5] = "Простецк",
[6] = "Холмопупинка",
[7] = "Зеленоград",
[8] = "Белочкино",
[9] = "Пограничинск",
[10] = "Яичкино",
[11] = "Квакушкино",
[12] = "Избиваловка",
[13] = "Большие Чумли",
[14] = "Мелкопоповецк",
[15] = "Клептоманск",
}
graphs = {
  deaths = "Умерло",
  money_in = "Доход",
  money_out = "Расход",
  visitors = "Посетители",
  wages = "Зарплата",
  balance = "Баланс",
  time_spans = {
    [1] = "1 год",
    [2] = "12 лет",
    [3] = "48 лет",
  },
  cures = "Вылечено",
  reputation = "Репутация",
}
newspaper = {
  [1] = {
    [1] = "УЖАСЫ НАШЕГО КАБИНЕТА",
    [2] = "ТЕРАПЕВТ ВОЗОМНИЛ СЕБЯ БОГОМ",
    [3] = "КРУЧЕ ФРАНКЕНШТЕЙНА",
    [4] = "ЧТО У НАС НА СТОЛЕ?",
    [5] = "ОБЛАВА НА СУМАСШЕДШИХ ВРАЧЕЙ",
  },
  [2] = {
    [1] = "ВРАЧ УПОРОЛСЯ В ХЛАМ",
    [2] = "ОТЪЯВЛЕННЫЙ ХИРУРГ",
    [3] = "КОНСУЛЬТАНТ-ДЕБОШИР",
    [4] = "АЛКО-ХИРУРГИЯ",
    [5] = "ХИРУРГ ПОД НАРКОЗОМ",
    [6] = "ВРАЧ ДЫШАЛ ПЕРЕГАРОМ",
  },
  [3] = {
    [1] = "НЕУДАЧНАЯ ХИРУРГИЯ",
    [2] = "ВРАЧА ЗАСТАЛИ ВРАСПЛОХ",
    [3] = "ПРОВАЛ ВРАЧА",
    [4] = "НЕНАСЫТНЫЙ ХИРУРГ",
  },
  [4] = {
    [1] = "ПОДПОЛЬНЫЕ ОПЕРАЦИИ",
    [2] = "ОРГАН-ИЗОВАННОЕ ПРЕСТУПЛЕНИЕ",
    [3] = "ОПЕРАЦИИ...С ДЕНЬГАМИ",
    [4] = "ВРАЧ ГРЕБ ДЕНЬГИ ЛОПАТКОЙ",
  },
  [5] = {
    [1] = "МЕДИЦИНСКА НЕКРОФИЛИЯ",
    [2] = "ВРАЧ РАСКАПЫВАЛ МОГИЛЫ",
    [3] = "ЗАСТУКАЛИ С ТРУПОМ",
    [4] = "СУДНЫЙ ДЕНЬ ДЛЯ ДОКТОРА",
    [5] = "ТЕРМИНАЛЬНАЯ СТАДИЯ ПРАКТИКИ",
    [6] = "ДОКАЗАТЕЛЬСТВА ВЫКОПАНЫ!",
  },
  [6] = {
    [1] = "ВРАЧА ПОВЯЗАЛИ!",
    [2] = "РРАЗ! И ВСЕ!",
    [3] = "ДИАГНОСТИКА НА КОФЕЙНОЙ ГУЩЕ",
    [4] = "КОНСУЛЬТАНТ-НЕВЕЖДА",
  },
  [7] = {
    [1] = "ДОКТОР ЗНАЛ, ЧЕМ ВСЕ КОНЧИТСЯ",
    [2] = "ХИРУРГ ВСКРЫЛ САМ СЕБЯ",
    [3] = "В ПУЧИНЕ КОРРУПЦИИ",
    [4] = "ВРАЧ В ЦЕНТРЕ СКАНДАЛА",
    [5] = "ДОКТОР ЗАПУТАЛСЯ В СЛОВАХ",
  },
}
-- 10.4  Неиспользуемые/системные/diff/хз что
debug_patient_window = {
  caption = "Debug Patient",
}
menu_debug = {
  lua_console = "  (F12) LUA CONSOLE  ",
  porter_pagers = "  PORTER PAGERS        ",
  object_cells = "  OBJECT CELLS         ",
  display_pager = "  DISPLAY PAGER        ",
  disable_salary_raise = "  DISABLE SALARY RAISE  ",
  make_debug_fax = "  (F8) MAKE DEBUG FAX  ",
  display_big_cells = "  DISPLAY BIG CELLS    ",
  make_debug_patient = "  (F9) MAKE DEBUG PATIENT  ",
  mapwho_checking = "  MAPWHO CHECKING      ",
  sprite_viewer = "  SPRITE VIEWER  ",
  keep_clear_cells = "  KEEP CLEAR CELLS     ",
  dump_strings = "  DUMP STRINGS  ",
  machine_pagers = "  MACHINE PAGERS       ",
  remove_walls = "  REMOVE WALLS         ",
  enter_nav_debug = "  ENTER NAV DEBUG      ",
  lose_game_anim = {
    [1] = "  LOSE GAME 1 ANIM     ",
    [2] = "  LOSE GAME 2 ANIM     ",
    [3] = "  LOSE GAME 3 ANIM     ",
    [4] = "  LOSE GAME 4 ANIM     ",
    [5] = "  LOSE GAME 5 ANIM     ",
    [6] = "  LOSE GAME 6 ANIM     ",
    [7] = "  LOSE GAME 7 ANIM     ",
  },
  map_overlay = "  MAP OVERLAY  ",
  calls_dispatcher = "  CALLS DISPATCHER  ",
  show_nav_cells = "  SHOW NAV CELLS       ",
  win_game_anim = "  WIN GAME ANIM        ",
  display_room_status = "  DISPLAY ROOM STATUS  ",
  cheats = "  (F11) CHEATS  ",
  remove_objects = "  REMOVE OBJECTS       ",
  nav_bits = "  NAV BITS             ",
  win_level_anim = "  WIN LEVEL ANIM       ",
  dump_gamelog = "  (CTRL+D) DUMP GAME LOG  ",
  limit_camera = "  LIMIT CAMERA  ",
  pixbuf_cells = "  PIXBUF CELLS         ",
  transparent_walls = "  (X) TRANSPARENT WALLS  ",
  show_help_hotspot = "  SHOW HELP HOTSPOTS   ",
  jump_to_level = "  JUMP TO LEVEL  ",
  entry_cells = "  ENTRY CELLS          ",
  plant_pagers = "  PLANT PAGERS         ",
}
lua_console = {
  execute_code = "Выполнить",
  close = "Закрыть",
}
calls_dispatcher = {
  repair = "Repair %s",
  summary = "%d calls; %d assigned",
  close = "Close",
  watering = "Watering @ %d,%d",
  staff = "%s - %s",
}
information = {
  level_lost = {
    [1] = "Бум! Вы проиграли этот уровень! Может быть, повезет в следующий раз.",
    [2] = "Причина проигрыша:",
    reputation = "Ваша репутация упала ниже %d.",
    balance = "Ваш банковский баланс опустился ниже %d.",
    percentage_killed = "Более %d вагих пациентов отошли в мир иной.",
  },
  cannot_restart = "Unfortunately this custom game was saved before the restart feature was implemented.",
  custom_game = "Добро пожаловать в CorsixTH. Развлекайтесь по полной на пользовательской карте!",
}


