// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: st_stuff.c,v 1.21 2001/08/20 21:37:35 hurdler Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: st_stuff.c,v $
// Revision 1.21  2001/08/20 21:37:35  hurdler
// fix palette in splitscreen + hardware mode
//
// Revision 1.20  2001/08/20 20:40:39  metzgermeister
// *** empty log message ***
//
// Revision 1.19  2001/08/08 20:34:43  hurdler
// Big TANDL update
//
// Revision 1.18  2001/05/16 21:21:14  bpereira
// no message
//
// Revision 1.17  2001/04/01 17:35:07  bpereira
// no message
//
// Revision 1.16  2001/03/03 06:17:34  bpereira
// no message
//
// Revision 1.15  2001/02/24 13:35:21  bpereira
// no message
//
// Revision 1.14  2001/02/10 13:05:45  hurdler
// no message
//
// Revision 1.13  2001/01/31 17:14:07  hurdler
// Add cv_scalestatusbar in hardware mode
//
// Revision 1.12  2001/01/25 22:15:44  bpereira
// added heretic support
//
// Revision 1.11  2000/11/02 19:49:37  bpereira
// no message
//
// Revision 1.10  2000/10/04 16:34:51  hurdler
// Change a little the presentation of monsters/secrets numbers
//
// Revision 1.9  2000/10/02 18:25:45  bpereira
// no message
//
// Revision 1.8  2000/10/01 10:18:19  bpereira
// no message
//
// Revision 1.7  2000/10/01 01:12:00  hurdler
// Add number of monsters and secrets in overlay
//
// Revision 1.6  2000/09/28 20:57:18  bpereira
// no message
//
// Revision 1.5  2000/09/25 19:28:15  hurdler
// Enable Direct3D support as OpenGL
//
// Revision 1.4  2000/09/21 16:45:09  bpereira
// no message
//
// Revision 1.3  2000/08/31 14:30:56  bpereira
// no message
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      Status bar code.
//      Does the face/direction indicator animatin.
//      Does palette indicators as well (red pain/berserk, bright pickup)
//
//-----------------------------------------------------------------------------

#include "doomdef.h"

#include "am_map.h"

#include "g_game.h"
#include "m_cheat.h"

#include "screen.h"
#include "r_local.h"
#include "p_local.h"
#include "p_inter.h"
#include "m_random.h"

#include "st_stuff.h"
#include "i_video.h"
#include "v_video.h"

#include "keys.h"

#include "z_zone.h"
#include "hu_stuff.h"
#include "d_main.h"

#ifdef HWRENDER
#include "hw_drv.h"
#include "hw_main.h"
#endif

char patcharti[][10] =
{
        {"ARTIBOX"},    // none
        {"ARTIINVU"},   // invulnerability
        {"ARTIINVS"},   // invisibility
        {"ARTIPTN2"},   // health
        {"ARTISPHL"},   // superhealth
        {"ARTIPWBK"},   // tomeofpower
        {"ARTITRCH"},   // torch
        {"ARTIFBMB"},   // firebomb
        {"ARTIEGGC"},   // egg
        {"ARTISOAR"},   // fly
        {"ARTIATLP"}    // teleport
};

char ammopic[][10] =
{
        {"INAMGLD"},
        {"INAMBOW"},
        {"INAMBST"},
        {"INAMRAM"},
        {"INAMPNX"},
        {"INAMLOB"}
};

player_t *CPlayer;

patch_t *smallnum[10];
patch_t *midnum[12];
patch_t *numbers[11];
patch_t *keys[6];
patch_t *ammo[6];
patch_t *armor[2];

patch_t *arti[11];
patch_t *selectbox;

static void DrawNumber(signed int val, int x, int y)
{
	patch_t *patch;
        int xpos;
        int oldval;

        oldval = val;
        xpos = x;
        if(val < 0)
        {
                val = 0;
        }
        if(val > 99)
        {
                // Begin Duke code modification
                // Adjust HUD number spacing
                patch = numbers[val/100];
                if(gamemode == heretic)
                    V_DrawPatch(xpos+((12-patch->width)/2), y, 0, patch);
                else
                    V_DrawPatch(val/100 == 1 ? xpos+((12-patch->width)/2)-1 : xpos+((12-patch->width)/2), y, 0, patch);
        }
        val = val%100;
        xpos += 12;
        if(val > 9 || oldval > 99)
        {
                patch = numbers[val/10];
                if(gamemode == heretic)
                    V_DrawPatch(xpos+((12-patch->width)/2), y, 0, patch);
                else
                    V_DrawPatch(val/10 == 1 ? xpos+((12-patch->width)/2)-1 : xpos+((12-patch->width)/2), y, 0, patch);
        }
        val = val%10;
        xpos += 12;
        patch = numbers[val];
        if(gamemode == heretic)
            V_DrawPatch(xpos+((12-patch->width)/2), y, 0, patch);
        else
            V_DrawPatch(val == 1 ? xpos+((12-patch->width)/2)-1 : xpos+((12-patch->width)/2), y, 0, patch);
        // End Duke code modification
}

static void MidNumber(signed int val, int x, int y)
{
        patch_t *patch;
        int oldval;

        oldval = val;
        if(val < 0)
        {
                if(val < -9)
                {
                        V_DrawPatch(x+1, y+1, 0, midnum[11]);
                }
                else
                {
                        val = -val;
                        V_DrawPatch(x+18, y, 0, midnum[val]);
                        V_DrawPatch(x+9, y, 0, midnum[10]);
                }
                return;
        }
        if(val > 99)
        {
                patch = midnum[val/100];
                V_DrawPatch(x, y, 0, patch);
        }
        val = val%100;
        if(val > 9 || oldval > 99)
        {
                patch = midnum[val/10];
                V_DrawPatch(x+9, y, 0, patch);
        }
        val = val%10;
        patch = midnum[val];
        V_DrawPatch(x+18, y, 0, patch);
}

static void SmallNumber(int val, int x, int y)
{
        if(val == 1)
        {
                return;
        }
        if(val > 9)
        {
                V_DrawPatch(x, y, 0, smallnum[val/10]);
        }
        val = val%10;
        V_DrawPatch(x+4, y, 0, smallnum[val]);
}

// kgsws: now not palette
void PaletteFlash(void)
{
	unsigned int fadecolor;

	if(CPlayer->powers[pw_invulnerability]) {
		HWR_FadeInvulnerability();
		return;
	}

	if(CPlayer->damagecount) {
		if(CPlayer->damagecount > 50) CPlayer->damagecount = 50;
		fadecolor = ((CPlayer->damagecount * 4) << 24) | 0x000000FF;
		HWR_FadeScreenMenuBack(fadecolor, 0);
	}
	if(CPlayer->bonuscount) {
		if(CPlayer->bonuscount > 4) CPlayer->bonuscount = 4;
		fadecolor = ((CPlayer->bonuscount * 4) << 24) | 0x0000FFA0;
		HWR_FadeScreenMenuBack(fadecolor, 0);
	}
}

void DoomBAR()
{
        // Begin Duke code modification
        // Adjusted positions, swapped armor and ammo positions
	int temp;
	int by, yy, ry;
	if(CPlayer->playerstate != PST_DEAD)
		DrawNumber(CPlayer->mo->health, 6, 252);
	else
		DrawNumber(0, 6, 252);
        V_DrawPatch(44, 252, 0, ammo[4]);
	if(cv_deathmatch.value) {
                temp = ST_PlayerFrags(CPlayer-players);
                DrawNumber(temp, 439, 4);
        } else {
		ry = yy = ry = 2;
	        if(CPlayer->cards & it_bluecard) {
        	        V_DrawPatch(449, 3, 0, keys[0]);
			by = 9;
		}
		if(CPlayer->cards & it_yellowcard) {
			V_DrawPatch(459, 3, 0, keys[1]);
			yy = 9;
		}
		if(CPlayer->cards & it_redcard) {
			V_DrawPatch(469, 3, 0, keys[2]);
			ry = 9;
		}
	        if(CPlayer->cards & it_blueskull) {
        	        V_DrawPatch(449, by+1, 0, keys[3]);
		}
		if(CPlayer->cards & it_yellowskull) {
			V_DrawPatch(459, yy+1, 0, keys[4]);
		}
		if(CPlayer->cards & it_redskull) {
			V_DrawPatch(469, ry+1, 0, keys[5]);
		}
	}
        if(CPlayer->weaponinfo[CPlayer->readyweapon].ammo != am_noammo)
        {
                DrawNumber(CPlayer->ammo[CPlayer->weaponinfo[CPlayer->readyweapon].ammo], 422, 252);
                V_DrawPatch(460, 252, 0, ammo[CPlayer->weaponinfo[CPlayer->readyweapon].ammo]);
        }
	if(CPlayer->armorpoints > 0) {
		DrawNumber(CPlayer->armorpoints, 70, 252);
		V_DrawPatch(108, 252, 0, armor[CPlayer->armortype - 1]);
	}
}

void HereticBAR()
{
    int i;
    int x;
    int temp;
    int frame;
    static boolean hitCenterFrame;

	if(CPlayer->playerstate != PST_DEAD)
                DrawNumber(CPlayer->mo->health, 3, 251);
        else
                DrawNumber(0, 3, 251);
        if(cv_deathmatch.value) {
		temp = ST_PlayerFrags(CPlayer-players);
		MidNumber(temp, 449, 2);
        } else {
		if(CPlayer->cards & it_yellowcard) {
			V_DrawPatch(466, 4, 0, keys[0]);
		}
		if(CPlayer->cards & it_redcard) {
			V_DrawPatch(466, 11, 0, keys[1]);
		}
	        if(CPlayer->cards & it_bluecard) {
        	        V_DrawPatch(466, 18, 0, keys[2]);
		}
	}
        if(!CPlayer->st_inventoryTics)
        {
                if( CPlayer->inventory[CPlayer->inv_ptr].type > 0)
                {
                        V_DrawTranslucentPatch(446, 238, 0, arti[0]);
                        V_DrawPatch(446, 238, 0, arti[CPlayer->inventory[CPlayer->inv_ptr].type]);
                        SmallNumber(CPlayer->inventory[CPlayer->inv_ptr].count, 466, 260);
                }
        }
        else
        {
                x = CPlayer->inv_ptr-CPlayer->st_curpos;
                for(i = 0; i < 7; i++)
                {
                        V_DrawTranslucentPatch(150 + i*31, 240, 0, arti[0]);
                        if(CPlayer->inventorySlotNum > x+i
                                && CPlayer->inventory[x+i].type != arti_none)
                        {
                                V_DrawPatch(150 + i*31, 240, 0, arti[CPlayer->inventory[x+i].type]);
                                SmallNumber(CPlayer->inventory[x+i].count, 170 + i*31, 262);
                        }
                }
                V_DrawPatch(150 + CPlayer->st_curpos*31, 269, 0, selectbox);
/*                if(x != 0)
                {
                        V_DrawPatch(130, 239, 0, !(leveltime&4) ? PatchINVLFGEM1 : PatchINVLFGEM2);
                }
                if(CPlayer->inventorySlotNum-x > 7)
                {
                        V_DrawPatch(300, 239, 0, !(leveltime&4) ? PatchINVRTGEM1 : PatchINVRTGEM2);
                }*/
        }
        if(CPlayer->weaponinfo[CPlayer->readyweapon].ammo != am_noammo)
        {
                MidNumber(CPlayer->ammo[CPlayer->weaponinfo[CPlayer->readyweapon].ammo], 395, 255);
                V_DrawPatch(420, 253, 0, ammo[CPlayer->weaponinfo[CPlayer->readyweapon].ammo]);
        }

        if(CPlayer->armorpoints > 0)
            DrawNumber(CPlayer->armorpoints, 48, 251);
        // End Duke code modification
    
    // Flight icons
    // Begin Duke code modification
    // Edited to fix fly and tome powerup spinning icons
    if(CPlayer->powers[pw_flight])
    {
        int spinflylump = W_GetNumForName("SPFLY0");

        if(CPlayer->powers[pw_flight] > BLINKTHRESHOLD
            || !(CPlayer->powers[pw_flight]&16))
        {
            frame = (leveltime/3)&15;
            if(CPlayer->mo->flags2&MF2_FLY)
            {
                if(hitCenterFrame && (frame != 15 && frame != 0))
                {
                    V_DrawPatch(20, 17, 0, W_CachePatchNum(spinflylump+15, PU_CACHE));
                }
                else
                {
                    V_DrawPatch(20, 17, 0, W_CachePatchNum(spinflylump+frame, PU_CACHE));
                    hitCenterFrame = false;
                }
            }
            else
            {
                if(!hitCenterFrame && (frame != 15 && frame != 0))
                {
                    V_DrawPatch(20, 17, 0, W_CachePatchNum(spinflylump+frame, PU_CACHE));
                    hitCenterFrame = false;
                }
                else
                {
                    V_DrawPatch(20, 17, 0, W_CachePatchNum(spinflylump+15, PU_CACHE));
                    hitCenterFrame = true;
                }
            }
            //                  BorderTopRefresh = true;
            //                  UpdateState |= I_MESSAGES;
        }
        else
        {
            //                  BorderTopRefresh = true;
            //                  UpdateState |= I_MESSAGES;
        }
    }
    
    if(CPlayer->powers[pw_weaponlevel2] && !CPlayer->chickenTics)
    {
        int spinbooklump = W_GetNumForName("SPINBK0");

        if(CPlayer->powers[pw_weaponlevel2] > BLINKTHRESHOLD
            || !(CPlayer->powers[pw_weaponlevel2]&16))
        {
            frame = (leveltime/3)&15;
            V_DrawPatch(463, 16, 0, W_CachePatchNum(spinbooklump+frame, PU_CACHE));
            //                  BorderTopRefresh = true;
            //                  UpdateState |= I_MESSAGES;
        }
        else
        {
            //                  BorderTopRefresh = true;
            //                  UpdateState |= I_MESSAGES;
        }
    }
    // End Duke code modification
}

boolean ST_SameTeam(player_t *a,player_t *b)
{
    switch (cv_teamplay.value) {
       case 0 : return false;
       case 1 : return (a->skincolor == b->skincolor);
       case 2 : return (a->skin == b->skin);
    }
    return false;
}

int ST_PlayerFrags (int playernum)
{
    int    i,frags;

    frags = players[playernum].addfrags;
    for (i=0 ; i<MAXPLAYERS ; i++)
    {
        if ((cv_teamplay.value==0 && i != playernum)
         || (cv_teamplay.value && !ST_SameTeam(&players[i],&players[playernum])) )
            frags += players[playernum].frags[i];
        else
            frags -= players[playernum].frags[i];
    }

    return frags;
}

void ST_Drawer(boolean refresh)
{
	CPlayer = &players[consoleplayer];

	PaletteFlash();

	if(gamemode == heretic) HereticBAR();
	else DoomBAR();
}

int st_borderpatchnum;
byte namebuf[10];
void ST_Init (void)
{
	int     i;

	if(dedicated) return;

	if(gamemode == heretic) {
		for(i = 0; i < 10; i++) {
			sprintf(namebuf, "FONTB%i", i + 16);
			numbers[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 10; i++) {
			sprintf(namebuf, "IN%i", i);
			midnum[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 10; i++) {
			sprintf(namebuf, "SMALLIN%i", i);
			smallnum[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 6; i++) {
			ammo[i] = W_CachePatchName(ammopic[i], PU_CACHE);
		}
		numbers[10] = W_CachePatchName("FONTB13", PU_CACHE);
		midnum[10] = W_CachePatchName("NEGNUM", PU_CACHE);
		midnum[11] = W_CachePatchName("LAME", PU_CACHE);
		keys[0] = W_CachePatchName("YKEYICON", PU_CACHE);
		keys[1] = W_CachePatchName("GKEYICON", PU_CACHE);
		keys[2] = W_CachePatchName("BKEYICON", PU_CACHE);
		for(i = 0; i < 11; i++) {
			arti[i] = W_CachePatchName(patcharti[i], PU_CACHE);
		}
		selectbox = W_CachePatchName("SELECTBO", PU_CACHE);
	} else {
		for(i = 0; i < 10; i++) {
			sprintf(namebuf, "STTNUM%i", i);
			numbers[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 10; i++) {
			sprintf(namebuf, "STYSNUM%i", i);
			smallnum[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 6; i++) {
			sprintf(namebuf, "STKEYS%i", i);
			keys[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		for(i = 0; i < 4; i++) {
			sprintf(namebuf, "SBOAMMO%i", i + 1);
			ammo[i] = W_CachePatchNum(W_CheckNumForNamePwad(namebuf, 1, 0), PU_CACHE);
		}
		for(i = 0; i < 2; i++) {
			sprintf(namebuf, "SBOARM%i", i + 1);
			armor[i] = W_CachePatchName(namebuf, PU_CACHE);
		}
		numbers[10] = W_CachePatchName("STTMINUS", PU_CACHE);
		ammo[4] = W_CachePatchNum(W_CheckNumForNamePwad("SBOHEALT", 1, 0), PU_CACHE);
	}

    // kgsws: for m_menu.c
    switch(gamemode) {
        case commercial :
            // DOOM II border patch, original was GRNROCK
            st_borderpatchnum = W_GetNumForName ("GRNROCK");
            break;
        case heretic :
            if(W_CheckNumForName("e2m1")==-1)
                st_borderpatchnum = W_GetNumForName ("FLOOR04");
            else
                st_borderpatchnum = W_GetNumForName ("FLAT513");
            break;
        case hexen :
            st_borderpatchnum = W_GetNumForName ("F_022");
            break;
        default :
            // DOOM border patch.
            st_borderpatchnum = W_GetNumForName ("FLOOR7_2");
    }
}

//  Draw the status bar overlay, customisable : the user choose which
//  kind of information to overlay
//
/*
void ST_overlayDrawer ()
{
    char*  cmds;
    char   c;
    int    i;

    cmds = cv_stbaroverlay.string;

    while ((c=*cmds++))
    {
       if (c>='A' && c<='Z')
           c = c + 'a' - 'A';
       switch (c)
       {
         case 'h': // draw health
           ST_drawOverlayNum(SCX(50),
                             SCY(198)-(16*vid.dupy),
                             plyr->health,
                             tallnum,NULL);

           V_DrawPic (SCX(52),SCY(198)-16*vid.dupy,0,sbohealth);
           break;

         case 'f': // draw frags
           st_fragscount = ST_PlayerFrags(plyr-players);

           if (cv_deathmatch.value)
           {
               ST_drawOverlayNum(SCX(300),
                                 SCY(2),
                                 st_fragscount,
                                 tallnum,NULL);

               V_DrawPic (SCX(302),SCY(2),0,sbofrags);
           }
           break;

         case 'a': // draw ammo
           i = sboammo[plyr->readyweapon];
           if (i)
           {
               ST_drawOverlayNum(SCX(234),
                                 SCY(198)-(16*vid.dupy),
                                 plyr->ammo[plyr->weaponinfo[plyr->readyweapon].ammo],
                                 tallnum,NULL);

               V_DrawPic (SCX(236),SCY(198)-(16*vid.dupy),0,i);
           }
           break;

         case 'k': // draw keys
           c=1;
           for (i=0;i<3;i++)
                if( plyr->cards & (1<<(i+3)) ) // first skull then card
                    V_DrawPatch(SCX(318)-(c++)*(ST_KEY0WIDTH*vid.dupx), SCY(198)-((16+8)*vid.dupy), FG | V_NOSCALESTART, keys[i+3]);
                else
                if( plyr->cards & (1<<i) )
                    V_DrawPatch(SCX(318)-(c++)*(ST_KEY0WIDTH*vid.dupx), SCY(198)-((16+8)*vid.dupy), FG | V_NOSCALESTART, keys[i]);
           break;

         case 'm': // draw armor
           ST_drawOverlayNum(SCX(300),
                             SCY(198)-(16*vid.dupy),
                             plyr->armorpoints,
                             tallnum,NULL);

           V_DrawPic (SCX(302),SCY(198)-(16*vid.dupy),0,sboarmor);
           break;

         // added by Hurdler for single player only
         case 'e': // number of monster killed 
           if ( (!cv_deathmatch.value))
           {
               char buf[16];
               sprintf(buf, "%d/%d", plyr->killcount, totalkills);
               V_DrawString(SCX(318-V_StringWidth(buf)), SCY(1), V_NOSCALESTART, buf);

           }
           break;

         case 's': // number of secrets found
           if ( (!cv_deathmatch.value))
           {
               char buf[16];
               sprintf(buf, "%d/%d", plyr->secretcount, totalsecret);
               V_DrawString(SCX(318-V_StringWidth(buf)), SCY(11), V_NOSCALESTART, buf);
           }
           break;
       }
    }
}
*/
