// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: s_sound.c,v 1.30 2002/09/19 21:47:05 judgecutor Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: s_sound.c,v $
// Revision 1.30  2002/09/19 21:47:05  judgecutor
// no message
//
// Revision 1.29  2002/09/12 20:10:51  hurdler
// Added some cvars
//
// Revision 1.28  2002/08/16 20:19:36  judgecutor
// Sound pitching coming back
//
// Revision 1.27  2001/08/20 20:40:39  metzgermeister
// *** empty log message ***
//
// Revision 1.26  2001/05/27 13:42:48  bpereira
// no message
//
// Revision 1.25  2001/04/30 17:19:24  stroggonmeth
// HW fix and misc. changes
//
// Revision 1.24  2001/04/18 19:32:26  hurdler
// no message
//
// Revision 1.23  2001/04/17 22:26:07  calumr
// Initial Mac add
//
// Revision 1.22  2001/04/04 20:24:21  judgecutor
// Added support for the 3D Sound
//
// Revision 1.21  2001/04/02 18:54:32  bpereira
// no message
//
// Revision 1.20  2001/04/01 17:35:07  bpereira
// no message
//
// Revision 1.19  2001/03/03 11:11:49  hurdler
// I hate warnigs ;)
//
// Revision 1.18  2001/02/24 13:35:21  bpereira
// no message
//
// Revision 1.17  2001/01/27 11:02:36  bpereira
// no message
//
// Revision 1.16  2001/01/25 22:15:44  bpereira
// added heretic support
//
// Revision 1.15  2000/11/21 21:13:18  stroggonmeth
// Optimised 3D floors and fixed crashing bug in high resolutions.
//
// Revision 1.14  2000/11/12 21:59:53  hurdler
// Please verify that sound bug
//
// Revision 1.13  2000/11/03 11:48:40  hurdler
// Fix compiling problem under win32 with 3D-Floors and FragglScript (to verify!)
//
// Revision 1.12  2000/11/02 17:50:10  stroggonmeth
// Big 3Dfloors & FraggleScript commit!!
//
// Revision 1.11  2000/10/27 20:38:20  judgecutor
// - Added the SurroundSound support
//
// Revision 1.10  2000/09/28 20:57:18  bpereira
// no message
//
// Revision 1.9  2000/05/07 08:27:57  metzgermeister
// no message
//
// Revision 1.8  2000/04/22 16:16:50  emanne
// Correction de l'interface.
// Une erreur s'y tait gliss, d'o un segfault si on compilait sans SDL.
//
// Revision 1.7  2000/04/21 08:23:47  emanne
// To have SDL working.
// Makefile: made the hiding by "@" optional. See the CC variable at
// the begining. Sorry, but I like to see what's going on while building
//
// qmus2mid.h: force include of qmus2mid_sdl.h when needed.
// s_sound.c: ??!
// s_sound.h: with it.
// (sorry for s_sound.* : I had problems with cvs...)
//
// Revision 1.6  2000/03/29 19:39:48  bpereira
// no message
//
// Revision 1.5  2000/03/22 18:51:08  metzgermeister
// introduced I_PauseCD() for Linux
//
// Revision 1.4  2000/03/12 23:21:10  linuxcub
// Added consvars which hold the filenames and arguments which will be used
// when running the soundserver and musicserver (under Linux). I hope I
// didn't break anything ... Erling Jacobsen, linuxcub@email.dk
//
// Revision 1.3  2000/03/06 15:13:08  hurdler
// maybe a bug detected
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:  
//
//
//-----------------------------------------------------------------------------


#ifdef MUSSERV
#include <sys/msg.h>
struct musmsg {
  long msg_type;
  char msg_text[12];
};
extern int msg_id;
#endif

#include "doomdef.h"
#include "doomstat.h"
#include "command.h"
#include "g_game.h"
#include "m_argv.h"
#include "r_main.h"     //R_PointToAngle2() used to calc stereo sep.
//#include "r_things.h"     // for skins
#include "p_info.h"

#include "i_sound.h"
#include "s_sound.h"
#include "w_wad.h"
#include "z_zone.h"
#include "d_main.h"

#include "m_random.h"

// Begin Duke code modification
// Support for MP3 music
// Array of song numbers for music to be played on each level, current song being played, variable for stopping MP3 music on level load
#include "mp3.h"

short songlist[200];
short currentsong = 0;
boolean stopMP3 = true;
// End Duke code modification

// commands for music and sound servers
#ifdef MUSSERV
consvar_t musserver_cmd = {"musserver_cmd","musserver",0};
consvar_t musserver_arg = {"musserver_arg","-t 20 -f -u 0",0};
#endif
#ifdef SNDSERV
consvar_t sndserver_cmd = {"sndserver_cmd","llsndserv",0};
consvar_t sndserver_arg = {"sndserver_arg","-quiet",0};
#endif

#if defined (__WIN32__) && !defined (SURROUND)
#define SURROUND
#endif

#ifdef __MACOS__
consvar_t  play_mode = {"play_mode","0",0,CV_Unsigned};
#endif

// if true, all sounds are loaded at game startup
consvar_t precachesound = {"precachesound","0",0 ,CV_OnOff};

CV_PossibleValue_t soundvolume_cons_t[]={{0,"MIN"},{31,"MAX"},{0,NULL}};
// actual general (maximum) sound & music volume, saved into the config
// Begin Duke code modification
// Enabled sound and music volume cvars
consvar_t cv_soundvolume = {"soundvolume","15",CV_SAVE,soundvolume_cons_t};
consvar_t cv_musicvolume = {"musicvolume","15",CV_SAVE,soundvolume_cons_t};
// End Duke code modification
//consvar_t cv_rndsoundpitch = {"rndsoundpitch","Off",0 ,CV_OnOff};

// number of channels available
void SetChannelsNum(void);
consvar_t cv_numChannels = {"snd_channels","16",0 | CV_CALL, CV_Unsigned,SetChannelsNum};

#ifdef SURROUND
consvar_t surround = {"surround", "0", 0, CV_OnOff};
#endif

#define S_MAX_VOLUME            127

// when to clip out sounds
// Does not fit the large outdoor areas.
// added 2-2-98 in 8 bit volume control (befort  (1200*0x10000))
#define S_CLIPPING_DIST         (1200*0x10000)

// Distance tp origin when sounds should be maxed out.
// This should relate to movement clipping resolution
// (see BLOCKMAP handling).
// Originally: (200*0x10000).
// added 2-2-98 in 8 bit volume control (befort  (160*0x10000))
#define S_CLOSE_DIST            (160*0x10000)

// added 2-2-98 in 8 bit volume control (befort  remove the +4)
#define S_ATTENUATOR            ((S_CLIPPING_DIST-S_CLOSE_DIST)>>(FRACBITS+4))

// Adjustable by menu.
#define NORM_VOLUME             snd_MaxVolume

#define NORM_PITCH              128
#define NORM_PRIORITY           64
#define NORM_SEP                128

#define S_PITCH_PERTURB         1
#define S_STEREO_SWING          (96*0x10000)

#ifdef SURROUND
#define SURROUND_SEP            -128
#endif

// percent attenuation from front to back
#define S_IFRACVOL              30

typedef struct
{
    // sound information (if null, channel avail.)
    sfxinfo_t*  sfxinfo;

    // origin of sound
    void*       origin;

    // handle of the sound being played
    int         handle;

} channel_t;


// the set of channels available
static channel_t*       channels;

static int              nextcleanup;


//
// Internals.
//
int
S_getChannel
( void*         origin,
  sfxinfo_t*    sfxinfo );


int
S_AdjustSoundParams
( mobj_t*       listener,
  mobj_t*       source,
  int*          vol,
  int*          sep,
  int*          pitch );

static void S_StopChannel(int cnum);


void S_RegisterSoundStuff (void)
{
    if(dedicated)
	return;
    
    CV_RegisterVar (&precachesound);

#ifdef SNDSERV
    CV_RegisterVar (&sndserver_cmd);
    CV_RegisterVar (&sndserver_arg);
#endif
#ifdef MUSSERV
    CV_RegisterVar (&musserver_cmd);
    CV_RegisterVar (&musserver_arg);
#endif
#ifdef SURROUND
    CV_RegisterVar (&surround);
#endif

}

void SetChannelsNum(void)
{
    int i;

    // Allocating the internal channels for mixing
    // (the maximum number of sounds rendered
    // simultaneously) within zone memory.
    if(channels)
      Z_Free(channels);

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
    {
        HW3S_SetSourcesNum();
        return;
    }
#endif
    channels =
      (channel_t *) Z_Malloc(cv_numChannels.value*sizeof(channel_t), PU_STATIC, 0);

    // Free all channels for use
    for (i=0 ; i<cv_numChannels.value ; i++)
      channels[i].sfxinfo = 0;

    
}

//
// Initializes sound stuff, including volume
// Sets channels, SFX and music volume,
//  allocates channel buffer, sets S_sfx lookup.
//
void S_Init ( int           sfxVolume,
              int           musicVolume )
{
    int           i;

    if(dedicated)
	return;

    //CONS_Printf( "S_Init: default sfx volume %d\n", sfxVolume);

    S_SetSfxVolume (sfxVolume);

    SetChannelsNum();

    // Note that sounds have not been cached (yet).
    for (i=1 ; i<NUMSFX ; i++)
        S_sfx[i].lumpnum = S_sfx[i].usefulness = -1;      // for I_GetSfx()

    //
    //  precache sounds if requested by cmdline, or precachesound var true
    //
    if(!nosound && (M_CheckParm("-precachesound") || precachesound.value) )
    {
        // Initialize external data (all sounds) at start, keep static.
        CONS_Printf("Loading sounds... ");

        for (i=1 ; i<NUMSFX ; i++)
        {
            // NOTE: linked sounds use the link's data at StartSound time
            if (S_sfx[i].name && !S_sfx[i].link)
                S_sfx[i].data = I_GetSfx (&S_sfx[i]);
                    
        }

        CONS_Printf(" pre-cached all sound data\n");
    }

    // Begin Duke code modification
    // Array of song numbers for music to be played on each level
    songlist[0] = 1, // DOOM: E1M1
    songlist[1] = 2; // DOOM: E1M2
    songlist[2] = 3; // DOOM: E1M3
    songlist[3] = 4; // DOOM: E1M4
    songlist[4] = 5; // DOOM: E1M5
    songlist[5] = 6; // DOOM: E1M6
    songlist[6] = 7; // DOOM: E1M7
    songlist[7] = 8; // DOOM: E1M8
    songlist[8] = 9; // DOOM: E1M9
    songlist[9] = 10; // DOOM: E2M1
    songlist[10] = 11; // DOOM: E2M2
    songlist[11] = 12; // DOOM: E2M3
    songlist[12] = 13; // DOOM: E2M4
    songlist[13] = 7; // DOOM: E2M5
    songlist[14] = 14; // DOOM: E2M6
    songlist[15] = 15; // DOOM: E2M7
    songlist[16] = 16; // DOOM: E2M8
    songlist[17] = 17; // DOOM: E2M9
    songlist[18] = 17; // DOOM: E3M1
    songlist[19] = 18; // DOOM: E3M2
    songlist[20] = 19; // DOOM: E3M3
    songlist[21] = 8; // DOOM: E3M4
    songlist[22] = 7; // DOOM: E3M5
    songlist[23] = 6; // DOOM: E3M6
    songlist[24] = 15; // DOOM: E3M7
    songlist[25] = 20; // DOOM: E3M8
    songlist[26] = 9; // DOOM: E3M9
    songlist[27] = 8; // DOOM: E4M1
    songlist[28] = 18; // DOOM: E4M2
    songlist[29] = 19; // DOOM: E4M3
    songlist[30] = 5; // DOOM: E4M4
    songlist[31] = 15; // DOOM: E4M5
    songlist[32] = 13; // DOOM: E4M6
    songlist[33] = 14; // DOOM: E4M7
    songlist[34] = 7; // DOOM: E4M8
    songlist[35] = 9; // DOOM: E4M9
    songlist[36] = 12; // DOOM: End of level screen
    songlist[37] = 22; // DOOM: Title screen
    songlist[38] = 21; // DOOM: Intermission screen
    songlist[39] = 23; // DOOM: End of game screen
    songlist[40] = 24; // DOOM 2: MAP01
    songlist[41] = 25; // DOOM 2: MAP02
    songlist[42] = 26; // DOOM 2: MAP03
    songlist[43] = 27; // DOOM 2: MAP04
    songlist[44] = 28; // DOOM 2: MAP05
    songlist[45] = 29; // DOOM 2: MAP06
    songlist[46] = 30; // DOOM 2: MAP07
    songlist[47] = 31; // DOOM 2: MAP08
    songlist[48] = 32; // DOOM 2: MAP09
    songlist[49] = 33; // DOOM 2: MAP10
    songlist[50] = 25; // DOOM 2: MAP11
    songlist[51] = 29; // DOOM 2: MAP12
    songlist[52] = 28; // DOOM 2: MAP13
    songlist[53] = 31; // DOOM 2: MAP14
    songlist[54] = 24; // DOOM 2: MAP15
    songlist[55] = 33; // DOOM 2: MAP16
    songlist[56] = 25; // DOOM 2: MAP17
    songlist[57] = 34; // DOOM 2: MAP18
    songlist[58] = 30; // DOOM 2: MAP19
    songlist[59] = 35; // DOOM 2: MAP20
    songlist[60] = 26; // DOOM 2: MAP21
    songlist[61] = 31; // DOOM 2: MAP22
    songlist[62] = 36; // DOOM 2: MAP23
    songlist[63] = 29; // DOOM 2: MAP24
    songlist[64] = 37; // DOOM 2: MAP25
    songlist[65] = 35; // DOOM 2: MAP26
    songlist[66] = 34; // DOOM 2: MAP27
    songlist[67] = 38; // DOOM 2: MAP28
    songlist[68] = 30; // DOOM 2: MAP29
    songlist[69] = 39; // DOOM 2: MAP30
    songlist[70] = 40; // DOOM 2: MAP31
    songlist[71] = 41; // DOOM 2: MAP32
    songlist[72] = 42; // DOOM 2: End of level screen
    songlist[73] = 43; // DOOM 2: Title screen
    songlist[74] = 44; // DOOM 2: Intermission screen
    songlist[75] = 40; // DOOM 2: End of game screen
    songlist[76] = 45; // TNT: MAP01
    songlist[77] = 46; // TNT: MAP02
    songlist[78] = 35; // TNT: MAP03
    songlist[79] = 47; // TNT: MAP04
    songlist[80] = 48; // TNT: MAP05
    songlist[81] = 49; // TNT: MAP06
    songlist[82] = 50; // TNT: MAP07
    songlist[83] = 51; // TNT: MAP08
    songlist[84] = 45; // TNT: MAP09
    songlist[85] = 52; // TNT: MAP10
    songlist[86] = 53; // TNT: MAP11
    songlist[87] = 31; // TNT: MAP12
    songlist[88] = 47; // TNT: MAP13
    songlist[89] = 54; // TNT: MAP14
    songlist[90] = 46; // TNT: MAP15
    songlist[91] = 55; // TNT: MAP16
    songlist[92] = 48; // TNT: MAP17
    songlist[93] = 52; // TNT: MAP18
    songlist[94] = 26; // TNT: MAP19
    songlist[95] = 56; // TNT: MAP20
    songlist[96] = 32; // TNT: MAP21
    songlist[97] = 57; // TNT: MAP22
    songlist[98] = 36; // TNT: MAP23
    songlist[99] = 27; // TNT: MAP24
    songlist[100] = 28; // TNT: MAP25
    songlist[101] = 55; // TNT: MAP26
    songlist[102] = 51; // TNT: MAP27
    songlist[103] = 57; // TNT: MAP28
    songlist[104] = 47; // TNT: MAP29
    songlist[105] = 51; // TNT: MAP30
    songlist[106] = 58; // TNT: MAP31
    songlist[107] = 32; // TNT: MAP32
    songlist[108] = 58; // TNT: End of level screen
    songlist[109] = 59; // TNT: Title screen
    songlist[110] = 60; // TNT: Intermission screen
    songlist[111] = 58; // TNT: End of game screen
    songlist[112] = 2; // Plutonia: MAP01
    songlist[113] = 3; // Plutonia: MAP02
    songlist[114] = 6; // Plutonia: MAP03
    songlist[115] = 4; // Plutonia: MAP04
    songlist[116] = 9; // Plutonia: MAP05
    songlist[117] = 8; // Plutonia: MAP06
    songlist[118] = 10; // Plutonia: MAP07
    songlist[119] = 11; // Plutonia: MAP08
    songlist[120] = 19; // Plutonia: MAP09
    songlist[121] = 7; // Plutonia: MAP10
    songlist[122] = 23; // Plutonia: MAP11
    songlist[123] = 20; // Plutonia: MAP12
    songlist[124] = 18; // Plutonia: MAP13
    songlist[125] = 16; // Plutonia: MAP14
    songlist[126] = 15; // Plutonia: MAP15
    songlist[127] = 17; // Plutonia: MAP16
    songlist[128] = 1; // Plutonia: MAP17
    songlist[129] = 7; // Plutonia: MAP18
    songlist[130] = 5; // Plutonia: MAP19
    songlist[131] = 35; // Plutonia: MAP20
    songlist[132] = 44; // Plutonia: MAP21
    songlist[133] = 31; // Plutonia: MAP22
    songlist[134] = 36; // Plutonia: MAP23
    songlist[135] = 29; // Plutonia: MAP24
    songlist[136] = 37; // Plutonia: MAP25
    songlist[137] = 35; // Plutonia: MAP26
    songlist[138] = 10; // Plutonia: MAP27
    songlist[139] = 11; // Plutonia: MAP28
    songlist[140] = 1; // Plutonia: MAP29
    songlist[141] = 21; // Plutonia: MAP30
    songlist[142] = 8; // Plutonia: MAP31
    songlist[143] = 16; // Plutonia: MAP32
    songlist[144] = 42; // Plutonia: End of level screen
    songlist[145] = 43; // Plutonia: Title screen
    songlist[146] = 44; // Plutonia: Intermission screen
    songlist[147] = 8; // Plutonia: End of game screen
    songlist[148] = 61; // Heretic: E1M1
    songlist[149] = 62; // Heretic: E1M2
    songlist[150] = 63; // Heretic: E1M3
    songlist[151] = 64; // Heretic: E1M4
    songlist[152] = 65; // Heretic: E1M5
    songlist[153] = 66; // Heretic: E1M6
    songlist[154] = 67; // Heretic: E1M7
    songlist[155] = 68; // Heretic: E1M8
    songlist[156] = 69; // Heretic: E1M9
    songlist[157] = 70; // Heretic: E2M1
    songlist[158] = 71; // Heretic: E2M2
    songlist[159] = 72; // Heretic: E2M3
    songlist[160] = 73; // Heretic: E2M4
    songlist[161] = 64; // Heretic: E2M5
    songlist[162] = 74; // Heretic: E2M6
    songlist[163] = 75; // Heretic: E2M7
    songlist[164] = 76; // Heretic: E2M8
    songlist[165] = 77; // Heretic: E2M9
    songlist[166] = 61; // Heretic: E3M1
    songlist[167] = 78; // Heretic: E3M2
    songlist[168] = 79; // Heretic: E3M3
    songlist[169] = 66; // Heretic: E3M4
    songlist[170] = 63; // Heretic: E3M5
    songlist[171] = 62; // Heretic: E3M6
    songlist[172] = 65; // Heretic: E3M7
    songlist[173] = 69; // Heretic: E3M8
    songlist[174] = 74; // Heretic: E3M9
    songlist[175] = 66; // Heretic: E4M1
    songlist[176] = 62; // Heretic: E4M2
    songlist[177] = 63; // Heretic: E4M3
    songlist[178] = 64; // Heretic: E4M4
    songlist[179] = 65; // Heretic: E4M5
    songlist[180] = 61; // Heretic: E4M6
    songlist[181] = 67; // Heretic: E4M7
    songlist[182] = 68; // Heretic: E4M8
    songlist[183] = 69; // Heretic: E4M9
    songlist[184] = 70; // Heretic: E5M1
    songlist[185] = 71; // Heretic: E5M2
    songlist[186] = 72; // Heretic: E5M3
    songlist[187] = 73; // Heretic: E5M4
    songlist[188] = 64; // Heretic: E5M5
    songlist[189] = 74; // Heretic: E5M6
    songlist[190] = 75; // Heretic: E5M7
    songlist[191] = 76; // Heretic: E5M8
    songlist[192] = 77; // Heretic: E5M9
    songlist[193] = 78; // Heretic: E6M1
    songlist[194] = 79; // Heretic: E6M2
    songlist[195] = 66; // Heretic: E6M3
    songlist[196] = 80; // Heretic: End of level screen
    songlist[197] = 81; // Heretic: Title screen
    songlist[198] = 82; // Heretic: Intermission screen
    // End Duke code modification

    // Begin Duke code modification
    // Initialize MP3 Library
    mp3_init();
    // End Duke code modification
}

// Begin Duke code modification
// Stops any MP3 music playing and starts playing MP3 music based on type
// 0 = Play level music using current gameepisode and gamemap
// 1 = Play end of level screen music
// 2 = Play title screen music
// 3 = Play intermission screen music
// 4 = Play end of game screen music
void S_StartMP3Music(int type)
{
    extern boolean istnt, isplutonia;

    if(type == 0)
    {
        if(gameepisode < 1 || gamemap < 1)
            return;

        currentsong = S_GetLevelSongNum(gameepisode, gamemap);
    }
    else if(type == 1)
    {
        if(gamemode == shareware || gamemode == registered || gamemode == retail)
            currentsong = songlist[36];
        else if(istnt)
            currentsong = songlist[108];
        else if(isplutonia)
            currentsong = songlist[144];
        else if(gamemode == commercial)
            currentsong = songlist[72];
        else if(gamemode == heretic)
            currentsong = songlist[196];
    }
    else if(type == 2)
    {
        if(gamemode == shareware || gamemode == registered || gamemode == retail)
            currentsong = songlist[37];
        else if(istnt)
            currentsong = songlist[109];
        else if(isplutonia)
            currentsong = songlist[145];
        else if(gamemode == commercial)
            currentsong = songlist[73];
        else if(gamemode == heretic)
            currentsong = songlist[197];
    }
    else if(type == 3)
    {
        if(gamemode == shareware || gamemode == registered || gamemode == retail)
            currentsong = songlist[38];
        else if(istnt)
            currentsong = songlist[110];
        else if(isplutonia)
            currentsong = songlist[146];
        else if(gamemode == commercial)
            currentsong = songlist[74];
        else if(gamemode == heretic)
            currentsong = songlist[198];
    }
    else if(type == 4)
    {
        if(gamemode == shareware || gamemode == registered || gamemode == retail)
            currentsong = songlist[39];
        else if(istnt)
            currentsong = songlist[111];
        else if(isplutonia)
            currentsong = songlist[147];
        else if(gamemode == commercial)
            currentsong = songlist[75];
        else if(gamemode == heretic)
            return;
    }

    char path[20];
    sprintf(path, "music\\song%i.mp3", currentsong);

    mp3_job_started = 0;
    mp3_start_play(path, 0);
    mp3_job_started = 1;
}
// End Duke code modification

// Begin Duke code modification
// Returns the MP3 song number for the episode and map passed in, 0 if error
short S_GetLevelSongNum(int episode, int map)
{
    if(episode < 1 || map < 1)
        return 0;

    extern boolean istnt, isplutonia;
    short songnum = 0;

    if(gamemode == shareware || gamemode == registered || gamemode == retail)
        songnum = songlist[9*(episode-1)+(map-1)];
    else if(istnt)
        songnum = songlist[76+(map-1)];
    else if(isplutonia)
        songnum = songlist[112+(map-1)];
    else if(gamemode == commercial)
        songnum = songlist[40+(map-1)];
    else if(gamemode == heretic)
        songnum = songlist[148+(9*(episode-1)+(map-1))];

    return songnum;
}
// End Duke code modification

//  Retrieve the lump number of sfx
//
int S_GetSfxLumpNum (sfxinfo_t* sfx)
{
    char namebuf[9];
    int  sfxlump;

    if( gamemode == heretic || (unsigned int)sfx >= (unsigned int)&S_sfx[sfx_amb1])
        strncpy(namebuf, sfx->name, 9);
    else
        sprintf(namebuf, "ds%s", sfx->name);
    
    sfxlump=W_CheckNumForName(namebuf);
    if (sfxlump>0)
        return sfxlump;

/*    if( gamemode != heretic )
        strncpy(namebuf, sfx->name, 9);
    else
        sprintf(namebuf, "ds%s", sfx->name);

    sfxlump=W_CheckNumForName(namebuf);
    if (sfxlump>0)
        return sfxlump;*/

    if( gamemode == heretic)
        return W_GetNumForName ("keyup");
    else
        return W_GetNumForName ("dspistol");
}


//
// Per level startup code.
// Kills playing sounds at start of level,
//  determines music if any, changes music.
//

//SoM: Stop all sounds, load level info, THEN start sounds.
void S_StopSounds()
{
  int cnum;

#ifdef HW3SOUND
  if (hws_mode != HWS_DEFAULT_MODE)
  {
      HW3S_StopSounds();
      return;
  }
#endif

  // kill all playing sounds at start of level
  //  (trust me - a good idea)
  for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
    if (channels[cnum].sfxinfo)
      S_StopChannel(cnum);
}

void S_StartSoundAtVolume( void*         origin_p,
                           int           sfx_id,
                           int           volume )
{

    int           sep;
    int           pitch;
    int           priority;
    sfxinfo_t*    sfx;
    int           cnum;

    mobj_t*       origin = (mobj_t *) origin_p;

    if(nosound || (origin && origin->type == MT_SPIRIT))
        return;

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
    {
        HW3S_StartSound(origin, sfx_id);
        return;
    };
#endif

    // Debug.
    /*fprintf( stderr,
             "S_StartSoundAtVolume: playing sound %d (%s)\n",
             sfx_id, S_sfx[sfx_id].name );*/

#ifdef PARANOIA
    // check for bogus sound #
    if (sfx_id < 1 || sfx_id > NUMSFX)
        I_Error("Bad sfx #: %d\n", sfx_id);
#endif

    sfx = &S_sfx[sfx_id];

/*    if (sfx->skinsound!=-1 && origin && origin->skin)
    {
        // it redirect player sound to the sound in the skin table
        sfx_id = ((skin_t *)origin->skin)->soundsid[sfx->skinsound];
        sfx    = &S_sfx[sfx_id];
    }*/

    // Initialize sound parameters
    if (sfx->link)
    {
      pitch = sfx->pitch;
      priority = sfx->priority;
      volume += sfx->volume;

      if (volume < 1)
        return;

    // added 2-2-98 SfxVolume is now the hardware volume, don't mix up
    //    if (volume > SfxVolume)
    //      volume = SfxVolume;
    }
    else
    {
      pitch = NORM_PITCH;
      priority = NORM_PRIORITY;
    }


    // Check to see if it is audible,
    //  and if not, modify the params

    //added:16-01-98:changed consoleplayer to displayplayer
    if (origin && origin != players[displayplayer].mo)
    {
        int           rc,rc2;
        int volume2=volume,sep2/*=sep*/,pitch2=pitch;
        rc=S_AdjustSoundParams(players[displayplayer].mo,
                               origin,
                               &volume,
                               &sep,
                               &pitch);
        if(!rc) return;

        if ( origin->x == players[displayplayer].mo->x &&
             origin->y == players[displayplayer].mo->y )
      {
        sep       = NORM_SEP;
      }
    }
    else
    {
      sep = NORM_SEP;
    }

    // hacks to vary the sfx pitches

    //added:16-02-98: removed by Fab, because it used M_Random() and it
    //                was a big bug, and then it doesnt change anything
    //                dont hear any diff. maybe I'll put it back later
    //                but of course not using M_Random().
    //added 16-08-02: added back by Judgecutor
    //Sound pitching for both Doom and Heretic
/*    if (cv_rndsoundpitch.value)
    {
        if (gamemode != heretic)
        {
            if (sfx_id >= sfx_sawup && sfx_id <= sfx_sawhit)
                pitch += 8 - (M_Random()&15);
            else if (sfx_id != sfx_itemup && sfx_id != sfx_tink)
                pitch += 16 - (M_Random()&31);
        }
        else
            pitch = 128 + (M_Random() & 7) - (M_Random() & 7);
    }

    if (pitch < 0)
        pitch = NORM_PITCH;
    if (pitch > 255)
        pitch = 255;
*/
    // kill old sound
    S_StopSound(origin);

    // try to find a channel
    cnum = S_getChannel(origin, sfx);

    if (cnum<0)
      return;

    //
    // This is supposed to handle the loading/caching.
    // For some odd reason, the caching is done nearly
    //  each time the sound is needed?
    //

    // cache data if necessary
    // NOTE : set sfx->data NULL sfx->lump -1 to force a reload
    if (sfx->link)
        sfx->data = sfx->link->data;

    if (!sfx->data)
    {
        //CONS_Printf ("cached sound %s\n", sfx->name);
        if (!sfx->link)
            sfx->data = I_GetSfx (sfx);
        else
        {
            sfx->data = I_GetSfx (sfx->link);
            sfx->link->data = sfx->data;
        }
    }

    // increase the usefulness
    if (sfx->usefulness++ < 0)
        sfx->usefulness = -1;

    // Assigns the handle to one of the channels in the
    //  mix/output buffer.
    channels[cnum].handle = I_StartSound(sfx_id,
                                         /*sfx->data,*/
                                         volume,
                                         sep,
                                         pitch,
                                         priority);
}

void S_StartSound( void*         origin,
                   int           sfx_id )
{
    // the volume is handled 8 bits

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
        HW3S_StartSound(origin, sfx_id);
    else
#endif
        S_StartSoundAtVolume(origin, sfx_id, 255);
}


void S_StopSound(void *origin)
{
    int cnum;

    // SoM: Sounds without origion can have multiple sources, they shouldn't
    // be stoped by new sounds.
    if(!origin)
      return;

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
    {
        HW3S_StopSound(origin);
        return;
    }
    else
    {
#endif
       for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
       {
            if (channels[cnum].sfxinfo && channels[cnum].origin == origin)
            {
                S_StopChannel(cnum);
                break;
            }
        }
#ifdef HW3SOUND
    }
#endif
}

//
// Updates music & sounds
//
static int      actualsfxvolume;        //check for change through console
// Begin Duke code modification
// Added music volume "check" cvar
static int	actualmusvolume;
// End Duke code modification

void S_UpdateSounds(void)
{
    int         audible;
    int         cnum;
    int         volume;
    int         sep;
    int         pitch;
    sfxinfo_t*  sfx;
    channel_t*  c;

    mobj_t*     listener = players[displayplayer].mo;

    if(dedicated)
	return;
    
    // Update sound/music volumes, if changed manually at console
    if (actualsfxvolume != cv_soundvolume.value)
    {
	// Begin Duke code modification
	// Added to change PSP sound effect channel volume using volume slider
	actualsfxvolume = cv_soundvolume.value;
	pspAudioSetVolume(0, cv_soundvolume.value*1057, cv_soundvolume.value*1057);
        //S_SetSfxVolume (cv_soundvolume.value);
	// End Duke code modification
    }
    // Begin Duke code modification
    // Added to change PSP music channel volume using volume slider
    if (actualmusvolume != cv_musicvolume.value)
    {
	char path[20];
        sprintf(path, "music\\song%i.mp3", currentsong);

	actualmusvolume = cv_musicvolume.value;
	mp3_volume = actualmusvolume*1057;
	mp3_job_started = 0;
	mp3_start_play(path, 0);
    }
    // End Duke code modification

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
    {
        HW3S_UpdateSources();
        return;
    }
#endif

    /* Clean up unused data.
    if (gametic > nextcleanup)
    {
        for (i=1 ; i<NUMSFX ; i++)
        {
            if (S_sfx[i].usefulness==0)
            {
                //S_sfx[i].usefulness--;

                // don't forget to unlock it !!!
                // __dmpi_unlock_....
                //Z_ChangeTag(S_sfx[i].data, PU_CACHE);
                //S_sfx[i].data = 0;

                CONS_Printf ("\2flushed sfx %.6s\n", S_sfx[i].name);
            }
        }
        nextcleanup = gametic + 15;
    }*/

    for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
    {
        c = &channels[cnum];
        sfx = c->sfxinfo;

        if (c->sfxinfo)
        {
            if (I_SoundIsPlaying(c->handle))
            {
                // initialize parameters
                volume = 255;            //8 bits internal volume precision
                pitch = NORM_PITCH;
                sep = NORM_SEP;

                if (sfx->link) // strange (BP)
                {
                    pitch = sfx->pitch;
                    volume += sfx->volume;
                    if (volume < 1)
                    {
                        S_StopChannel(cnum);
                        continue;
                    }
                }

                // check non-local sounds for distance clipping
                //  or modify their params
                if (c->origin && listener != c->origin)
                {
                    int audible2;
                    int volume2=volume,sep2=sep,pitch2=pitch;
                    audible = S_AdjustSoundParams(listener,
                                                  c->origin,
                                                  &volume,
                                                  &sep,
                                                  &pitch);

                    if (!audible)
                    {
                        S_StopChannel(cnum);
                    }
                    else
                        I_UpdateSoundParams(c->handle, volume, sep, pitch);
                }
            }
            else
            {
                // if channel is allocated but sound has stopped,
                //  free it
                S_StopChannel(cnum);
            }
        }
    }
    // kill music if it is a single-play && finished
    // if (     mus_playing
    //      && !I_QrySongPlaying(mus_playing->handle)
    //      && !mus_paused )
    // S_StopMusic();

}

void S_SetSfxVolume(int volume)
{
volume = 31;
    if (volume < 0 || volume > 31)
        CONS_Printf("sfxvolume should be between 0-31\n");

/*    CV_SetValue (&cv_soundvolume, volume&31);
    actualsfxvolume = cv_soundvolume.value;       //check for change of var*/

#ifdef HW3SOUND
    hws_mode == HWS_DEFAULT_MODE 
        ? I_SetSfxVolume (volume&31)
        : HW3S_SetSfxVolume(volume & 31);
#else
    // now hardware volume
    I_SetSfxVolume(volume&31);
#endif

}

static void S_StopChannel(int cnum)
{

    int         i;
    channel_t*  c = &channels[cnum];

    if (c->sfxinfo)
    {
        // stop the sound playing
        if (I_SoundIsPlaying(c->handle))
        {
            I_StopSound(c->handle);
        }

        // check to see
        //  if other channels are playing the sound
        for (i=0 ; i<cv_numChannels.value ; i++)
        {
            if (cnum != i
                && c->sfxinfo == channels[i].sfxinfo)
            {
                break;
            }
        }

        // degrade usefulness of sound data
        c->sfxinfo->usefulness--;

        c->sfxinfo = 0;
    }
}



//
// Changes volume, stereo-separation, and pitch variables
//  from the norm of a sound effect to be played.
// If the sound is not audible, returns a 0.
// Otherwise, modifies parameters and returns 1.
//
int S_AdjustSoundParams ( mobj_t*       listener,
                          mobj_t*       source,
                          int*          vol,
                          int*          sep,
                          int*          pitch )
{
    fixed_t     approx_dist;
    fixed_t     adx;
    fixed_t     ady;
    angle_t     angle;

    // calculate the distance to sound origin
    //  and clip it if necessary
    adx = abs(listener->x - source->x);
    ady = abs(listener->y - source->y);

    // From _GG1_ p.428. Appox. eucledian distance fast.
    approx_dist = adx + ady - ((adx < ady ? adx : ady)>>1);

    if (gamemap != 8
        && approx_dist > S_CLIPPING_DIST)
    {
        return 0;
    }

    // angle of source to listener
    angle = R_PointToAngle2(listener->x,
                            listener->y,
                            source->x,
                            source->y);

    if (angle > listener->angle)
        angle = angle - listener->angle;
    else
        angle = angle + (0xffffffff - listener->angle);

#ifdef SURROUND
    
    // Produce a surround sound for angle from 105 till 255
    if (surround.value == 1 && (angle > (ANG90 + (ANG45/3)) && angle < (ANG270 - (ANG45/3))))
        *sep = SURROUND_SEP;
    else
    {
#endif

    angle >>= ANGLETOFINESHIFT;

    // stereo separation
    *sep = 128 - (FixedMul(S_STEREO_SWING,finesine[angle])>>FRACBITS);

#ifdef SURROUND
    }
#endif

    // volume calculation
    if (approx_dist < S_CLOSE_DIST)
    {
        // added 2-2-98 SfxVolume is now hardware volume
        *vol = 255; //snd_SfxVolume;
    }
    // removed hack here for gamemap==8 (it made far sound still present)
    else
    {
        // distance effect
        *vol = (15
                * ((S_CLIPPING_DIST - approx_dist)>>FRACBITS))
            / S_ATTENUATOR;
    }

    return (*vol > 0);
}




//
// S_getChannel :
//   If none available, return -1.  Otherwise channel #.
//
int S_getChannel( void*         origin,
                  sfxinfo_t*    sfxinfo )
{
    // channel number to use
    int         cnum;

    channel_t*  c;

    // Find an open channel
    for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
    {
        if (!channels[cnum].sfxinfo)
            break;
        else if (origin &&  channels[cnum].origin ==  origin)
        {
            S_StopChannel(cnum);
            break;
        }
    }

    // None available
    if (cnum == cv_numChannels.value)
    {
        // Look for lower priority
        for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
            if (channels[cnum].sfxinfo->priority >= sfxinfo->priority) break;

        if (cnum == cv_numChannels.value)
        {
            // FUCK!  No lower priority.  Sorry, Charlie.
            return -1;
        }
        else
        {
            // Otherwise, kick out lower priority.
            S_StopChannel(cnum);
        }
    }

    c = &channels[cnum];

    // channel is decided to be cnum.
    c->sfxinfo = sfxinfo;
    c->origin = origin;

    return cnum;
}


// SoM: Searches through the channels and checks for origin or id.
// returns 0 of not found, returns 1 if found.
// if id == -1, the don't check it...
int S_SoundPlaying(void *origin, int id)
{
    int         cnum;

#ifdef HW3SOUND
    if (hws_mode != HWS_DEFAULT_MODE)
    {
        return HW3S_SoundPlaying(origin, id);
    }
#endif

    for (cnum=0 ; cnum<cv_numChannels.value ; cnum++)
    {
        if (origin &&  channels[cnum].origin ==  origin)
          return 1;
        if (id != -1 && channels[cnum].sfxinfo - S_sfx == id)
          return 1;
    }
    return 0;
}


//
// S_StartSoundName
// Starts a sound using the given name.
#define MAXNEWSOUNDS 10
int     newsounds[MAXNEWSOUNDS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void S_StartSoundName(void *mo, char *soundname)
{
  int  i;
  int  soundnum = 0;
  //Search existing sounds...
  for(i = sfx_None + 1; i < NUMSFX; i++)
  {
    if(!S_sfx[i].name)
      continue;
    if(!stricmp(S_sfx[i].name, soundname))
    {
      soundnum = i;
      break;
    }
  }

  if(!soundnum)
  {
    for(i = 0; i < MAXNEWSOUNDS; i++)
    {
      if(newsounds[i] == 0)
        break;
      if(!S_SoundPlaying(NULL, newsounds[i]))
        {S_RemoveSoundFx(newsounds[i]); break;}
    }

    if(i == MAXNEWSOUNDS)
    {
      CONS_Printf("Cannot load another extra sound!\n");
      return;
    }

    soundnum = S_AddSoundFx(soundname, false);
    newsounds[i] = soundnum;
  }

  S_StartSound(mo, soundnum);
}

void S_StartAttackSound(const void *origin, int sfx_id)
{
        S_StartSound((void*)origin, sfx_id);
}

void S_StartScreamSound(const void *origin, int sfx_id)
{  
        S_StartSound((void*)origin, sfx_id);
}

void S_StartAmbientSound(int sfx_id, int volume)
{
        S_StartSoundAtVolume(NULL, sfx_id, volume);
}

