// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: r_opengl.c,v 1.60 2002/09/21 11:10:28 hurdler Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: r_opengl.c,v $
// Revision 1.60  2002/09/21 11:10:28  hurdler
// no message
//
// Revision 1.59  2002/06/30 21:37:48  hurdler
// Ready for 1.32 beta 5 release
//
// Revision 1.58  2002/01/05 16:39:19  hurdler
// Little fix
//
// Revision 1.57  2001/12/31 13:47:46  hurdler
// Add setcorona FS command and prepare the code for beta 4
//
// Revision 1.56  2001/12/27 22:50:26  hurdler
// fix a colormap bug, add scrolling floor/ceiling in hw mode
//
// Revision 1.55  2001/12/15 18:41:36  hurdler
// small commit, mainly splitscreen fix
//
// Revision 1.54  2001/08/27 19:59:35  hurdler
// Fix colormap in heretic + opengl, fixedcolormap and NEWCORONA
//
// Revision 1.53  2001/08/26 15:27:30  bpereira
// added fov for glide and fixed newcoronas code
//
// Revision 1.52  2001/08/19 15:40:07  bpereira
// added Treansform (and lighting) to glide
//
// Revision 1.51  2001/08/09 21:35:23  hurdler
// Add translucent 3D water in hw mode
//
// Revision 1.50  2001/08/08 20:34:44  hurdler
// Big TANDL update
//
// Revision 1.49  2001/08/07 00:44:06  hurdler
// MD2 implementation is getting better but still need lots of work
//
// Revision 1.48  2001/05/03 21:54:15  hurdler
// fix bis
//
// Revision 1.47  2001/05/03 20:05:57  hurdler
// small opengl fix
//
// Revision 1.46  2001/04/28 17:03:05  hurdler
// small fix for debug version and OS!=win32
//
// Revision 1.45  2001/04/28 15:19:32  hurdler
// fix PF_Occlude/PF_NoDepthTest
//
// Revision 1.44  2001/03/09 21:53:56  metzgermeister
// *** empty log message ***
//
// Revision 1.43  2001/02/28 17:50:56  bpereira
// no message
//
// Revision 1.42  2001/02/24 13:35:22  bpereira
// no message
//
// Revision 1.41  2001/02/19 17:45:20  hurdler
// Fix the problem of fullbright with Matrox's drivers under Linux
//
// Revision 1.40  2001/02/10 13:26:06  hurdler
// no message
//
// Revision 1.39  2001/01/25 18:56:28  bpereira
// no message
//
// Revision 1.38  2001/01/05 18:19:29  hurdler
// add renderer version checking
//
// Revision 1.37  2000/11/27 17:22:07  hurdler
// fix a small bug with GeForce based cards
//
// Revision 1.36  2000/11/02 19:49:39  bpereira
// no message
//
// Revision 1.35  2000/10/22 14:17:17  hurdler
// Adjust version string
//
// Revision 1.34  2000/10/04 16:27:56  hurdler
// Implement hardware texture memory stats
//
// Revision 1.33  2000/10/01 01:00:29  hurdler
// Fix a bug with PF_Invisible
//
// Revision 1.32  2000/09/28 20:57:21  bpereira
// no message
//
// Revision 1.31  2000/09/10 10:48:56  metzgermeister
// *** empty log message ***
//
// Revision 1.30  2000/08/10 19:58:04  bpereira
// no message
//
// Revision 1.29  2000/08/10 14:19:19  hurdler
// add waitvbl, fix sky problem
//
// Revision 1.28  2000/07/01 09:23:50  bpereira
// no message
//
// Revision 1.27  2000/06/08 19:41:53  hurdler
// my changes before splitting (can be reverted in development branch)
//
// Revision 1.26  2000/05/10 17:43:48  kegetys
// Sprites are drawn using PF_Environment
//
// Revision 1.25  2000/05/09 20:53:27  hurdler
// definitively fix the colormap
//
// Revision 1.24  2000/05/05 18:00:06  bpereira
// no message
//
// Revision 1.23  2000/04/30 10:30:10  bpereira
// no message
//
// Revision 1.22  2000/04/28 00:09:22  hurdler
// Full support of coronas in splitscreen mode
//
// Revision 1.21  2000/04/27 23:42:30  hurdler
// Change coronas' code for MiniGL compatibility
//
// Revision 1.20  2000/04/27 17:52:32  hurdler
// colormap code in hardware mode is now the default
//
// Revision 1.19  2000/04/24 15:20:40  hurdler
// Support colormap for text
//
// Revision 1.18  2000/04/23 15:07:37  hurdler
// quick bug fix
//
// Revision 1.17  2000/04/23 12:55:24  hurdler
// support filter mode in OpenGL
//
// Revision 1.16  2000/04/22 16:48:56  hurdler
// no message
//
// Revision 1.15  2000/04/22 16:48:00  hurdler
// support skin color
//
// Revision 1.14  2000/04/19 10:54:43  hurdler
// no message
//
// Revision 1.13  2000/04/18 16:07:47  hurdler
// better support of decals
//
// Revision 1.12  2000/04/18 14:49:25  hurdler
// fix a bug for Mesa 3.1 and previous
//
// Revision 1.11  2000/04/18 12:45:09  hurdler
// change a little coronas' code
//
// Revision 1.10  2000/04/16 18:38:07  bpereira
// no message
//
// Revision 1.9  2000/04/14 23:31:02  hurdler
// fix the bug of near clipping plane at startup
//
// Revision 1.8  2000/04/14 16:37:12  hurdler
// some nice changes for coronas
//
// Revision 1.7  2000/04/11 01:00:23  hurdler
// Better coronas support
//
// Revision 1.6  2000/04/09 17:18:24  hurdler
// modified coronas' code for 16 bits video mode
//
// Revision 1.5  2000/04/06 20:51:57  hurdler
// add support for new coronas
//
// Revision 1.4  2000/03/29 19:39:49  bpereira
// no message
//
// Revision 1.3  2000/03/07 03:31:14  hurdler
// fix linux compilation
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
// Rewrite  2009/04/04 kgsws
// Port to PSP GU
//
// DESCRIPTION:
//      GU API for Doom Legacy
//
//-----------------------------------------------------------------------------


#ifdef __WIN32__
#include <windows.h>
#pragma warning (disable : 4244)
#endif

#ifdef LINUX
#include <unistd.h>
#endif

#include <stdarg.h>
#include <math.h>
#include "r_gu.h"
//#include "vram.h"

// ==========================================================================
//                                                                  CONSTANTS
// ==========================================================================

// With OpenGL 1.1+, the first texture should be 1
#define NOTEXTURE_NUM     1     // small white texture
#define FIRST_TEX_AVAIL   (NOTEXTURE_NUM + 1)

#define N_PI_DEMI  (1.5707963268f)                  // PI/2

#define ASPECT_RATIO            (1.0f)  //(320.0f/200.0f)
#define FAR_CLIPPING_PLANE      9000.0f
float   NEAR_CLIPPING_PLANE =   3.99f;

#define MIPMAP_MASK     0x0100

// **************************************************************************
//                                                                    GLOBALS
// **************************************************************************


static  unsigned int      NextTexAvail    = FIRST_TEX_AVAIL;
static  unsigned int      tex_downloaded  = 0;
static  float     fov             = 90.0;
static  unsigned int      pal_col         = 0;
static  FRGBAFloat  const_pal_col;
static  FBITFIELD   CurrentPolyFlags;

int oglflags;

static  FTextureInfo*  gr_cachetail = NULL;
static  FTextureInfo*  gr_cachehead = NULL;

RGBA_t  myPaletteData[256];
int   screen_width;               // used by Draw2DLine()
int   screen_height;
byte  screen_depth;
int   textureformatGL;

int min_filter = GU_LINEAR;
int mag_filter = GU_LINEAR;

const   byte     *gl_extensions;

//Hurdler: 04/10/2000: added for the kick ass coronas as Boris wanted ;-)
/*#ifndef MINI_GL_COMPATIBILITY
static GLdouble    modelMatrix[16];
static GLdouble    projMatrix[16];
static int       viewport[4]; 
#endif*/


#ifdef USE_PALETTED_TEXTURE
    PFNGLCOLORTABLEEXTPROC  glColorTableEXT;
    GLboolean               usePalettedTexture;
    byte                 palette_tex[768];
#endif

// shortcut for ((float)1/i)
static const float    byte2float[256] = {
    0.000000f, 0.003922f, 0.007843f, 0.011765f, 0.015686f, 0.019608f, 0.023529f, 0.027451f,
    0.031373f, 0.035294f, 0.039216f, 0.043137f, 0.047059f, 0.050980f, 0.054902f, 0.058824f,
    0.062745f, 0.066667f, 0.070588f, 0.074510f, 0.078431f, 0.082353f, 0.086275f, 0.090196f,
    0.094118f, 0.098039f, 0.101961f, 0.105882f, 0.109804f, 0.113725f, 0.117647f, 0.121569f,
    0.125490f, 0.129412f, 0.133333f, 0.137255f, 0.141176f, 0.145098f, 0.149020f, 0.152941f,
    0.156863f, 0.160784f, 0.164706f, 0.168627f, 0.172549f, 0.176471f, 0.180392f, 0.184314f,
    0.188235f, 0.192157f, 0.196078f, 0.200000f, 0.203922f, 0.207843f, 0.211765f, 0.215686f,
    0.219608f, 0.223529f, 0.227451f, 0.231373f, 0.235294f, 0.239216f, 0.243137f, 0.247059f,
    0.250980f, 0.254902f, 0.258824f, 0.262745f, 0.266667f, 0.270588f, 0.274510f, 0.278431f,
    0.282353f, 0.286275f, 0.290196f, 0.294118f, 0.298039f, 0.301961f, 0.305882f, 0.309804f,
    0.313726f, 0.317647f, 0.321569f, 0.325490f, 0.329412f, 0.333333f, 0.337255f, 0.341176f,
    0.345098f, 0.349020f, 0.352941f, 0.356863f, 0.360784f, 0.364706f, 0.368627f, 0.372549f,
    0.376471f, 0.380392f, 0.384314f, 0.388235f, 0.392157f, 0.396078f, 0.400000f, 0.403922f,
    0.407843f, 0.411765f, 0.415686f, 0.419608f, 0.423529f, 0.427451f, 0.431373f, 0.435294f,
    0.439216f, 0.443137f, 0.447059f, 0.450980f, 0.454902f, 0.458824f, 0.462745f, 0.466667f,
    0.470588f, 0.474510f, 0.478431f, 0.482353f, 0.486275f, 0.490196f, 0.494118f, 0.498039f,
    0.501961f, 0.505882f, 0.509804f, 0.513726f, 0.517647f, 0.521569f, 0.525490f, 0.529412f,
    0.533333f, 0.537255f, 0.541177f, 0.545098f, 0.549020f, 0.552941f, 0.556863f, 0.560784f,
    0.564706f, 0.568627f, 0.572549f, 0.576471f, 0.580392f, 0.584314f, 0.588235f, 0.592157f,
    0.596078f, 0.600000f, 0.603922f, 0.607843f, 0.611765f, 0.615686f, 0.619608f, 0.623529f,
    0.627451f, 0.631373f, 0.635294f, 0.639216f, 0.643137f, 0.647059f, 0.650980f, 0.654902f,
    0.658824f, 0.662745f, 0.666667f, 0.670588f, 0.674510f, 0.678431f, 0.682353f, 0.686275f,
    0.690196f, 0.694118f, 0.698039f, 0.701961f, 0.705882f, 0.709804f, 0.713726f, 0.717647f,
    0.721569f, 0.725490f, 0.729412f, 0.733333f, 0.737255f, 0.741177f, 0.745098f, 0.749020f,
    0.752941f, 0.756863f, 0.760784f, 0.764706f, 0.768627f, 0.772549f, 0.776471f, 0.780392f,
    0.784314f, 0.788235f, 0.792157f, 0.796078f, 0.800000f, 0.803922f, 0.807843f, 0.811765f,
    0.815686f, 0.819608f, 0.823529f, 0.827451f, 0.831373f, 0.835294f, 0.839216f, 0.843137f,
    0.847059f, 0.850980f, 0.854902f, 0.858824f, 0.862745f, 0.866667f, 0.870588f, 0.874510f,
    0.878431f, 0.882353f, 0.886275f, 0.890196f, 0.894118f, 0.898039f, 0.901961f, 0.905882f,
    0.909804f, 0.913726f, 0.917647f, 0.921569f, 0.925490f, 0.929412f, 0.933333f, 0.937255f,
    0.941177f, 0.945098f, 0.949020f, 0.952941f, 0.956863f, 0.960784f, 0.964706f, 0.968628f,
    0.972549f, 0.976471f, 0.980392f, 0.984314f, 0.988235f, 0.992157f, 0.996078f, 1.000000
};


static I_Error_t I_Error_GL = NULL;

//
// VBHeap
//
#define VBHEAP_SIZE (4*1024*1024) // 4 megs is insanley high
void* vbheap = 0x0;
int vbheapcursor = 0;

void GU_InitMemory()
{
	vbheap = memalign(32, VBHEAP_SIZE);
	if(!vbheap)
		I_Error("VB heap malloc failed");	
	vbheap = (void*)((unsigned int)vbheap | 0x40000000);
}

void GU_FreeMemory()
{
	vbheap = (void *)((unsigned int)vbheap & ~0x40000000U);
	free(vbheap);
	vbheap = 0x0;
}

inline void* GU_VBAlloc(int size)
{
	void* mem = vbheap + vbheapcursor;
	vbheapcursor += size;
	vbheapcursor = (vbheapcursor+31)&~31;

//	if (vbheapcursor > VBHEAP_SIZE)
//		I_Error("Out of VB memory");

	return mem;
}

inline void GU_VBRewind()
{
	vbheapcursor = 0;
}


// -----------------+
// DBG_Printf       : Output error messages to debug log if DEBUG_TO_FILE is defined,
//                  : else do nothing
// Returns          :
// -----------------+
void DBG_Printf( LPCTSTR lpFmt, ... )
{
}


// -----------------+
// SetNoTexture     : Disable texture
// -----------------+
static void SetNoTexture( void )
{
/*    // Set small white texture.
    if( tex_downloaded != NOTEXTURE_NUM )
    {
        glBindTexture( GL_TEXTURE_2D, NOTEXTURE_NUM );
        tex_downloaded = NOTEXTURE_NUM;
    }*/
}


// -----------------+
// SetModelView     :
// -----------------+
void SetModelView( int w, int h )
{
//    DBG_Printf( "SetModelView(): %dx%d\n", w, h );
	screen_width = w;
	screen_height = h;

//	sceGuViewport(2048, 2048, w, h);

	sceGumMatrixMode(GU_PROJECTION);
	sceGumLoadIdentity();
	sceGumPerspective(fov, ASPECT_RATIO, NEAR_CLIPPING_PLANE, FAR_CLIPPING_PLANE);
	sceGumUpdateMatrix();

	sceGumMatrixMode(GU_MODEL);
	sceGumLoadIdentity();
	//glScalef(1.0f, 320.0f/200.0f, 1.0f);  // gr_scalefrustum (ORIGINAL_ASPECT)
}


// -----------------+
// SetStates        : Set permanent states
// -----------------+
ScePspFVector3 scale = {1.0f, 1.0f, 1.0f};
ScePspFVector3 rotate = {0.0f, -(GU_PI/2), 0.0f};

void SetStates( void )
{
    // Bind little white RGBA texture to ID NOTEXTURE_NUM.
	FUINT Data[8*8];
	int i;

//    DBG_Printf( "SetStates()\n" );

    // Hurdler: not necessary, is it?
    //sceGuShadeModel(GU_SMOOTH);
	sceGuShadeModel(GU_FLAT);

//    glEnable( GL_TEXTURE_2D );      // two-dimensional texturing
//    glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );

//    glAlphaFunc( GL_NOTEQUAL, 0 );
    //glDisable( GL_ALPHA_TEST );     // enable alpha testing
    //glBlendFunc( GL_ONE, GL_ZERO ); // copy pixel to frame buffer (opaque)
//    glEnable( GL_BLEND );           // enable color blending

//    glColorMask( GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE );

//    glDisable(GL_DITHER);         // faB: ??? (undocumented in OpenGL 1.1)
                                  // Hurdler: yes, it is!
	sceGuEnable(GU_DEPTH_TEST);    // check the depth buffer
//	sceGuDepthMask(GU_FALSE);             // enable writing to depth buffer
	sceGuClearDepth(0xFFFF);
	sceGuDepthRange(0, 0xFFFF);
	sceGuDepthFunc(GU_LEQUAL);

    // this set CurrentPolyFlags to the acctual configuration
	CurrentPolyFlags = 0xffffffff;
//	SetBlend(0);

	for(i=0; i<64; i++) Data[i] = 0xffFFffFF;       // white pixel

//	tex_downloaded = -1;
	SetNoTexture();
    //glBindTexture( GL_TEXTURE_2D, NOTEXTURE_NUM );
    //tex_downloaded = NOTEXTURE_NUM;
    //glTexImage2D( GL_TEXTURE_2D, 0, 4, 8, 8, 0, GL_RGBA, GL_UNSIGNED_BYTE, Data );

//	glPolygonOffset(-1.0, -1.0);

    //glEnable(GL_CULL_FACE);
    //glCullFace(GL_FRONT);
    //glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    //glPolygonMode(GL_FRONT, GL_LINE);

    //glFogi(GL_FOG_MODE, GL_EXP);
    //glHint(GL_FOG_HINT, GL_NICEST);
    //glFogfv(GL_FOG_COLOR, fogcolor);
    //glFogf(GL_FOG_DENSITY, 0.0005);

	sceGumMatrixMode(GU_MODEL);
	sceGumLoadIdentity();
	sceGumScale(&scale);
}

/*
// 8bit
int AddVramTexture(FTextureInfo *pTexInfo)
{
return 0;
	tex_downloaded++;
	pTexInfo->grInfo.vram = valloc(pTexInfo->height * pTexInfo->width);
	if(!pTexInfo->grInfo.vram) {
		tex_downloaded--;
		return 0;
	}
	pTexInfo->downloaded = tex_downloaded;
	memcpy((unsigned int)pTexInfo->grInfo.vram | 0x40000000, pTexInfo->grInfo.buff, pTexInfo->height * pTexInfo->width);

	pTexInfo->nextmipmap = NULL;
	if(gr_cachetail) {
		gr_cachetail->nextmipmap = pTexInfo;
		gr_cachetail = pTexInfo;
	} else gr_cachetail = gr_cachehead =  pTexInfo;

	return tex_downloaded;
}

void FreeVramTexture(FTextureInfo *pTexInfo)
{
	if(!pTexInfo->grInfo.vram) return;
	vfree(pTexInfo->grInfo.vram, pTexInfo->height * pTexInfo->width);
	pTexInfo->grInfo.vram = NULL;
}
*/

// -----------------+
// Flush            : flush OpenGL textures
//                  : Clear list of downloaded mipmaps
// -----------------+
void Flush( void )
{
/*    while( gr_cachehead )
    {
//        glDeleteTextures( 1, &gr_cachehead->downloaded );
        FreeVramTexture(gr_cachehead);
        gr_cachehead->downloaded = 0;
        gr_cachehead = gr_cachehead->nextmipmap;
    }*/
    gr_cachetail = gr_cachehead = NULL; //Hurdler: well, gr_cachehead is already NULL
    NextTexAvail = FIRST_TEX_AVAIL;
    tex_downloaded = 0;
}

// -----------------+
// Init             : Initialise the OpenGL interface API
// Returns          :
// -----------------+
boolean Init(I_Error_t FatalErrorFunction)
{
    I_Error_GL = FatalErrorFunction;
//    DBG_Printf ("%s v%d.%d%s\n", DRIVER_STRING, VERSION/100, VERSION%100, VERSIONSTRING);
    return 1;
}

// -----------------+
// ClearMipMapCache : Flush OpenGL textures from memory
// -----------------+
void ClearMipMapCache( void )
{
	Flush();
}


// -----------------+
// ReadRect         : Read a rectangle region of the truecolor framebuffer
//                  : store pixels as 16bit 565 RGB
// Returns          : 16bit 565 RGB pixel array stored in dst_data
// -----------------+
extern void *fbp0;
void ReadRect(int x, int y, int width, int height, unsigned short * dst_data)
{
	unsigned short *fbuf = (unsigned int)fbp0 | 0x44000000;
	unsigned short *buff;
	int py, px;
	for(py = y; py < y + height; py++) {
		buff = fbuf + py * 512;
		memcpy(dst_data, buff, width * 2);
	}
}

// -----------------+
// ClearBuffer      : Clear the color/alpha/depth buffer(s)
// -----------------+
void ClearBuffer(FBOOLEAN ColorMask, FBOOLEAN DepthMask, FRGBAFloat * ClearColor)
{
    // DBG_Printf ("ClearBuffer(%d)\n", alpha);
	FUINT ClearMask = 0;

	if(ColorMask) {
		if(ClearColor) {
/*			sceGuClearColor();
			glClearColor( ClearColor->red,
                          ClearColor->green,
                          ClearColor->blue,
                          ClearColor->alpha );*/
		}
		ClearMask |= GU_COLOR_BUFFER_BIT;
	}
	if(DepthMask) {
		ClearMask |= GU_DEPTH_BUFFER_BIT;
	}

//	SetBlend( DepthMask ? PF_Occlude | CurrentPolyFlags : CurrentPolyFlags&~PF_Occlude );
	sceGuClear(ClearMask);
}

// -----------------+
// SetBlend         : Set render mode
// -----------------+
// PF_Masked - we could use an ALPHA_TEST of GL_EQUAL, and alpha ref of 0,
//             is it faster when pixels are discarded ?
/*void SetBlend(FBITFIELD PolyFlags)
{
    FBITFIELD   Xor = CurrentPolyFlags^PolyFlags;
    if( Xor & ( PF_Blending|PF_Occlude|PF_NoTexture|PF_Modulated|PF_NoDepthTest|PF_Decal|PF_Invisible|PF_NoAlphaTest ) )
    {
        if( Xor&(PF_Blending) ) // if blending mode must be changed
        {
            switch(PolyFlags & PF_Blending) {
                case PF_Translucent & PF_Blending:
                     sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
//                     glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ); // alpha = level of transparency
                     break;
                case PF_Masked & PF_Blending:
                     sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
//                     sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_FIX, 0, 0);
//                     glBlendFunc( GL_SRC_ALPHA, GL_ZERO );                // 0 alpha = holes in texture
                     break;
                case PF_Additive & PF_Blending:
                     sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
//                     glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ); // alpha = level of transparency
//                     glBlendFunc( GL_SRC_ALPHA, GL_ONE );                 // src * alpha + dest
                     break;
                case PF_Environment & PF_Blending:
                     sceGuBlendFunc(GU_ADD, GU_FIX, GU_ONE_MINUS_SRC_ALPHA, 0xFFFFFFFF, 0);
//                     glBlendFunc( GL_ONE, GL_ONE_MINUS_SRC_ALPHA );
                     break;
                case PF_Substractive & PF_Blending:
                     // good for shadow
                     // not realy but what else ?
                     sceGuBlendFunc(GU_ADD, GU_FIX, GU_ONE_MINUS_SRC_COLOR, 0, 0);
//                     glBlendFunc( GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
                     break;
                default : // must be 0, otherwise it's an error
                     // No blending
                     sceGuDisable(GU_BLEND);
//                     sceGuBlendFunc(GU_ADD, GU_FIX, GU_FIX, 0xFFFFFFFF, 0);
//                     glBlendFunc( GL_ONE, GL_ZERO );   // the same as no blending
                     break;
            }
        }
        if( Xor & PF_NoAlphaTest)
        {
            if( PolyFlags & PF_NoAlphaTest)
                sceGuDisable(GU_ALPHA_TEST);
            else
                sceGuEnable(GU_ALPHA_TEST);      // discard 0 alpha pixels (holes in texture)
        }

        if( Xor & PF_Decal )
        {
            if( PolyFlags & PF_Decal )
                glEnable(GL_POLYGON_OFFSET_FILL);
            else
                glDisable(GL_POLYGON_OFFSET_FILL);
        }

        if( Xor&PF_NoDepthTest )
        {
            if( PolyFlags & PF_NoDepthTest )
            {
                sceGuDepthFunc(GU_ALWAYS);
            }
            else
                sceGuDepthFunc(GU_LEQUAL);
        }
        if( Xor&PF_Modulated )
        {
            if (oglflags & GLF_NOTEXENV)
            {
                if ( !(PolyFlags & PF_Modulated) )
                    glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
//sceGuDepthMask(GU_FALSE);
        if( Xor & PF_Occlude ) // depth test but (no) depth write
        {
            if (PolyFlags&PF_Occlude)
            {
                sceGuDepthMask(GU_TRUE);
            } else sceGuDepthMask(GU_FALSE);
        }
        ////Hurdler: not used if we don't define POLYSKY
        if( Xor & PF_Invisible )
        {                     
        }
        if( PolyFlags & PF_NoTexture )
        {
            SetNoTexture();
        }
    }
    CurrentPolyFlags = PolyFlags;
}*/
/*
#define MAXTEX 200

typedef struct {
	int w, h;
	int format;
	byte *data;
} texture_t;

texture_t textures[MAXTEX];

int tnum;

int GU_AddTexture(int format, int w, int h, byte *data)
{
	int datasize;
	if(format == GU_PSM_8888) datasize = w*h*4;
	else if(format == GU_PSM_T8) datasize = w*h;
	else I_Error("Usupported texture bpp");
	if(tnum == MAXTEX) I_Error("Too many textures");
	textures[tnum].w = w;
	textures[tnum].h = h;
	textures[tnum].format = format;
	textures[tnum].data = malloc(datasize);
	memcpy(textures[tnum].data, data, datasize);
	tnum++;
	return tnum - 1;
}

void GU_BindTexture(int number)
{
	if(number < 0 || number > tnum-1) I_Error("Wrong texture selected");
	sceGuTexMode(textures[number].format,0,0,0);
	sceGuTexImage(0, textures[number].w, textures[number].h, textures[number].w, textures[number].data);
	sceGuTexFunc(GU_TFX_ADD,GU_TCC_RGB);
	sceGuTexFilter(GU_NEAREST,GU_LINEAR);
}

void GU_UnloadTextures()
{
	int i;
	for(i = 0; i < tnum; i++) {
		free(textures[tnum].data);
		textures[tnum].data = NULL;
	}
	tnum = 0;
}
*/

void GU_SetTexture(int format, int w, int h, byte *data)
{
	sceGuTexMode(format, 0, 0, format == GU_PSM_T8);
	sceGuTexImage(0, w, h, w, data);
}

// -----------------+
// SetTexture       : The mipmap becomes the current texture source
// -----------------+
void SetTexture(FTextureInfo *pTexInfo)
{
	switch(pTexInfo->grInfo.format) {
		case GR_TEXFMT_ALPHA_8:
		case GR_TEXFMT_INTENSITY_8:
		case GR_TEXFMT_ALPHA_INTENSITY_44:
			GU_SetTexture(GU_PSM_T8, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
		case GR_TEXFMT_P_8:
			GU_SetTexture(GU_PSM_T8, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
		case GR_TEXFMT_RGB_565:
			GU_SetTexture(GU_PSM_5650, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
		case GR_TEXFMT_ARGB_1555:
			GU_SetTexture(GU_PSM_5551, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
		case GR_TEXFMT_ARGB_4444:
		case GR_TEXFMT_ALPHA_INTENSITY_88:
		case GR_TEXFMT_AP_88:
			GU_SetTexture(GU_PSM_5551, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
		case GR_RGBA:
			GU_SetTexture(GU_PSM_8888, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.buff);
		break;
	}

/*    if(pTexInfo->downloaded)
    {
        if (pTexInfo->downloaded != tex_downloaded)
        {
//            glBindTexture(GL_TEXTURE_2D, pTexInfo->downloaded);
            tex_downloaded = pTexInfo->downloaded;
        }
    }
    else
    {
        // Download a mipmap
        static RGBA_t   tex[256*256*2];
//	RGBA_t *tex;
        RGBA_t *ptex = tex;
        int             w, h;

        //DBG_Printf ("DownloadMipmap %d %x\n",NextTexAvail,pTexInfo->grInfo.data);

//	ptex = tex = memalign(16, 256*256*4);
//	if(!ptex) I_Error("Texture malloc error");

        w = pTexInfo->width;
        h = pTexInfo->height;

#ifdef USE_PALETTED_TEXTURE
        if( usePalettedTexture &&
            (pTexInfo->grInfo.format==GR_TEXFMT_P_8) &&
            !(pTexInfo->flags & TF_CHROMAKEYED) )
        {
            // do nothing here.
            // Not a problem with MiniGL since we don't use paletted texture
        }
        else
#endif
        if( (pTexInfo->grInfo.format==GR_TEXFMT_P_8) ||
            (pTexInfo->grInfo.format==GR_TEXFMT_AP_88) )
        {
            byte *pImgData;
            int i, j;

            pImgData = (byte *)pTexInfo->grInfo.data;
            for( j=0; j<h; j++ )
            {
                for( i=0; i<w; i++)
                {
                    if ( (*pImgData==HWR_PATCHES_CHROMAKEY_COLORINDEX) &&
                         (pTexInfo->flags & TF_CHROMAKEYED) )
                    {
                        tex[w*j+i].s.red   = 0;
                        tex[w*j+i].s.green = 0;
                        tex[w*j+i].s.blue  = 0;
                        tex[w*j+i].s.alpha = 0;
                    }
                    else
                    {
                        tex[w*j+i].s.red   = myPaletteData[*pImgData].s.red;
                        tex[w*j+i].s.green = myPaletteData[*pImgData].s.green;
                        tex[w*j+i].s.blue  = myPaletteData[*pImgData].s.blue;
                        tex[w*j+i].s.alpha = 0xFF;//myPaletteData[*pImgData].s.alpha;
                    }

                    pImgData++;

                    if( pTexInfo->grInfo.format == GR_TEXFMT_AP_88 )
                    {
                        if( !(pTexInfo->flags & TF_CHROMAKEYED) )
                            tex[w*j+i].s.alpha = *pImgData;
                        pImgData++;
                    }

                }
            }
        }
        else if (pTexInfo->grInfo.format==GR_RGBA)            
        {
            // corona test : passed as ARGB 8888, which is not in glide formats
            // Hurdler: not used for coronas anymore, just for dynamic lighting
            ptex = (RGBA_t *) pTexInfo->grInfo.data;
        }
        else if (pTexInfo->grInfo.format==GR_TEXFMT_ALPHA_INTENSITY_88)
        {
            byte *pImgData;
            int i, j;

            pImgData = (byte *)pTexInfo->grInfo.data;
            for( j=0; j<h; j++ )
            {
                for( i=0; i<w; i++)
                {
                    tex[w*j+i].s.red   = *pImgData;
                    tex[w*j+i].s.green = *pImgData;
                    tex[w*j+i].s.blue  = *pImgData;
                    pImgData++;
                    tex[w*j+i].s.alpha = *pImgData;
                    pImgData++;
                }
            }
        }
//        else
//            DBG_Printf ("SetTexture(bad format) %d\n", pTexInfo->grInfo.format);
        pTexInfo->downloaded = NextTexAvail++;
        tex_downloaded = pTexInfo->downloaded;
//        glBindTexture( GL_TEXTURE_2D, pTexInfo->downloaded );
/*
#ifdef USE_PALETTED_TEXTURE
            //Hurdler: not really supported and not tested recently
        if( usePalettedTexture &&
            (pTexInfo->grInfo.format==GR_TEXFMT_P_8) &&
            !(pTexInfo->flags & TF_CHROMAKEYED) )
        {
//            glColorTableEXT(GL_TEXTURE_2D, GL_RGB8, 256, GL_RGB, GL_UNSIGNED_BYTE, palette_tex);
//            glTexImage2D( GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, w, h, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, pTexInfo->grInfo.data );
        }
        else
#endif*//*

//        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, mag_filter);
//        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, min_filter);

        pTexInfo->nextmipmap = NULL;
        if (gr_cachetail) { // insertion en fin de liste
            gr_cachetail->nextmipmap = pTexInfo;
            gr_cachetail = pTexInfo;
        }
        else // initialisation de la liste
            gr_cachetail = gr_cachehead =  pTexInfo;
    }
    if(pTexInfo->grInfo.data) {
        if (pTexInfo->grInfo.format==GR_TEXFMT_ALPHA_INTENSITY_88)
        {
		GU_SetTexture(GU_PSM_8888, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.data);
        }
        else 
        {
		GU_SetTexture(GU_PSM_8888, pTexInfo->width, pTexInfo->height, pTexInfo->grInfo.data);
        }
    }*/
}

//int num_drawn_poly;

// -----------------+
// DrawPolygon      : Render a polygon, set the texture, set render mode
// -----------------+

poly_vertex_t __attribute__((aligned(32))) point;

void DrawPolygon(FSurfaceInfo *pSurf, FOutVector *pOutVerts, FUINT iNumPts, FBITFIELD PolyFlags)
{
	int i;
	poly_vertex_t* vb = GU_VBAlloc(iNumPts*sizeof(poly_vertex_t));
	poly_vertex_t* v = vb;

	if(PolyFlags & PF_MD2) return;

	if(PolyFlags & PF_Blending) sceGuEnable(GU_BLEND);
	else sceGuDisable(GU_BLEND);

	if(PolyFlags & PF_NoDepthTest) sceGuDepthFunc(GU_ALWAYS);
	else sceGuDepthFunc(GU_LEQUAL);
	
	sceGuDepthMask((PolyFlags & PF_Occlude) ? 0 : 0xFFFF);

	if(PolyFlags & PF_NoTexture) sceGuDisable(GU_TEXTURE_2D); else sceGuEnable(GU_TEXTURE_2D);

	if((PolyFlags & PF_Modulated) && pSurf) {
		sceGuAmbientColor(pSurf->FlatColor.rgba);
		sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
	} else sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);

	for(i = 0; i < iNumPts; i++) {
		v->x = pOutVerts[i].x;
		v->y = pOutVerts[i].y;
		v->z = pOutVerts[i].z;
		v->u = pOutVerts[i].sow;
		v->v = pOutVerts[i].tow;
		v++;
	}
	sceGumDrawArray(GU_TRIANGLE_FAN, GU_TEXTURE_32BITF|GU_VERTEX_32BITF|GU_TRANSFORM_3D, iNumPts, 0, vb);
}


// ==========================================================================
//
// ==========================================================================
void SetSpecialState(hwdspecialstate_t IdState, int Value)
{
/*    switch (IdState)
    {
        case 77: {
            //08/01/00: Hurdler this is a test for mirror
            if (!Value)
                ClearBuffer( false, true, 0 ); // clear depth buffer
            break;
        }

        case HWD_SET_PALETTECOLOR: {
            pal_col = Value;
            const_pal_col.blue  = byte2float[((Value>>16)&0xff)];
            const_pal_col.green = byte2float[((Value>>8)&0xff)];
            const_pal_col.red   = byte2float[((Value)&0xff)];
            break;
        }

        case HWD_SET_FOG_COLOR: {
            float fogcolor[4];

            fogcolor[0] = byte2float[((Value>>16)&0xff)];
            fogcolor[1] = byte2float[((Value>>8)&0xff)];
            fogcolor[2] = byte2float[((Value)&0xff)];
            fogcolor[3] = 0x0;
            glFogfv(GL_FOG_COLOR, fogcolor);
            break;
        }
        case HWD_SET_FOG_DENSITY:
            glFogf(GL_FOG_DENSITY, Value*1200/(500*1000000.0f));
            break;

        case HWD_SET_FOG_MODE:
            if (Value)
            {
                glEnable(GL_FOG);
                // experimental code
                /-*
                switch (Value)
                {
                    case 1:
                        glFogi(GL_FOG_MODE, GL_LINEAR);
                        glFogf(GL_FOG_START, -1000.0f);
                        glFogf(GL_FOG_END, 2000.0f);
                        break;
                    case 2:
                        glFogi(GL_FOG_MODE, GL_EXP);
                        break;
                    case 3:
                        glFogi(GL_FOG_MODE, GL_EXP2);
                        break;
                }
                *-/
            }
            else
                glDisable(GL_FOG);
            break;

        case HWD_SET_POLYGON_SMOOTH:
            if (Value)
                glEnable(GL_POLYGON_SMOOTH);
            else
                glDisable(GL_POLYGON_SMOOTH);
            break;

        case HWD_SET_TEXTUREFILTERMODE:
            switch (Value) 
            {
                case HWD_SET_TEXTUREFILTER_TRILINEAR:
                    min_filter = mag_filter = GL_LINEAR_MIPMAP_LINEAR;
                    break;
                case HWD_SET_TEXTUREFILTER_BILINEAR :
                    min_filter = mag_filter = GL_LINEAR;
                    break;
                case HWD_SET_TEXTUREFILTER_POINTSAMPLED :
                    min_filter = mag_filter = GL_NEAREST;
                    break;
                case HWD_SET_TEXTUREFILTER_MIXED1 :
                    mag_filter = GL_LINEAR;
                    min_filter = GL_NEAREST;
                    break;
                case HWD_SET_TEXTUREFILTER_MIXED2 :
                    mag_filter = GL_NEAREST;
                    min_filter = GL_LINEAR;
                    break;
            }
            Flush(); //??? if we want to change filter mode by texture, remove this

        default:
            break;
    }*/
}

FTransform  md2_transform;

// -----------------+
// HWRAPI DrawMD2   : Draw an MD2 model with glcommands
// -----------------+
//void (DrawMD2 ) (md2_model_t *model, int frame)
void DrawMD2(int *gl_cmd_buffer, md2_frame_t *frame, FTransform *pos, float scale)
{
/*    int     val, count, index;
    float s, t;

    //TODO: Maybe we can put all this in a display list the first time it's
    //      called and after, use this display list: faster (how much?) but
    //      require more memory (how much?)

    DrawPolygon( NULL, NULL, 0, PF_Masked|PF_Modulated|PF_Occlude|PF_Clip);

    glPushMatrix(); // should be the same as glLoadIdentity
    //Hurdler: now it seems to work
    glTranslatef(pos->x, pos->z, pos->y);
    glRotatef(pos->angley, 0.0f, -1.0f, 0.0f);
    glRotatef(pos->anglex, -1.0f, 0.0f, 0.0f);
    glScalef(scale, scale, scale);

    val = *gl_cmd_buffer++;

    while (val != 0)
    {
        if (val < 0)
        {
            glBegin (GL_TRIANGLE_FAN);
            count = -val;
        }
        else
        {
            glBegin (GL_TRIANGLE_STRIP);
            count = val;
        }

        while (count--)
        {
            s = *(float *) gl_cmd_buffer++;
            t = *(float *) gl_cmd_buffer++;
            index = *gl_cmd_buffer++;

            glTexCoord2f (s, t);
            glVertex3f (frame->vertices[index].vertex[0]/2.0f,
                        frame->vertices[index].vertex[1]/2.0f,
                        frame->vertices[index].vertex[2]/2.0f);
        }

        glEnd ();

        val = *gl_cmd_buffer++;
    }
    glPopMatrix(); // should be the same as glLoadIdentity*/
}

#define DEG2RAD(deg) ((GU_PI/180.0f)*(deg))
// -----------------+
// SetTransform     : 
// -----------------+
void SetTransform(FTransform *transform)
{
	ScePspFVector3 vector;
	static int special_splitscreen;
	if(transform) {
		// keep a trace of the transformation for md2
		memcpy(&md2_transform, transform, sizeof(md2_transform));
		sceGumMatrixMode(GU_PROJECTION);
		sceGumLoadIdentity();
		sceGumPerspective(transform->fovxangle, ASPECT_RATIO, NEAR_CLIPPING_PLANE, FAR_CLIPPING_PLANE);
		sceGumMatrixMode(GU_VIEW);
		sceGumLoadIdentity();
		vector.x = transform->scalex;
		vector.y = transform->scaley;
		vector.z = -transform->scalez;
		sceGumScale(&vector);
//		glScalef(transform->scalex, transform->scaley, -transform->scalez);
		vector.x = transform->anglex;
		vector.y = (transform->angley - (GU_PI/2));
		vector.z = 0.0f;
		sceGumRotateXYZ(&vector);
//		glRotatef(transform->anglex       , 1.0, 0.0, 0.0);
//		glRotatef(transform->angley+270.0f, 0.0, 1.0, 0.0);
		vector.x = -transform->x;
		vector.y = -transform->z;
		vector.z = -transform->y;
		sceGumTranslate(&vector);

		sceGumUpdateMatrix();
		sceGumMatrixMode(GU_MODEL);
		sceGumLoadIdentity();

//		glTranslatef(-transform->x, -transform->z, -transform->y);
	} else {
		sceGumMatrixMode(GU_PROJECTION);
		sceGumLoadIdentity();
		sceGumPerspective(fov, ASPECT_RATIO, NEAR_CLIPPING_PLANE, FAR_CLIPPING_PLANE);
		sceGumMatrixMode(GU_VIEW);
		sceGumLoadIdentity();
		vector.x = 1.0f;
		vector.y = 1.0f;
		vector.z = -1.0f;
		sceGumScale(&vector);
		sceGumMatrixMode(GU_MODEL);
		sceGumLoadIdentity();
    }
}

int GetTextureUsed(void)
{
/*    FTextureInfo*   tmp = gr_cachehead;
    int             res = 0;

    while (tmp)
    {
        res += tmp->height*tmp->width*(screen_depth/8);
        tmp = tmp->nextmipmap;
    }
    return res;*/return 1;
}

int GetRenderVersion(void)
{
    return VERSION;
}

//extern int started;
void GU_DrawPatch(patch_vertex_t *iv, FSurfaceInfo *pSurf, FBITFIELD PolyFlags)
{
	if(PolyFlags & PF_NoTexture) sceGuDisable(GU_TEXTURE_2D); else sceGuEnable(GU_TEXTURE_2D);

	if((PolyFlags & PF_Modulated) && pSurf) {
		sceGuAmbientColor(pSurf->FlatColor.rgba);
		sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
	} else sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);

	if(PolyFlags & PF_Blending) sceGuEnable(GU_BLEND);
	else sceGuDisable(GU_BLEND);

	sceGuDepthMask((PolyFlags & PF_Occlude) ? 0 : 0xFFFF);

	void* vb = GU_VBAlloc(2*sizeof(patch_vertex_t));
	memcpy(vb, iv, 2*sizeof(patch_vertex_t));
	sceGumDrawArray(GU_SPRITES, GU_TEXTURE_32BITF|GU_VERTEX_32BITF|GU_TRANSFORM_2D, 2, 0, vb);
}

void GU_DrawLine(F2DCoord* v0, F2DCoord* v1, RGBA_t color)
{
	poly_vertex_t* vb = GU_VBAlloc(2*sizeof(poly_vertex_t)); 
	memset(vb, 0, 2*sizeof(poly_vertex_t));
	vb[0].x = v0->x;
	vb[0].y = v0->y;
	vb[1].x = v1->x;
	vb[1].y = v1->y;

	sceGuAmbientColor(color.rgba);
	sceGuDisable(GU_TEXTURE_2D);
	sceGumDrawArray(GU_LINES, GU_TEXTURE_32BITF|GU_VERTEX_32BITF|GU_TRANSFORM_2D, 2, 0, vb);
}

void GU_Finish()
{
	GU_VBRewind();
}
