// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: I_video.c,v 1.5 2001/04/27 13:32:14 bpereira Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: I_video.c,v $
// Revision 1.5  2001/04/27 13:32:14  bpereira
// no message
//
// Revision 1.4  2000/11/02 19:49:38  bpereira
// no message
//
// Revision 1.3  2000/08/31 14:30:57  bpereira
// no message
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      hardware and software level, screen and video i/o, refresh,
//      setup ... a big mess. Got to clean that up!
//
//-----------------------------------------------------------------------------

#include "doomdef.h"
#include "i_system.h"
#include "v_video.h"
#include "m_argv.h"
#include "i_video.h"

#include "hw_drv.h"
#include "hw_main.h"

#include "z_zone.h"

char *finalpal;
void *dList;
void *fbp0;

void VID_Init();

//dosstuff -newly added
unsigned long dascreen;

boolean    highcolor;

#define SCREENDEPTH   1     // bytes per pixel, do NOT change.

//
// I_StartFrame
//
void I_StartFrame (void)
{

}

//
// I_OsPolling
//
void I_OsPolling()
{
    I_GetEvent();
    //i dont think i have to do anything else here
}


//
// I_UpdateNoBlit
//
int vykreslit = 0;

void I_UpdateNoBlit (void)
{
/*	if(rendermode != render_soft) {
		vykreslit = 1;
		sceGuStart(GU_DIRECT, dList);
		sceGuClearColor(0xff000000);
		sceGuClearDepth(0);
		sceGuClear(GU_COLOR_BUFFER_BIT|GU_DEPTH_BUFFER_BIT);
	}*/
}


//profile stuff ---------------------------------------------------------
//added:16-01-98:wanted to profile the VID_BlitLinearScreen() asm code.
//#define TIMING      //uncomment this to enable profiling
#ifdef TIMING
#include "../p5prof.h"
static   long long mycount;
static   long long mytotal = 0;
static   unsigned long  nombre = TICRATE*10;
//static   char runtest[10][80];
#endif
//profile stuff ---------------------------------------------------------


#define FPSPOINTS  35
#define SCALE      4
#define PUTDOT(xx,yy,cc) screens[0][((yy)*vid.width+(xx))*vid.bpp]=(cc)

int fpsgraph[FPSPOINTS];

//
// I_FinishUpdate
//
void I_FinishUpdate (void)
{
	GU_Finish();
	sceGuFinish();
	sceGuSync(0,0);
	sceDisplayWaitVblankStart();
	fbp0 = sceGuSwapBuffers();

	sceGuStart(GU_DIRECT, dList);
}


//
// I_ReadScreen
//
void I_ReadScreen (byte* scr)
{
    memcpy (scr, vid.buffer, vid.width*vid.height*vid.bpp);
}


void I_SetPalette (RGBA_t* palette)
{
	if(!finalpal) return;
	memcpy(finalpal, palette, 1024);
	sceGuClutMode(GU_PSM_8888,0,0xFF,0);
	sceGuClutLoad(32,finalpal);
	sceKernelDcacheWritebackRange(finalpal, 1024);
}
//
//  Close the screen, restore previous video mode.
//
void I_ShutdownGraphics (void)
{
	if(!graphics_started) return;

	if(vid.buffer) free(vid.buffer);

	GU_FreeMemory();

	sceGuTerm();
	free(dList);

	graphics_started = false;
}

//added:08-01-98: now uses Allegro to setup Linear Frame Buffer video modes.
//
//  Initialize video mode, setup dynamic screen size variables,
//  and allocate screens.
//
void I_StartupGraphics(void)
{
    //added:26-01-98: VID_Init() must be done only once,
    //                use VID_SetMode() to change vid mode while in the game.
    if( graphics_started )
        return;

    CONS_Printf("Vid_Init...\n");

    // 0 for 256 color, else use highcolor modes
    highcolor = false;//M_CheckParm ("-highcolor");

    VID_Init();

    //added:03-01-98: register exit code for graphics
    I_AddExitFunc(I_ShutdownGraphics);
    graphics_started = true;

}

int VID_NumModes()
{
	return 1;
}

char *VID_GetModeName(int num)
{
	return "480*272?";
}

int VID_GetModeForSize(int x, int y)
{
	return 0;
}

int VID_SetMode(int num)
{
	vid.width = 480;
	vid.height = 272;
	vid.rowbytes = 480;
	cv_scr_height.value = vid.height;
	cv_scr_width.value = vid.width;
	vid.modenum = 0;
	vid.recalc = 1;
	vid.bpp = 4;
	return 1;
}

void VID_Init()
{
	fbp0 = (void*)0;
	dList = memalign(64, 0x40000);
	sceGuInit();
	sceGuStart(GU_DIRECT, dList);
	sceGuDrawBuffer(GU_PSM_5650, (void *)0, 512);
	sceGuDispBuffer(480, 272, (void*)0x44000, 512);
	sceGuDepthBuffer((void*)0x88000, 512);

	sceGuOffset(2048 - (480/2), 2048 - (272/2));
	sceGuViewport(2048, 2048, 480, 272);
	sceGuScissor(0, 0, 480, 272);
	sceGuEnable(GU_SCISSOR_TEST);

	sceGuDepthRange(0, 0xFFFF);
	sceGuDepthFunc(GU_LEQUAL);
	sceGuEnable(GU_DEPTH_TEST);

	sceGuClearDepth(0xFFFF);
	sceGuClearColor(0xFF000000);

	sceGuShadeModel(GU_SMOOTH);
	sceGuEnable(GU_CLIP_PLANES);
//	sceGuEnable(GU_CULL_FACE);
//	sceGuFrontFace(GU_CW);

	sceGuEnable(GU_ALPHA_TEST);
	sceGuAlphaFunc(GU_GREATER, 0, 0xFF);

	sceGuEnable(GU_TEXTURE_2D);
	sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);
	sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	sceGuAmbientColor(0xFFFFFFFF);
	sceGuEnable(GU_BLEND);
	sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);

	sceGumMatrixMode(GU_PROJECTION);
	sceGumLoadIdentity();
	sceGumPerspective(60.0f, 16.0f/9.0f, 0.5f, 500.0f);
	sceGumUpdateMatrix();
	sceGumMatrixMode(GU_VIEW);
	sceGumLoadIdentity();
	sceGumUpdateMatrix();
	sceGumMatrixMode(GU_MODEL);
	sceGumLoadIdentity();
	sceGumUpdateMatrix();

/*		sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGB);
		sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	//	sceGuTexEnvColor(0xffff00);
		sceGuTexScale(1.0f,1.0f);
		sceGuTexOffset(0.0f,0.0f);
	//	sceGuAmbientColor(0x00ffffff);
*/

	sceGuFinish();
	sceGuSync(0,0);
	sceDisplayWaitVblankStart();
	sceGuDisplay(GU_TRUE);

	sceKernelDcacheWritebackInvalidateAll();

	byte *tmpal;
	finalpal = malloc(1024);
	if(!finalpal) I_Error("Palette storage malloc fail");

/*	tmpal = W_CacheLumpName("PLAYPAL",PU_CACHE);

	memcpy(finalpal, tmpal, 1024);

	Z_Free(tmpal);*/

	V_Init(); // heretic font

	GU_InitMemory();

	int argc = 0;
	VID_SetMode(0);

	sceGuStart(GU_DIRECT, dList);

	HWR_Startup();
	ClearBuffer(true, true, NULL);
}

