// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: i_tcp.c,v 1.37 2001/08/26 15:27:29 bpereira Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: i_tcp.c,v $
// Revision 1.37  2001/08/26 15:27:29  bpereira
// added fov for glide and fixed newcoronas code
//
// Revision 1.36  2001/08/21 21:53:37  judgecutor
// Fixed incorect place of #include "d_main.h"
//
// Revision 1.35  2001/08/20 20:40:39  metzgermeister
// *** empty log message ***
//
// Revision 1.34  2001/05/16 22:33:34  bock
// Initial FreeBSD support.
//
// Revision 1.33  2001/02/24 13:35:20  bpereira
// no message
//
// Revision 1.32  2001/02/10 12:27:13  bpereira
// no message
//
// Revision 1.31  2001/01/05 18:17:43  hurdler
// fix master server bug
//
// Revision 1.30  2000/11/26 00:46:31  hurdler
// small bug fixes
//
// Revision 1.29  2000/10/21 08:43:29  bpereira
// no message
//
// Revision 1.28  2000/10/16 20:02:29  bpereira
// no message
//
// Revision 1.27  2000/10/08 13:30:00  bpereira
// no message
//
// Revision 1.26  2000/10/01 15:20:23  hurdler
// Add private server
//
// Revision 1.25  2000/09/28 20:57:15  bpereira
// no message
//
// Revision 1.24  2000/09/15 19:49:22  bpereira
// no message
//
// Revision 1.23  2000/09/10 10:43:21  metzgermeister
// *** empty log message ***
//
// Revision 1.22  2000/09/08 22:28:30  hurdler
// merge masterserver_ip/port in one cvar, add -private
//
// Revision 1.21  2000/09/01 18:23:42  hurdler
// fix some issues with latest network code changes
//
// Revision 1.20  2000/08/31 14:30:55  bpereira
// no message
//
// Revision 1.19  2000/08/29 15:53:47  hurdler
// Remove master server connect timeout on LAN (not connected to Internet)
//
// Revision 1.18  2000/08/21 11:06:44  hurdler
// Add ping and some fixes
//
// Revision 1.17  2000/08/17 23:18:05  hurdler
// fix bad port sent to master server when using -udpport
//
// Revision 1.16  2000/08/16 23:39:41  hurdler
// fix a bug with windows sockets
//
// Revision 1.15  2000/08/16 17:21:50  hurdler
// update master server code (bis)
//
// Revision 1.14  2000/08/16 15:44:18  hurdler
// update master server code
//
// Revision 1.13  2000/08/16 14:10:01  hurdler
// add master server code
//
// Revision 1.12  2000/08/10 14:55:56  ydario
// OS/2 port
//
// Revision 1.11  2000/08/10 14:08:48  hurdler
// no message
//
// Revision 1.10  2000/08/03 17:57:42  bpereira
// no message
//
// Revision 1.9  2000/04/21 13:03:27  hurdler
// apply Robert's patch for SOCK_Get error. Boris, can you verify this?
//
// Revision 1.8  2000/04/21 00:01:45  hurdler
// apply Robert's patch for SOCK_Get error. Boris, can you verify this?
//
// Revision 1.7  2000/04/16 18:38:07  bpereira
// no message
//
// Revision 1.6  2000/03/29 19:39:48  bpereira
// no message
//
// Revision 1.5  2000/03/08 14:44:52  hurdler
// fix "select" problem under linux
//
// Revision 1.4  2000/03/07 03:32:24  hurdler
// fix linux compilation
//
// Revision 1.3  2000/03/06 15:46:43  hurdler
// compiler warning removed
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
// NOTE:    This is not realy Os dependant because all Os have the same Socket api
//          Just use '#ifdef' for Os dependant stuffs
//
//-----------------------------------------------------------------------------

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "doomdef.h"
#include "i_system.h"
#include "i_net.h"
#include "d_net.h"
#include "m_argv.h"
#include "command.h"
#include "d_main.h"

#include "doomstat.h"
#include "mserv.h" //Hurdler: support master server

#include "i_adhoc.h"

#define  SOCKET int
#define  INVALID_SOCKET -1

/*typedef union {
        byte ip[6];
}  sockaddr;*/

static sockaddr clientaddress[MAXNETNODES+1];
        
static SOCKET   mysocket = -1;
static boolean  nodeconnected[MAXNETNODES+1];
int sock_port = ADHOC_PORT;

int init_tcp_driver = 0;

char *SOCK_AddrToStr(sockaddr *sk)
{
    static char s[50];
    sprintf(s,"Unknow type");
    return s;
}

#define SOCK_cmpaddr AddrCompare

/*boolean SOCK_cmpaddr(sockaddr *a,sockaddr *b)
{
	AddrCompare(sockaddr *a, sockaddr *b)
}*/

static int getfreenode( void )
{
    int j;

    for(j=0;j<MAXNETNODES;j++)
        if( !nodeconnected[j] )
        {
            nodeconnected[j]=true;
            return j;
        }
    return -1;
}

//Hurdler: something is wrong with Robert's patch and win2k
void SOCK_Get(void)
{
    int           i,j,c;
    sockaddr  fromaddress;

    if(!init_tcp_driver) return;

    c = recv(mysocket, (char *)&doomcom->data, MAXPACKETLENGTH, (struct sockaddr *)&fromaddress);
    if (!c) {
         doomcom->remotenode = -1;      // no packet
         return;
    }
    
//    DEBFILE(va("Get from %s\n",SOCK_AddrToStr(&fromaddress)));

    // find remote node number
    for (i=0 ; i<MAXNETNODES+1 ; i++)
        if ( SOCK_cmpaddr(&fromaddress,&(clientaddress[i])) )
        {
            doomcom->remotenode = i;      // good packet from a game player
            doomcom->datalength = c;
//CONS_Printf("Prijato od %i delka: %i\n",i,c);
            return;
        }

    // not found
    // find a free slot
    j=getfreenode();
    if(j>0)
    {
        memcpy(&clientaddress[j],&fromaddress,sizeof(sockaddr));
#ifdef DEBUGFILE
        if( debugfile )
            fprintf(debugfile,"New node detected : node:%d address:%s\n",j,SOCK_AddrToStr(&clientaddress[j]));
#endif
        doomcom->remotenode = j; // good packet from a game player
        doomcom->datalength = c;
//CONS_Printf("Prijato od %i\n",j);
        return;
    }

    // node table full
    if( debugfile )
        fprintf(debugfile,"New node detected : No more free slote\n");

    doomcom->remotenode = -1;
CONS_Printf("Prijato od ?\n");
}

// check if we can send (do not go over the buffer)
boolean SOCK_CanSend(void)
{
    return 1;
}

sockaddr nothing;

void SOCK_Send(void)
{
    int         c;
    if(!init_tcp_driver) return;
/*CONS_Printf("Send to %i\n",doomcom->remotenode);            
    if( !nodeconnected[doomcom->remotenode] )
        return;
CONS_Printf("ConnectedOK\n");*/
    if(memcmp(&clientaddress[doomcom->remotenode].mac, &nothing.mac, 6) == 0) {
	CONS_Printf("\2Tried send to zero MAC, fixed to broadcast\n");
        for(c = 0; c < 6; c++) clientaddress[doomcom->remotenode].mac[c] = 0xFF;
        clientaddress[doomcom->remotenode].port = ADHOC_PORT;
    }

    c = send(mysocket, (char *)&doomcom->data, doomcom->datalength,&clientaddress[doomcom->remotenode]);

//CONS_Printf("\2S: 0x%08X N:%i M: %02x:%02x:%02x:%02x:%02x:%02x L: %i\n",c,doomcom->remotenode,clientaddress[doomcom->remotenode].mac[0] & 0xFF,clientaddress[doomcom->remotenode].mac[1] & 0xFF,clientaddress[doomcom->remotenode].mac[2] & 0xFF,clientaddress[doomcom->remotenode].mac[3] & 0xFF,clientaddress[doomcom->remotenode].mac[4] & 0xFF,clientaddress[doomcom->remotenode].mac[5] & 0xFF,doomcom->datalength);

//    DEBFILE(va("send to %s\n",SOCK_AddrToStr(&clientaddress[doomcom->remotenode])));
    // ECONNREFUSED was send by linux port
//    if (c == -1 && errno!=ECONNREFUSED && errno!=EWOULDBLOCK)
//        I_Error ("SOCK_Send sending to node %d (%s): %s",doomcom->remotenode,SOCK_AddrToStr(&clientaddress[doomcom->remotenode]),strerror(errno));
}

void SOCK_FreeNodenum(int numnode)
{
/*    // can't disconnect to self :)
    if(!numnode)
        return;

    if( debugfile )
        fprintf(debugfile,"Free node %d (%s)\n",numnode,SOCK_AddrToStr(&clientaddress[numnode]));

    nodeconnected[numnode]=false;

    // put invalide address
    //memset(&clientaddress[numnode],0xFF,sizeof(clientaddress[numnode]));*/
}

//Hurdler: temporary addition and changes for master server

int I_InitTcpDriver(void)
{
    int i;
    if (!init_tcp_driver)
    {
	i = Adhoc_Init();
	if(i < 0) return i;
        init_tcp_driver = 1;
    }
}


void SOCK_CloseSocket( void )
{
    if( mysocket>=0 )
    {
	CloseSocket(mysocket);
        mysocket = -1;
    }
}

void I_ShutdownTcpDriver(void)
{
    if (init_tcp_driver)
    {
	pspSdkAdhocTerm();
        init_tcp_driver = 0;
    }
}


int SOCK_NetMakeNode (char *hostname)
{
/*    int newnode;
    char *localhostname = strdup(hostname);
    char *portchar;
    int portnum = htons(sock_port);

    // retrieve portnum from address !
    strtok(localhostname,":");
    portchar = strtok(NULL,":");
    if( portchar )
        portnum = htons(atoi(portchar));
    free(localhostname);
    portnum = ADHOC_PORT;

        struct  hostent *hostentry;      // host information entry
        char            *t;

         // remove the port in the hostname as we've it already
        t = localhostname = strdup(hostname);
        while ((*t != ':') && (*t != '\0'))
            t++;
        *t = '\0';

        newnode = getfreenode();
        if( newnode == -1 )
            return -1;
        // find ip of the server
        clientaddress[newnode].ip.sin_family      = AF_INET;
        clientaddress[newnode].ip.sin_port        = portnum;
        clientaddress[newnode].ip.sin_addr.s_addr = inet_addr(localhostname);

        if(clientaddress[newnode].ip.sin_addr.s_addr==INADDR_NONE) // not a ip ask to the dns
        {
            CONS_Printf("Resolving %s\n",localhostname);
            hostentry = gethostbyname (localhostname);
            if (!hostentry)
            {
                CONS_Printf ("%s unknow\n", localhostname);
                I_NetFreeNodenum(newnode);
                free(localhostname);
                return -1;
            }
            clientaddress[newnode].ip.sin_addr.s_addr = *(int *)hostentry->h_addr_list[0];
        }
        CONS_Printf("Resolved %s\n",inet_ntoa(*(struct in_addr *)&clientaddress[newnode].ip.sin_addr.s_addr));
        free(localhostname);

        return newnode;
*/
    // ipx only
    return BROADCASTADDR;
}

boolean SOCK_OpenSocket( void )
{
    int i;
    if(mysocket != -1) return 1;
    if(!init_tcp_driver) return false;

    memset(clientaddress,0,sizeof(clientaddress));
    for(i = 0; i < MAXNETNODES+1; i++) clientaddress[i].port = ADHOC_PORT;
    for(i = 0; i < 6; i++) clientaddress[BROADCASTADDR].mac[i] = 0xFF;

    for(i=0;i<MAXNETNODES;i++)
        nodeconnected[i]=false;

    nodeconnected[0] = true; // always connected to self
    nodeconnected[BROADCASTADDR] = true;
    I_NetSend        = SOCK_Send;
    I_NetGet         = SOCK_Get;
    I_NetCloseSocket = SOCK_CloseSocket;
    I_NetFreeNodenum = SOCK_FreeNodenum;
    I_NetMakeNode    = SOCK_NetMakeNode;

    packetheaderlength=20 + 8;
    doomcom->extratics=1;

    mysocket = OpenSocket(ADHOC_PORT);

    return mysocket != -1;
}


boolean I_InitTcpNetwork( void )
{
    char     serverhostname[255];
    boolean  ret=0;

    // initilize the driver
//    I_InitTcpDriver(); 
//    I_AddExitFunc (I_ShutdownTcpDriver);

    // parse network game options,
    if ( M_CheckParm ("-server") || dedicated)
    {
        server=true;

        // if a number of clients (i.e. nodes) is specified, the server will wait for the clients to connect before starting
        // if no number is specified here, the server starts with 1 client, others can join in-game.
        // since Boris has implemented join in-game, there is no actual need for specifying a particular number here
        // FIXME: for dedicated server, numnodes needs to be set to 0 upon start
        if( M_IsNextParm() )
            doomcom->numnodes=atoi(M_GetNextParm());
        else if (dedicated)
            doomcom->numnodes=0;
        else
            doomcom->numnodes=1;

        if (doomcom->numnodes<0)
            doomcom->numnodes=0;
        if (doomcom->numnodes>MAXNETNODES)
            doomcom->numnodes=MAXNETNODES;

        // server
        servernode = 0;
        // FIXME:
        // ??? and now ?
        // server on a big modem ??? 4*isdn
        net_bandwidth = 16000;
        hardware_MAXPACKETLENGTH = INETPACKETLENGTH;

        ret = true;
    }
    else if( M_CheckParm ("-connect") )
    {
        if(M_IsNextParm())
            strcpy(serverhostname,M_GetNextParm());
        else
            serverhostname[0]=0; // assuming server in the LAN, use broadcast to detect it

        // server address only in ip
        if(serverhostname[0])
        {
            COM_BufAddText("connect \"");
            COM_BufAddText(serverhostname);
            COM_BufAddText("\"\n");

            // probably modem
            hardware_MAXPACKETLENGTH = INETPACKETLENGTH;
        }
        else
        {
            // so we're on a LAN
            COM_BufAddText("connect any\n");

            net_bandwidth = 800000;
            hardware_MAXPACKETLENGTH = MAXPACKETLENGTH;
        }
    }

    I_NetOpenSocket = SOCK_OpenSocket;

    return ret;
}

