// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: I_system.c,v 1.5 2000/10/21 08:43:32 bpereira Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: I_system.c,v $
// Revision 1.5  2000/10/21 08:43:32  bpereira
// no message
//
// Revision 1.4  2000/10/02 18:25:46  bpereira
// no message
//
// Revision 1.3  2000/04/16 18:38:07  bpereira
// no message
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//     Misc. stuff
//     Startup & Shutdown routines for music,sound,timer,keyboard,...
//     Signal handler to trap errors and exit cleanly.
//
//-----------------------------------------------------------------------------

#include "doomdef.h"
#include "m_misc.h"
#include "i_video.h"
#include "i_sound.h"
#include "i_system.h"
#include "d_net.h"
#include "g_game.h"

#include "d_main.h"

#include "m_argv.h"
#include "w_wad.h"
#include "z_zone.h"
#include "g_input.h"

#include "console.h"

#ifdef __GNUG__
 #pragma implementation "../i_system.h"
#endif

SceCtrlData pad;
SceCtrlData oldpad;

// Do not execute cleanup code more than once. See Shutdown_xxx() routines.
byte graphics_started=false;
byte keyboard_started=false;
byte sound_started=false;
byte timer_started=false;

/* Mouse stuff */
byte mouse_detected=false;

volatile tic_t ticcount;   //returned by I_GetTime(), updated by timer interrupt

void I_Tactile ( int   on,   int   off,   int   total )
{
  // UNUSED.
  on = off = total = 0;
}

ticcmd_t        emptycmd;
ticcmd_t*       I_BaseTiccmd(void)
{
    return &emptycmd;
}

//
//  Allocates the base zone memory,
//  this function returns a valid pointer and size,
//  else it should interrupt the program immediately.
//
//added:11-02-98: now checks if mem could be allocated, this is still
//    prehistoric... there's a lot to do here: memory locking, detection
//    of win95 etc...
//
boolean   lockmem;

ULONG I_GetFreeMem(ULONG *total)
{
/*    if( total )
        *total = RAMsize<<12; // <<12 for convert page to byte
    return info.RAMsize<<12;*/
	*total = 14 * 1024 * 1024;
	return *total;
}


/*==========================================================================*/
// I_GetTime ()
/*==========================================================================*/
tic_t I_GetTime(void)
{
    struct timeval tp;
    struct timezone tzp;
    int newtics;
    static int basetime = 0;

    gettimeofday(&tp, &tzp);
    if (!basetime)
        basetime = tp.tv_sec;
    newtics = (tp.tv_sec - basetime) * TICRATE + tp.tv_usec * TICRATE / 1000000;
    return newtics;
}

//
// I_Init
//

/*
void I_WaitJoyButton (void)
{
     CON_Drawer ();
     I_FinishUpdate ();        // page flip or blit buffer
}

void I_InitJoystick (void)
{
    joystick_detected=0;
}
*/

//
// I_Error
//
//added:18-02-98: put an error message (with format) on stderr
void I_OutputMsg (char *error, ...)
{
    va_list     argptr;

    va_start (argptr,error);
    vfprintf (stderr,error,argptr);
    va_end (argptr);

    // dont flush the message!
}

int errorcount=0; // fuck recursive errors
int shutdowning=false;
char errortext[1024];
//added 31-12-97 : display error messy after shutdowngfx
void I_Error (char *error, ...)
{
	va_list     argptr;

	va_start (argptr, error);
	vsprintf (errortext, error, argptr);
	va_end (argptr);

	pspDebugScreenInit();
	pspDebugScreenPrintf(errortext);
	sceKernelSleepThread();

/*
    if(shutdowning)
    {
        errorcount++;
        if(errorcount==5)
           I_ShutdownGraphics();
        if(errorcount==6)
           I_ShutdownSystem();
        if(errorcount>7)
          exit(-1);       // recursive errors detected
    }
    shutdowning=true;

    // put message to stderr
    va_start (argptr,error);
    fprintf (stderr, "Error: ");
    vfprintf (stderr,error,argptr);
#ifdef DEBUGFILE
    if (debugfile)
    {
        fprintf (debugfile,"I_Error :");
        vfprintf (debugfile,error,argptr);
    }
#endif

    va_end (argptr);


    //added:18-02-98: save one time is enough!
    if (!errorcount)
    {
        M_SaveConfig (NULL);   //save game config, cvars..
    }

    //added:16-02-98: save demo, could be useful for debug
    //                NOTE: demos are normally not saved here.
    if (demorecording)
        G_CheckDemoStatus();

    D_QuitNetGame ();

    I_ShutdownSystem();

    fprintf (stderr, "\nPress ENTER");
    fflush( stderr );
    getchar();

    exit(-1);*/
}


//
// I_Quit : shutdown everything cleanly, in reverse order of Startup.
//
void I_Quit (void)
{
    byte* endoom;

    //added:16-02-98: when recording a demo, should exit using 'q' key,
    //        but sometimes we forget and use 'F10'.. so save here too.
    if (demorecording)
        G_CheckDemoStatus();

    M_SaveConfig (NULL);   //save game config, cvars..


    //endoom = W_CacheLumpName("ENDOOM",PU_CACHE);


    //added:03-01-98: maybe it needs that the ticcount continues,
    // or something else that will be finished by ShutdownSystem()
    // so I do it before.
    D_QuitNetGame ();

    /* shutdown everything that was started ! */
    I_ShutdownSystem();

    //puttext(1,1,80,25,endoom);
    //gotoxy(1,24);

    if(shutdowning || errorcount)
        I_Error("Error detected (%d)",errorcount);

    fflush(stderr);

    sceKernelExitGame();
}


//added:12-02-98: does want to work!!!! rhaaahahha
void I_WaitVBL(int count)
{
	//sceDisplayWaitVblankStart();
}

//  Fab: this is probably to activate the 'loading' disc icon
//       it should set a flag, that I_FinishUpdate uses to know
//       whether it draws a small 'loading' disc icon on the screen or not
//
//  also it should explicitly draw the disc because the screen is
//  possibly not refreshed while loading
//
void I_BeginRead (void)
{
}

//  Fab: see above, end the 'loading' disc icon, set the flag false
//
void I_EndRead (void)
{
}

byte*   I_AllocLow(int length)
{
    byte*       mem;

    mem = (byte *)malloc (length);
    memset (mem,0,length);
    return mem;

}

// wait ms milliseconde
void I_Delay(int ms)
{
	sceKernelDelayThread(ms*1000);
}

//  Initialise the mouse. Doesnt need to be shutdown.
//
void I_StartupMouse (void)
{
	mouse_detected=false;
}

void CheckKey(int key, int gamekey)
{
	event_t event;
	if(pad.Buttons & key && !(oldpad.Buttons & key)) {
		event.type = ev_keydown;
		event.data1 = gamekey;
		D_PostEvent(&event);
	}
	if(!(pad.Buttons & key) && oldpad.Buttons & key) {
		event.type = ev_keyup;
		event.data1 = gamekey;
		D_PostEvent(&event);
	}
}

extern boolean menuactive;
extern boolean keychange;
int firstrun = 1;
extern consvar_t cv_cpu333;
int pervfreq = 0;

void I_GetEvent (void)
{
	const int deadzone = 36;
	int stickx, sticky;
	event_t event;

	oldpad = pad;
	sceCtrlPeekBufferPositive(&pad, 1);
	if(firstrun) {oldpad = pad;firstrun = 0;}
	{
		CheckKey(PSP_CTRL_UP, KEY_UPARROW);
		CheckKey(PSP_CTRL_DOWN, KEY_DOWNARROW);
		CheckKey(PSP_CTRL_RIGHT, KEY_RIGHTARROW);
		CheckKey(PSP_CTRL_LEFT, KEY_LEFTARROW);
		CheckKey(PSP_CTRL_CROSS, KEY_CROSS);
		CheckKey(PSP_CTRL_RTRIGGER, KEY_R);
		CheckKey(PSP_CTRL_LTRIGGER, KEY_L);
		CheckKey(PSP_CTRL_TRIANGLE, KEY_TRIANGLE);
		CheckKey(PSP_CTRL_SQUARE, KEY_SQUARE);
		CheckKey(PSP_CTRL_CIRCLE, KEY_CIRCLE);
		CheckKey(PSP_CTRL_START, KEY_START);
		CheckKey(PSP_CTRL_SELECT, KEY_SELECT);

		stickx = pad.Lx - 128;
		sticky = pad.Ly - 128;

		if (abs(sticky) > deadzone)
			sticky = abs(sticky)*sticky >> (7 + 2);
		else
			sticky = 0;

		if (abs(stickx) > deadzone)
		{
			// When running forward we don't want to turn too fast
			int damping = 256 - abs(sticky)*256/64;
			if (damping < 0)
				damping = 0;

			stickx = abs(stickx)*stickx*damping >> (8 + 7 + 2);
		}
		else
			stickx = 0;

		if (stickx || sticky)
		{
			event.type=ev_mouse;
			event.data1=0;
			event.data2=stickx;
			event.data3=-sticky;

			D_PostEvent(&event);
		}
	}

	if(pervfreq != cv_cpu333.value) {
		pervfreq = cv_cpu333.value;
		if(cv_cpu333.value == 0) scePowerSetClockFrequency(222, 222, 111);
		if(cv_cpu333.value == 1) scePowerSetClockFrequency(333, 333, 166);
	}

/*
    int i;

    if(mouse_detected)
    {
        //mouse movement
        int stickx,sticky,buttons;
        static int lastbuttons=0;

        r.x.ax=0x0b;           // ask the mouvement not the position
        __dpmi_int(0x33,&r);
        stickx=(signed short)r.x.cx;
        sticky=(signed short)r.x.dx;
        r.x.ax=0x03;
        __dpmi_int(0x33,&r);
        buttons=r.x.bx;

        // post key event for buttons
        if (buttons!=lastbuttons)
        {
            int j=1,k;
            k=(buttons ^ lastbuttons); // only changed bit to 1
            lastbuttons=buttons;

            for(i=0;i<MOUSEBUTTONS;i++,j<<=1)
                if(k & j)
                {
                    if(buttons & j)
                       event.type=ev_keydown;
                    else
                       event.type=ev_keyup;
                    event.data1=KEY_MOUSE1+i;
                    D_PostEvent(&event);
                }
        }

        if ((stickx!=0)||(sticky!=0))
        {
          event.type=ev_mouse;
          event.data1=0;
//          event.data1=buttons;    // not needed
          event.data2=stickx;
          event.data3=-sticky;

          D_PostEvent(&event);
        }

    }*/
}

//
//  Timer user routine called at ticrate.
/*
void I_TimerISR (void)
{
   //  IO_PlayerInput();      // old doom did that
   ticcount++;

}
END_OF_FUNCTION(I_TimerISR);*/

void I_ShutdownTimer (void)
{
    if( !timer_started )
        return;
    //remove_timer();
}


//
//  Installs the timer interrupt handler with timer speed as TICRATE.
//
void I_StartupTimer(void)
{
   ticcount = 0;

   //lock this from being swapped to disk! BEFORE INSTALLING
   //LOCK_VARIABLE(ticcount);
   //LOCK_FUNCTION(I_TimerISR);

/*   if( install_timer() != 0 )
      I_Error("I_StartupTimer: could not install timer.");
*/

   I_AddExitFunc(I_ShutdownTimer);
   timer_started = true;
}


//added:07-02-98:
//
//
/*
byte ASCIINames[128] =
{
//  0       1       2       3       4       5       6       7
//  8       9       A       B       C       D       E       F
    0  ,    27,     '1',    '2',    '3',    '4',    '5',    '6',
    '7',    '8',    '9',    '0', KEY_MINUS,KEY_EQUALS,KEY_BACKSPACE, KEY_TAB,
    'q',    'w',    'e',    'r',    't',    'y',    'u',    'i',
    'o',    'p',    '[',    ']', KEY_ENTER,KEY_CTRL,'a',    's',
    'd',    'f',    'g',    'h',    'j',    'k',    'l',    ';',
    '\'',   '`', KEY_SHIFT, '\\',   'z',    'x',    'c',    'v',
    'b',    'n',    'm',    ',',    '.',    '/', KEY_SHIFT, '*',
 KEY_ALT,KEY_SPACE,KEY_CAPSLOCK, KEY_F1, KEY_F2, KEY_F3, KEY_F4, KEY_F5,
    KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F10,KEY_NUMLOCK,KEY_SCROLLLOCK,KEY_KEYPAD7,
 KEY_KEYPAD8,KEY_KEYPAD9,KEY_MINUSPAD,KEY_KEYPAD4,KEY_KEYPAD5,KEY_KEYPAD6,KEY_PLUSPAD,KEY_KEYPAD1,
 KEY_KEYPAD2,KEY_KEYPAD3,KEY_KEYPAD0,KEY_KPADDEL,      0,      0,      0,      KEY_F11,
    KEY_F12,0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0
};*/

volatile int pausepressed=0;
volatile char nextkeyextended;

static void I_KeyboardHandler()
{
/*    unsigned char ch;
    event_t       event;

    ch=inportb(0x60);

    if(pausepressed>0)
        pausepressed--;
    else
        if(ch==0xE1) // pause key
        {
          event.type=ev_keydown;
          event.data1=KEY_PAUSE;
          D_PostEvent(&event);
          pausepressed=5;
        }
        else
        if(ch==0xE0) // extended key handled at next call
        {
          nextkeyextended=1;
        }
        else
        {
          if((ch&0x80)==0)
            event.type=ev_keydown;
          else
            event.type=ev_keyup;

          ch&=0x7f;

          if(nextkeyextended)
          {
            nextkeyextended=0;

            if(ch==70)  // crtl-break
            {
                asm ("movb $0x79, %%al
                     call ___djgpp_hw_exception"
                     : : :"%eax","%ebx","%ecx","%edx","%esi","%edi","memory");
            }

            // remap lonely keypad slash
            if (ch==53)
                event.data1 = KEY_KPADSLASH;
            else
            // remap the bill gates keys...
            if (ch>=91 && ch<=93)
                event.data1 = ch + 0x80;    // leftwin, rightwin, menu
            else
            // remap non-keypad extended keys to a value<128, but
            // make them different than the KEYPAD keys.
            if (ch>=71 && ch<=83)
                event.data1 = 0x80 + ch + 30;
            else if (ch==28)
                event.data1 = KEY_ENTER;    // keypad enter -> return key
            else if (ch==29)
                event.data1 = KEY_CTRL;     // rctrl -> lctrl
            else if (ch==56)
                event.data1 = KEY_ALT;      // ralt -> lalt
            else
                ch = 0;
            if (ch)
                D_PostEvent(&event);
          }
          else
          {
            if (ASCIINames[ch]!=0)
              event.data1=ASCIINames[ch];
            else
              event.data1=ch+0x80;
            D_PostEvent(&event);
          }
        }
*/
}

//  Return a key that has been pushed, or 0
//  (replace getchar() at game startup)
//
int I_GetKey (void)
{
/*    if( keyboard_started )
    {
    event_t   *ev;

    if (eventtail != eventhead)
    {
        ev = &events[eventtail];
        eventtail = (++eventtail)&(MAXEVENTS-1);
        if (ev->type == ev_keydown)
            return ev->data1;
        else
            return 0;
    }
    return 0;
    }

    // keyboard not started use the bios call trouth djgpp
    if(_conio_kbhit())
    {
        int key=getch();
        if(key==0) key=getch()+256;
        return key;
    }
    else
        return 0;
*/
}

//
//  Removes the keyboard handler.
//
void I_ShutdownKeyboard()
{
    keyboard_started=false;
}

//
//  Installs the keyboard handler.
//
void I_StartupKeyboard()
{
    if(keyboard_started)
        return;

    nextkeyextended=0;

    I_AddExitFunc(I_ShutdownKeyboard);
    keyboard_started = true;
}




//added:08-01-98:
//
//  Clean Startup & Shutdown handling, as does Allegro.
//  We need this services for ourselves too, and we don't want to mix
//  with Allegro, because someone might not use Allegro.
//  (all 'exit' was renamed to 'quit')
//
#define MAX_QUIT_FUNCS     16
typedef void (*quitfuncptr)();
static quitfuncptr quit_funcs[MAX_QUIT_FUNCS] =
               { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
               };


//added:08-01-98:
//
//  Adds a function to the list that need to be called by I_SystemShutdown().
//
void I_AddExitFunc(void (*func)())
{
   int c;

   for (c=0; c<MAX_QUIT_FUNCS; c++) {
      if (!quit_funcs[c]) {
         quit_funcs[c] = func;
         break;
      }
   }
}


//added:08-01-98:
//
//  Removes a function from the list that need to be called by
//   I_SystemShutdown().
//
void I_RemoveExitFunc(void (*func)())
{
   int c;

   for (c=0; c<MAX_QUIT_FUNCS; c++) {
      if (quit_funcs[c] == func) {
         while (c<MAX_QUIT_FUNCS-1) {
            quit_funcs[c] = quit_funcs[c+1];
            c++;
         }
         quit_funcs[MAX_QUIT_FUNCS-1] = NULL;
         break;
      }
   }
}

//added:08-01-98: now this replaces allegro_init()
//
//  REMEMBER: THIS ROUTINE MUST BE STARTED IN i_main.c BEFORE D_DoomMain()
//
//  This stuff should get rid of the exception and page faults when
//  Doom bugs out with an error. Now it should exit cleanly.
//
int  I_StartupSystem(void)
{
   graphics_started = false;
   keyboard_started = false;
   sound_started = false;
   timer_started = false;
   return 0;
}


//added:08-01-98:
//
//  Closes down everything. This includes restoring the initial
//  pallete and video mode, and removing whatever mouse, keyboard, and
//  timer routines have been installed.
//
//  NOTE : Shutdown user funcs. are effectively called in reverse order.
//
void I_ShutdownSystem()
{
   int c;

   for (c=MAX_QUIT_FUNCS-1; c>=0; c--)
      if (quit_funcs[c])
         (*quit_funcs[c])();

}

void I_GetDiskFreeSpace(INT64 *freespace)
{
/*    struct diskfree_t df;
    if(_dos_getdiskfree(0,&df))
        *freespace = (unsigned long)df.avail_clusters *
                     (unsigned long)df.bytes_per_sector *
                     (unsigned long)df.sectors_per_cluster;
    else*/
        *freespace = MAXINT;
}

int get_registry_value(const char *dir, const char *name, void *val, int maxlen)
{
	int ret = 0;
	struct RegParam reg;
	REGHANDLE h;

	memset(&reg, 0, sizeof(reg));
	reg.regtype = 1;
	reg.namelen = strlen("/system");
	reg.unk2 = 1;
	reg.unk3 = 1;
	strcpy(reg.name, "/system");
	if(sceRegOpenRegistry(&reg, 2, &h) == 0)
	{
		REGHANDLE hd;
		if(!sceRegOpenCategory(h, dir, 2, &hd))
		{
			REGHANDLE hk;
			unsigned int type, size;

			if(!sceRegGetKeyInfo(hd, name, &hk, &type, &size))
			{
				if(!sceRegGetKeyValue(hd, hk, val, maxlen))
				{
					ret = 1;
					sceRegFlushCategory(hd);
				}
			}
			sceRegCloseCategory(hd);
		}
		sceRegFlushRegistry(h);
		sceRegCloseRegistry(h);
	}

	return ret;
}
char name[64];
char *I_GetUserName(void)
{
	if(get_registry_value("/CONFIG/SYSTEM", "owner_name", &name, 64))
	{
		return &name;
	} else {
		CONS_Printf("Can't read nickname\n");
		return NULL;
	}
	return NULL;
}

int  I_mkdir(const char *dirname, int unixright)
{
    //return mkdir(dirname,unixright);
	return -1;
}

