// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: I_sound.c,v 1.4 2001/03/30 17:12:52 bpereira Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: I_sound.c,v $
// Revision 1.4  2001/03/30 17:12:52  bpereira
// no message
//
// Revision 1.3  2000/03/06 15:32:56  hurdler
// compiler warning removed
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      interface level code for sound
//
//-----------------------------------------------------------------------------

#include <stdio.h>

#include "doomdef.h"
#include "doomstat.h"
#include "i_system.h"
#include "i_sound.h"
#include "z_zone.h"
#include "m_argv.h"
#include "m_misc.h"
#include "w_wad.h"
#include "s_sound.h"
#include "console.h"

void sound_callback(void* buf, unsigned int length, void *userdata);

#define NUM_CHANNELS 24
#define MIXER_FRACBITS 12UL

typedef struct
{
    short unk;
    short rate;
    long len;
    char firstSample;
} sample_t;

typedef struct _sound_channel
{
	unsigned long pos;
    int is_playing;
    int len;
    int rate;
	int age;
    float rvol;
    float lvol;
	byte *ptr;
} sound_channel;

sound_channel sndchans[NUM_CHANNELS];

void* I_GetSfx (sfxinfo_t*  sfx)
{
    byte*               dssfx;
    int                 size;

    if (sfx->lumpnum<0)
        sfx->lumpnum = S_GetSfxLumpNum (sfx);

    size = W_LumpLength (sfx->lumpnum);
    dssfx = W_CacheLumpNum (sfx->lumpnum, PU_STATIC);

    return dssfx;
}


void I_FreeSfx (sfxinfo_t* sfx)
{
    byte*    dssfx;

    if (sfx->lumpnum<0)
        return;

    // free sample data
    if( sfx->data )
    {
        dssfx = sfx->data;
        Z_Free (dssfx);
        //Z_Free (sfx->data);
    }

    sfx->data = NULL;
    sfx->lumpnum = -1;
}


void I_SetSfxVolume(int volume)
{
    if(nosound)
        return;

//    set_volume (cv_soundvolume.value*255/31,-1);
}

//
// Starting a sound means adding it
//  to the current list of active sounds
//  in the internal channels.
// As the SFX info struct contains
//  e.g. a pointer to the raw data,
//  it is ignored.
// As our sound handling does not handle
//  priority, it is ignored.
// Pitching (that is, increased speed of playback)
//  is set, but currently not used by mixing.
//
int I_StartSound ( int           id,
                   int           vol,
                   int           sep,
                   int           pitch,
                   int           priority )
{
	int slot, i, leftvol, rightvol;
	int oldest = gametic;
	int oldestnum = 0;
	sample_t *sample;

	if(nosound)
		return 0;


	if(!S_sfx[id].data) return -1;

	for( i=0; (i<NUM_CHANNELS) && (sndchans[i].is_playing); i++ )
	{
		if( sndchans[i].age < oldest )
		{
			oldestnum = i;
			oldest = sndchans[i].age;
		}
	}

	if( i == NUM_CHANNELS ) 
		slot = oldestnum;
	else
		slot = i;

	vol *= 8;
	leftvol = vol - ((vol*sep*sep) >> 16); ///(256*256);
	sep = sep - 257;
	rightvol = vol - ((vol*sep*sep) >> 16);

	if(rightvol > 1523) rightvol = 1523;
	if(leftvol > 1523) leftvol = 1523;

	sample = S_sfx[id].data;
	sndchans[i].ptr = S_sfx[id].data + 8;
	sndchans[i].len = sample->len;
	sndchans[i].rvol = (float)rightvol * (1.0f/1523.0f);
	sndchans[i].lvol = (float)leftvol * (1.0f/1523.0f);
	sndchans[i].age = gametic;
	sndchans[i].pos = 0;
	sndchans[i].rate = (sample->rate << MIXER_FRACBITS) / 44100;
	sndchans[i].is_playing = 1;


//    CONS_Printf("sndvol: %i\n", rightvol);

    return slot;
/*  int voice;

  if(nosound)
      return 0;

  // UNUSED
  priority = 0;

  pitch=(pitch-128)/2+128;
  voice=play_sample(S_sfx[id].data,vol,sep,(pitch*1000)/128,0);


  return (id<<VOICESSHIFT)+voice;*/
}

void I_StopSound (int handle)
{
    sndchans[handle].is_playing = 0;
/*  int voice=handle & (VIRTUAL_VOICES-1);

  if(nosound)
      return;

  if(voice_check(voice)==S_sfx[handle>>VOICESSHIFT].data)
    deallocate_voice(voice);*/
}

int I_SoundIsPlaying(int handle)
{
/*  if(nosound)
      return FALSE;

  if(voice_check(handle & (VIRTUAL_VOICES-1))==S_sfx[handle>>VOICESSHIFT].data)
      return true;*/
  return sndchans[handle].is_playing;
}

void I_UpdateSound( void )
{
}

void I_SubmitSound( void )
{
}

void I_UpdateSoundParams( int   handle,
                          int   vol,
                          int   sep,
                          int   pitch)
{
	int rightvol, leftvol;
	if(sndchans[handle].is_playing) {
		vol *= 8;
		leftvol = vol - ((vol*sep*sep) >> 16); ///(256*256);
		sep = sep - 257;
		rightvol = vol - ((vol*sep*sep) >> 16);

		if(rightvol > 1523) rightvol = 1523;
		if(leftvol > 1523) leftvol = 1523;

		sndchans[handle].rvol = (float)rightvol / 1600.0f;
		sndchans[handle].lvol = (float)leftvol / 1600.0f;
	}
/*  int voice=handle & (VIRTUAL_VOICES-1);
  int numsfx=handle>>VOICESSHIFT;

  if(nosound)
      return;

  if(voice_check(voice)==S_sfx[numsfx].data)
  {
    voice_set_volume(voice, vol);
    voice_set_pan(voice, sep);
    voice_set_frequency(voice, absolute_freq(pitch*1000/128
                             , S_sfx[numsfx].data));
  }*/
}

void I_ShutdownSound(void)
{
  if( !sound_started )
      return;

  sound_started = false;
}

void I_StartupSound()
{
/*    int    sfxcard,midicard;
    char   err[255];
*/
    nosound = false;

    CONS_Printf("I_StartupSound: ");

    pspAudioInit();
    pspAudioSetVolume(0, 0x6000, 0x6000);
    pspAudioSetChannelCallback(0, (void *) &sound_callback, NULL);
    CONS_Printf(" using pspAudio\n" );

    S_Init(255,0);

    I_AddExitFunc(I_ShutdownSound);
    sound_started = true;
}

void sound_callback(void* buf, unsigned int length, void *userdata)
{
	int j, k;
	int l, i;
	int samplepos;
	float pcm1 = 0;
	float pcm2 = 0;
	short *p = (short *) buf;

	memset(buf, 0, length * 4);
	l = length;

	for(i = 0; i < l; i++)
	{
		pcm1 = 0;
		pcm2 = 0;
		for(j = 0; j < NUM_CHANNELS; j++)
		{
			sound_channel* ch = sndchans+j;

			if(ch->is_playing)
			{
				ch->pos += ch->rate;
				samplepos = ch->pos >> MIXER_FRACBITS;

				if(samplepos >= ch->len)
				{
					ch->is_playing = 0;
					break;
				}

				byte sample = ch->ptr[samplepos];
				pcm1 += (float)(0x80 - sample) * ch->lvol;
				pcm2 += (float)(0x80 - sample) * ch->rvol;
			}
		}
		if(pcm1 < -128.0f) pcm1 = -128.0f;
		if(pcm1 > 128.0f) pcm1 = 128.0f;
		if(pcm2 < -128.0f) pcm2 = -128.0f;
		if(pcm2 > 128.0f) pcm2 = 128.0f;
		*(p++) = (short)(255.0f * pcm1);
		*(p++) = (short)(255.0f * pcm2);
	}
}

