// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: I_main.c,v 1.3 2000/04/23 16:19:52 bpereira Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: I_main.c,v $
// Revision 1.3  2000/04/23 16:19:52  bpereira
// no message
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      Main program, simply calls D_DoomMain high level loop.
//
//-----------------------------------------------------------------------------

#include "doomdef.h"

#include "m_argv.h"
#include "d_main.h"

#include "i_system.h"

#include "i_video.h"

//#include "exception.h"

PSP_MODULE_INFO("legacy", 0, 1, 1);
PSP_MAIN_THREAD_ATTR(PSP_THREAD_ATTR_USER | PSP_THREAD_ATTR_VFPU);
PSP_MAIN_THREAD_STACK_SIZE_KB(1*1024);
PSP_HEAP_SIZE_KB(20*1024);

extern void _DisableFPUExceptions();

/* Exit callback */
int exit_callback(void)
{
    I_Quit();
//    pspDebugScreenClear();
//    sceKernelExitGame();
    return 0;
}

/* Callback thread */
void CallbackThread(void *arg)
{
    int cbid;
    cbid = sceKernelCreateCallback("Exit Callback", (SceKernelCallbackFunction) exit_callback, NULL);
    sceKernelRegisterExitCallback(cbid);
    sceKernelSleepThreadCB();
}

/* Sets up the callback thread and returns its thread id */
int SetupCallbacks(void)
{
    int thid = 0;
    thid = sceKernelCreateThread("update_thread", (SceKernelThreadEntry) CallbackThread, 0x11, 0xFA0, 0, 0);
    if (thid >= 0) sceKernelStartThread(thid, (SceSize) 0, 0);
    return thid;
}

#define MAXPARAM 16
#define MAXPWADS 4
#define MAXSPWADS 16

void AddParam(char *obsah, int pwad)
{
	if(myargc == MAXPARAM) I_Error("To many parameters");
	if(pwad) {
		myargv[myargc] = malloc(strlen(obsah)+7);
		sprintf(myargv[myargc],"pwads/%s",obsah);
	} else {
		myargv[myargc] = malloc(strlen(obsah)+1);
		sprintf(myargv[myargc],"%s",obsah);
	}
	myargc++;
}

typedef struct {
	char *file;
	int state;
} pwadlist_t;

typedef struct {
	char *game;
	char *file;
	char *save;
	int state;
} iwadlist_t;

iwadlist_t iwadlist[] = {
	{"Doom 1 (demo)", "doom1.wad", "doom1-%i.sav", 0},
	{"Doom 1", "doom.wad", "doom-%i.sav", 0},
	{"Doom 1 (Ultimate)", "doomu.wad", "doomu-%i.sav", 0},
	{"Doom 2", "doom2.wad", "doom2-%i.sav", 0},
	{"Doom 2 (Plutonia)", "plutonia.wad", "plut-%i.sav", 0},
	{"Doom 2 (TNT)", "tnt.wad", "tnt-%i.sav", 0},
	{"Heretic", "heretic.wad", "htic-%i.sav", 0},
//	{"Strife (full)", "strife1.wad", "strife-%i.sav", 0},
	{NULL, NULL, NULL, -1}
};

char *pwads[MAXPWADS];
pwadlist_t pwadlist[MAXSPWADS];

SceCtrlData pad;
int i, j, oi;
int numiwads = 0;
int numpwads = 0;
int currpwad = 0;
SceUID f;
SceIoDirent dirent;

extern char savegamename[256];

void disableFloatingPointExceptions()
{
	asm(
		".set push\n"
		".set noreorder\n"
		"cfc1    $2, $31\n"		// Get the FP Status Register.
		"lui     $8, 0x80\n"	// (?)
		"and     $8, $2, $8\n"	// Mask off all bits except for 23 of FCR. (? - where does the 0x80 come in?)
		"ctc1    $8, $31\n"		// Set the FP Status Register.
		".set pop\n"
		:						// No inputs.
		:						// No outputs.
		: "$2", "$8"			// Clobbered registers.
	);
}

int main(int argc, char** argv)
{
    myargc = 1;
    myargv = malloc(MAXPARAM*4);
    myargv[0] = argv[0];

    initExceptionHandler();
//    _DisableFPUExceptions();
disableFloatingPointExceptions();
    pspDebugScreenInit();

//    int err = 
    sceIoMkdir("save", 0777);
    sceIoMkdir("pwads", 0777);
//    if(err<0) {if(err == 0x80010011) {}}

    for(i = 0; iwadlist[i].state != -1; i++) {
        f = sceIoOpen(iwadlist[i].file, PSP_O_RDONLY, 0777);
        if(f > -1) {
            sceIoClose(f);
            iwadlist[i].state = numiwads + 1;
            numiwads++;
        }
    }

    if(numiwads < 1) {
        SetupCallbacks();
	I_Error("No usable IWAD present.");
    }

    if(numiwads == 1) {
	for(i = 0; iwadlist[i].state != 1; i++) ;
    } else {
        // Begin Duke code modification
        // Updated IWAD and PWAD menus
        int wadcount = 0;
        printf("Select game:\n\n");
	for(i = 0; iwadlist[i].state != -1; i++)
        {
            if(iwadlist[i].state > 0)
            {
                printf("    %s\n",iwadlist[i].game);
                wadcount++;
            }
        }
        gotoxy(0,wadcount+3);
        printf("Arrows move, cross selects.");
        gotoxy(0,33);
        printf("PSP Legacy (Release 4) - ported by kgsws, updated by Duke and Sunray");
        i = 1;
        oi = 2;
        while(1) {
            sceCtrlReadBufferPositive(&pad, 1);
            if(pad.Buttons & PSP_CTRL_UP) i--;
            if(pad.Buttons & PSP_CTRL_DOWN) i++;
            if(i > numiwads) i = 1;
            if(i < 1) i = numiwads;
            if(pad.Buttons & PSP_CTRL_CROSS) break;
            if(oi != i) {
                gotoxy(0, oi+1);
                printf("   ");
                gotoxy(0, i+1);
                printf("-->");
                oi = i;
		sceKernelDelayThread(200*1000);
            }
        }
        oi = i;
        for(i = 0; iwadlist[i].state != oi; i++) ;
    }
    pspDebugScreenClear();
    printf("Using %s as IWAD\n",iwadlist[i].file);
    while(1) {
        sceCtrlReadBufferPositive(&pad, 1);
        if(!(pad.Buttons & PSP_CTRL_CROSS)) break;
    }
    sprintf(savegamename,"save/%s",iwadlist[i].save);
    AddParam("-iwad",0);
    AddParam(iwadlist[i].file,0);

    pspDebugScreenClear();

    memset(&dirent,0,sizeof(SceIoDirent));
    f = sceIoDopen("pwads");
    if(f > 0) {
        printf("Select PWAD(s):\n\n");
	sceIoDread(f, &dirent); // "."
	sceIoDread(f, &dirent); // ".."
        while (sceIoDread(f, &dirent) > 0) {
            if((FIO_S_IFREG & (dirent.d_stat.st_mode & FIO_S_IFMT)) != 0) {
                printf("    %s\n",dirent.d_name);
                pwadlist[numpwads].file = malloc(strlen(dirent.d_name)+1);
		sprintf(pwadlist[numpwads].file, "%s", dirent.d_name);
                pwadlist[numpwads].state = 0;
                numpwads++;
                if(numpwads == MAXSPWADS) break;
            }
        }
        sceIoDclose(f);
    }

    if(!numpwads) {
        currpwad = 0;
        printf("No PWADs found\n");
    } else {
        for(j = 0; j < MAXPWADS; j++) pwads[j] = "*empty*";
        printf("\n    Start game\n");
        gotoxy(0,numpwads+5);
        printf("Arrows move, cross selects,\ncircle removes all selected files.");
        gotoxy(0,33);
        printf("PSP Legacy (Third Release) - ported by kgsws, updated by Duke");
        gotoxy(0,numpwads+9);
        printf("PWAD(s) to be loaded:");
        for(j = 0; j < MAXPWADS; j++) {
            gotoxy(4,numpwads+11+j);
            printf("*empty*");
        }

        i = 1;
        oi = 2;
        while(1) {
            sceCtrlReadBufferPositive(&pad, 1);
            if(pad.Buttons & PSP_CTRL_UP)
            {
                if(i == numpwads + 2)
                    i -= 2;
                else
                    i--;
            }
            if(pad.Buttons & PSP_CTRL_DOWN)
            {
                if(i == numpwads)
                    i += 2;
                else
                    i++;
            }
            if(i > numpwads + 2) i = 1;
            if(i < 1) i = numpwads + 2;
            if(pad.Buttons & PSP_CTRL_CROSS) {
                if(i == numpwads + 2) break;
                if(currpwad < MAXPWADS && !pwadlist[i-1].state) {
                    pwads[currpwad] = pwadlist[i-1].file;
                    pwadlist[i-1].state = 1;
                    for(j = 0; j < MAXPWADS; j++) {
                        gotoxy(4,numpwads+11+j);
                        printf("%s                                                             ",pwads[j]);
                    }
                    currpwad++;
                }
            }
            if(pad.Buttons & PSP_CTRL_CIRCLE && currpwad) {
                currpwad = 0;
                for(j = 0; j < numpwads; j++) pwadlist[j].state = 0;
                for(j = 0; j < MAXPWADS; j++) {
                    pwads[j] = "*empty*";
                    gotoxy(4,numpwads+11+j);
                    printf("%s                                                             ",pwads[j]);
                }
            }
            if(oi != i) {
                gotoxy(0, oi+1);
                printf("   ");
                gotoxy(0, i+1);
                printf("-->");
                oi = i;
		sceKernelDelayThread(200*1000);
            }
            // End Duke code modification
        }
        pspDebugScreenClear();
        if(currpwad) {
            AddParam("-file",0);
            for(i = 0; i < currpwad; i++) {
                //printf("PWAD: %s\n",pwads[i]);
                AddParam(pwads[i],1);
             }
        } else {
            printf("No PWAD(s) selected.\n");
        }
    }
    SetupCallbacks();
    sceCtrlSetSamplingCycle(0);
    sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
     //added:03-01-98:
    //       Setup signal handlers and other stuff BEFORE ANYTHING ELSE!
    I_StartupSystem();

    D_DoomMain ();
    D_DoomLoop ();

     //added:03-01-98:
    //       hmmm... it will never go here.

    return 0;
}

